//
//  MPAnalytics.h
//  MPServices
//
//  Created by Kirill Kovalenko on 22.12.15.
//  Copyright © 2015 MacPhun. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "MPAnalyticsProtocols.h"

@interface MPAnalytics : NSObject <MPAnalyticsService>

+ (void)send:(nonnull id<MPUserTracking>)event;
+ (void)trackEventNamed:(nonnull NSString *)name
                 action:(nullable NSString *)action
                 screen:(nullable NSString *)screen
               category:(nullable NSString *)category
                  label:(nullable NSString *)label
                  value:(nullable NSNumber *)value;

@end

@interface MPAnalytics (LegacySupport)

/// Method does nothing
+ (void)trackEventNamed:(nonnull NSString *)name
                 screen:(nullable NSString *)screen
               category:(nullable NSString *)category
                  label:(nullable NSString *)label
                  value:(nullable NSNumber *)value;

@end
