//
//  MPAnalyticsProtocols.h
//  MPServices
//
//  Created by Oleksandr Kradenkov on 2/8/18.
//  Copyright © 2018 MacPhun. All rights reserved.
//

#import <Foundation/Foundation.h>

@protocol MPUserTracking <NSObject>
@property (readonly, nonatomic, nonnull) NSString  *displayName;
@property (readonly, nonatomic, nullable) NSString *screen;
@property (readonly, nonatomic, nullable) NSString *category;
@property (readonly, nonatomic, nullable) NSString *action;
@property (readonly, nonatomic, nullable) NSString *label;

@end


@protocol MPAnalyticsService <NSObject>

- (void)send:(nonnull id<MPUserTracking>)event;

- (void)trackEventNamed:(nonnull NSString *)name
                 action:(nullable NSString *)action
                 screen:(nullable NSString *)screen
               category:(nullable NSString *)category
                  label:(nullable NSString *)label
                  value:(nullable NSNumber *)value;

@end
