//
//  MPApi.h
//  MPServices
//
//  Created by Oleksii Dykan on 4/29/14.
//  Copyright (c) 2014 MacPhun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MPNotification.h"

typedef void (^json_dict_block)(NSDictionary *jsonDict, NSError *error);
typedef void (^bundle_ids_block)(NSArray *bundleIds);
typedef void (^success_block)(BOOL success);
typedef void (^succes_json_block)(BOOL success, id jsonObject);

extern NSString *const kApiRequestKeyAppName;
extern NSString *const kApiRequestKeyApps;
extern NSString *const kApiRequestKeyToken;
extern NSString *const kApiRequestKeyId;
extern NSString *const kApiRequestKeyStatus;
extern NSString *const kApiRequestKeyMD5;
extern NSString *const kApiRequestKeySerial;
extern NSString *const kApiRequestKeyUpdate;
extern NSString *const kApiRequestKeyLang;
extern NSString *const kApiRequestKeySessions;
extern NSString *const kApiRequestKeyEvent;
extern NSString *const kApiRequestKeyEvents;
extern NSString *const kApiRequestKeyTimes;
extern NSString *const kApiRequestKeyBundleId;
extern NSString *const kApiRequestKeyAppVersion;

extern NSString *const kApiResponseKeyResult;
extern NSString *const kApiResponseKeyStatus;
extern NSString *const kApiResponseValueSuccess;

@interface MPApi : NSObject

+ (id)api;
+ (id)apiAuth;
+ (id)apiWithBaseUrl:(NSString *)baseUrlStr;
+ (id)apiWithBaseUrl:(NSString *)baseUrlStr apiSecret:(NSString *)apiSecret;

+ (void)sendStatisticsWithDeviceToken:(NSData *)deviceToken;

- (NSMutableDictionary *)defaultParams;

- (void)addToken:(NSString *)tokenStr appName:(NSString *)appName completionHandler:(success_block)completionHandler;
- (void)sendNotificationStatus:(MPNotification *)notification completionHandler:(success_block)completionHandler;
- (void)getBundleIdentifiers:(bundle_ids_block)completionHandler;
- (void)sendAppsStatictics:(NSDictionary *)apps completionHandler:(success_block)completionHandler;

- (void)sendSessions:(NSArray *)sessions completionHandler:(success_block)completionHandler;
- (void)sendEvents:(NSArray *)events completionHandler:(success_block)completionHandler;
- (BOOL)sendEvents:(NSArray *)events;

- (void)requestApiWithUrl:(NSString *)url params:(NSDictionary *)params completionHandler:(json_dict_block)completionHandler;
- (void)requestApiWithUrl:(NSString *)url params:(NSDictionary *)params md5Hash:(NSString *)md5Hash completionHandler:(json_dict_block)completionHandler;

- (void)requestApiWithUrl:(NSString *)url params:(NSDictionary *)params md5Hash:(NSString *)md5Hash httpMethod:(NSString *)httpMethod completionHandler:(json_dict_block)completionHandler;

- (void)requestApiWithUrl:(NSString *)url params:(NSDictionary *)params successCompletionHandler:(succes_json_block)completionHandler;
- (void)requestApiWithUrl:(NSString *)url params:(NSDictionary *)params md5Hash:(NSString *)md5Hash successCompletionHandler:(succes_json_block)completionHandler;

- (NSDictionary *)syncRequestApiWithUrl:(NSString *)url params:(NSDictionary *)params error:(NSError **)error;
- (NSDictionary *)syncRequestApiWithUrl:(NSString *)url params:(NSDictionary *)params md5Hash:(NSString *)md5Hash error:(NSError **)error;

- (BOOL)successFromJsonDict:(NSDictionary *)jsonDict error:(NSError *)error;

@end
