//
//  MPApplicationVersion.h
//  MPServices
//
//  Created by Oleksandr Kradenkov on 1/26/18.
//  Copyright © 2018 MacPhun. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface MPApplicationVersion: NSObject
@property (readonly) NSString *bundleID;
@property (readonly) NSString *shortVersion;
@property (readonly) NSString *longVersion;
@property (copy, nonatomic, nullable) NSString *licenseType;

+ (instancetype)sharedInstance;

- (instancetype)initWithBundleID:(NSString *)bundleID
                    shortVersion:(NSString *)shortVersion
                     longVersion:(NSString *)longVersion NS_DESIGNATED_INITIALIZER;

@end

NS_ASSUME_NONNULL_END
