//
//  MPBatchPreviewViewController.h
//  Phoenix
//
//  Created by Oleksii Dykan on 5/29/15.
//  Copyright (c) 2015 MacPhun LLC. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MPBatchProcessing.h"
#import "MPSCollectionView.h"

typedef void(^MPThumbCompletionBlock)(NSImage *thumb);
typedef void(^MPThumbPrepareBlock)(NSURL *imageUrl, NSSize imageSize, MPThumbCompletionBlock completionHandler);
typedef void(^MPThumbPrepareCancelBlock)(NSURL *thumbToCancel);
typedef void(^MPPreviewCompletionHandler)(NSArray *imageUrls);

@interface MPBatchPreviewViewController : NSViewController

@property (nonatomic, copy) MPThumbPrepareBlock thumbnailHandler;
@property (nonatomic, copy) MPThumbPrepareCancelBlock thumbnailCancelBlock;
@property (nonatomic, copy) MPPreviewCompletionHandler completionHandler;
@property (nonatomic, copy) MPUnsupportedRawHandler unsupportedRawHandler;
@property (nonatomic, copy) void(^closeBatchHandler)(void);

- (void)clearPhotos;
- (void)reloadData;

@end

@interface MPBatchCollectionView : MPSCollectionView

@property (nonatomic, copy) void(^keyDownHandler)(NSEvent *theEvent);

@end