//
//  MPBatchProcessingWindowController.h
//  Phoenix
//
//  Created by Oleksii Dykan on 5/19/15.
//  Copyright (c) 2015 MacPhun LLC. All rights reserved.
//

#import "MPServices.h"

@interface MPBatchProcessingWindowController : NSWindowController

@property (nonatomic, copy) MPBatchImageProcessBlock imageProcessBlock;
@property (nonatomic, copy) void (^cancelProcessBlock) ();
@property (nonatomic, copy) void(^unsupportedRawHandler)(NSArray *unsupportedRAWUrls);;
@property (nonatomic, strong) MPAbstractBatchSettingsController *settingsController;
@property (nonatomic, assign) BOOL needsColorSpace;
@property (nonatomic, copy) void(^batchProcessCloseHandler)();

@end


#ifdef MPBatchProcessingWindowController_Protected

#import "MPBatchOptionsViewController.h"
#import "MPBatchPreviewViewController.h"
#import "MPBatchProcessViewController.h"
#import "MPBatchProcessingController.h"

@interface MPBatchProcessingWindowController ()

@property (nonatomic, weak) IBOutlet NSButton *closeButton;
@property (nonatomic, weak) IBOutlet MPSView *containerView;
@property (nonatomic, weak) IBOutlet NSLayoutConstraint *windowHeightConstraint;

@property (nonatomic, strong) MPBatchProcessingController *batchProcessingController;

@property (nonatomic, strong) MPBatchPreviewViewController *batchPreviewViewController;
@property (nonatomic, strong) MPBatchOptionsViewController *batchOptionsViewController;
@property (nonatomic, strong) MPBatchProcessViewController *batchProcessViewController;

- (IBAction)closeButtonPressed:(id)sender;
- (void)presentViewController:(NSViewController *)viewController hideViewController:(NSViewController *)controllerToHide;

@end

#endif
