//
//  MPBackgroundTextField.h
//  Luminar
//
//  Created by Dmitry Gaponenko on 5/5/16.
//  Copyright © 2016 Macphun. All rights reserved.
//

#import <Cocoa/Cocoa.h>

// TODO: При использовании в xib необходимо просетить селлу MPEditableTextFieldCell

@interface MPEditableTextField : NSTextField <NSWindowDelegate, NSTextFieldDelegate>

@property (nonatomic, strong) IBInspectable NSColor *cursorColor;
@property (nonatomic, strong) IBInspectable NSColor *editedTextColor;
@property (nonatomic, strong) IBInspectable NSColor *selectionColor;
@property (nonatomic, strong) IBInspectable NSColor *selectedTextColor;
@property (nonatomic, assign) BOOL showTextSelectionCursor;
@property (nonatomic, assign) IBInspectable BOOL doubleClickToEdit;

@property (nonatomic, strong) IBOutlet NSView *editBackgroundView;

- (void)setEditingEnabled:(BOOL)flag;
- (void)finishEditing;

@end
