//
//  MPLaunchTab.h
//  MPServices
//
//  Created by Oleksii Dykan on 12/5/14.
//  Copyright (c) 2014 MacPhun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MPLaunchTabButton.h"

typedef void(^MPPrepareImageCompletionBlock)(NSString *imagePath);
typedef void(^MPPrepareImageBlock)(MPPrepareImageCompletionBlock completionBlock);

FOUNDATION_EXPORT NSString *const kMPApplicationWillTerminateNotification;

@interface MPLaunchTab : NSObject

+ (void)start;
+ (void)setLaunchTabButton:(MPLaunchTabButton *)launchTabButton;
+ (void)setImagePrepareBlock:(MPPrepareImageBlock)imagePrepareBlock;
+ (void)showLaunchTabWindow:(id)sender;

#ifdef DEBUG
+ (void)saveInfoToPlist;
#endif

@end
