//
//  MPLogger.h
//  MPServices
//
//  Created by vladislav.senyukov on 5/29/17.
//  Copyright © 2017 MacPhun. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSUInteger, MPLogRule) {
    MPLogRule_None =        0, // in a case of wrong usage
    MPLogRule_Console =     1 << 0,
    MPLogRule_File =        1 << 1,
};

typedef NS_ENUM(NSUInteger, MPLogLevel) {
    MPLogLevel_None =               0, // in a case of wrong usage
    MPLogLevel_UI =                 1 << 0,
    MPLogLevel_Analytics =          1 << 1,
    MPLogLevel_Model =              1 << 2,
    MPLogLevel_Business =           1 << 3,
    MPLogLevel_ImageProcessing =    1 << 4,
    MPLogLevel_Network =            1 << 5,
    MPLogLevel_Debug =              1 << 6,
    MPLogLevel_Verbose =            1 << 7,
    MPLogLevel_Cache =              1 << 8
};

FOUNDATION_EXPORT void _MPLog(MPLogLevel level, NSString *filePath, NSInteger line, NSString *method, NSString *format, ...);

#define MPLogx(level, format, ...)
#define MPLog(level, format, ...) _MPLog(level, [NSString stringWithUTF8String:__FILE__], __LINE__, NSStringFromSelector(_cmd), format, ##__VA_ARGS__)

#define MPLogUI(format, ...)    MPLog(MPLogLevel_UI, format, ##__VA_ARGS__)
#define MPLogM(format, ...)     MPLog(MPLogLevel_Model, format, ##__VA_ARGS__)
#define MPLogB(format, ...)     MPLog(MPLogLevel_Business, format, ##__VA_ARGS__)
#define MPLogIP(format, ...)    MPLog(MPLogLevel_ImageProcessing, format, ##__VA_ARGS__)
#define MPLogN(format, ...)     MPLog(MPLogLevel_Network, format, ##__VA_ARGS__)
#define MPLogD(format, ...)     MPLog(MPLogLevel_Debug, format, ##__VA_ARGS__)
#define MPLogV(format, ...)     MPLog(MPLogLevel_Verbose, format, ##__VA_ARGS__)
#define MPLogC(format, ...)     MPLog(MPLogLevel_Cache, format, ##__VA_ARGS__)
#define MPLogA(format, ...)     MPLog(MPLogLevel_Analytics, format, ##__VA_ARGS__)

@interface MPLogger : NSObject
@property (nonatomic, copy) NSString *configPath;
@property (nonatomic, copy) NSString *outputPath;
@property (nonatomic, assign) NSInteger logResetInterval;
@property (nonatomic, assign) MPLogLevel defaultLevels;
@property (nonatomic, assign) MPLogRule defaultRules;
@property (nonatomic, assign, getter=isEnabled) BOOL enabled;
+ (instancetype)instance;
- (void)logWithLevel:(MPLogLevel)level logString:(NSString*)logString;
- (BOOL)shouldLogLevel:(MPLogLevel)level;
@end
