//
//  MPSInstallPluginsUtils.h
//  MPServices
//
//  Created by yurk on 1/22/15.
//  Copyright (c) 2015 MacPhun. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface MPSInstallPluginsUtils : NSObject

@property (assign, getter = isAuthorizationAllowed) BOOL authorizationAllowed;

+ (instancetype)sharedUtils;

- (BOOL)removeFileWithElevatedPrivilegesFromLocation:(NSString *)location;
- (BOOL)copyFileWithElevatedPrivilegesFromPath:(NSString *)from toPath:(NSString*)destination;
- (BOOL)copyLinkWithElevatedPrivilegesFromPath:(NSString *)aSrc toPath:(NSString *)aDst;
- (BOOL)createFolderWithElevatedPrivilegesAtPath:(NSString *)aPath;

- (BOOL)removeQuarantineAttributeForItemAtPath:(NSString *)aPath recursive:(BOOL)aRecursive;

- (NSString *)getPermissionsForItemAtPath:(NSString *)aPath;

- (BOOL)setPermissions:(NSString *)aPermissions forItemAtPath:(NSString *)aPath;

@end
