//
//  MPLocalization.h
//  MPServices
//
//  Created by Andrey Shekhovtsov on 12.06.15.
//  Copyright (c) 2015 MacPhun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "NSBundle+MPServices.h"

#define MPSLocalizedStr(key) \
[MPSLocalization localizedStringForKey:(key) comment:nil]

#define MPSLocalizedString(key,com) \
[MPSLocalization localizedStringForKey:(key) comment:(com)]

#define MPSLocalizedStringUsingOnlyMPServicesBundle(key,com) \
[MPSLocalization localizedStringForKey:(key) comment:(com) inBundle:[NSBundle mpServicesBundle]]

#define MPSLocalizedStringUsingOnlyMainBundle(key,com) \
[MPSLocalization localizedStringForKey:(key) comment:(com) inBundle:[NSBundle mainBundle]]


extern NSString *const kMPNoTranslationKey;
extern NSString *const kMPSLocalizableTableName;


@interface MPSLocalization : NSObject

+ (NSString *)localizedStringForKey:(NSString *)key comment:(NSString *)comment;
+ (NSString *)localizedStringForKey:(NSString *)key comment:(NSString *)comment inBundle:(NSBundle *)bundle;

@end

#if DEBUG
@interface MPSLocalization (MPSDebug)
+ (void)mps_setLogginEnabled:(BOOL)loggingEnabled;
+ (NSSet *)mps_unlocalizedStrings;
@end
#endif // DEBUG