//
//  MPOpenDragView.h
//  Luminar
//
//  Created by Dmitry Gaponenko on 1/26/17.
//  Copyright © 2017 Macphun. All rights reserved.
//

#import <Cocoa/Cocoa.h>
@class MPSOpenDragView;

@protocol MPSOpenDragViewDelegate <NSObject>

@required
- (void)openDragView:(MPSOpenDragView *)dragView didReceiveURLs:(NSArray *)url;
- (NSDragOperation)openDragView:(MPSOpenDragView *)dragView validateURLs:(NSArray<NSURL *> *)urls;

@end

@interface MPSOpenDragView : NSView <NSDraggingDestination>

@property(nonatomic, assign) IBOutlet id <MPSOpenDragViewDelegate> delegate;

@end

