//
//  MPSView.h
//  MPServices
//
//  Created by Oleksii Dykan on 6/12/15.
//  Copyright (c) 2015 MacPhun. All rights reserved.
//

#import <Cocoa/Cocoa.h>

typedef NS_ENUM(NSUInteger, MPSImageScaling) {
    MPSImageScaleFill = 0,
    MPSImageScaleFillMaxSize,
    MPSImageScaleFit
};

@interface MPSView : NSView

@property (nonatomic, copy) IBInspectable NSString *ninePartImageName;
@property (nonatomic, copy) IBInspectable NSString *threePartImageName;
@property (nonatomic, copy) IBInspectable NSString *backgroundImageName;
@property (nonatomic, strong) IBInspectable NSColor *backgroundColor;
@property (nonatomic, assign) IBInspectable CGFloat cornerRadius;

@property (nonatomic, strong) IBInspectable NSColor *borderColor;
@property (nonatomic, assign) IBInspectable CGFloat borderWidth;


@property (nonatomic, assign) IBInspectable BOOL blurEnabled;
@property (nonatomic, strong) IBInspectable NSImage *blurMaskImage;

/// Bundle identifier to use images from other bundles. Default value - nil for main bundle
@property (nonatomic, copy) IBInspectable NSString *bundleIdentifier;
@property (nonatomic, assign) IBInspectable NSInteger imageScaling;
@property (nonatomic, strong) NSImage *image;

- (void)commonInit;

/// For subclassing purposes
- (void)drawNinePartImage;
- (void)drawThreePartImage;
- (void)drawBackgroundImage;
- (void)drawBackgroundColor;
- (void)drawBorder;

@end
