//
//  MPStatistics.h
//  MPServices
//
//  Created by Oleksii Dykan on 6/2/14.
//  Copyright (c) 2014 MacPhun. All rights reserved.
//

#import <Cocoa/Cocoa.h>

//NOTE:This enums are also ids of events
/**
 Open image in app named
*/
typedef NS_ENUM(NSUInteger, MPStatisticsOpenIn) {
    ///Intensify
    MPStatisticsOpenInIntensify = 1,
    ///Snapheal
	MPStatisticsOpenInSnapheal,
    ///FX PhotoStudio
	MPStatisticsOpenInFXPhotoStudio,
    ///iPhoto
	MPStatisticsOpenInIPhoto,
    ///Aperture
	MPStatisticsOpenInAperture,
    ///Photoshop
	MPStatisticsOpenInPhotoshop,
    ///Photoshop Elements
	MPStatisticsOpenInPhotoshopElements,
    ///Lightroom
	MPStatisticsOpenInLightroom,
    ///Focus
    MPStatisticsOpenInFocus,
    ///Tonality
    MPStatisticsOpenInTonality = 43,
};

/**
 Share image to
 */
typedef NS_ENUM(NSUInteger, MPStatisticsShareTo) {
    ///Mail
	MPStatisticsShareToMail = 10,
    ///Facebook
	MPStatisticsShareToFaceBook,
    ///Twitter
	MPStatisticsShareToTwitter,
    ///Flickr
	MPStatisticsShareToFlickr,
    ///Messages
	MPStatisticsShareToMessages,
    ///Airdrop
	MPStatisticsShareToAirDrop,
    ///SmugMug
    MPStatisticsShareToSmugMug,
    ///500px
    MPStatisticsShareTo500px = 76
};

typedef enum : NSUInteger {
    MPStatisticsPhotoshopPlugin = 92,
    MPStatisticsLightroomPlugin,
    MPStatisticsElementsPlugin,
    MPStatisticsAperturePlugin,
} MPStatisticsPluginMode;

/**
 Used to send Statistics about using app
*/
@interface MPStatistics : NSObject

/**
 Start sending statistics
 
 This method start heandling sessions and setups timer for sending events to the server
 */
+ (void)start;

/**
 Start sending statistics
 
 This method start heandling sessions and setups timer for sending events to the server
 
 @param buildType If is set sends an open app event with the defined build type
 */
+ (void)startWithBuildType:(NSString *)buildType;

/**
 Send event Open in Plugin Mode
*/
+ (void)openedInPluginMode;

/**
 Send event Opened as Other App Plugin
 @param hostAppType
 */
+ (void)openedAsPlugin:(MPStatisticsPluginMode)hostAppType;

/// Send event Opened as Other Photos Extension
+ (void)openedAsPhotosExtension;

/**
 Send event Open in some app
 
 @param openInId The id of App to open in
 */
+ (void)openIn:(MPStatisticsOpenIn)openInId;

/**
 Send event Share to some service
 
 @param shareToId The id of service to share to
 */
+ (void)shareTo:(MPStatisticsShareTo)shareToId;

/**
 Send event Share to standard sharing service
 
 @param sharingService Sharing service to use
 */
+ (void)shareToSharingService:(NSSharingService *)sharingService;

/**
 Send event Image Did Load
 */
+ (void)imageDidLoad;

/**
 Send event Image was saved
 */
+ (void)imageWasSaved;

/**
 Send event Exported to Image
 */
+ (void)exportedToImage;

/**
 Send event Sharing window did open
 */
+ (void)sharingWindowDidOpen;

/**
 Send event Macphun Printlab(Milkbooks)
 */
+ (void)printlabWindowDidOpen;

/**
 Send event Save to document
 */
+ (void)savedToDocument;

/**
 Apply preset event
 
 @param presetName The name of the preset
 @param categoryName Preset category name
 */
+ (void)presetAppliedWithName:(NSString *)presetName categoryName:(NSString *)categoryName;

/**
 Send event Preset Amound Changed
 
 @param presetName The name of the preset
 @param categoryName Preset category name
 @param amount Current preset amount
 */
+ (void)presetAmoundChanged:(float)amount forPresetName:(NSString *)presetName categoryName:(NSString *)categoryName;

/**
 Send event when opening welcome window
 */
+ (void)welcomeScreenOpened;

/**
 Send event when subscribing email in welcome window
 */
+ (void)emailSubscribed;

/**
 Send event when open all preset
 */
+ (void)openAllPreset;

/**
 Send event when apply layer
 */
+ (void)addLayer;

/**
 Send event when create own preset
 */
+ (void)createOwnPreset;

/**
 Send event when using crop
 */
+ (void)usingCrop;

/**
 Send event when using texture
 */
+ (void)usingTexture;

/**
 Send event when using bracket in the layer
 */
+ (void)usingBracketInLayer;

/**
 Send event when drawing
 */
+ (void)drawing;

/**
 Send event when using gradient mask
 */
+ (void)gradientMask;

/**
 Send event when using luminosity mask
 */
+ (void)luminosityMask;

/**
 Send event when change blend mode
 */
+ (void)changeBlendMode;

/**
 Send event with count brackets user using
 */
+ (void)brackitsCount:(NSNumber *)count;

/**
 Send event with name effect user using
 */
+ (void)useEffect:(NSString *)name;

/**
 Send event with name effect witch add adjust
 */
+ (void)addAdjustToEffect:(NSString *)name;

/**
 Send event with count add effect on the image
 */
+ (void)countEffectOnImage:(NSNumber *)count;

/**
 Send event with name mode selection
 */
+ (void)modeSelection:(NSString *)name;

/**
 Send event with name frame
 */
+ (void)useFrame:(NSString *)name;

/**
 Send event when use mask
 */
+ (void)useMask;

/**
 Send event when use batch
 */
+ (void)useBatch;

/**
 Send event when use erase
 */
+ (void)withOutErase;

/**
 Send event when apply retouch
 */
+ (void)applyRetouch;

/**
 Send event when apply retouch
 */
+ (void)useCloneStamp;

/**
 Send event with type erase
 */
+ (void)typeErase:(NSString *)type;

/**
 Send event when use adjust
 */
+ (void)useAdjust;

/**
 Send event with name group effect
 */
+ (void)useGroupEffect:(NSString *)name;

/**
 Send event with count layers
 */
+ (void)countLayers:(NSNumber *)count;

/**
 Send event when first click on the Demo
 */
+ (void)firstDemo;

/**
 Send event with specific id
 
 @param eventId id of event to send
 */
+ (void)sendEventWithId:(NSInteger)eventId;

/**
 Force send of all events
 
 @param completionHandler Async completion Handler
 */
+ (void)sendEventsWithCompletionHandler:(void(^)(BOOL success))completionHandler;

/**
 Force sync sending of all events
 */
+ (BOOL)sendEvents;

@end
