//
//  MPSuperMenuSettings.h
//  MPServices
//
//  Created by Kirill Kovalenko on 6/14/16.
//  Copyright © 2016 MacPhun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MPSuperPopoverControllerDefines.h"
#import "MPSuperMenuItemSettings.h"

@interface MPSuperMenuSettings : NSObject

#pragma mark -
#pragma mark Properties

/* Settings */

@property (nonatomic, assign) BOOL hasArrow;
@property (nonatomic, assign) NSSize arrowSize;
@property (nonatomic, assign) CGFloat cornerRadius;
@property (nonatomic, assign) CGFloat borderWidth;
@property (nonatomic, strong, nonnull) NSColor *color;
@property (nonatomic, strong, nonnull) NSColor *borderColor;
@property (nonatomic, assign) MPSuperPopoverArrowDirection arrowDirection;
@property (nonatomic, assign) ShadowSettings shadowSettings;
@property (nonatomic, assign) BOOL blurBackground;
@property (nonatomic, assign) NSEdgeInsets contentEdgeInsets;
@property (nonatomic, assign) NSEdgeInsets popoverOffsetsFromPositionView;
// SenderPosition work only if popoverOffset is zeroPoint and we have sender
@property (nonatomic, assign) MPSuperPopoverSenderPosition senderPosition;
@property (nonatomic, assign) NSPoint popoverOffset;
@property (nonatomic, assign) CGFloat topMargin;
@property (nonatomic, assign) CGFloat bottomMargin;
@property (nonatomic, assign) CGFloat itemsSpacing;
@property (nonatomic, assign) BOOL applyOnMouseOver;

@property (nonatomic, strong, nonnull) MPSuperMenuItemSettings *menuItemSettings;


#pragma mark -
#pragma mark Methods

/* Default special setting for Tokio. */
+ (MPSuperMenuSettings * _Nonnull)defaultSettings;

@end
