//
//  MPSystemVersion.h
//  MPServices
//
//  Created by Vladislav Senyukov on 11/7/17.
//  Copyright © 2017 MacPhun. All rights reserved.
//

#import "MPSingleton.h"

@interface MPSystemVersion : MPSingleton
@property (class, nonatomic, readonly) NSInteger major;
@property (class, nonatomic, readonly) NSInteger minor;
@property (class, nonatomic, readonly) NSInteger patch;
@property (class, nonatomic, readonly) NSString *string;
/**
 *  @abstruct A convenient static method to make possible OS version check in a single conditional branch
 *  
 *  @discussion
 *  Example:
 *  if ([MPSystemVersion check:^BOOL(NSInteger major, NSInteger minor, NSInteger patch) {
 *      return major >= 10 && minor >= 12;
 *  }]) {
 *      NSLog(@"You system is 10.12 or higher");
 *  } else {
 *      NSLog(@"otherwise");
 *  }
 */
+ (BOOL)check:(BOOL(^)(NSInteger major, NSInteger minor, NSInteger patch))condition;
@end
