//
//  NSFileManager+Additions.h
//  FXPhotoStudioMac
//
//  Created by Dmitry Gaponenko on 3/2/11.
//  Copyright 2011 Macphun. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface NSFileManager (DirectoryLocations)

+ (NSArray<NSString *> *)filesSortedByModDateFromDir:(NSString *)dir;
+ (NSUInteger)fileCountAtPath:(NSString *)path extension:(NSString *)extension;

- (NSString *)findOrCreateDirectory:(NSSearchPathDirectory)searchPathDirectory inDomain:(NSSearchPathDomainMask)domainMask appendPathComponent:(NSString *)appendComponent error:(NSError **)errorOut;
- (NSString *)applicationSupportDirectory;
- (NSNumber *)sizeForContentsAtPath:(NSString *)source error:(NSError **)error;
- (NSNumber *)sizeForFolderAtPath:(NSString *)source error:(NSError **)error;

@end
