//
//  NSImage+Additions.h
//  MPServices
//
//  Created by Oleksii Dykan on 10/15/14.
//  Copyright (c) 2014 MacPhun. All rights reserved.
//

#import <Cocoa/Cocoa.h>


static NSString * const MPThreePartImageSuffixLeftName = @"_left";
static NSString * const MPThreePartImageSuffixCenterName = @"_center";
static NSString * const MPThreePartImageSuffixRightName = @"_right";


@interface NSImage (Additions)

+ (NSImage *)properImageNamed:(NSString *)imageName;
+ (NSImage *)properImageNamed:(NSString *)imageName withBundleIdentifier:(NSString *)bundleIdentifier;
+ (NSArray *)properThreePartImagesNamed:(NSString *)threePartImageName withBundleIdentifier:(NSString *)bundleIdentifier;

+ (CGImageRef)resizeImage:(CGImageRef)image toNewSize:(NSSize)newSize;

- (NSImage *)imageRotated:(float)degrees;
- (NSImage *)maskImageWithAlphaThreshold:(uint8_t)threshold;
- (NSData *)jpegRepresentaionWithQuality:(CGFloat)quality;
- (NSData *)representaionUsingType:(NSBitmapImageFileType)type properties:(NSDictionary *)properties;
- (instancetype)drawColor:(NSColor*)color;

@end
