//
//  NSObject+Additions.h
//  MPServices
//
//  Created by vladislav.senyukov on 9/15/17.
//  Copyright © 2017 MacPhun. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/// Returns object of [NSNull null]
FOUNDATION_EXPORT id MPGetNullNormalizedObject(id _Nullable object);

/// Returns nil if object is kind of `NSNull` class of is equal to `nil`
FOUNDATION_EXPORT id _Nullable MPGetNullDenormalizedObject(id _Nullable object);

@interface NSObject (Additions)

- (BOOL)isBlock;

/**
 Return hash values composed from `values` using FNV-1a algorithm

 @param values array of hashes
 @param count array count
 @see http://www.isthe.com/chongo/tech/comp/fnv/index.html#FNV-1a
 @return hash value composed from `values` using FNV-1a algorithm
 */
- (NSUInteger)composedHashValues:(NSUInteger*)values count:(NSUInteger)count;

@end

NS_ASSUME_NONNULL_END
