//
//  NSString+Additions.h
//  PushNotification
//
//  Created by Oleksii Dykan on 4/15/14.
//  Copyright (c) 2014 MacPhun. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 Additional method for NSString
 */
@interface NSString (Additions)

@property (nonatomic, readonly) unichar unicode;

@property (assign, readonly, nonatomic) BOOL isWinPath;
@property (copy, readonly, nonatomic) NSString *lastWinPathComponent;


/**
 Generate string push notification token from NSData
 
 @param deviceToken Push notification device token
 */
+ (NSString *)tokenStringFromData:(NSData *)deviceToken;

/**
 Create body string for NSURLRequest separated by &
 
 @param body Dictionary to generate body string from
 */
+ (NSString *)bodyStringFromDictionary:(NSDictionary *)body;

/**
 Create md5 hash string from NSArray
 
 @warning All components must of type NSString
 
 @param components Components to generate md5 has string from
 */
+ (NSString *)md5HashFromComponents:(NSArray *)components;

/**
 Get current mac serial number
 */
+ (NSString *)macSerial;

/**
 Create json string from dictionary
 
 @param jsonDict JSON Dictionary
 */
+ (NSString *)jsonStringFromDictionary:(NSDictionary *)jsonDict;

/**
 Create json string from array
 
 @param jsonArray JSON Array
 */
+ (NSString *)jsonStringFromArray:(NSArray *)jsonArray;

/*!
 * @description Returns a new string made by removing from both ends of the receiver whitespaceAndNewlineCharacters.
 * @param string An input string for manipulation.
 * @return A new string made by removing from both ends of the receiver whitespaceAndNewlineCharacters.
 */
+ (NSString *)trim:(NSString *)string;

/*!
 * @description Returns YES if string exists and doesn't constain whitespaceAndNewlineCharacters only. Otherswise NO.
 * @param  string An input string for manipulation.
 * @return YES if string is empty, otherwise NO.
 */
+ (BOOL)isEmpty:(NSString *)string;

/**
 Create md5 hash from string
 */
- (NSString *)md5;

/**
 percent encode string for NSURLConnection
 */
- (NSString *)urlEncode;

/*!
 * @description encodes string as a valid parameter for NSURL query. Unlike 'urlEncode' method it replaces whitespace with %20.
 */
- (NSString *)urlParamEncode;

/**
 Percent encode special characters
 */
- (NSString *)stringByPercentEncodingSpecialCharacters;

/**
 UUID string
 */
+ (NSString*)stringWithUUID;

// Path localization

- (NSString*)localizedDisplayPath;

/*!
 * @description email validator
 * @return YES for valid email address, NO in another case
 */
- (BOOL)isValidEmailAddress;


/// A new string made by removing from the trailing end of the receiver characters contained in a given character set.
- (NSString *)stringByTrimmingTrailingCharactersInSet:(NSCharacterSet *)characterSet;

+ (NSString*)uuidString;
- (BOOL)isUUID;

/**
 *  @abstract timehash sequence that uses a secret key to calculate a hash of its random substring and flanks it with hashes of current time and time of nearest past
 */
+ (NSString*)timeHash:(NSString*)key;

- (NSString*)mimeType;

+ (NSString*)urlQueryStringFromDictionary:(NSDictionary*)parameters;

@end
