"use strict";
/**
 * @license
 * Copyright 2018 Google Inc. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
Object.defineProperty(exports, "__esModule", { value: true });
var tf = require("@tensorflow/tfjs-core");
// tslint:disable-next-line:max-line-length
var test_util_1 = require("@tensorflow/tfjs-core/dist/test_util");
describe('delayed upload', function () {
    it('should handle data before op execution', function () {
        var t = tf.tensor1d([1, 2, 3]);
        test_util_1.expectArraysClose(t, [1, 2, 3]);
        var r = t.add(tf.tensor1d([4, 5, 6]));
        test_util_1.expectArraysClose(r, [5, 7, 9]);
    });
    it('Should not cache tensors in the tensor map for device support. ', function () {
        var logits = tf.tensor1d([1, 2, 3]);
        var softmaxLogits = tf.softmax(logits);
        var data = softmaxLogits.dataSync();
        expect(softmaxLogits.dataSync()[0]).toEqual(data[0]);
        expect(softmaxLogits.dataSync()[1]).toEqual(data[1]);
        expect(softmaxLogits.dataSync()[2]).toEqual(data[2]);
    });
});
describe('type casting', function () {
    it('exp support int32', function () {
        tf.exp(tf.scalar(2, 'int32'));
    });
});
describe('conv3d dilations', function () {
    it('CPU should throw error on dilations >1', function () {
        var input = tf.ones([1, 2, 2, 2, 1]);
        var filter = tf.ones([1, 1, 1, 1, 1]);
        expect(function () {
            tf.conv3d(input, filter, 1, 'same', 'NHWC', [2, 2, 2]);
        }).toThrowError();
    });
    it('GPU should handle dilations >1', function () {
        // This test can only run locally with CUDA bindings and GPU package
        // installed.
        if (tf.ENV.backend.isGPUPackage) {
            var input = tf.ones([1, 2, 2, 2, 1]);
            var filter = tf.ones([1, 1, 1, 1, 1]);
            tf.conv3d(input, filter, 1, 'same', 'NHWC', [2, 2, 2]);
        }
    });
});
