
//function convertColor(color, from, to) {
//}

function convertLinearRGBToSRGB(color) {
	// values from http://www.sjbrown.co.uk/2004/05/14/gamma-correct-rendering/

	var converted = clone(color);
	
	['red', 'blue', 'green'].every(function (key) {

		if (color[key] <= 0.04045)
			converted[key] = color[key] / 12.92;
		else
			converted[key] = Math.pow((color[key] + 0.055)/1.055, 1.4);
			
		return true;
	});

	return converted;
}

function convertSRGBToLinearRGB(color) {

	var converted = clone(color);
	
	['red', 'blue', 'green'].every(function (key) {
	
		console.log(key);

		if (color[key] <= 0.04045)
			converted[key] = color[key] * 12.92;
		else
			converted[key] = Math.pow((1.055 * color[key]), 2) - 0.055;
			
		return true;
	});

	return converted;

}

function convertSRGBToLinearRGB2(r,g,b) {

	var converted = convertSRGBToLinearRGB({ red: r/255, green: g/255, blue: b/255 });
	
	console.log(converted);
	
	return 'rgb('+(converted.red*255)+','+(converted.green*255)+','+(converted.blue*255)+')';

}

function convertLinearRGBToSRGB2(r,g,b) {

	var converted = convertLinearRGBToSRGB({ red: r/255, green: g/255, blue: b/255 });
	
	console.log(converted);
	
	return 'rgb('+(converted.red*255)+','+(converted.green*255)+','+(converted.blue*255)+')';

}

function cssRgbToHsv(v) {

	if (!v) return [];

			var colorIdentifierLength = v.substr(0,4) === 'rgba' ? 4 : 3,
				rgb = v.substring(v.length-1, colorIdentifierLength+1)
					   .split(',')
					   .map(function (value) { return parseInt(value) }),
				hsv = rgbToHsv(rgb[0], rgb[1], rgb[2]);
	return hsv;

}

/**
 * Converts an RGB color value to HSV. Conversion formula
 * adapted from http://en.wikipedia.org/wiki/HSV_color_space.
 * Assumes r, g, and b are contained in the set [0, 255] and
 * returns h, s, and v in the set [0, 1].
 *
 * @param   Number  r       The red color value
 * @param   Number  g       The green color value
 * @param   Number  b       The blue color value
 * @return  Array           The HSV representation
 */
function rgbToHsv(r, g, b){
	var r = r/255, g = g/255, b = b/255;
    var max = Math.max(r, g, b), min = Math.min(r, g, b);
    var h, s, v = max;

    var d = max - min;
    s = max == 0 ? 0 : d / max;

    if(max == min){
        h = 0; // achromatic
    }else{
        switch(max){
            case r: h = (g - b) / d + (g < b ? 6 : 0); break;
            case g: h = (b - r) / d + 2; break;
            case b: h = (r - g) / d + 4; break;
        }
        h /= 6;
    }

    return [h, s, v];
}

/**
 * Converts an HSV color value to RGB. Conversion formula
 * adapted from http://en.wikipedia.org/wiki/HSV_color_space.
 * Assumes h, s, and v are contained in the set [0, 1] and
 * returns r, g, and b in the set [0, 255].
 *
 * @param   Number  h       The hue
 * @param   Number  s       The saturation
 * @param   Number  v       The value
 * @return  Array           The RGB representation
 */
function hsvToRgb(h, s, v){
    var r, g, b;

    var i = Math.floor(h * 6);
    var f = h * 6 - i;
    var p = v * (1 - s);
    var q = v * (1 - f * s);
    var t = v * (1 - (1 - f) * s);

    switch(i % 6){
        case 0: r = v, g = t, b = p; break;
        case 1: r = q, g = v, b = p; break;
        case 2: r = p, g = v, b = t; break;
        case 3: r = p, g = q, b = v; break;
        case 4: r = t, g = p, b = v; break;
        case 5: r = v, g = p, b = q; break;
    }

    return [r * 255, g * 255, b * 255];
}

function rgbToCss(rgb) {
	return 'rgb('+parseInt(rgb[0])+','+parseInt(rgb[1])+','+parseInt(rgb[2])+')';
}

function changeLightness(brightness, factor, darkenColor) {
	if (factor < 0 && darkenColor === true) return brightness+brightness*factor;
	return brightness+(1-brightness)*factor;
}

function changeSaturation(saturation, factor, brightness) {
	if (brightness < 0.33) {
		return saturation * (brightness+factor/5);
	}
	return saturation * factor;
}

function parseRgbCSSColor(v) {
			var split = v.split(',');
			if (split.length === 4) {
				split[0] = parseInt(split[0].substr(5));
				split[1] = parseInt(split[1]);
				split[2] = parseInt(split[2]);
				split[3] = parseFloat(split[3]);
				if (split[3] === 1) split.pop();
			}
			else {
				split[0] = parseInt(split[0].substr(4));
				split[1] = parseInt(split[1]);
				split[2] = parseInt(split[2]);
			}
	return split;
}


	// convert RGBA color data to hex
	function rgba2hex(r, g, b, a) {
		if (r > 255 || g > 255 || b > 255 || a > 255)
			return '';//throw "Invalid color component";
		r |= 0;
		g |= 0;
		b |= 0;
		a |= 0;
		return (256 + r).toString(16).substr(1) +((1 << 24) + (g << 16) | (b << 8) | a).toString(16).substr(1);
	}
	

// Copyright 2011 THEtheChad Elliott
// Released under the MIT and GPL licenses.

function parseColor(color) {

	var cache
	  , p = parseInt // Use p as a byte saving reference to parseInt
	  , color = color.replace(/\s\s*/g,'') // Remove all spaces
	;//var
	
	// Checks for 6 digit hex and converts string to integer
	if (cache = /^#([\da-fA-F]{2})([\da-fA-F]{2})([\da-fA-F]{2})/.exec(color)) 
		cache = [p(cache[1], 16), p(cache[2], 16), p(cache[3], 16)];
		
	// Checks for 3 digit hex and converts string to integer
	else if (cache = /^#([\da-fA-F])([\da-fA-F])([\da-fA-F])/.exec(color))
		cache = [p(cache[1], 16) * 17, p(cache[2], 16) * 17, p(cache[3], 16) * 17];
		
	// Checks for rgba and converts string to
	// integer/float using unary + operator to save bytes
	else if (cache = /^rgba\(([\d]+),([\d]+),([\d]+),([\d]+|[\d]*.[\d]+)\)/.exec(color))
		cache = [+cache[1], +cache[2], +cache[3], +cache[4]];
		
	// Checks for rgb and converts string to
	// integer/float using unary + operator to save bytes
	else if (cache = /^rgb\(([\d]+),([\d]+),([\d]+)\)/.exec(color))
		cache = [+cache[1], +cache[2], +cache[3]];
		
	// Otherwise throw an exception to make debugging easier
	else throw Error(color + ' is not supported by parseColor()');
	
	// Performs RGBA conversion by default
	isNaN(cache[3]) && (cache[3] = 1);
	
	// Adds or removes 4th value based on rgba support
	// Support is flipped twice to prevent erros if
	// it's not defined
	//return cache.slice(0,3 + !!$.support.rgba);
	
	return cache;

}

function cssColorToHex(cssString, alpha) {
	var parts = parseColor(cssString);
	var hexString = rgba2hex(parts[0], parts[1], parts[2], (parts[3] || 1)*255);
	if (!alpha) hexString = hexString.substr(0,6);
	return hexString;
}
