
registerType('Core', (function () { function ApplicationContext() {} var __super = setSupertypeFromDomain(ApplicationContext, 'BindingsContext', 'Core');


	

ApplicationContext.prototype.initFromData = function ApplicationContext_initFromData(data) {
		if (!__super.prototype.initFromData.call(this, data))
			return;

		this.sharedImagePool = {};
		
		if (data.usePasteboard === true) 
			this.pasteboardDelegate = createComponentFromDomain(
				'PasteboardDelegate',
				'Core',
				this, {});
													
		if (data.useUndoManager === true) 
			this.undoManager = createComponentFromDomain(
				'UndoManager',
				'Core',
				this, {});

		if (data.usePasteboard === true || data.useUndoManager === true) {
			if (window.NativeProxy !== undefined) {
				this.nativeProxy = new NativeProxy(this);
				this.nativeProxyIsReady();
			}
			else {
			
				console.warn('Simulating window.nativeProxy');
				this.nativeProxy = {
					sendMessage: function (m) {
						if (m === 'applicationContextIsReady') {
						}
					}.bind(this)
				};
			}
		}
		
		if (data.mainUIFile) {
			this.loadUIFile(data.mainUIFile);
		}
		
		this.applicationContextIsReady();
		
		return this;};
	
	
ApplicationContext.prototype.nativeProxyIsReady = function ApplicationContext__nativeProxyIsReady() {

		window.tint = parseInt(this.nativeProxy.sendMessage('systemTint'));
		window.hasFocus = true;
		Object.defineProperty(this, "highResolutionEnabled", {
		writable: true, 
			value: this.nativeProxy.sendMessage('highResolutionEnabled')});
		
		this.loadLocalization();};
	
	
ApplicationContext.prototype.applicationContextIsReady = function ApplicationContext__applicationContextIsReady() {
		if (this.nativeProxy) {
			this.nativeProxy.sendMessage('applicationContextIsReady');
			return this;
		}};
	

ApplicationContext.prototype.loadLocalization = function ApplicationContext__loadLocalization() {};
	
	
ApplicationContext.prototype.loadUIFile = function ApplicationContext__loadUIFile(path) {
		
		var data = this.nativeProxy.sendMessage('stringFromFile', path);
		if (!data) return;
		var bundle = JSON.parse(data);
		if (!bundle) return;
		var instances = this.decodeArchive(bundle);
		this.viewController = instances[0];
		this.registerMainViewController(this.viewController);
};
	
	
	
	
	
ApplicationContext.prototype.decodeArchive = function ApplicationContext_decodeArchive(archive) {

		var instancesData = archive.instances,
			decodedInstances = [];
			
		if (Array.isArray(instancesData)) instancesData.every(function (instanceData) {
			var instance = this.createFromDataWithoutInitializing(instanceData);
			
			if (!instance) return true;

			decodedInstances.push(instance);return true; }, this);
		

		if (Array.isArray(decodedInstances)) decodedInstances.every(function (instance) {
			this.initObjectFromArchive(instance);return true; }, this);
		
		
		return decodedInstances;
		};
	

ApplicationContext.prototype.decodeObjectTree = function ApplicationContext_decodeObjectTree(data, context) {
	
		if (!data) return;
	
		var instance = this.createFromDataWithoutInitializing(data, context);
		if (instance === undefined || !instance.decodeData) {
			console.warn('instance === undefined || !instance.decodeData', instance, 'data was:', data);
			console.trace();
			return;
		}

		this.initObjectFromArchive(instance);
		return instance;};
	

ApplicationContext.prototype.createFromDataWithoutInitializing = function ApplicationContext__createFromDataWithoutInitializing(data, context) {
	
		if (!data) return;
	
		if (!data.$type) {
			console.warn('Error in createFromDataWithoutInitializing(): This object has no type property.', data);
			return;
		}
	
		try {
			var supertype = getTypeFromDomain(data.$type, data.$domain);
		} catch (err) {
			console.trace();
			throw err;
		}

		if (supertype === undefined) {
			console.error('Error getting prototype for '+data.$domain+'.'+data.$type+', data was', data, this);
			console.trace();
			supertype = this.handleUnknownData(data);
			if (!supertype) return;
		}
	
		var instance = new supertype();
		Object.defineProperty(instance, 'context', { value: context || this });
		Object.defineProperty(instance, '__uninitializedData', { value: data, configurable: true, writable: true });
		
		if (data.$id !== undefined) {
			this.connectableObjects[data.$id] = instance;
			instance.$id = data.$id;
		}
	
		if (instance.decodeData)
			instance.__uninitializedData = instance.decodeData(data);

		return instance;
	};
	
	
ApplicationContext.prototype.handleUnknownData = function ApplicationContext__handleUnknownData(data) {
		return;};
	
	
ApplicationContext.prototype.initObjectFromArchive = function ApplicationContext__initObjectFromArchive(instance) {
	
		if (!instance || instance.__uninitializedData === undefined) {
			
			return;
		}
		this.dissolveConnections(instance.__uninitializedData);
		instance.initFromArchive(instance.__uninitializedData);
		delete instance.__uninitializedData;};
	
	
ApplicationContext.prototype.dissolveConnections = function ApplicationContext__dissolveConnections(instanceData) {
		var connections = instanceData.connections;
		if (connections === undefined) return;
		
		
		if (Array.isArray(connections)) connections.every(function (connection) {

			if (connection.key in instanceData) {
				console.warn("Could not dissolve a connection, the data already has a _property with this name:", connection.key, instanceData);
				return true;
			}

			var destination = this.connectableObjects[connection.destination];
			if (!destination) {
				console.warn("Could not dissolve a connection, the destination was not found:", connection.destination, clone(this.connectableObjects));
			}
			instanceData[connection.key] = destination;
return true; }, this);
		
		
		delete instanceData.connections;};
	


	

	function is_empty(obj) {
	
		if (Array.isArray(obj) && obj.length > 0)
			return false;
	
		for (var key in obj) {
			if (obj[key] !== undefined)
				return false;
		}
	
		return true;
	}
	
	function CSSPropertyToJS(property) {
		var result = "", ch, ucNext;
		for (var i = 0, c = property.length; i < c; i++) {
			ch = property[i];
			if (ch === '-') {
				if (i !== 0) {
					ucNext = true;
				}
				continue;
			}
			if (ucNext === true) {
				result += ch.toUpperCase();
				ucNext = false;
			}
			else result += ch;
		}
		return result;
	}
	
ApplicationContext.prototype.encodeObject = function ApplicationContext_encodeObject(objToencode, nodeWithStyle, CSSPropertiesToSkip) {
	

		var data = {};

		if (objToencode.__domain) {
			data.$type = objToencode.constructor.name;
			data.$domain = objToencode.__domain;
		}
	
		for (var key in objToencode) {

			var obj = this.encodeObjectItem(objToencode[key], objToencode, key);

			if (obj !== null)
				data[key] = obj;
	
		}
		
	
		
		if (nodeWithStyle) {
			var style = nodeWithStyle.style,
				styleLength = style.length;
			if (styleLength) {
				if (!CSSPropertiesToSkip) CSSPropertiesToSkip = [];
				var dataStyle = {},
					c = 0;
				for (var i = 0; i != styleLength; i++) {
					var key = CSSPropertyToJS(style[i]);
					if (CSSPropertiesToSkip.indexOf(key) !== -1)
						continue;
					dataStyle[key] = style[key];
					c++;
				}
				if (c) data.style = dataStyle;
			}
		}
	
		return data;};
	
	
ApplicationContext.prototype.encodeObjectItem = function ApplicationContext__encodeObjectItem(obj, parentObj, key) {
	
		if (typeof obj === 'function') {
			return null;
		}
		
		if (window.logKeys) {
			 console.log(key, obj);
		}
		
		if (typeof obj === 'object') {
			if(is_empty(obj)) {
				return null;
			}
			if (typeof obj.encode === 'function') {
				obj = obj.encode.call(obj);
				return obj;
			}
			if (obj.constructor.name !== 'Object' &&
				obj.constructor.name !== 'Function' &&
				!Array.isArray(obj)) {
				console.warn('Trying to encode a complex object structure.', parentObj, obj, key);
				console.trace();
				return null;
			}
			if (Array.isArray(obj)) {
				_array = obj;
				obj = [];
				if (Array.isArray(_array)) _array.every(function (item) {
					obj.push(this.encodeObjectItem(item, obj, 0));return true; }, this);
				
				return obj;
			}
			else {
				var _obj = {};
				for (var key in obj) {
					_obj[key] = this.encodeObjectItem(obj[key], obj, key);
				}
				obj = _obj;
			}
		}
		
		return obj;};
	


	
	
	var loadedBundles = [];
	
ApplicationContext.prototype.callWhenResourcesAreLoaded = function ApplicationContext_callWhenResourcesAreLoaded(callback, bundle) {
		
		if (loadedBundles.indexOf(bundle) !== -1) {
			callback.call();
			return;
		}
		
		loadedBundles.push(bundle);
		
		var counter = bundle.length;
		var resourceOnLoad = function () {
			counter--;
			if (counter === 0) callback.call();
		};
		var resourceOnError = function (e) {
			console.error(e);
		};
		
		setTimeout(function () {
			if (counter > 0) {
				console.warn('Some files were not loaded ('+counter+').');
				callback.call();
			}
		}, 5000);
	
	
		var head = document.getElementsByTagName('head')[0],
			self = this;
		
		bundle.every(function (URL) {
			
			var extension = URL.substr(URL.lastIndexOf('.'));
			if (extension === '.js') {
				var script = document.createElement('script');
				script.onload = resourceOnLoad;
				script.onerror = resourceOnError;
				URL += '#' + Math.random(10000000);
				script.src = URL;
				head.appendChild(script);
			}
			else if (extension === '.css') {
				var link = document.createElement('link');
				link.onload = resourceOnLoad;
				link.onerror = resourceOnError;
				link.rel = "stylesheet";
				link.href = URL;
				head.appendChild(link);
				counter--;
			}
			else if (extension === '.png') {
				var image = document.createElement('img');
				image.onload = function (e) {
					self.sharedImagePool[URL] = this;
					resourceOnLoad(e);
				};
				image.onerror = resourceOnError;
				image.src = URL;
			}
			else {
				console.warn('Unknown file type: '+extension);
			}
			
			return true;
		
		});
	
	};
	
	
ApplicationContext.prototype.whenImageIsReady = function ApplicationContext_whenImageIsReady(imageSrc, callback, errorCallback) {
		
		if (this.sharedImagePool[imageSrc] !== undefined) {
			callback(this.sharedImagePool[imageSrc], imageSrc);
			return;
		}
		
		var img = new Image(),
			self = this;

		img.onload = function (e) {
			self.sharedImagePool[imageSrc] = this;
			callback(this, imageSrc);
			self = null;
		};
		img.onerror = function (e) {
			if (errorCallback)
				errorCallback(this, imageSrc, e);
		}
		img.src = imageSrc;
		};
	
	
ApplicationContext.prototype.pathForImageWithID = function ApplicationContext_pathForImageWithID(ID, highResolution) {
		if (highResolution === true)
			return this.nativeProxy.sendMessage('pathForRetinaImageWithID', ID);

		return this.nativeProxy.sendMessage('pathForImageWithID', ID);};
	

ApplicationContext.prototype.pathForDatabaseWithID = function ApplicationContext_pathForDatabaseWithID(ID) {
		return this.nativeProxy.sendMessage('pathForDatabaseWithID', ID);};
	
	
ApplicationContext.prototype.pathForOptimizedImage = function ApplicationContext_pathForOptimizedImage(src) {
	
		if (typeof src !== 'string' || this.highResolutionEnabled !== true || src.indexOf('://') !== -1)
			return src;
	
		var highResSrc = src.replace(/.png/, "@2x.png");

		if (this.nativeProxy.sendMessage('imageExistsAtPath', highResSrc) === true) return highResSrc;
		
		return src;
};
	
	
ApplicationContext.prototype.pathForResource = function ApplicationContext_pathForResource(name) {
		return 'Resources/'+name;};
	

ApplicationContext.prototype.pathForResourceNamed = function ApplicationContext_pathForResourceNamed(resourceName) {
		return this.pathForResource(resourceName);};
	
	
ApplicationContext.prototype.getOrCreateInstance = function ApplicationContext_getOrCreateInstance(id) {
		
		try {
			var instance = this.globals[id];
		} catch (err) {
			console.warn('Error in getOrCreateInstance() with id', id, this);
			throw err;
		}
		
		if (instance !== undefined)
			return instance;

		var instanceData = this.instancesData[id];
		if (instanceData === undefined) {
			console.warn('Instance '+id+' not found and could not be decoded.');
			console.trace();
			return;
		}
		
		instance = this.decodeObjectTree(instanceData);

		this.instances[id] = instance;

		return instance;
		};
	
	
ApplicationContext.prototype.destroyInstance = function ApplicationContext_destroyInstance(id) {
		if (!this.instances[id]) return;
		this.instances[id].destroy();
		delete this.instances[id];};
	

ApplicationContext.prototype.resourceWithName = function ApplicationContext_resourceWithName(name) {
		var resource;
		if (!this.resourcesData) return {};
		this.resourcesData.every(function (aResource) {
			if (aResource.name === name)
				resource = aResource;
			else return true;
		});
		return resource;};
	


	
	
ApplicationContext.prototype.selectAll = function ApplicationContext_selectAll() {
		this.pasteboardDelegate.handleSelectAll();};
	

ApplicationContext.prototype.unselectAll = function ApplicationContext_unselectAll() {
		this.pasteboardDelegate.handleUnselectAll();};
	
	
ApplicationContext.prototype.deleteSelection = function ApplicationContext_deleteSelection() {
		this.pasteboardDelegate.handleDelete();};
	

ApplicationContext.prototype.duplicateSelection = function ApplicationContext_duplicateSelection() {
		this.pasteboardDelegate.handleDuplicate();};
	


	
	
ApplicationContext.prototype.windowDidBecomeMain = function ApplicationContext_windowDidBecomeMain() {
		window.hasFocus = true;
		var e = document.createEvent('CustomEvent');
		e.initCustomEvent("didBecomeMain", false, false, null);
		window.dispatchEvent(e);};
	

ApplicationContext.prototype.windowDidResignMain = function ApplicationContext_windowDidResignMain() {
		window.hasFocus = false;
		var e = document.createEvent('CustomEvent');
		e.initCustomEvent("didResignMain", false, false, null);
		window.dispatchEvent(e);};
	
	
ApplicationContext.prototype.registerFocus = function ApplicationContext_registerFocus(view) {
		this.focusedView = view;
		if (this.pasteboardDelegate)
			this.pasteboardDelegate.register(view);};
	

ApplicationContext.prototype.unregisterFocus = function ApplicationContext_unregisterFocus(view) {
		if (this.focusedView === view) this.focusedView = null;
		if (this.pasteboardDelegate)
			this.pasteboardDelegate.unregister(view);};
	

ApplicationContext.prototype.registerDefaultFocus = function ApplicationContext_registerDefaultFocus(view) {
		if (this.pasteboardDelegate)
			this.pasteboardDelegate.registerDefault(view);};
	

ApplicationContext.prototype.unregisterDefaultFocus = function ApplicationContext_unregisterDefaultFocus(view) {
		if (this.pasteboardDelegate)
			this.pasteboardDelegate.unregisterDefault(view);};
	
	
	Object.defineProperty(ApplicationContext.prototype, "focusedElement", {
		get: function () { return this.pasteboardDelegate.focusedElement; }});
	


	
	
ApplicationContext.prototype.windowDidLiveResize = function ApplicationContext_windowDidLiveResize() {
		var e = document.createEvent('CustomEvent');
		e.initCustomEvent("liveResize", false, false, null);
		window.dispatchEvent(e);};
	
	

	
	
	Object.defineProperty(ApplicationContext.prototype, "keyViewController", {
	configurable: true, 
	writable: true});
	
	
ApplicationContext.prototype.registerKeyViewController = function ApplicationContext_registerKeyViewController(vc) {

		if (this.keyViewController)
			this.unregisterKeyViewController();
		
		this.keyViewController = vc;

		this.registerDefaultFocus(vc);

		if (vc.view.hidden) {
			vc.view.hidden = false;
			vc.viewDidAppear();
		}

		vc.view.DOMNode.focus();
		document.body.focus();


		

		if (this._onKeyViewControllerResize) {
			window.removeEventListener('liveResize', this._onKeyViewControllerResize);
		}
			
		this._onKeyViewControllerResize = (function (e) {
	
				this.view.size = {
					width: window.innerWidth,
					height: window.innerHeight
				};
	
			}).bind(vc);
			
		window.addEventListener('liveResize', this._onKeyViewControllerResize);
		
		this._onKeyViewControllerResize();
		
		this.nativeProxy.sendMessage('validateToolbarItems');
};
	

ApplicationContext.prototype.unregisterKeyViewController = function ApplicationContext__unregisterKeyViewController(vc) {
	
		this.unregisterDefaultFocus(this.keyViewController);

		if (!this.keyViewController.view.hidden) {
			this.keyViewController.view.hidden = true;
			this.keyViewController.viewDidDisappear();
		}
			
		delete this.keyViewController;
		
		document.activeElement.blur();};
	

ApplicationContext.prototype.registerMainViewController = function ApplicationContext__registerMainViewController(vc) {

		

		document.body.appendChild(vc.view.DOMNode);
		vc.viewDidLoadCallOnce();
		
		if (!vc.view.hidden) {
			vc.viewDidAppear();
		}
		
		vc.view.size = {
			width: window.innerWidth,
			height: window.innerHeight
		};
		};
	

	
	
	
ApplicationContext.prototype.systemTintDidChange = function ApplicationContext_systemTintDidChange(tint) {
		tint = parseInt(tint);

		window.tint = tint;

		if (this.keyViewController)
			this.keyViewController.view.systemTintDidChange(tint);};
	
	
	
	
	
	var currentContextMenu, currentContextMenuItemsByTag, currentContextMenuEvent;
	
ApplicationContext.prototype.prepareContextMenu = function ApplicationContext__prepareContextMenu(menu, i) {
		if (!i) i = 0;
		if (Array.isArray(menu.items)) menu.items.every(function (item) {
			item.tag = i;
			currentContextMenuItemsByTag.push(item);
			i++;
			if (item.submenu) i = this.prepareContextMenu(item.submenu, i);return true; }, this);
		
		return i;};
	
	
ApplicationContext.prototype.showContextMenu = function ApplicationContext_showContextMenu(menu, e) {
	
		currentContextMenuItemsByTag = [];

		this.prepareContextMenu(menu);
		currentContextMenu = menu;
		currentContextMenuEvent = e;

		this.nativeProxy.sendMessage('openContextMenu', JSON.stringify(menu.encode()));
		
		
		
		var evt = document.createEvent("MouseEvents");
		evt.initEvent("mouseup", true, true);
		window.dispatchEvent(evt);
		};
	
	
ApplicationContext.prototype.handleContextMenuAction = function ApplicationContext_handleContextMenuAction(tag) {
	
		var item = currentContextMenuItemsByTag[tag];
		item.performActionWithEvent(currentContextMenuEvent);
		
		currentContextMenu = null;
		currentContextMenuEvent = null;
		currentContextMenuItemsByTag = null;};
	
	
	
	
	
ApplicationContext.prototype.isCancelEvent = function ApplicationContext_isCancelEvent(e) {
		return (e.keyCode === 27 && !e.altKey && !e.metaKey) ||
		(e.metaKey && e.keyCode === 190);};
	
	
	
	
	
ApplicationContext.prototype.undo = function ApplicationContext_undo() {
		this.undoManager.undo();};
	

ApplicationContext.prototype.redo = function ApplicationContext_redo() {
		this.undoManager.redo();};
	
	
// role UndoManagerPersistanceIDProvider 
		
ApplicationContext.prototype.persistantIDForController = function ApplicationContext_persistantIDForController(controller) {
			return controller.identify();};
		
		
ApplicationContext.prototype.controllerForPersistantID = function ApplicationContext_controllerForPersistantID(pID) {
			return this.globals[pID];};
		
		
	
	
ApplicationContext.prototype.enableModalUndoManager = function ApplicationContext_enableModalUndoManager() {
	
		if (this.hasModalUndoManager) this.disableModalUndoManager();
		
		if (this.undoManager) {
			this.undoManager.disableRegistration();
		}


		this.nativeProxy.sendMessage('enableModalUndoManager');
};
	

ApplicationContext.prototype.disableModalUndoManager = function ApplicationContext_disableModalUndoManager() {

		if (this.undoManager) {
			this.undoManager.enableRegistration();
		}
		
		this.nativeProxy.sendMessage('disableModalUndoManager');

		delete this.hasModalUndoManager;
};
	


	
	
ApplicationContext.prototype.callbackFromNativeProxy = function ApplicationContext_callbackFromNativeProxy(cb) {
		var target, method;
		
		target = this.dissolveKeyPathWithContextObject(cb.target, this.globals) || this.dissolveKeyPathWithContextObject(cb.target, this.projectContext.globals);
		
		if (!target) {
			console.warn('Callback failed, target not found.', cb);
			return;
		}
		
		method = target[cb.method];

		if (!method) {
			console.warn('Callback failed, method not found.', cb);
			return;
		}

		method.call(target, cb.data);
};
	
	
ApplicationContext.prototype.beginModalSessionWithData = function ApplicationContext_beginModalSessionWithData(name, data, callback) {

		this.modalSessionCallback = callback;
		this.nativeProxy.sendMessage('openRemoteDataSourceEditor', data);
	};
	
	
ApplicationContext.prototype.modalSessionDidEndWithData = function ApplicationContext_modalSessionDidEndWithData(data) {
		if (!this.modalSessionCallback) return;
		this.modalSessionCallback(data);
		delete this.modalSessionCallback;};
	
	


	

ApplicationContext.prototype.beep = function ApplicationContext_beep() {
		this.nativeProxy.sendMessage('beep');};
	
	

ApplicationContext.prototype.expectedTypeForProperty = function ApplicationContext_expectedTypeForProperty(key) {
	if (key === "highResolutionEnabled") return "";
	if (key === "focusedElement") return "";
	if (key === "keyViewController") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ApplicationContext; }()));