
registerType('Core', (function () { function PasteboardDelegate() {} var __super = null;

PasteboardDelegate.prototype.initFromData = function PasteboardDelegate_initFromData(data) {

		document.addEventListener('paste', function (e) {
			this.handlePaste(e);
		}.bind(this));

		document.addEventListener('copy', function (e) {
			this.handleCopy(e);
		}.bind(this));

		document.addEventListener('cut', function (e) {
			this.handleCut(e);
		}.bind(this));

		data = null;

		return this;};
	
	
PasteboardDelegate.prototype.register = function PasteboardDelegate_register(obj) {
		this._focusedElement = obj;};
	

PasteboardDelegate.prototype.unregister = function PasteboardDelegate_unregister(obj) {
		if (this._focusedElement === obj)
			this._focusedElement = undefined;};
	

PasteboardDelegate.prototype.registerDefault = function PasteboardDelegate_registerDefault(obj) {
		this._defaultFocusedElement = obj;
		this._focusedElement === obj;};
	

PasteboardDelegate.prototype.unregisterDefault = function PasteboardDelegate_unregisterDefault(obj) {
		if (this._defaultFocusedElement === obj)
			this._defaultFocusedElement = undefined;};
	

	Object.defineProperty(PasteboardDelegate.prototype, "focusedElement", {
		get: function () {
			return this._focusedElement || this._defaultFocusedElement;
		}});
	
	
	
PasteboardDelegate.prototype.clearData = function PasteboardDelegate_clearData(e) {
		if (e) e.clipboardData.clearData();
		else this.context.nativeProxy.sendMessage('pasteboardClearData');};
	

PasteboardDelegate.prototype.setData = function PasteboardDelegate_setData(dataType, data, e) {
		if (e) e.clipboardData.setData(dataType, data);
		else {
			
			
			setTimeout(function () {
				this.context.nativeProxy.sendMessage('pasteboardSetData', dataType, data);
			}.bind(this), 1);
		}};
	

PasteboardDelegate.prototype.getData = function PasteboardDelegate_getData(dataType, data, e) {
		if (e) return e.clipboardData.getData(dataType);
		else return this.context.nativeProxy.sendMessage('pasteboardGetData', dataType);};
	
	
PasteboardDelegate.prototype.containsType = function PasteboardDelegate_containsType(dataType, e) {
		if (e) return e.clipboardData.types.indexOf(dataType) !== -1;
		else return this.context.nativeProxy.sendMessage('pasteboardContainsType', dataType);};
	


	

PasteboardDelegate.prototype.canCopy = function PasteboardDelegate_canCopy() {
		if (this.focusedElement === undefined)
			return false;
		return this.focusedElement.canCopy();};
	

PasteboardDelegate.prototype.canCut = function PasteboardDelegate_canCut() {
		if (this.focusedElement === undefined) return false;
		return this.focusedElement.canCopy() && this.focusedElement.canCut();};
	
		
PasteboardDelegate.prototype.canPaste = function PasteboardDelegate_canPaste() {

		if (this.focusedElement === undefined)
			return false;
	
		return this.focusedElement.canPaste();};
	

PasteboardDelegate.prototype.canSelectAll = function PasteboardDelegate_canSelectAll() {
		if (this.focusedElement === undefined)
			return false;
		
		if (!this.focusedElement.canSelectAll) {
			console.warn('canSelectAll() not implemented in', this.focusedElement);
			return false;
		};
	
		return this.focusedElement.canSelectAll();};
	

PasteboardDelegate.prototype.canUnselectAll = function PasteboardDelegate_canUnselectAll() {
		return this.focusedElement && this.focusedElement.canUnselectAll && this.focusedElement.canUnselectAll();};
	

PasteboardDelegate.prototype.canDuplicate = function PasteboardDelegate_canDuplicate() {

		if (this.focusedElement === undefined)
			return false;

		if (!this.focusedElement.canDuplicate) {
			console.warn('canDuplicate() not implemented in', this.focusedElement);
			return false;
		};
	
		return this.focusedElement.canDuplicate();};
	

PasteboardDelegate.prototype.canDelete = function PasteboardDelegate_canDelete() {

		if (this.focusedElement === undefined)
			return false;

		if (!this.focusedElement.canDelete) {
			console.warn('canDelete() not implemented in', this.focusedElement);
			return false;
		};
	
		return this.focusedElement.canDelete();};
	


PasteboardDelegate.prototype.handlePaste = function PasteboardDelegate_handlePaste(e) {
		if (this.focusedElement !== undefined &&
			this.focusedElement.paste(e, this) === true)
				e.preventDefault();};
	

PasteboardDelegate.prototype.handleCopy = function PasteboardDelegate_handleCopy(e) {
		if (this.focusedElement !== undefined &&
			this.focusedElement.copy(e, this) === true) {
				e.preventDefault();
			}};
	

PasteboardDelegate.prototype.handleCut = function PasteboardDelegate_handleCut(e) {
		if (this.focusedElement !== undefined &&
			this.focusedElement.cut(e, this) === true)
				e.preventDefault();};
	
	
PasteboardDelegate.prototype.handleSelectAll = function PasteboardDelegate_handleSelectAll() {
		if (this.focusedElement === undefined)
			return false;
	
		return this.focusedElement.selectAll(this);};
	

PasteboardDelegate.prototype.handleUnselectAll = function PasteboardDelegate_handleUnselectAll() {
		if (!this.focusedElement || !this.focusedElement.unselectAll)
			return false;
	
		return this.focusedElement.unselectAll(this);};
	

PasteboardDelegate.prototype.handleDelete = function PasteboardDelegate_handleDelete() {
		if (this.focusedElement === undefined)
			return false;
	
		return this.focusedElement.deleteSelection(this);};
	

PasteboardDelegate.prototype.handleDuplicate = function PasteboardDelegate_handleDuplicate() {
		if (this.focusedElement === undefined)
			return false;
	
		return this.focusedElement.duplicateSelection(this);};
	

PasteboardDelegate.prototype.expectedTypeForProperty = function PasteboardDelegate_expectedTypeForProperty(key) {
	if (key === "focusedElement") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return PasteboardDelegate; }()));