
registerType('Core', (function () { function ArrayController() {} var __super = setSupertypeFromDomain(ArrayController, 'ObjectController', 'Core');

ArrayController.prototype.init = function ArrayController_init() {
		var self = __super.prototype.init.call(this);
		Object.defineProperty(this, "selectedIndices", {
			value: []});
		
		if (!self.contents) this.contents = [];
		return self;};
	


	

// role ArrayController 
	
		Object.defineProperty(ArrayController.prototype, "numberOfValues", {
			get: function () {
				return this.contents.length;
			}});
		
		
		
		
ArrayController.prototype.hasValue = function ArrayController_hasValue(value) {
			return this.contents.indexOf(value) !== -1;};
		
		
ArrayController.prototype.valueAtIndex = function ArrayController_valueAtIndex(i) {
			return this.contents[i];};
		
	
		Object.defineProperty(ArrayController.prototype, "lastValue", {
			get: function () {
				return this.contents[this.contents.length-1];
			}});
		

		Object.defineProperty(ArrayController.prototype, "firstValue", {
			get: function () {
				return this.contents[0];
			}});
		
		


		
	
ArrayController.prototype.insertValueAtIndex = function ArrayController_insertValueAtIndex(value, index, sender) {

			this.moveValueInSelection(this.contents.length, index);

			this.contents.splice(index, 0, value);
	
			this.context.broadcastInsertionForObject(index, this, sender);
	
			if (this.canUndo === true) {
				var change = {
					type: 'insert',
					value: value,
					index: index
				};
	
				this.context.undoManager.registerChange(this, change);
			}
};
		

ArrayController.prototype.addValue = function ArrayController_addValue(value, sender) {
			this.insertValueAtIndex(value, this.contents.length, sender);};
		

ArrayController.prototype.removeValue = function ArrayController_removeValue(value, sender) {
		
			var index = this.contents.indexOf(value);
			if (index !== -1) {
				this.unselectValue(value, sender);
				this.removeValueAtIndex(index, sender);
			}
			else
				console.warn('Removing a value failed, not in the dataset:', value, this, 'sender:', sender);
			};
		
	
ArrayController.prototype.removeValueAtIndex = function ArrayController_removeValueAtIndex(index, sender) {
		
			if (this.selectedIndices.indexOf(index) !== -1);
				this.selectedIndices.splice(this.selectedIndices.indexOf(index), 1);
			
			var value = this.contents[index];
			this.contents.splice(index, 1);

			this.context.broadcastDeletionForObject(index, value, this, sender);
	
			if (this.canUndo === true) {
				var change = {
					type: 'remove',
					value: value,
					index: index
				};
	
				this.context.undoManager.registerChange(this, change);
			}
};
		

ArrayController.prototype.removeObjectForKey = function ArrayController_removeObjectForKey(key, sender) {
			return this.removeValueAtIndex(key, sender);};
		
		
ArrayController.prototype.moveValueFromIndexToIndex = function ArrayController_moveValueFromIndexToIndex(oldIndex, newIndex, sender) {
		
			if (newIndex < 0 || newIndex >= this.contents.length) return;
		
			var spliced = this.contents.splice(oldIndex, 1);
			this.contents.splice(newIndex, 0, spliced[0]);
			
			this.moveValueInSelection(oldIndex, newIndex)
						
			this.context.broadcastKeyChangeForKeyPathInObject(oldIndex, newIndex, '', this, sender);

			if (this.canUndo === true) {
				this.context.undoManager.registerChange(this, {
					type: 'indexChange',
					oldIndex: oldIndex,
					newIndex: newIndex
				});
			}
		};
		
		
ArrayController.prototype.replaceWithValues = function ArrayController_replaceWithValues(values, sender) {
			console.warn('replaceWithValues() is deprecated. use setValues() instead.');
			console.trace();
		
			if (!values) values = [];
	
			this.contents.splice(0, this.contents.length);
			this.selectedIndices.splice(0, this.selectedIndices.length);
			
			if (Array.isArray(values)) values.every(function (value) {
				this.contents.push(value);return true; }, this);
			
			
			this.context.broadcastValueReplacementForObject(this, sender);
};
		

ArrayController.prototype.setValues = function ArrayController_setValues(values, sender) {
			if (!values) values = [];
			this.selectedIndices.splice(0, this.selectedIndices.length);
			this.contents = values;
			this.context.broadcastValueReplacementForObject(this, sender);};
		
		
ArrayController.prototype.removeAllValues = function ArrayController_removeAllValues(sender) {
			this.setValues([], sender);};
		


		

ArrayController.prototype.selectValue = function ArrayController_selectValue(value, sender) {
			var index = this.contents.indexOf(value);
			if (index === -1) return;
			if (this.selectedIndices.indexOf(index) !== -1) return;
			this.selectedIndices.push(index);
			this.didSelectIndex(index, true, sender);};
		
		
ArrayController.prototype.selectAllValues = function ArrayController_selectAllValues(sender) {
			if (Array.isArray(this.contents)) this.contents.every(function (value) {
				this.selectValue(value, sender);return true; }, this);
			};
		

ArrayController.prototype.unselectValue = function ArrayController_unselectValue(value, sender) {
			var index = this.contents.indexOf(value);
			if (index === -1) return;
			if (this.selectedIndices.indexOf(index) === -1) return;
			this.selectedIndices.splice(this.selectedIndices.indexOf(index), 1);
			this.didSelectIndex(index, false, sender);};
		
		
ArrayController.prototype.unselectAllValues = function ArrayController_unselectAllValues(sender) {
			if (Array.isArray(this.selectedIndices)) this.selectedIndices.every(function (index) {
				this.didSelectIndex(index, false, sender);return true; }, this);
			
			this.selectedIndices.splice(0, this.selectedIndices.length);};
		
		
ArrayController.prototype.valueIsSelected = function ArrayController_valueIsSelected(value) {
			var index = this.contents.indexOf(value);
			return this.selectedIndices.indexOf(index) !== -1;};
		
		
		Object.defineProperty(ArrayController.prototype, "selectedValues", {
			get: function () {
				var a = [];
				if (this.selectedIndices) {
					this.selectedIndices.sort();
					if (Array.isArray(this.selectedIndices)) this.selectedIndices.every(function (index) {
						a.push(this.contents[index]);return true; }, this);
					
				}
				return a;
			}});
		
		
		
		
ArrayController.prototype.valuesPassingTest = function ArrayController_valuesPassingTest(test) {
			var r = [];
			if (Array.isArray(this.contents)) this.contents.every(function (v) {
				if (test(v) === true) r.push(v);return true; }, this);
			
			return r;};
		

ArrayController.prototype.valuePassingTest = function ArrayController_valuePassingTest(test) {
			var r;
			if (Array.isArray(this.contents)) this.contents.every(function (v) {
				if (test(v) === true) { r = v; return false; }return true; }, this);
			
			return r;};
		
	
	
	
ArrayController.prototype.moveValueInSelection = function ArrayController__moveValueInSelection(oldIndex, newIndex) {

		
		
		var selectedIndicesOld = clone(this.selectedIndices);
		this.selectedIndices.splice(0, this.selectedIndices.length);

		if (Array.isArray(selectedIndicesOld)) selectedIndicesOld.every(function (index) {
			if (index === oldIndex) this.selectedIndices.push(newIndex);
			else {
				if (index > oldIndex && index <= newIndex) {
					this.selectedIndices.push(--index);
				}
				else if (index >= newIndex && index < oldIndex) {
					this.selectedIndices.push(++index);
				}
				else {
					this.selectedIndices.push(index);
				}
			}return true; }, this);
		
};
	
	
ArrayController.prototype.didSelectIndex = function ArrayController__didSelectIndex(index, isSelected, sender) {
		this.context.broadcastSelectionChangeForKeyPathInObject(index, isSelected, this, sender);
		if (!this.isChangingSelection)
			this.commitSelectionChange(sender);};
	

// role UndoCapableObject (Core) 

ArrayController.prototype.readableUndoName = function ArrayController_readableUndoName(change) {
		
			if (change.type === 'indexChange') {
				return LocalizedString('Change Order');
			}

			return __super.prototype.readableUndoName.call(this, change);
		
};
		

ArrayController.prototype.readableUndoDetails = function ArrayController_readableUndoDetails(change) {
	
			if (change.type === 'indexChange') {
				return change.newIndex + ' -> ' + change.oldIndex;
			}
			
			return __super.prototype.readableUndoDetails.call(this, change);
		};
		
	
ArrayController.prototype.undoChange = function ArrayController_undoChange(change) {
			
			if (change.type === 'insert') {
				this.removeValueAtIndex(change.index, this);
			}
			else if (change.type === 'remove') {
				this.insertValueAtIndex(change.value, change.index, this);
			}
			else if (change.type === 'indexChange') {
				this.moveValueFromIndexToIndex(change.newIndex, change.oldIndex, this);
			}
			else
				__super.prototype.undoChange.call(this, change);
			
			if (this.undoDelegate && this.undoDelegate.objectControllerDidUndoChange)
				this.undoDelegate.objectControllerDidUndoChange(this, change);
};
		

	

ArrayController.prototype.expectedTypeForProperty = function ArrayController_expectedTypeForProperty(key) {
	if (key === "selectedIndices") return "";
	if (key === "numberOfValues") return "";
	if (key === "lastValue") return "";
	if (key === "firstValue") return "";
	if (key === "selectedValues") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ArrayController; }()));