
registerType('Core', (function () { function BasicObject() {} var __super = null;
	
// role BasicObject 
	
BasicObject.prototype.initFromData = function BasicObject_initFromData(data) {
		
			this.initPropertiesFromData(data);
			this.init();
	
			return this;};
		
		
BasicObject.prototype.init = function BasicObject_init() {
			return this;};
		
	
BasicObject.prototype.destroy = function BasicObject_destroy() {
	
			if (this._isDestroyed !== undefined) {
				return;
			}
			Object.defineProperty(this, "_isDestroyed", {
				value: true});
			
	
			this.unregisterBindings();
			this.unregisterObservations();
			
			this.context.unidentify(this);
		};
		
	
	
	
BasicObject.prototype.initPropertiesFromData = function BasicObject__initPropertiesFromData(data) {
		var properties = ['bindings', 'observations', 'globalBindingsSymbol', 'isExpandedInEditorOutline', 'locked'];

		if (Array.isArray(properties)) properties.every(function (key) {
			if (data.hasOwnProperty(key)) {
				this[key] = data[key];
			}return true; }, this);
		};
	

	Object.defineProperty(BasicObject.prototype, "globalBindingsSymbol", {
	enumerable: true, 
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_globalBindingsSymbol")) Object.defineProperty(this, "_globalBindingsSymbol", { writable: true, configurable: true });
			this._globalBindingsSymbol = v;
			this.context.registerGlobal(v, this);
		}, get:function () { return this._globalBindingsSymbol; }});
	

	
	
	
	
// role EncodableObject 
		
BasicObject.prototype.encode = function BasicObject_encode() {
			try {
				return this.context.encodeObject(this);
			} catch (err) {
				return {};
			}};
		

BasicObject.prototype.encodeCloned = function BasicObject_encodeCloned() {
			var data = this.encode();
			delete data.$id;
			return data;};
		

BasicObject.prototype.decodeData = function BasicObject_decodeData(data) {
			return clone(data);};
		

BasicObject.prototype.initFromArchive = function BasicObject_initFromArchive(data) {
			this.initFromData(data);};
		
		
BasicObject.prototype.clone = function BasicObject_clone() {
			return this.context.decodeObjectTree(this.encodeCloned());};
		
		

BasicObject.prototype.shallowClone = function BasicObject_shallowClone() {
			return clone(this);};
		

	


	
	
// role KeyValueCodingObject 
	
BasicObject.prototype.get = function BasicObject_get(keyPath, obj) {
			
			return this.context.getValueForKeyPathInObject(keyPath, obj || this);
	};
		
	
BasicObject.prototype.set = function BasicObject_set(obj, silent, sender) {
		
			for (key in obj) {
				this[key] = obj[key];
			}
			return true;};
		
	
BasicObject.prototype.setValueForKeyPath = function BasicObject_setValueForKeyPath(value, keyPath, sender) {
			this.context.setValueForKeyPathInObject(value, keyPath, this);};
		
		
BasicObject.prototype.identify = function BasicObject_identify() {
			return this.$id || this.context.identify(this);};
		
	
	


	
	
// role BindingsCapableObject 

		Object.defineProperty(BasicObject.prototype, "bindings", {
		enumerable: true, 
		synthesized: true, 
	
			set: function (v) {if (!Object.hasOwnProperty(this, "_bindings")) Object.defineProperty(this, "_bindings", { writable: true, configurable: true });
				this.unregisterBindings();
				this._bindings = v;
				if (v) {
					this.registerBindings();
				}
			}
	, get:function () { return this._bindings; }});
		

BasicObject.prototype.addBinding = function BasicObject_addBinding(binding) {
			if (!this.bindings) this.bindings = [];
	
			this.bindings.push(binding);
			this.context.registerBindingForObject(binding, this);};
		
		
BasicObject.prototype.removeBinding = function BasicObject_removeBinding(binding) {

			if (!this.bindings) return;
			
			this.bindings.splice(this.bindings.indexOf(binding), 1);
			this.context.unregisterBinding(binding);};
		
	
BasicObject.prototype.valueShouldChangeForKeyPath = function BasicObject_valueShouldChangeForKeyPath(value, keyPath) {
		
			this.context.setValueForKeyPathInObject(value, keyPath, this);
			
			return true;};
		

BasicObject.prototype.applyBindings = function BasicObject_applyBindings(isInitializing, destinationOnly) {

			if (!this.bindings) return;
			
			if (Array.isArray(this.bindings)) this.bindings.every(function (binding) {
				if (destinationOnly && binding.destination !== destinationOnly.$id) {
					return true;
				}

				if (!(isInitializing === true && binding.ignoreWhenInitializing === true))
					this.context.applyBinding(binding);
return true; }, this);
			};
		

BasicObject.prototype.bindingsDidChange = function BasicObject_bindingsDidChange(sender) {
			this.context.broadcastValueChangeForKeyPathInObject('bindings', this, sender);};
		
		
BasicObject.prototype.bindingForKey = function BasicObject_bindingForKey(key) {

			if (!this.bindings) return;

			for (var i = 0, c = this.bindings.length; i < c; i++) {
				if (this.bindings[i].sourceKeyPath === key) return this.bindings[i];
			}
		};
		

BasicObject.prototype.hasBindingForKey = function BasicObject_hasBindingForKey(key) {

			return typeof this.bindingForKey(key) === 'object';
		};
		
		
BasicObject.prototype.hasReadonlyBindingForKey = function BasicObject_hasReadonlyBindingForKey(key) {
			var binding = this.bindingForKey(key);
			if (binding) {
				return binding.destinationObject && !binding.destinationObject.mutable;
			}
			return false;};
		

	
	
BasicObject.prototype.performBidirectionalBindingForKey = function BasicObject__performBidirectionalBindingForKey(key) {
		var binding = this.bindingForKey(key);
		if (binding && binding.destinationObject && binding.destinationObject.isMutable) {
			binding.destinationObject.setValueForKeyPath(this[key], binding.destinationKeyPath, this);
		}};
	

BasicObject.prototype.registerBindings = function BasicObject__registerBindings() {

		if (Array.isArray(this.bindings)) this.bindings.every(function (binding) {
			this.context.registerBindingForObject(binding, this);return true; }, this);
		
};
	

BasicObject.prototype.unregisterBindings = function BasicObject__unregisterBindings() {

		if (!this.bindings)
			return;

		if (Array.isArray(this.bindings)) this.bindings.every(function (binding) {
			if (Array.isArray(binding)) {
				console.warn('This binding is deprecated:', binding);
				return true;
			}
			this.context.unregisterBinding(binding);return true; }, this);
		
		
		delete this.bindings;
};
	
	
	
	
	
// role Observer 
	
		Object.defineProperty(BasicObject.prototype, "observations", {
		synthesized: true, 
	
			set: function (v) {if (!Object.hasOwnProperty(this, "_observations")) Object.defineProperty(this, "_observations", { writable: true, configurable: true });
			
				this._observations = v;
				
				if (Array.isArray(v))
				if (Array.isArray(v)) v.every(function (observation) {
	
					var observedObject = this.context.dissolveKeyPathWithContextObject(
						observation.keyPath, this);
	
					observation.observedObject = observedObject;
					
					if (observedObject === undefined) {
						console.warn('Could not add observation, keyPath could not be dissolved: ', observation.keyPath, observation, this);
						return true;
					}
					
					this.observeObject(observedObject);
	return true; }, this);
				
			}
		, get:function () { return this._observations; }});
		
	
BasicObject.prototype.observeObject = function BasicObject_observeObject(observedObject) {
	
			if (this._observations === undefined) this.observations = [];
			else if (this.observationForObject(observedObject) !== undefined) {
				return;
			}
	
			this.context.identify(observedObject);
			this.context.registerObservation(this, observedObject);
			
			this._observations.push({
				observedObject: observedObject
			});
	};
		
	
BasicObject.prototype.unobserveObject = function BasicObject_unobserveObject(observedObject) {
			var o = this.observationForObject(observedObject);
			if (o !== undefined) {
				this.context.unregisterObservation(this, o.observedObject);
				this._observations.splice(this._observations.indexOf(o), 1);
			}};
		
		
BasicObject.prototype.observationForObject = function BasicObject_observationForObject(observedObject) {
			if (!this._observations) return;
			for (var i = 0, c = this._observations.length; i < c; i++) {
				if (this._observations[i] && this._observations[i].observedObject === observedObject) {
					return this._observations[i];
				}
			}
		};
		
		
BasicObject.prototype.removeAllObservations = function BasicObject_removeAllObservations() {
			this.unregisterObservations();
			delete this._observations;};
		
		
	

// role ObserverContextInterface 

BasicObject.prototype.observedObjectValueDidAppearForKey = function BasicObject_observedObjectValueDidAppearForKey(obj, key, sender) {};
		

BasicObject.prototype.observedObjectValueWillDisappearForKey = function BasicObject_observedObjectValueWillDisappearForKey(obj, item, key, sender) {};
		
		
BasicObject.prototype.observedObjectValueDidDisappearForKey = function BasicObject_observedObjectValueDidDisappearForKey(obj, value, key, sender) {};
		

BasicObject.prototype.observedObjectValueDidChangeKey = function BasicObject_observedObjectValueDidChangeKey(obj, oldKey, newKey, keyPath, sender) {};
		

BasicObject.prototype.observedObjectValuesDidReplace = function BasicObject_observedObjectValuesDidReplace(obj, sender) {};
		

BasicObject.prototype.observedObjectValueWillChangeForKeyPath = function BasicObject_observedObjectValueWillChangeForKeyPath(obj, keyPath, sender) {};
		

BasicObject.prototype.observedObjectValueDidChangeForKeyPath = function BasicObject_observedObjectValueDidChangeForKeyPath(obj, keyPath, sender) {};
		
		
BasicObject.prototype.observedObjectSelectionDidChangeForKeyPath = function BasicObject_observedObjectSelectionDidChangeForKeyPath(obj, index, isSelected, sender) {};
		
		
BasicObject.prototype.observedObjectSelectionDidChange = function BasicObject_observedObjectSelectionDidChange(obj, sender) {};
		

	
	
BasicObject.prototype.unregisterObservations = function BasicObject__unregisterObservations() {
	
		if (this._observations === undefined) return;
		
		if (Array.isArray(this._observations)) this._observations.every(function (observation) {
			if (observation) this.context.unregisterObservation(this, observation.observedObject);return true; }, this);
		
		};
	


	

BasicObject.prototype.callDelegate = function BasicObject__callDelegate(methodName, args) {

		if (this.delegate === undefined)
			return;

		var f = this.delegate[methodName];

		if (f === undefined)
			return;
		
		return f.apply(this.delegate, args);
		};
	

BasicObject.prototype.delegateRespondsTo = function BasicObject__delegateRespondsTo(methodName) {
		if (!this.delegate) return false;
		return !!this.delegate[methodName];};
	
	
	
	
	
BasicObject.prototype.listen = function BasicObject_listen(obj, eventType, handler) {
		obj.addEventListener(eventType, handler);};
	

BasicObject.prototype.unlisten = function BasicObject_unlisten(obj, eventType) {
		obj.removeEventListener(eventType);};
	
	
BasicObject.prototype.addEventListener = function BasicObject_addEventListener(eventType, handler) {
	
		if (this.eventListeners === undefined) {
			Object.defineProperty(this, "eventListeners", {
				value: []});
			
		}
		
		this.eventListeners.push({
			eventType: eventType,
			handler: handler
		});
};
	

BasicObject.prototype.removeEventListener = function BasicObject_removeEventListener(eventType) {
		if (Array.isArray(this.eventListeners)) this.eventListeners.every(function (l) {
			if (l.eventType === eventType) {
				this.eventListeners.splice(this.eventListeners.indexOf(l));
				return false;
			}return true; }, this);
		};
	

BasicObject.prototype.dispatchEvent = function BasicObject_dispatchEvent(event) {
	
		if (this.eventListeners === undefined)
			return;

		if (Array.isArray(this.eventListeners)) this.eventListeners.every(function (item) {
			if (item.eventType !== event.type) return true;
			item.handler.call(this, event);return true; }, this);
		
		};
	


	

	Object.defineProperty(BasicObject.prototype, "readableValue", {
		get: function () {
			return this.name || this.readableType || this.constructor.name;
		}});
	
	
	Object.defineProperty(BasicObject.prototype, "readableBindings", {
		get: function () {
			if (!this.bindings || !this.bindings.length)
				return LocalizedString('No Data Links');
			if (this.bindings.length === 1) {
				if (this.bindings[0].destinationObject) {
					var readablePropertyName = this.readableNameForProperty(this.bindings[0].sourceKeyPath)||'?';
					
					var v = this.bindings[0].destinationObject.nameForKeyPath(this.bindings[0].destinationKeyPath);

					var readableDestinationKeyPath = LocalizedString('„')+v+LocalizedString('“');

					var readableDestination = LocalizedString('„')+this.bindings[0].destinationObject.readableValue+LocalizedString('“');
					
					return ''+readablePropertyName+' '+LocalizedString('linked to')+' '+readableDestinationKeyPath+' '+LocalizedString('in')+' '+readableDestination;
				}
				return LocalizedString('1 Data Link');
			}
			return this.bindings.length+' '+LocalizedString('Data Links');
		}});
	
	
BasicObject.prototype.nameForKeyPath = function BasicObject_nameForKeyPath(keyPath) {};
	
	
BasicObject.prototype.readableValueDidChange = function BasicObject__readableValueDidChange() {
		this.context.broadcastValueChangeForKeyPathInObject('readableValue', this, this);};
	
	
BasicObject.prototype.readableNameForProperty = function BasicObject__readableNameForProperty(propertyName) {};
	

BasicObject.prototype.undoNameForKeyPaths = function BasicObject__undoNameForKeyPaths(keyPaths) {

		if (keyPaths.indexOf('e_locked') !== -1) {
			return 'Schutz ändern';
		}
	};
	
	
	
	
	Object.defineProperty(BasicObject.prototype, "UTI", {
		get: function () {
			return this.__domain + '.' + this.constructor.name;
		}});
	


BasicObject.prototype.expectedTypeForProperty = function BasicObject_expectedTypeForProperty(key) {
	if (key === "globalBindingsSymbol") return "";
	if (key === "bindings") return "";
	if (key === "observations") return "";
	if (key === "eventListeners") return "";
	if (key === "readableValue") return "";
	if (key === "readableBindings") return "";
	if (key === "UTI") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return BasicObject; }()));