
registerType('Core', (function () { function ObjectController() {} var __super = setSupertypeFromDomain(ObjectController, 'BasicObject', 'Core');


	
	
	Object.defineProperty(ObjectController.prototype, "contents", {
	outlet: true, 
	synthesized: true, get:function () { return this._contents; }, set:function (v) {if (!Object.hasOwnProperty(this, "_contents")) Object.defineProperty(this, "_contents", { writable: true, configurable: true }); this._contents = v; }});
	

	Object.defineProperty(ObjectController.prototype, "canUndo", {
	outlet: true, 
	synthesized: true, get:function () { return this._canUndo; }, set:function (v) {if (!Object.hasOwnProperty(this, "_canUndo")) Object.defineProperty(this, "_canUndo", { writable: true, configurable: true }); this._canUndo = v; }});
	

	Object.defineProperty(ObjectController.prototype, "undoDelegate", {
	outlet: true, 
	synthesized: true, get:function () { return this._undoDelegate; }, set:function (v) {if (!Object.hasOwnProperty(this, "_undoDelegate")) Object.defineProperty(this, "_undoDelegate", { writable: true, configurable: true }); this._undoDelegate = v; }});
	
	
	Object.defineProperty(ObjectController.prototype, "selectionModeChange", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_selectionModeChange")) Object.defineProperty(this, "_selectionModeChange", { writable: true, configurable: true });
			if (v < 0) v = 0;
			this._selectionModeChange = v;
		}, 
		get: function () {
			if (this._selectionModeChange === undefined) this.selectionModeChange = 0;
			return this._selectionModeChange;
		}});
	


	

ObjectController.prototype.get = function ObjectController_get(keyPath) {
		return __super.prototype.get.call(this, keyPath, this.contents);};
	


	

ObjectController.prototype.set = function ObjectController_set(obj, sender, silent) {
		
		var useNotifications = (this.announcedChanges === undefined) && silent !== true;
		
		if (useNotifications)
			this.beginChangingValuesForKeyPaths(Object.keys(obj), sender);


		for (var keyPath in obj) {
			this.context.setValueForKeyPathInObject(obj[keyPath], keyPath, this.contents);
		}

		if (useNotifications)
			this.endChangingValuesForKeyPaths(Object.keys(obj), sender || this);
		};
	
	
ObjectController.prototype.setValueForKeyPath = function ObjectController_setValueForKeyPath(value, keyPath, sender, silent) {

		if (this.announcedChanges === undefined && this.canUndo === true) {

			var before = this.get(keyPath);
			if (before !== value) {
			
				var change = {
					keyPath: keyPath,
					valueBefore: before,
					valueNow: value
				};

				this.context.undoManager.registerChange(this, change);
			}

		}

		if (silent !== true) {
			this.context.broadcastValueChangeAnnouncementForKeyPathInObject(keyPath, this, sender);
		}

		this.context.setValueForKeyPathInObject(value, keyPath, this.contents);

		if (silent !== true) {
			this.context.broadcastValueChangeForKeyPathInObject(keyPath, this, sender);
		}
};
	

ObjectController.prototype.setValueForKey = function ObjectController_setValueForKey(value, key, sender, silent) {
		this.setValueForKeyPath(value, key, sender, silent);};
	
	
ObjectController.prototype.insertObjectForKey = function ObjectController_insertObjectForKey(obj, key, sender) {

		this.contents[key] = obj;

		this.context.broadcastInsertionForObject(key, this, sender);

		if (this.canUndo === true) {
			var change = {
				type: 'insert',
				value: obj,
				key: key
			};

			this.context.undoManager.registerChange(this, change);
		}};
	

ObjectController.prototype.removeObjectForKey = function ObjectController_removeObjectForKey(key, sender) {

		var value = this.get(key);

		delete this.contents[key];
	
		this.context.broadcastDeletionForObject(key, value, this, sender);

		if (this.canUndo === true) {
			var change = {
				type: 'remove',
				value: value,
				key: key
			};

			this.context.undoManager.registerChange(this, change);
		}
		};
	


	

ObjectController.prototype.replaceWithData = function ObjectController_replaceWithData(newData, sender) {
		this.contents = newData;
		this.context.broadcastValueReplacementForObject(this, sender);};
	


	

ObjectController.prototype.beginChangingValuesForKeyPaths = function ObjectController_beginChangingValuesForKeyPaths(keyPaths, sender) {

		this.announcedChanges = keyPaths;
		
		if (this.canUndo === true) {
			this.valuesBefore = this.valuesForKeyPaths(keyPaths);
		}
		
		if (Array.isArray(keyPaths)) keyPaths.every(function (keyPath) {
			this.context.broadcastValueChangeAnnouncementForKeyPathInObject(keyPath, this, sender);return true; }, this);
		
		};
	

ObjectController.prototype.endChangingValuesForKeyPaths = function ObjectController_endChangingValuesForKeyPaths(keyPaths, sender) {
		this.announcedChanges = undefined;
		if (keyPaths.length === 0) return;
		if (sender === undefined) sender = this;

		if (Array.isArray(keyPaths)) keyPaths.every(function (keyPath) {
			this.context.broadcastValueChangeForKeyPathInObject(keyPath, this, sender);return true; }, this);
		

		if (this.canUndo === true) {
			var before = this.valuesBefore,
				now = this.valuesForKeyPaths(keyPaths);
				
			if (objectValuesAreEqual(before, now) !== true) {
			var change = {
				keyPaths: keyPaths,
				valuesBefore: before,
				valuesNow: now
			};

			this.context.undoManager.registerChange(this, change);
			}
		}};
	
	
ObjectController.prototype.valuesForKeyPaths = function ObjectController__valuesForKeyPaths(keyPaths) {
		var v = {};
		
		if (Array.isArray(keyPaths)) keyPaths.every(function (keyPath) {
			v[keyPath] = this.get(keyPath);return true; }, this);
		

		return v;};
	
	

	

ObjectController.prototype.beginSelectionChange = function ObjectController_beginSelectionChange() {
		this.selectionModeChange++;
		this.isChangingSelection = true;};
	

ObjectController.prototype.commitSelectionChange = function ObjectController_commitSelectionChange(sender) {
		this.selectionModeChange--;
		if (this.selectionModeChange === 0) {
			this.isChangingSelection = false;
			this.context.broadcastSelectionChangeForObject(this, sender || this);
		}};
	


	
	
// role BindingsCapableObject (Core) 

ObjectController.prototype.valueShouldChangeForKeyPath = function ObjectController_valueShouldChangeForKeyPath(value, keyPath, sender) {
			this.setValueForKeyPath(value, keyPath, sender, true);
			return true;};
		
		
	
	
	
	

// role UndoCapableObject (Core) 

ObjectController.prototype.readableUndoName = function ObjectController_readableUndoName(change) {

			if (change.type === 'remove') {
				return LocalizedString('Remove Element');
			}
		
			var a = change.keyPaths || [change.keyPath];
			if (this.contents && this.contents.undoNameForKeyPaths)
				return this.contents.undoNameForKeyPaths(a);
};
		

ObjectController.prototype.readableUndoDetails = function ObjectController_readableUndoDetails(change) {

			if (change.type === 'remove') {
				return '';
			}
	
			if (change.keyPaths) {
				var t = '';
				if (Array.isArray(change.keyPaths)) change.keyPaths.every(function (kp) {
					t += kp + '=' + change.valuesBefore[kp] + ', ';return true; }, this);
				
				return t.substr(0, t.length-2);
			}
			return change.keyPath + '=' + change.valueBefore;
		};
		
	
ObjectController.prototype.undoChange = function ObjectController_undoChange(change) {

			if (change.type === 'remove') {
				this.insertObjectForKey(change.value, change.key, this);
				return;
			}

			if (change.type === 'insert') {
				this.removeObjectForKey(change.key, this);
				return;
			}
			
			if (change.valuesBefore) {
				this.set(change.valuesBefore, this);
			}
			else {
				this.setValueForKeyPath(change.valueBefore, change.keyPath, this);
			}
			
			if (this.undoDelegate && this.undoDelegate.objectControllerDidUndoChange)
				this.undoDelegate.objectControllerDidUndoChange(this, change);
};
		

	

	
	function objectValuesAreEqual(obj1, obj2) {
		for (var i in obj2) {
			if (obj2.hasOwnProperty(i)) {
				if (!obj1.hasOwnProperty(i)) return false;
				if (obj1[i] != obj2[i]) return false;
			}
		}
		return true;
	}
	
ObjectController.prototype.initPropertiesFromData = function ObjectController_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("contents")) this.contents = data.contents;
if (data.hasOwnProperty("canUndo")) this.canUndo = data.canUndo;
if (data.hasOwnProperty("undoDelegate")) this.undoDelegate = data.undoDelegate;
};

ObjectController.prototype.decodeData = function ObjectController_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

ObjectController.prototype.encode = function ObjectController_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

ObjectController.prototype.encodeCloned = function ObjectController_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

ObjectController.prototype.expectedTypeForProperty = function ObjectController_expectedTypeForProperty(key) {
	if (key === "contents") return "";
	if (key === "canUndo") return "";
	if (key === "undoDelegate") return "";
	if (key === "selectionModeChange") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ObjectController; }()));