
registerType('Core', (function () { function TreeController() {} var __super = setSupertypeFromDomain(TreeController, 'ObjectController', 'Core');

	Object.defineProperty(TreeController.prototype, "contents", {
	outlet: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_contents")) Object.defineProperty(this, "_contents", { writable: true, configurable: true });
			if (Array.isArray(v)) {
				var i = 0;
				if (Array.isArray(v)) v.every(function (obj) {
					this.rootNode.addChildNodeWithRepresentedObject(obj);
					i++;return true; }, this);
				
			}
			else {
				this.rootNode.addChildNodeWithRepresentedObject(v);
			}
		}, get:function () { return this._contents; }});
	
	
TreeController.prototype.objectForIndexPath = function TreeController_objectForIndexPath(indexPath) {
		var node = this.nodeForIndexPath(indexPath);
		return node ? node.representedObject : null;};
	
	
TreeController.prototype.nodeForRepresentedObject = function TreeController_nodeForRepresentedObject(representedObject) {
		return this.rootNode.nodeForRepresentedObject(representedObject);};
	
	
TreeController.prototype.indexPathForObject = function TreeController_indexPathForObject(representedObject) {
		var node = this.nodeForRepresentedObject(representedObject);
		return node.indexPath;};
	
	
TreeController.prototype.clear = function TreeController_clear() {
		var isReplacing = !!this.rootNode;
		this.rootNode = createComponentFromDomain("TreeNode", "Core", this.context, {
			controller: this})
		;
		this.selectedNodes = [];
		if (isReplacing) this.context.broadcastValueReplacementForObject(this, this);};
	


	
	
TreeController.prototype.nodeIsSelected = function TreeController_nodeIsSelected(node) {
		return this.selectedNodes.indexOf(node) !== -1;};
	
	
TreeController.prototype.selectNode = function TreeController_selectNode(node, sender) {
		if (!node) return;
		if (this.nodeIsSelected(node)) return;
		this.selectedNodes.push(node);
		this.selectionDidChangeForNode(node, true, sender);
		if (!this.isChangingSelection) this.commitSelectionChange(sender);};
	
	
TreeController.prototype.unselectNode = function TreeController_unselectNode(node, sender) {
		if (!node) return;
		if (!this.nodeIsSelected(node)) return;
		this.selectedNodes.splice(this.selectedNodes.indexOf(node), 1);
		this.selectionDidChangeForNode(node, false, sender);
		if (!this.isChangingSelection) this.commitSelectionChange(sender);};
	
	
TreeController.prototype.selectionDidChangeForNode = function TreeController__selectionDidChangeForNode(node, isSelected, sender) {
		this.context.broadcastSelectionChangeForKeyPathInObject(node.indexPath.indices.join('.'), isSelected, this, sender);};
	
	
TreeController.prototype.unselectAll = function TreeController_unselectAll(sender) {
		this.beginSelectionChange();
		if (Array.isArray(clone(this.selectedNodes))) clone(this.selectedNodes).every(function (node) {
			this.unselectNode(node, sender);return true; }, this);
		
		this.commitSelectionChange(sender);};
	
	
TreeController.prototype.nodeForIndexPath = function TreeController__nodeForIndexPath(indexPath) {
		return this.rootNode.nodeForIndexPath(indexPath);};
	

TreeController.prototype.nodeForKeyPath = function TreeController_nodeForKeyPath(keyPath) {
		if (keyPath === "") return this.rootNode;
		if (!keyPath) {
			alertd("nodeForKeyPath", arguments);console.log("nodeForKeyPath", arguments);
			console.trace();
			return;
		}
		var indexPath = { indices: keyPath.split('.') };
		return this.nodeForIndexPath(indexPath);};
	
	
TreeController.prototype.get = function TreeController_get(keyPath) {
		var node = this.nodeForKeyPath(keyPath);
		return node ? node.representedObject : null;};
	

	function keyPathForIndexPath(indexPath) {
		var indices = (indexPath && indexPath.indices) ?
			indexPath.indices : [];
		return indices.join('.');
	}
	
	function parentIndexPath(indexPath) {
		if (!indexPath || !indexPath.indices) return null;
		var indices = indexPath.indices.slice(0, -1);
		return { indices: indices };
	}
	
	function lastIndexOfIndexPath(indexPath) {
		if (!indexPath || !indexPath.indices) return null;
		return indexPath.indices[indexPath.indices.length-1];
	}
	
	
	
	
TreeController.prototype.valueIsSelected = function TreeController_valueIsSelected(obj) {
		var node = this.nodeForRepresentedObject(obj);
		return this.nodeIsSelected(node);};
	
	
TreeController.prototype.selectValue = function TreeController_selectValue(obj, sender) {
		var node = this.nodeForRepresentedObject(obj);
		if (node) this.selectNode(node, sender);};
	

TreeController.prototype.unselectValue = function TreeController_unselectValue(obj, sender) {
		var node = this.nodeForRepresentedObject(obj);
		if (node) this.unselectNode(node, sender);};
	
	
	Object.defineProperty(TreeController.prototype, "selectedValues", {
		get: function () {
			var representedObjects = [];
			if (Array.isArray(this.selectedNodes)) this.selectedNodes.every(function (node) {
				representedObjects.push(node.representedObject);return true; }, this);
			
			return representedObjects;
		}});
	
	
	
	
TreeController.prototype.moveNodeToNodeAtIndex = function TreeController_moveNodeToNodeAtIndex(node, targetNode, index, sender) {
	
		var oldParentNode = node.parentNode;
		var oldIndex = node.index;
	
		node.remove(sender);
		if (index < 0) 
			targetNode.addChildNode(node, sender);
		else {
			targetNode.insertChildNodeAtIndex(node, index, sender);
		}

		var newIndexPath = node.indexPath;
		var oldParentIndexPath = oldParentNode.indexPath;
		
		if (this.canUndo) {
			this.context.undoManager.registerChange(this, {
				type: 'indexPathChange',
				oldParentIndexPath: oldParentIndexPath,
				oldIndex: oldIndex,
				newIndexPath: newIndexPath
			});
		}
		
			};
	
	
	
	

TreeController.prototype.init = function TreeController_init() {
		var self = __super.prototype.init.call(this);
		if (self) {
			self.clear();
		}
		return self;};
	


	
	
TreeController.prototype.undoChange = function TreeController_undoChange(change) {
		
		if (change.type === 'indexChange') {
			var node = this.nodeForKeyPath(change.keyPath);
			if (node)
				node.moveChildNodeFromIndexToIndex(change.newIndex, change.oldIndex, this);
		}
		else if (change.type === 'indexPathChange') {
			var node = this.nodeForIndexPath(change.newIndexPath);
			var oldParentNode = this.nodeForIndexPath(change.oldParentIndexPath);
			if (node) {
				this.moveNodeToNodeAtIndex(node, oldParentNode, change.oldIndex, this);
			}
		}
		else 	__super.prototype.undoChange.call(this, change);
};
	

TreeController.prototype.readableUndoName = function TreeController_readableUndoName(change) {
	
		if (change.type === 'indexChange') {
			return LocalizedString('Change Order');
		}
		if (change.type === 'indexPathChange') {
			return LocalizedString('Move');
		}
		if (change.type === 'delete') {
			return LocalizedString('Delete');
		}

		return __super.prototype.readableUndoName.call(this);};
	

	
TreeController.prototype.initPropertiesFromData = function TreeController_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("contents")) this.contents = data.contents;
};

TreeController.prototype.decodeData = function TreeController_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

TreeController.prototype.encode = function TreeController_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

TreeController.prototype.encodeCloned = function TreeController_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

TreeController.prototype.expectedTypeForProperty = function TreeController_expectedTypeForProperty(key) {
	if (key === "contents") return "";
	if (key === "selectedValues") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return TreeController; }()));