
registerType('Core', (function () { function TreeNode() {} var __super = setSupertypeFromDomain(TreeNode, 'BasicObject', 'Core');

	Object.defineProperty(TreeNode.prototype, "controller", {
	outlet: true, 
	synthesized: true, get:function () { return this._controller; }, set:function (v) {if (!Object.hasOwnProperty(this, "_controller")) Object.defineProperty(this, "_controller", { writable: true, configurable: true }); this._controller = v; }});
	

	Object.defineProperty(TreeNode.prototype, "representedObject", {
	outlet: true, 
	synthesized: true, get:function () { return this._representedObject; }, set:function (v) {if (!Object.hasOwnProperty(this, "_representedObject")) Object.defineProperty(this, "_representedObject", { writable: true, configurable: true }); this._representedObject = v; }});
	

	Object.defineProperty(TreeNode.prototype, "indexPath", {
		get: function () {

			var indexPath = { indices: [] };
			if (this.parentNode) {
				var ip = this.parentNode.indexPath;
				if (ip) indexPath = ip;
			}

			if (typeof this.index === 'number')
				indexPath.indices.push(this.index);
			
			return indexPath;
		}});
	
	
	Object.defineProperty(TreeNode.prototype, "keyPath", {
		get: function () {
			return this.indexPath.indices.join('.');
		}});
	

	Object.defineProperty(TreeNode.prototype, "index", {
		get: function () {
			if (!this.parentNode) return;
			return this.parentNode.childNodes.indexOf(this);
		}});
	

	Object.defineProperty(TreeNode.prototype, "inverseIndex", {
		get: function () {
			if (!this.parentNode) return;
			return this.parentNode.childNodes.length-this.parentNode.childNodes.indexOf(this)-1;
		}});
	

	Object.defineProperty(TreeNode.prototype, "isLeaf", {
	outlet: true, 
	synthesized: true, get:function () { return this._isLeaf; }, set:function (v) {if (!Object.hasOwnProperty(this, "_isLeaf")) Object.defineProperty(this, "_isLeaf", { writable: true, configurable: true }); this._isLeaf = v; }});
	

	Object.defineProperty(TreeNode.prototype, "childNodes", {
	outlet: true, 
	synthesized: true, 
		get: function () {
			if (!this._childNodes) this.childNodes = [];
			return this._childNodes;
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_childNodes")) Object.defineProperty(this, "_childNodes", { writable: true, configurable: true }); this._childNodes = v; }});
	
	
	Object.defineProperty(TreeNode.prototype, "firstChild", {
		get: function () {
			if (this._childNodes) return this._childNodes[0];
		}});
	

	Object.defineProperty(TreeNode.prototype, "lastChild", {
		get: function () {
			if (this._childNodes) return this._childNodes[this._childNodes.length-1];
		}});
	
	
	Object.defineProperty(TreeNode.prototype, "nextSibling", {
		get: function () {
			return this.parentNode.childNodes[this.index+1];
		}});
	

	Object.defineProperty(TreeNode.prototype, "previousSibling", {
		get: function () {
			return this.parentNode.childNodes[this.index-1];
		}});
	

	Object.defineProperty(TreeNode.prototype, "allObjects", {
		get: function () {
			var objects = [];
			if (Array.isArray(this.childNodes)) this.childNodes.every(function (node) {
				objects.push(node.representedObject);return true; }, this);
			
			return objects;
		}});
	

	Object.defineProperty(TreeNode.prototype, "parentNode", {
	outlet: true, 
	synthesized: true, get:function () { return this._parentNode; }, set:function (v) {if (!Object.hasOwnProperty(this, "_parentNode")) Object.defineProperty(this, "_parentNode", { writable: true, configurable: true }); this._parentNode = v; }});
	
	
TreeNode.prototype.addChildNodeWithRepresentedObject = function TreeNode_addChildNodeWithRepresentedObject(representedObject, sender, silent) {
		return this.insertChildNodeWithRepresentedObjectAtIndex(representedObject, this.childNodes.length, sender, silent);};
	

TreeNode.prototype.insertChildNodeWithRepresentedObjectAtIndex = function TreeNode_insertChildNodeWithRepresentedObjectAtIndex(representedObject, index, sender, silent) {
		var node = createComponentFromDomain("TreeNode", "Core", this.context, {
			controller: this.controller,
			representedObject: representedObject,
			parentNode: this,
			isLeaf: true})
		;

		this.childNodes.splice(index, 0, node);
		if (!silent && this.controller)
			this.context.broadcastInsertionForObject(node.keyPath, this.controller, sender);
		return node;};
	
	
	
TreeNode.prototype.addChildNode = function TreeNode_addChildNode(node, sender) {
		this.insertChildNodeAtIndex(node, this.childNodes.length, sender, false);};
	
	
TreeNode.prototype.insertChildNodeAtIndex = function TreeNode_insertChildNodeAtIndex(node, index, sender, silent) {

		this.childNodes.splice(index, 0, node);
		node.parentNode = this;
		node.controller = this.controller;
		if (!silent && this.controller)
			this.context.broadcastInsertionForObject(node.keyPath, this.controller, sender);};
	
	
TreeNode.prototype.removeChildNodeWithRepresentedObject = function TreeNode_removeChildNodeWithRepresentedObject(representedObject, sender) {
		var node = this.nodeForRepresentedObject(representedObject, true);
		this.removeChildNode(node, sender);};
	
	
TreeNode.prototype.remove = function TreeNode_remove(sender) {
		this.parentNode.removeChildNode(this, sender);};
	
	
TreeNode.prototype.removeChildNode = function TreeNode_removeChildNode(node, sender) {
		this.context.broadcastDeletionAnnouncementForObject(this.keyPath, node, this.controller, sender);
		this.controller.unselectNode(node, sender);
		this.childNodes.splice(this.childNodes.indexOf(node), 1);
		this.context.broadcastDeletionForObject(this.keyPath, node, this.controller, sender);};
	

TreeNode.prototype.removeAllChildNodes = function TreeNode_removeAllChildNodes(sender) {
		if (Array.isArray(this.childNodes)) this.childNodes.every(function (childNode) {
			this.context.broadcastDeletionForObject(this.keyPath, childNode, this.controller, sender);return true; }, this);
		
		this.childNodes = [];};
	
	
TreeNode.prototype.moveChildNodeFromIndexToIndex = function TreeNode_moveChildNodeFromIndexToIndex(oldIndex, newIndex, sender) {
		if (newIndex < 0 || newIndex >= this.childNodes.length) return;
		var spliced = this.childNodes.splice(oldIndex, 1);
		this.childNodes.splice(newIndex, 0, spliced[0]);
		this.context.broadcastKeyChangeForKeyPathInObject(oldIndex, newIndex, this.keyPath, this.controller, sender);

		if (this.controller.canUndo) {
			this.context.undoManager.registerChange(this.controller, {
				type: 'indexChange',
				oldIndex: oldIndex,
				newIndex: newIndex,
				keyPath: this.keyPath
			});
		}};
	
	
TreeNode.prototype.nodeForRepresentedObject = function TreeNode_nodeForRepresentedObject(obj, noDeepSearch) {
		var node;
		if (Array.isArray(this.childNodes)) this.childNodes.every(function (childNode) {
			if (childNode.representedObject === obj) {
				node = childNode;
			}
			else if (!noDeepSearch) {
				node = childNode.nodeForRepresentedObject(obj);
			}
			if (node) return false;return true; }, this);
		
		return node;};
	
	
TreeNode.prototype.nodeForIndexPath = function TreeNode_nodeForIndexPath(indexPath) {

		if (!indexPath || !indexPath.indices) return null;
		if (!indexPath.indices.length) {
			return this;
		}
		var childIndexPath = { indices: clone(indexPath.indices) },
			childNode = this.childNodes[indexPath.indices[0]];
		if (!childNode) return null;
		childIndexPath.indices.splice(0,1);
		return childNode.nodeForIndexPath(childIndexPath);};
	
	
TreeNode.prototype.hasAncestor = function TreeNode_hasAncestor(node) {
		if (this.parentNode === node) return true;
		if (this.parentNode) return this.parentNode.hasAncestor(node);
		return false;};
	
	
	
	

TreeNode.prototype.initPropertiesFromData = function TreeNode_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("controller")) this.controller = data.controller;
if (data.hasOwnProperty("representedObject")) this.representedObject = data.representedObject;
if (data.hasOwnProperty("isLeaf")) this.isLeaf = data.isLeaf;
if (data.hasOwnProperty("childNodes")) this.childNodes = data.childNodes;
if (data.hasOwnProperty("parentNode")) this.parentNode = data.parentNode;
};

TreeNode.prototype.decodeData = function TreeNode_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

TreeNode.prototype.encode = function TreeNode_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

TreeNode.prototype.encodeCloned = function TreeNode_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

TreeNode.prototype.expectedTypeForProperty = function TreeNode_expectedTypeForProperty(key) {
	if (key === "controller") return "";
	if (key === "representedObject") return "";
	if (key === "indexPath") return "";
	if (key === "keyPath") return "";
	if (key === "index") return "";
	if (key === "inverseIndex") return "";
	if (key === "isLeaf") return "";
	if (key === "childNodes") return "";
	if (key === "firstChild") return "";
	if (key === "lastChild") return "";
	if (key === "nextSibling") return "";
	if (key === "previousSibling") return "";
	if (key === "allObjects") return "";
	if (key === "parentNode") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return TreeNode; }()));