
registerType('Core.UI', (function () { function Button() {} var __super = setSupertypeFromDomain(Button, 'View', 'Core.UI');

// role BasicObject (Core) 
	
Button.prototype.init = function Button_init() {
			__super.prototype.init.call(this);
			return this;};
		
		
Button.prototype.initFromData = function Button_initFromData(data) {
		
			if (!__super.prototype.initFromData.call(this, data))
				return;
			
			var properties = ['action', 'buttonStyle', 'buttonType', 'imageSrc', 'onStateImageSrc', 'highlightedStateImageSrc', 'text', 'target', 'targetMethod', 'localizeText', 'buttonBorderRadius', 'state'];
	
			if (data.localizeText === true)
				data.text = LocalizedString(data.text);
	
			if (Array.isArray(properties)) properties.every(function (key) {
				if (data.hasOwnProperty(key))
					this[key] = data[key];return true; }, this);
			
	
	
			this.styleButton();
			
			this.DOMNode.addEventListener('mousedown', this.mouseDownEventHandler.bind(this));
			this.DOMNode.addEventListener(data.triggerEvent || "click", this.trigger.bind(this));

			data = null;
			
			this._onWindowBlurEventHandler = function () {
				this.styleButton();
			}.bind(this);
			
			this._onWindowFocusEventHandler = function () {
				this.styleButton();
			}.bind(this);
			
			window.addEventListener('didBecomeMain', this._onWindowFocusEventHandler);
			window.addEventListener('didResignMain', this._onWindowBlurEventHandler);
	
			return this;
	};
		
		
Button.prototype.destroy = function Button_destroy() {
				
			this.DOMNode.onclick = null;
	
			window.removeEventListener('didResignMain', this._onWindowBlurEventHandler);
			window.removeEventListener('didBecomeMain', this._onWindowFocusEventHandler);
			
			delete this._onWindowBlurEventHandler;
			delete this._onWindowFocusEventHandler;
			
			__super.prototype.destroy.call(this);};
		
	
	
	
	
	
	
Button.prototype.trigger = function Button_trigger(e) {

		if (this.buttonType === 'onOff') {
			this.state = !this.state;
			this.styleButton();
		}

		if (this.action !== undefined)
			if (this.action(e) === false) return;
		
		if (this.target !== undefined)
			this.target[this.targetMethod](this, e);
		
		
		this.highlighted = false;
		};
	
	
	Object.defineProperty(Button.prototype, "target", {
	synthesized: true, get:function () { return this._target; }, set:function (v) {if (!Object.hasOwnProperty(this, "_target")) Object.defineProperty(this, "_target", { writable: true, configurable: true }); this._target = v; }});
	
	
Button.prototype.mouseDownEventHandler = function Button__mouseDownEventHandler(e) {
	
		e.preventDefault();
		e.stopPropagation();
		
		this.highlighted = true;
		
		this.DOMNode.onmouseout = function (e) {
			if (this.keepHighlightedOnMouseOut) return;
			this.highlighted = false;
		}.bind(this);

		this.DOMNode.onmouseover = function (e) {
			this.highlighted = true;
		}.bind(this);

		window.onmouseup = function (e) {
			this.highlighted = false;
			window.onmouseup = null;
			if (this.DOMNode) {
				this.DOMNode.onmouseout = null;
				this.DOMNode.onmouseover = null;
			}
		}.bind(this);
	};
	

	
	
	
Button.prototype.styleButton = function Button__styleButton() {
	
		if (!this.DOMNode) return;
	
		switch (this.buttonStyle) {

			case 'default': {
			
				if (this._highlighted === true) {
					this.style({
						backgroundImage: '-webkit-linear-gradient(hsl(0,0%,70%) 0%, hsl(0,0%,78%) 10%,hsl(0,0%,86%) 100%)',
						textShadow: '0 1px 1px hsla(0,0%,100%,.6)'
					});
				}
				else {
					this.style({
						backgroundImage: '-webkit-linear-gradient(#fff,#ddd)',
						textAlign: 'center',
						border: '1px solid #999',
						borderRadius: (this.buttonBorderRadius||5)+'px',
						width: this.size.width+'px',
						height: this.size.height+'px',
						boxSizing: 'border-box'
					});
				}
				
				this.label.DOMNode.style.height = this.size.height-3+'px';
				
				break;
			}

			case 'flat': {
				if (this._highlighted === true) {
					this.style({
						backgroundImage: '-webkit-linear-gradient(#aaa 0%, #ccc 15%, #ddd 100%)',
						"border": "1px solid hsl(0,0%,60%)",
					});
				}
				else {
					this.style({
						boxShadow: '0 1px 0 hsla(0,0%,100%,.4)',
						textAlign: 'center',
						"backgroundImage": "-webkit-linear-gradient(hsl(0,0%,100%) 0%, hsl(0,0%,97%) 48%, hsl(0,0%,93%) 53%, hsl(0,0%,93%) 90%, hsl(0,0%,96%) 100%)",
						"border": "1px solid hsl(0,0%,70%)",
						boxSizing: 'border-box'
					});
				}
				
				break;
			}

			case 'roundRect': {

				if (!this.backgroundView) {
					this.backgroundView = createComponentFromDomain("SmartScalingImage", "Core.UI", this.context, {
						imageSrc: this.context.pathForResource('ButtonAqua.png'),
						size: {
							width: this.size.width,
							height: this.size.height+2
						},
						contentInset: [7,11,9,6]})
					;
					this.insertSubviewAtIndex(this.backgroundView, 0);
					
					this.style({ textAlign: 'center' });
				}

				if (this._highlighted === true) {
					this.backgroundView.imageSrc = this.context.pathForResource('ButtonAquaHighlighted.png');
				}
				else if (this.state === true) {
					if (window.hasFocus)
						this.backgroundView.imageSrc = this.context.pathForResource('ButtonAquaOn.png');
					else
						this.backgroundView.imageSrc = this.context.pathForResource('ButtonAquaInactive.png');
				}
				else {
					this.backgroundView.imageSrc = this.context.pathForResource('ButtonAqua.png');
				}

				break;
			}
			
			case 'rounded': {
			
				if (this._highlighted === true) {
					this.style({
						backgroundImage: '-webkit-linear-gradient(hsl(0,0%,70%) 0%, hsl(0,0%,78%) 10%,hsl(0,0%,86%) 100%)',
						textShadow: '0 1px 1px hsla(0,0%,100%,.6)'
					});
				}
				else {
					this.style({
						backgroundImage: '-webkit-linear-gradient(#fff,#ddd)',
						textAlign: 'center',
						border: '1px solid #999',
						borderRadius: (this.buttonBorderRadius||20)+'px',
						boxSizing: 'border-box'
					});
				}
				
				this.label.DOMNode.style.height = this.size.height-3+'px';
				
				break;
			}

			case 'roundedFlat': {
			
				if (this._highlighted === true) {
					this.style({
						backgroundImage: '-webkit-linear-gradient(hsl(0,0%,82%) 0%,hsl(0,0%,86%) 100%)',
						textShadow: '0 1px 1px hsla(0,0%,100%,.6)',
						borderColor: '#bbb',
						borderTopColor: '#aaa',
						boxShadow: 'inset 0 1px 2px rgba(0,0,0,.2)'
					});
				}
				else {
					this.style({
						backgroundImage: '',
						textAlign: 'center',
						border: '1px solid #ccc',
						borderRadius: (this.buttonBorderRadius||20)+'px',
						boxSizing: 'border-box',
						boxShadow: ''
					});
				}
				
				this.label.DOMNode.style.height = this.size.height-3+'px';
				
				break;
			}
			
		}
	};
	
	
	Object.defineProperty(Button.prototype, "highlighted", {
		set: function (v) {
			Object.defineProperty(this, "_highlighted", {
			writable: true, 
				value: v});
			

			if (v === true) {
				this.updateImageSrc(this.highlightedStateImageSrc); 
			}
			else {
				this.updateImageSrc(this._state ? this.onStateImageSrc : this.imageSrc); 
			}

			this.styleButton();
		}});
	

	Object.defineProperty(Button.prototype, "state", {
	enumerable: true, 
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_state")) Object.defineProperty(this, "_state", { writable: true, configurable: true });
		
			
			v = (v === true); 
		
			this._state = v;
			
			if (v === true) {
				this.updateImageSrc(this.onStateImageSrc); 
			}
			else {
				this.updateImageSrc(this.imageSrc); 
			}
		}, get:function () { return this._state; }});
	



	

	Object.defineProperty(Button.prototype, "text", {
	enumerable: true, 
		get: function () { if (this.label) return this.label.text; }, 
		set: function (value) {
		
			if (this.label === undefined) {
				this.labelContainer = createComponentFromDomain("View", "Core.UI", this.context, {
					autoresizingMask: 18,
					size: this.sizeCopy,
					style: { textAlign: 'center' }})
				;

				this.label = createComponentFromDomain("Label", "Core.UI", this.context, {
					size: { width: this.size.width-2, height: this.size.height-2 },
					autoresizingMask: 2,
					text: value,
					style: {
						display: 'table-cell',
						verticalAlign: 'middle',
						position: 'inline',
						zIndex: 4
					}})
				;
				this.labelContainer.addSubview(this.label);
				this.addSubview(this.labelContainer);
			}

			else this.label.text = value;
		}});
	
	
	Object.defineProperty(Button.prototype, "label", {
	synthesized: true, get:function () { return this._label; }, set:function (v) {if (!Object.hasOwnProperty(this, "_label")) Object.defineProperty(this, "_label", { writable: true, configurable: true }); this._label = v; }});
	

	Object.defineProperty(Button.prototype, "readableValue", {
	enumerable: true, 
			get: function () { return this.text; }});
		
	
	Object.defineProperty(Button.prototype, "imageSrc", {
	enumerable: true, 
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_imageSrc")) Object.defineProperty(this, "_imageSrc", { writable: true, configurable: true });
			this._imageSrc = v;
			this.updateImageSrc(v);
		}, get:function () { return this._imageSrc; }});
	
	
Button.prototype.updateImageSrc = function Button__updateImageSrc(v) {
		
		if (v === undefined) return;
		
		if (this.imageView === undefined) {
			var size = this.sizeCopy;
			if (this.buttonStyle) {
				size.width-= 2;
				size.height-= 2;
			}
			this.imageView = createComponentFromDomain("ImageView", "Core.UI", this.context, {
				imageSrc: v,
				size: size,
				contentMode: 'center',})
			;
			this.addSubview(this.imageView);
		}
		else this.imageView.imageSrc = v;
};
	

	
	

// role EncodableObject (Core) 
	
Button.prototype.encode = function Button_encode() {
			var data = this.context.encodeObject(this);
			return data;};
		
	
	
		

Button.prototype.expectedTypeForProperty = function Button_expectedTypeForProperty(key) {
	if (key === "target") return "";
	if (key === "highlighted") return "";
	if (key === "state") return "";
	if (key === "text") return "";
	if (key === "label") return "";
	if (key === "readableValue") return "";
	if (key === "imageSrc") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return Button; }()));
registerType('Core.UI', (function () { function RadioButton() {} var __super = setSupertypeFromDomain(RadioButton, 'View', 'Core.UI');

RadioButton.prototype.init = function RadioButton_init() {
		__super.prototype.init.call(this);
		
		var radio = document.createElement('input');
		radio.type = 'radio';
		this.DOMNode.appendChild(radio);
		
		return this;};
	

RadioButton.prototype.expectedTypeForProperty = function RadioButton_expectedTypeForProperty(key) {
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return RadioButton; }()));