
registerType('Core.UI', (function () { function CollectionView() {} var __super = setSupertypeFromDomain(CollectionView, 'ItemsView', 'Core.UI');


	
	
CollectionView.prototype.init = function CollectionView_init() {
		__super.prototype.init.call(this);
		this.prepareAsDropTarget();
		return this;};
	

CollectionView.prototype.viewDidLoad = function CollectionView_viewDidLoad() {
		if (this.viewIsLoaded) return;
		this.loadDataSource();
		this.viewIsLoaded = true;
		this.reloadData();};
	
	
CollectionView.prototype.loadDataSource = function CollectionView__loadDataSource() {
		this.dataSource = this.context.getLivingDataSourceWithId(this.dataSourceId);};
	

	
	

	Object.defineProperty(CollectionView.prototype, "encodesSubviews", {
		value: false});
	

CollectionView.prototype.decodeData = function CollectionView_decodeData(data) {
		var decoded = __super.prototype.decodeData.call(this, data);
		if (data.dataSource !== undefined) { decoded.dataSource = this.context.createFromDataWithoutInitializing(data.dataSource); }
		return decoded;};
	

CollectionView.prototype.initFromArchive = function CollectionView_initFromArchive(data) {
		this.initFromData(data);
		if (data.dataSource) { this.context.initObjectFromArchive(data.dataSource); }};
	


	
	
	Object.defineProperty(CollectionView.prototype, "dataSourceId", {
	outlet: true, 
	synthesized: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_dataSourceId")) Object.defineProperty(this, "_dataSourceId", { writable: true, configurable: true });
			this._dataSourceId = v;
		}, get:function () { return this._dataSourceId; }});
	
	


	

	Object.defineProperty(CollectionView.prototype, "cellPrototype", {
	outlet: true, 
	synthesized: true, 
	enumerable: true, get:function () { return this._cellPrototype; }, set:function (v) {if (!Object.hasOwnProperty(this, "_cellPrototype")) Object.defineProperty(this, "_cellPrototype", { writable: true, configurable: true }); this._cellPrototype = v; }});
	
	
	Object.defineProperty(CollectionView.prototype, "livingCellPrototype", {
		get: function () {
			if (!this._livingCellPrototype)
			Object.defineProperty(this, "_livingCellPrototype", {
				value: this.context.decodeObjectTree(this.cellPrototype), 
				configurable: true});
			
			return this._livingCellPrototype;
		}});
	
	
CollectionView.prototype.reloadData = function CollectionView_reloadData() {
	
		if (this.timer) return;
		this.timer = setTimeout(function () {
			this.reloadDataLazy();
			this.timer = null;
		}.bind(this), 50);
};
	

CollectionView.prototype.insertData = function CollectionView__insertData() {
		if (!this.dataSource) return;

		var numberOfItems = this.dataSource.numberOfItemsInSection(0),
			numberOfColumns = this.numberOfColumns;
		numberOfItems = Math.min(numberOfItems, 100);
	
		var indexPath = { section: 0, item: 0 },
			self = this;
		
		var section = createComponentFromDomain("UICollectionViewSection", "appdoo.iOS", this.context, {
			itemsView: this})
		;

		var sectionView = createComponentFromDomain("UIItemsViewSectionView", "appdoo.iOS", this.context, {
			size: { width: 200, height: 200 },
			section: section})
		;
		section.view = sectionView;
		this.addSubview(sectionView);

		for (; indexPath.item < numberOfItems; indexPath.item++) {
			var cellClone = this.context.decodeObjectTree(this.cellPrototype);
			sectionView.addSubview(cellClone);
			this.prepareCellWithDataForIndexPath(cellClone, indexPath);
		}
		
		section.cells = clone(sectionView.subviews);
};
	
	
	
	

	Object.defineProperty(CollectionView.prototype, "numberOfSections", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_numberOfSections")) Object.defineProperty(this, "_numberOfSections", { writable: true, configurable: true });
			this._numberOfSections = v;
			this.reloadData();
		}, get:function () { return this._numberOfSections; }});
	

	Object.defineProperty(CollectionView.prototype, "flowLayoutMinimumLineSpacing", {
	outlet: true, 
	enumerable: true, get:function () { return this._flowLayoutMinimumLineSpacing; }, set:function (v) {if (!Object.hasOwnProperty(this, "_flowLayoutMinimumLineSpacing")) Object.defineProperty(this, "_flowLayoutMinimumLineSpacing", { writable: true, configurable: true }); this._flowLayoutMinimumLineSpacing = v; }});
	

	Object.defineProperty(CollectionView.prototype, "flowLayoutMinimumInteritemSpacing", {
	outlet: true, 
	enumerable: true, get:function () { return this._flowLayoutMinimumInteritemSpacing; }, set:function (v) {if (!Object.hasOwnProperty(this, "_flowLayoutMinimumInteritemSpacing")) Object.defineProperty(this, "_flowLayoutMinimumInteritemSpacing", { writable: true, configurable: true }); this._flowLayoutMinimumInteritemSpacing = v; }});
	

	Object.defineProperty(CollectionView.prototype, "flowLayoutScrollDirection", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_flowLayoutScrollDirection")) Object.defineProperty(this, "_flowLayoutScrollDirection", { writable: true, configurable: true });
			this._flowLayoutScrollDirection = v;
			if (v === 'horizontally')
				this.style({ overflowY: 'hidden', overflowX: 'auto' });
			else
				this.style({ overflowY: 'auto', overflowX: 'hidden' });
		}, get:function () { return this._flowLayoutScrollDirection; }});
	
	
	Object.defineProperty(CollectionView.prototype, "e_flowLayoutScrollDirection", {
		get: function ( ) { return this.flowLayoutScrollDirection; }, 
		set: function (v) { this.flowLayoutScrollDirection = v; this.layoutSubviews(); }});
	

	Object.defineProperty(CollectionView.prototype, "pagingEnabled", {
	outlet: true, 
	enumerable: true, get:function () { return this._pagingEnabled; }, set:function (v) {if (!Object.hasOwnProperty(this, "_pagingEnabled")) Object.defineProperty(this, "_pagingEnabled", { writable: true, configurable: true }); this._pagingEnabled = v; }});
	

	Object.defineProperty(CollectionView.prototype, "layout", {
	outlet: true, 
	enumerable: true, get:function () { return this._layout; }, set:function (v) {if (!Object.hasOwnProperty(this, "_layout")) Object.defineProperty(this, "_layout", { writable: true, configurable: true }); this._layout = v; }});
	

	Object.defineProperty(CollectionView.prototype, "margin", {
	outlet: true, 
	enumerable: true, get:function () { return this._margin; }, set:function (v) {if (!Object.hasOwnProperty(this, "_margin")) Object.defineProperty(this, "_margin", { writable: true, configurable: true }); this._margin = v; }});
	

	Object.defineProperty(CollectionView.prototype, "e_margin", {
		get: function ( ) { return this.margin||0; }, 
		set: function (v) { this.margin = v; this.layoutSubviews(); }});
	

	Object.defineProperty(CollectionView.prototype, "spacing", {
	outlet: true, 
	enumerable: true, get:function () { return this._spacing; }, set:function (v) {if (!Object.hasOwnProperty(this, "_spacing")) Object.defineProperty(this, "_spacing", { writable: true, configurable: true }); this._spacing = v; }});
	

	Object.defineProperty(CollectionView.prototype, "e_spacing", {
		get: function ( ) { return this.spacing||0; }, 
		set: function (v) {
			this.spacing = v;
			this.flowLayoutMinimumLineSpacing = v;
			this.flowLayoutMinimumInteritemSpacing = v;
			this.layoutSubviews();
		}});
	
	
CollectionView.prototype.calculateFloatingLayoutForCells = function CollectionView__calculateFloatingLayoutForCells(cells, layoutHorizontally) {
		if (!cells || !cells.length) return {numberOfColumns:0,xForCellInColumn:[]};
	
		var sizeProperty1 = layoutHorizontally ? 'height' : 'width';
		var sizeProperty2 = layoutHorizontally ? 'width' : 'height';
		var positionProperty1 = layoutHorizontally ? 'top' : 'left';
		var positionProperty2 = layoutHorizontally ? 'left' : 'top';
		
		var margin = this.margin || 0,
			availableWidth = (layoutHorizontally ? this.DOMNode.clientHeight : this.DOMNode.clientWidth) - margin*2,
			cellWidth = cells[0].size[sizeProperty1],
			cellHeight = cells[0].size[sizeProperty2];
			
		if (layoutHorizontally) {
			availableWidth -= (this.insetBottom||0)+(this.insetTop||0);
		}

		var numberOfColumns = (availableWidth / (cellWidth + this.flowLayoutMinimumInteritemSpacing)) | 0,
			xForCellInColumn = [];
		
		if ((numberOfColumns+1)*cellWidth + numberOfColumns*this.flowLayoutMinimumInteritemSpacing <= availableWidth) {
			numberOfColumns++;
		}

		var remainingSpace = availableWidth-cellWidth*numberOfColumns;
		var spaceBetweenCells = remainingSpace/(numberOfColumns-1);

		numberOfColumns = Math.max(1, numberOfColumns);
		if (numberOfColumns === 1) {
			var x = (availableWidth/2-cellWidth/2 | 0) + margin;
			xForCellInColumn = [x];
		}
		else {
			xForCellInColumn.push(margin);
			for (var i = 1; i < numberOfColumns-1; i++) {
				var x = (cellWidth+spaceBetweenCells)*i+margin;
				xForCellInColumn.push(x);
			}
			var x = availableWidth-cellWidth+margin;
			xForCellInColumn.push(x);
		}
		
		if (layoutHorizontally) {
			for (var i = 0, c = xForCellInColumn.length; i < c; i++) {
				xForCellInColumn[i] += (this.insetTop||0);
			}
		}
		
		return {
			numberOfColumns: numberOfColumns,
			xForCellInColumn: xForCellInColumn
		};};
	
	
CollectionView.prototype.layoutSubviews = function CollectionView_layoutSubviews() {
		this.arrangeSubviews();
		return true;};
	
	
CollectionView.prototype.arrangeSubviews = function CollectionView_arrangeSubviews(isRepeating) {
	
		
		if (!this.subviews || !this.subviews.length) return; 

		if (this.subviews[0].section)
			this.subviews[0].section.arrangeSubviews();
		else
			this.layoutCells(this.subviews);
};
	
	
CollectionView.prototype.layoutCells = function CollectionView_layoutCells(cells) {
		if (!cells) return;
		
		if (this.DOMNode.offsetHeight <= 0 || this.DOMNode.offsetWidth <= 0) return;

		switch (this.layout) {
			case "SideBySideLayout":
				this.layoutSubviewsSideBySide();
				break;
			case "FloatingLayout":
			default:
				if (this.flowLayoutScrollDirection === 'horizontally') { this.layoutCellsHorizontally(cells); }
				else { this.layoutCellsVertically(cells); }
		}
	};
	
	
CollectionView.prototype.layoutCellsVertically = function CollectionView__layoutCellsVertically(cells) {
	
		
		
		if (this.usesDataSource || allCellsHaveTheSameSize(cells)) {
			this.layoutPrototypeCells(cells, false);
		}
		else {
			this.layoutStaticCells(cells, false);
		}
};
	

CollectionView.prototype.layoutCellsHorizontally = function CollectionView__layoutCellsHorizontally(cells) {

		if (this.usesDataSource || allCellsHaveTheSameSize(cells)) {
			this.layoutPrototypeCells(cells, true);
		}
		else {
			this.layoutStaticCells(cells, true);
		}
};
	
	
CollectionView.prototype.layoutPrototypeCells = function CollectionView__layoutPrototypeCells(cells, layoutHorizontally) {
	
		if (!cells || !cells.length) return;
	
		var sizeProperty1 = layoutHorizontally ? 'height' : 'width',
			sizeProperty2 = layoutHorizontally ? 'width' : 'height',
			positionProperty1 = layoutHorizontally ? 'top' : 'left',
			positionProperty2 = layoutHorizontally ? 'left' : 'top';
		
		var layout = this.calculateFloatingLayoutForCells(cells, layoutHorizontally),
			x, y = this.margin || 0,
			availableWidth = layoutHorizontally ? this.DOMNode.clientHeight : this.DOMNode.clientWidth,
			cellWidth = cells[0].size[sizeProperty1],
			cellHeight = cells[0].size[sizeProperty2];
		
		if (layoutHorizontally && this.insetLeft) y += this.insetLeft;
		if (!layoutHorizontally && this.insetTop) y += this.insetTop;
		
		for (var i = 0, c = cells.length; i < c; i++) {
		
			var column = i % layout.numberOfColumns,
				row = i / layout.numberOfColumns | 0,
				x = layout.xForCellInColumn[column];

			var cell = cells[i];

			cell.position[positionProperty1] = x;
			cell.position[positionProperty2] = y;

			if (column === layout.numberOfColumns-1) {
				y += cellHeight + (this.flowLayoutMinimumLineSpacing || 0);
			}
		
		}
		};
	
	
CollectionView.prototype.layoutRowOfCells = function CollectionView__layoutRowOfCells(cells, y, rowHeight, totalWidth, margin, layoutHorizontally) {

		var sizeProperty1 = layoutHorizontally ? 'height' : 'width';
		var sizeProperty2 = layoutHorizontally ? 'width' : 'height';
		var positionProperty1 = layoutHorizontally ? 'top' : 'left';
		var positionProperty2 = layoutHorizontally ? 'left' : 'top';
	
		totalWidth -= margin*2;
	
		var summedCellWidth = 0;
		if (Array.isArray(cells)) cells.every(function (cell) {
			cell.position[positionProperty2] = y+(rowHeight-cell.size[sizeProperty2])/2;
			summedCellWidth += cell.size[sizeProperty1];return true; }, this);
		
		if (!totalWidth) return;
		if (cells.length === 1) {
			var pos = (totalWidth-summedCellWidth)/2;
			if (layoutHorizontally) pos += this.insetTop||0;
			cells[0].position[positionProperty1] = pos;
			return;
		}
		var padding = (totalWidth-summedCellWidth)/(cells.length-1);
		var x = margin;
		if (layoutHorizontally) x += this.insetTop||0;
		if (Array.isArray(cells)) cells.every(function (cell) {
			cell.position[positionProperty1] = x;
			x += cell.size[sizeProperty1] + padding;return true; }, this);
		};
	
	
	function allCellsHaveTheSameSize(cells) {
		if (!cells || !cells.length) return false;
		var width = cells[0].size.width,
			height = cells[0].size.height;

		for (var i in cells) {
			if (isNaN(i)) continue;
			if (cells[i].size.width !== width) return false;
			if (cells[i].size.height !== height) return false;
		}
		
		return true;
	}
	
CollectionView.prototype.layoutStaticCells = function CollectionView__layoutStaticCells(cells, layoutHorizontally) {

		if (!cells || !cells.length) return;

		var sizeProperty1 = layoutHorizontally ? 'height' : 'width';
		var sizeProperty2 = layoutHorizontally ? 'width' : 'height';
		var positionProperty1 = layoutHorizontally ? 'top' : 'left';
		var positionProperty2 = layoutHorizontally ? 'left' : 'top';

		var margin = this.margin || 0;
		var x0 = layoutHorizontally ? (this.insetTop||0) : (this.insetLeft||0);
		x0 += margin;
		
		var x = x0;
		var y = layoutHorizontally ? (this.insetLeft||0) : (this.insetTop||0);
		y += margin;
		
		var availableWidth = this.size[sizeProperty1];
		var currentRow = [];
		var maxHeightInCurrentRow = 0;
		var numberOfColumns = 1;
		

		if (Array.isArray(cells)) cells.every(function (cell) {
			if (cell.isSectionView) {
				cell.section.arrangeSubviews();
				return true;
			}
			x += cell.size[sizeProperty1];

			if (x > availableWidth) {
				this.layoutRowOfCells(currentRow, y, maxHeightInCurrentRow, availableWidth, margin, layoutHorizontally);
				y += maxHeightInCurrentRow+this.spacing;
				x = x0;
				cell.position[positionProperty1] = x;
				cell.position[positionProperty2] = y;
				maxHeightInCurrentRow = cell.size[sizeProperty2];
				currentRow = [cell];
				x += cell.size[sizeProperty1] + this.e_spacing;
			}
			else {
				currentRow.push(cell);
				maxHeightInCurrentRow = Math.max(maxHeightInCurrentRow, cell.size[sizeProperty2]);
				cell.position[positionProperty1] = x-cell.size[sizeProperty1];
				cell.position[positionProperty2] = y;
				x += this.e_spacing;
				
			}return true; }, this);
		
		
		if (currentRow.length >= 1) {
			var lastRowWidth = currentRow.length === 1 ? availableWidth : x-this.e_spacing+margin;
			this.layoutRowOfCells(currentRow, y, maxHeightInCurrentRow, lastRowWidth, margin, layoutHorizontally);
		}
		};
	
	
CollectionView.prototype.layoutSubviewsSideBySide = function CollectionView__layoutSubviewsSideBySide() {
	
		if (!this.subviews) return;
	
		var x = 0, y = this.margin;
		
		for (var i = 0, c = this.subviews.length; i < c; i++) {
			x += this.spacing;
		
			var cell = this.subviews[i];
			
			
			var cellSizeRatio = cell.size.width/cell.size.height;
			cell.size.height = this.size.height-this.margin*2;
			cell.size.width = cell.size.height*cellSizeRatio;
			
			var cellWidth = cell.size.width;
		
			cell.position.left = x;
			cell.position.top = y;
			
			x += cellWidth;
		}
		
		
		if (x < this.size.width) {
			var deltaX = (this.size.width/2 - (x - this.spacing)/2 - this.spacing) | 0;
			for (var i = 0, c = this.subviews.length; i < c; i++) {
				var cell = this.subviews[i];
				cell.position.left += deltaX;
			}
		}
		};
	
	
	
	
	

	Object.defineProperty(CollectionView.prototype, "dragMovesItems", {
	outlet: true, 
	synthesized: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_dragMovesItems")) Object.defineProperty(this, "_dragMovesItems", { writable: true, configurable: true });
			if (v) this.useNativeDragAndDrop = true;
		}, get:function () { return this._dragMovesItems; }});
	

	Object.defineProperty(CollectionView.prototype, "draggedCell", {
	synthesized: true, get:function () { return this._draggedCell; }, set:function (v) {if (!Object.hasOwnProperty(this, "_draggedCell")) Object.defineProperty(this, "_draggedCell", { writable: true, configurable: true }); this._draggedCell = v; }});
	
	
CollectionView.prototype.prepareAsDropTarget = function CollectionView__prepareAsDropTarget() {
	
		var draggedCell;
		
		this.dropHandler = {

			didEnterWithEvent: function (e) {
			
				draggedCell = this.draggedCell;
				
				if (!draggedCell) return;
				
				if (!this.acceptsMember(draggedCell.dataset))
					return;

				if (draggedCell.superview !== this) {
					this.addCellFromDragOperation(draggedCell, e);
					draggedCell.hidden = true;
					this.layoutCellsAnimated(true);
				}
				
			}.bind(this),

			didLeaveWithEvent: function (e) {
				if (!draggedCell) return;
				if (draggedCell.superview === this)
					draggedCell.hidden = true;
			}.bind(this),
			
			dropEffectForEvent: function (e) {

				if (!draggedCell) return;
				
				if (!this.acceptsMember(draggedCell.dataset))
					return 'none';

			
				var offsetX = this.getRelativeX(e.x),
					sourceIndex = this.subviews.indexOf(draggedCell),
					targetIndex = this.subviews.length-1, i = 0;

				if (Array.isArray(this.subviews)) this.subviews.every(function (cell) {
					if (cell.position.left+cell.size.width/2 > offsetX) {
						targetIndex = i-1;
						return false;
					}
					i++;return true; }, this);
				
				
				if (sourceIndex > targetIndex) targetIndex++;
				if (sourceIndex !== targetIndex)
					this.moveCellFromToAnimated(sourceIndex, targetIndex, true);
				return 'move';
			}.bind(this),
			
			didDropWithEvent: function (e) {

				if (!draggedCell) return;

				var offsetX = e.x + draggedCell.getRelativeX(0) - e.dataTransfer.getData('draggedItemOffsetX'), 
					offsetY = e.y + draggedCell.getRelativeY(0) - e.dataTransfer.getData('draggedItemOffsetY');
				
				this.bounceCellBack(draggedCell, offsetX, offsetY);
				
				e.preventDefault();
				return true;
			}.bind(this)
		};
};
	
	
CollectionView.prototype.acceptsMember = function CollectionView__acceptsMember(item) {
		return true;};
	
	
CollectionView.prototype.addCellFromDragOperation = function CollectionView__addCellFromDragOperation(cell, e) {
		this.addSubview(cell);};
	

CollectionView.prototype.bringCellToFront = function CollectionView__bringCellToFront(cell) {
		var i = 0;
		if (Array.isArray(this.subviews)) this.subviews.every(function (_cell) {
			_cell.DOMNode.style.zIndex = (_cell == cell) ? this.subviews.length : i;
			i++;return true; }, this);
		};
	
	
CollectionView.prototype.cellOnDragStart = function CollectionView__cellOnDragStart(cell, e) {

		this.draggedCell = cell;

		var offset = {
			left: -cell.getRelativeX(e.x),
			top: -cell.getRelativeY(e.y)
		};

		e.dataTransfer.setData('draggedItemId', cell.dataset.$id);
		e.dataTransfer.setData('draggedItemOffsetX', -offset.left);
		e.dataTransfer.setData('draggedItemOffsetY', -offset.top);
};
	

CollectionView.prototype.cellOnDragEnd = function CollectionView__cellOnDragEnd(cell, e) {
		this.draggedCell = null;};
	


	

	var duration = .25,
		hwAcceleration = false;

CollectionView.prototype.layoutCellsAnimated = function CollectionView__layoutCellsAnimated(animated) {

		if (animated) {
			if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {
				subview.beginAnimations();
				subview.animationHardwareAccelerationEnabled = hwAcceleration;
				subview.animationDuration = duration;return true; }, this);
			
		}
		
		this.layoutSubviews();

		if (animated) {
			if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {
				subview.commitAnimations();return true; }, this);
			
		}
};
	
	
CollectionView.prototype.moveCellFromToAnimated = function CollectionView__moveCellFromToAnimated(from, to, animated) {
		var cell = this.subviews[from];
		this.subviews.splice(from, 1);
		this.subviews.splice(to, 0, cell);
		this.layoutCellsAnimated(animated);};
	
	
CollectionView.prototype.bounceCellBack = function CollectionView__bounceCellBack(cell, offsetX, offsetY) {

		cell.style({
			opacity: 0.6,
			webkitTransform: 'translateX('+(offsetX)+'px) translateY('+(offsetY)+'px)'
		});
		
		this.bringCellToFront(cell);
		
		setTimeout(function () {
			cell.beginAnimations();
			cell.animationDuration = 0.33;
			cell.style({ opacity: 1, webkitTransform: '' });
			cell.commitAnimations();
		}.bind(this), 10);
};
	
	
	
	

	Object.defineProperty(CollectionView.prototype, "cellWidthIsEditable", {
		value: true});
	


CollectionView.prototype.initPropertiesFromData = function CollectionView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("dataSourceId")) this.dataSourceId = data.dataSourceId;
if (data.hasOwnProperty("cellPrototype")) this.cellPrototype = data.cellPrototype;
if (data.hasOwnProperty("numberOfSections")) this.numberOfSections = data.numberOfSections;
if (data.hasOwnProperty("flowLayoutMinimumLineSpacing")) this.flowLayoutMinimumLineSpacing = data.flowLayoutMinimumLineSpacing;
if (data.hasOwnProperty("flowLayoutMinimumInteritemSpacing")) this.flowLayoutMinimumInteritemSpacing = data.flowLayoutMinimumInteritemSpacing;
if (data.hasOwnProperty("flowLayoutScrollDirection")) this.flowLayoutScrollDirection = data.flowLayoutScrollDirection;
if (data.hasOwnProperty("pagingEnabled")) this.pagingEnabled = data.pagingEnabled;
if (data.hasOwnProperty("layout")) this.layout = data.layout;
if (data.hasOwnProperty("margin")) this.margin = data.margin;
if (data.hasOwnProperty("spacing")) this.spacing = data.spacing;
if (data.hasOwnProperty("dragMovesItems")) this.dragMovesItems = data.dragMovesItems;
};

CollectionView.prototype.encode = function CollectionView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

CollectionView.prototype.encodeCloned = function CollectionView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

CollectionView.prototype.expectedTypeForProperty = function CollectionView_expectedTypeForProperty(key) {
	if (key === "encodesSubviews") return "";
	if (key === "dataSourceId") return "";
	if (key === "cellPrototype") return "";
	if (key === "livingCellPrototype") return "";
	if (key === "numberOfSections") return "";
	if (key === "flowLayoutMinimumLineSpacing") return "";
	if (key === "flowLayoutMinimumInteritemSpacing") return "";
	if (key === "flowLayoutScrollDirection") return "";
	if (key === "e_flowLayoutScrollDirection") return "";
	if (key === "pagingEnabled") return "Boolean";
	if (key === "layout") return "";
	if (key === "margin") return "Number";
	if (key === "e_margin") return "";
	if (key === "spacing") return "Number";
	if (key === "e_spacing") return "Number";
	if (key === "dragMovesItems") return "";
	if (key === "draggedCell") return "";
	if (key === "cellWidthIsEditable") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return CollectionView; }()));
registerType('Core.UI', (function () { function CollectionViewCell() {} var __super = setSupertypeFromDomain(CollectionViewCell, 'View', 'Core.UI');
CollectionViewCell.prototype.expectedTypeForProperty = function CollectionViewCell_expectedTypeForProperty(key) {
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return CollectionViewCell; }()));