
registerType('Core.UI', (function () { function DisclosureLabel() {} var __super = setSupertypeFromDomain(DisclosureLabel, 'View', 'Core.UI');

DisclosureLabel.prototype.initFromData = function DisclosureLabel_initFromData(data) {
	
		if (__super.prototype.initFromData.call(this, data, null, true) 
			=== null) return null;

		this.disclosureTriangle = createComponentFromDomain("DisclosureTriangle", "Core.UI", this.context, {
			position: { top: (this.size.height - 15)/2 },
			colorStyle: data.colorStyle,
			selected: data.selected,
			delegate: data.delegate,
			tag: data.tag,
			style: {
				pointerEvents: 'none'
			}})
		;
		
		this.label = createComponentFromDomain("Label", "Core.UI", this.context, {
			text: data.text,
			position: { left: 16, top: 0 },
			size: { width: this.size.width - 16, height: this.size.height },
			autoresizingMask: 18,
			style: data.labelStyle,
			numberOfLines: 1})
		;
		
		
		
		
		function cloneMouseEvent(e) {
			var _e = document.createEvent('MouseEvent');
			_e.initMouseEvent(e.type, e.canBubble, e.cancelable, e.view, e.detail, e.screenX, e.screenY, e.clientX, e.clientY, e.ctrlKey, e.altKey, e.shiftKey, e.metaKey, e.button, e.relatedTarget);
			return _e;
		}

		this.DOMNode.onmousedown = function (e) {
			e.preventDefault();
			var _e = cloneMouseEvent(e);
			this.disclosureTriangle.DOMNode.dispatchEvent(_e);
			window.onmouseup = function () {
				window.onmouseup = null;
			}.bind(this);
		}.bind(this);
		
		this.DOMNode.onmouseup = function (e) {
			var _e = cloneMouseEvent(e);
			this.disclosureTriangle.DOMNode.dispatchEvent(_e);
		}.bind(this);

		this.DOMNode.onmouseout = function (e) {
			var _e = cloneMouseEvent(e);
			this.disclosureTriangle.DOMNode.dispatchEvent(_e);
		}.bind(this);

		this.DOMNode.onmouseover = function (e) {
			var _e = cloneMouseEvent(e);
			this.disclosureTriangle.DOMNode.dispatchEvent(_e);
		}.bind(this);

		this.DOMNode.onclick = function (e) {
			if (this.disclosureTriangle.hidden) return;
			var _e = cloneMouseEvent(e);
			this.disclosureTriangle.DOMNode.dispatchEvent(_e);
		}.bind(this);
		
		
		this.addSubview(this.disclosureTriangle);
		this.addSubview(this.label);

		this.applyBindings(true);
		return this;
};
	
	
	Object.defineProperty(DisclosureLabel.prototype, "text", {
	enumerable: true, 
		set: function (v) {
			this.label.text = v;
		}, 
		get: function () {
			return this.label.text;
		}});
	
	
	Object.defineProperty(DisclosureLabel.prototype, "tag", {
	enumerable: true, 
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_tag")) Object.defineProperty(this, "_tag", { writable: true, configurable: true });
			this._tag = v;
			if (this.disclosureTriangle)
				this.disclosureTriangle.tag = v;
		}, get:function () { return this._tag; }});
	

	Object.defineProperty(DisclosureLabel.prototype, "selected", {
		set: function (v) {
			this.disclosureTriangle.selected = v;
		}, 
		get: function () {
			return this.disclosureTriangle.selected;
		}});
	
	

DisclosureLabel.prototype.expectedTypeForProperty = function DisclosureLabel_expectedTypeForProperty(key) {
	if (key === "text") return "";
	if (key === "tag") return "";
	if (key === "selected") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return DisclosureLabel; }()));