
registerType('Core.UI', (function () { function DisclosureTriangle() {} var __super = setSupertypeFromDomain(DisclosureTriangle, 'SpriteButton', 'Core.UI');


	
	
DisclosureTriangle.prototype.initFromData = function DisclosureTriangle_initFromData(data) {

		data.size = { width: 11, height: 15 };

		if (__super.prototype.initFromData.call(this, data, null, true) 
			=== null) return null;
			
		this.selectable = true;
		this.colorStyle = data.colorStyle || 0;

		['selected', 'delegate', ].every(function (option) {
			this[option] = data[option];return true; }, this);
		
		
		this.applyBindings(true);
		
		this.DOMNode.addEventListener('mousedown', this.mouseDown.bind(this));
		this.DOMNode.addEventListener('click', this.click.bind(this));
		
		this.updateStyle();

		return this;
};
	
	
DisclosureTriangle.prototype.destroy = function DisclosureTriangle_destroy() {
		this.delegate = null;};
	
	
	
	
DisclosureTriangle.prototype.mouseDown = function DisclosureTriangle__mouseDown(e) {
	
		
		e.stopPropagation();
		
		
		e.preventDefault();

		this._animationInProcess = true;
		
		this.DOMNode.onmouseout = function (e) {
			this._animationInProcess = false;
		}.bind(this);

		this.DOMNode.onmouseover = function (e) {
			this._animationInProcess = true;
		}.bind(this);

		var self = this;
		window.addEventListener('mouseup', function onMouseUp(e) {

			if (self._animationInProcess) {
				setTimeout(function () {
					self._animationInProcess = false;
				}, self.animationDuration+100);
			}
			else {
				if (self._selected) self.style({ backgroundPositionY: -self.contentHeight+'px' });
				else self.style({ backgroundPositionY: '0px' });
			}

			window.removeEventListener('mouseup', onMouseUp);

		});
};
	
	
DisclosureTriangle.prototype.click = function DisclosureTriangle__click(e) {

		
		e.stopPropagation();

		setTimeout(function () {

			this.style({ backgroundPositionY: -this.contentHeight*1+'px',
						 backgroundPositionX: -this.contentWidth*1+'px' });


			setTimeout(function () {
				if (this._selected === true)
					this.style({ backgroundPositionY: -this.contentHeight*3+'px', backgroundPositionX: '' });
				else
					this.style({ backgroundPositionY: -this.contentHeight*1+'px', backgroundPositionX: '' });
	
	
				this.callDelegate('disclosureTriangleDidChange', [this]);
				setTimeout(function () {
					this._animationInProcess = false;
					this.highlighted = false;
				}.bind(this), 50);
					
			}.bind(this), this.animationDuration);
		}.bind(this), 50);
	};
	
	
	
	

DisclosureTriangle.prototype.encode = function DisclosureTriangle_encode() {
		var data = __super.prototype.encode.call(this);
		delete data.sprite;
		delete data.size;
		return data;};
	


	

	Object.defineProperty(DisclosureTriangle.prototype, "colorStyle", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_colorStyle")) Object.defineProperty(this, "_colorStyle", { writable: true, configurable: true });

			if (this._colorStyle === v) return;
			this._colorStyle = v;
			
			this.needsStyleUpdate();

		}, get:function () { return this._colorStyle; }});
	

	Object.defineProperty(DisclosureTriangle.prototype, "animationDuration", {
	writable: true, 
		value: 60});
	
	
	Object.defineProperty(DisclosureTriangle.prototype, "delegate", {
	synthesized: true, get:function () { return this._delegate; }, set:function (v) {if (!Object.hasOwnProperty(this, "_delegate")) Object.defineProperty(this, "_delegate", { writable: true, configurable: true }); this._delegate = v; }});
	
	
DisclosureTriangle.prototype.needsStyleUpdate = function DisclosureTriangle__needsStyleUpdate() {
		if (this.updateTimer) return;
		this.updateTimer = setTimeout(function () {
			this.updateStyle();
		}.bind(this), 1);};
	
	
DisclosureTriangle.prototype.updateStyle = function DisclosureTriangle__updateStyle() {
		delete this.updateTimer;

		switch (this.colorStyle) {
			case 2:
				this.sprite = this.context.pathForResource("DisclosureTriangleBright.png");
				break;
			case 3:
				this.sprite = this.context.pathForResource("DisclosureTriangleBlue.png");
				break;
			default:
				this.sprite = this.context.pathForResource("DisclosureTriangle.png");
				break;
		}
		
		if (this._selected)
			this.style({ backgroundPositionY: -this.contentHeight*2+'px' });
			};
	
	
DisclosureTriangle.prototype.expectedTypeForProperty = function DisclosureTriangle_expectedTypeForProperty(key) {
	if (key === "colorStyle") return "";
	if (key === "animationDuration") return "";
	if (key === "delegate") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return DisclosureTriangle; }()));