
registerType('Core.UI', (function () { function FloatingTextField() {} var __super = setSupertypeFromDomain(FloatingTextField, 'View', 'Core.UI');

FloatingTextField.prototype.initFromData = function FloatingTextField_initFromData(data) {
	
		if (!__super.prototype.initFromData.call(this, data))
			return;
		

		this.delegate = data.delegate;
		this.hidden = true;

		this._leftPosition = data.position.left;
		this._textAlignment = data.style.textAlign||'left';
		this.maximumWidth = data.maximumWidth;
		this.multiLine = data.multiLine;
		this.adjustsSize = data.adjustsSize;
		
		this.initTextField(data);
		this.initLabel(data);

		
		this.DOMNode.addEventListener('mousedown', function (e) {
			e.stopPropagation();
		}.bind(this));

		
		setTimeout(function () {
			this.adjustTextFieldSize();
			this.showAndSelectAll();
		}.bind(this),1);
		
		this.style({ zIndex: 10000 });
		
		return this;};
	
	
FloatingTextField.prototype.initLabel = function FloatingTextField__initLabel(data) {
	
		var labelStyle = clone(this.style);
		labelStyle.position = '';
		labelStyle.display = 'inline';
		labelStyle.textOverflow = 'ellipsis';
		labelStyle.marginLeft = '-1000px';
		
		if (!data.multiLine) {
			labelStyle.whiteSpace = 'pre';
		}
		else {
			labelStyle.whiteSpace = 'pre-wrap';
			labelStyle.display = 'block';
			labelStyle.width = (data.size.width-4)+'px';
		}

		this.label = createComponentFromDomain("Label", "Core.UI", this.context, {
			style: labelStyle,
			hidden: true,
			text: data.text,})
		
		this.addSubview(this.label);
	};
	
	
FloatingTextField.prototype.initTextField = function FloatingTextField__initTextField(data) {

		var textFieldStyle = clone(data.style);
		textFieldStyle.padding = '2px 2px';
		textFieldStyle.border = 0;
		textFieldStyle.margin = 0;

		this.textField = createComponentFromDomain("TextField", "Core.UI", this.context, {
			value: data.text,
			position: { left: -2, top: -2 },
			size: data.multiLine || data.adjustsSize === false ? data.size : { width: 0 },
			style: textFieldStyle,
			multiLine: data.multiLine,
			delegate: this,
			shouldUseModalUndoManager: true})
		;

		if (this._textAlignment)
			this.textField.inputNode.style.textAlign = this._textAlignment;
		

		this.textField.DOMNode.onkeydown = function (e) {
			if (
				(e.keyCode === 13 && (!this.multiLine || !e.altKey)) ||
				this.context.isCancelEvent(e)
				) {
				this.textField.blur();
				e.preventDefault();
			}
		}.bind(this);

		this.addSubview(this.textField);
	};
	
	
	
	
FloatingTextField.prototype.showAndSelectAll = function FloatingTextField__showAndSelectAll() {
		this.hidden = false;
		this.textField.selectAll();};
	

	
// role TextFieldDelegate (Core.UI) 

FloatingTextField.prototype.textFieldDidBeginEditing = function FloatingTextField_textFieldDidBeginEditing(textField) {
			this.callDelegate("textFieldDidBeginEditing", [textField]);};
		
		
FloatingTextField.prototype.textFieldDidEndEditing = function FloatingTextField_textFieldDidEndEditing(textField) {
			this.callDelegate("textFieldDidEndEditing", [textField]);
			this.removeFromSuperview();};
		

FloatingTextField.prototype.textFieldDidChangeValue = function FloatingTextField_textFieldDidChangeValue(textField) {
			this.callDelegate("textFieldDidChangeValue", [textField]);};
		

FloatingTextField.prototype.textFieldDidGetInput = function FloatingTextField_textFieldDidGetInput(textField) {
			this.adjustTextFieldSize();};
		
	
	
FloatingTextField.prototype.adjustTextFieldSize = function FloatingTextField__adjustTextFieldSize() {

		if (this.adjustsSize === false)
			return;

		var text = this.textField.value;

		
		if (text.length && text[text.length-1] === "\n") text += ' ';
		
		this.label.text = text;
		
		var textWidth = this.label.DOMNode.offsetWidth || 100;

		if (this.maximumWidth !== undefined && textWidth > this.maximumWidth)
			textWidth = this.maximumWidth - 4;
		
		var newWidth = textWidth+4;
		
		this.textField.size.width = newWidth + 4 + 2;
		this.size.width = newWidth + 2;
			
		
		if (this.multiLine === true) {
			var textHeight = this.label.DOMNode.offsetHeight || 100;
			this.textField.size.height = textHeight;
			this.position.left = this._leftPosition+1;
		}
		else {
			if (this._textAlignment === 'center') {
				this.position.left = this._leftPosition - Math.round(newWidth/2) - 1;
			}
			else if (this._textAlignment === 'right')
				this.position.left = this._leftPosition + this.maximumWidth - textWidth - 2;
		}
		
		
		};
	


FloatingTextField.prototype.expectedTypeForProperty = function FloatingTextField_expectedTypeForProperty(key) {
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return FloatingTextField; }()));