
registerType('Core', (function () { function GenericDataSource() {} var __super = setSupertypeFromDomain(GenericDataSource, 'BasicObject', 'Core');


	Object.defineProperty(GenericDataSource.prototype, "id", {
	outlet: true, 
	enumerable: true, get:function () { return this._id; }, set:function (v) {if (!Object.hasOwnProperty(this, "_id")) Object.defineProperty(this, "_id", { writable: true, configurable: true }); this._id = v; }});
	
	
	Object.defineProperty(GenericDataSource.prototype, "name", {
	outlet: true, 
	enumerable: true, get:function () { return this._name; }, set:function (v) {if (!Object.hasOwnProperty(this, "_name")) Object.defineProperty(this, "_name", { writable: true, configurable: true }); this._name = v; }});
	

	Object.defineProperty(GenericDataSource.prototype, "contents", {
	outlet: true, 
	synthesized: true, get:function () { return this._contents; }, set:function (v) {if (!Object.hasOwnProperty(this, "_contents")) Object.defineProperty(this, "_contents", { writable: true, configurable: true }); this._contents = v; }});
	

	Object.defineProperty(GenericDataSource.prototype, "dataController", {
	outlet: true, 
	synthesized: true, get:function () { return this._dataController; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dataController")) Object.defineProperty(this, "_dataController", { writable: true, configurable: true }); this._dataController = v; }});
	

	Object.defineProperty(GenericDataSource.prototype, "keyPath", {
	outlet: true, 
	synthesized: true, get:function () { return this._keyPath; }, set:function (v) {if (!Object.hasOwnProperty(this, "_keyPath")) Object.defineProperty(this, "_keyPath", { writable: true, configurable: true }); this._keyPath = v; }});
	
	
	Object.defineProperty(GenericDataSource.prototype, "listView", {
	synthesized: true, get:function () { return this._listView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_listView")) Object.defineProperty(this, "_listView", { writable: true, configurable: true }); this._listView = v; }});
	

	
// role BasicObject (Core) 

		
	
GenericDataSource.prototype.init = function GenericDataSource_init() {
		
			var self = __super.prototype.init.call(this);
			
			if (self.contents) {
				if (Array.isArray(self.contents))
					self.dataController = createComponentFromDomain("ArrayController", "Core", this.context, {
						contents: this.contents,
						keyPath: this.keyPath})
					;
				else
					self.dataController = createComponentFromDomain("ObjectController", "Core", this.context, {
						contents: this.contents,
						keyPath: this.keyPath})
					;
			}
	
			if (self.dataController)
				self.observeObject(self.dataController);

			return self;
	};
		
		
GenericDataSource.prototype.destroy = function GenericDataSource_destroy() {
			this.contents = null;
			this.dataController = null;};
		
	
	

	
	
	
// role ListViewDataSource (Core.UI) 

GenericDataSource.prototype.dataForItemInSectionAtIndex = function GenericDataSource_dataForItemInSectionAtIndex(section, index) {
			return this.dataForRowAtIndex(index);};
		
	
GenericDataSource.prototype.dataForRowAtIndex = function GenericDataSource_dataForRowAtIndex(index) {
			if (this.dataController) {
				var data = this.dataController.contents[index];
				if (data)
					Object.defineProperty(data, 'id', { writable: true });
				return data;
			}};
		
	
GenericDataSource.prototype.numberOfRowsInSection = function GenericDataSource_numberOfRowsInSection(section) {
			if (!this.dataController || !Array.isArray(this.dataController.contents)) { return 0; }
			return this.dataController.contents.length;};
		
		
GenericDataSource.prototype.numberOfSections = function GenericDataSource_numberOfSections() {
			return 1;};
		
		
GenericDataSource.prototype.addObserver = function GenericDataSource_addObserver(observer) {
			this.listView = observer;};
		
	
GenericDataSource.prototype.removeObserver = function GenericDataSource_removeObserver(observer) {
			this.listView = undefined;};
		

GenericDataSource.prototype.menuForItems = function GenericDataSource_menuForItems(items) {
			if (this.dataController.menuForItems)
				return this.dataController.menuForItems(items);};
		
		
GenericDataSource.prototype.beginChangingSelection = function GenericDataSource_beginChangingSelection() {
			return false;};
		

GenericDataSource.prototype.endChangingSelection = function GenericDataSource_endChangingSelection(sender) {};
		
	
	
	
// role OutlineViewDataSource 

GenericDataSource.prototype.numberOfChildrenOfItem = function GenericDataSource_numberOfChildrenOfItem(item) {
			if (item === null)
				return this.numberOfRowsInSection(0);
			return 1;};
		
		
GenericDataSource.prototype.isItemExpandable = function GenericDataSource_isItemExpandable(item) {
			return item && item.children;};
		
	
GenericDataSource.prototype.childWithIndexOfItem = function GenericDataSource_childWithIndexOfItem(index, item) {
			if (item === null) {
				return this.dataController.contents[index];
			}
			return item.children[index];};
		
	
	

	
	

// role TableViewDataSource (Core.UI) 
	
GenericDataSource.prototype.dataForColumnNameAtRow = function GenericDataSource_dataForColumnNameAtRow(columnName, row) {
			
			return this.dataController.contents[row][columnName];
		};
		
		
GenericDataSource.prototype.numberOfRows = function GenericDataSource_numberOfRows() {
			return this.dataController.contents.length || 0;};
		
		
GenericDataSource.prototype.valueShouldChangeForColumnNameAtRow = function GenericDataSource_valueShouldChangeForColumnNameAtRow(columnName, row, value, sender) {

			var keyPath = row + "." + columnName;
			this.dataController.setValueForKeyPath(value, keyPath, sender);
			};
		
	
GenericDataSource.prototype.bindableDataKeyPathForColumnNameAtRow = function GenericDataSource_bindableDataKeyPathForColumnNameAtRow(columnName, row) {
			return this.dataController.keyPath + "." + row + "." + columnName;};
		
		
GenericDataSource.prototype.bindableDataKeyPath = function GenericDataSource_bindableDataKeyPath() {
			return this.dataController.keyPath;};
		
		
GenericDataSource.prototype.keyAtIndex = function GenericDataSource_keyAtIndex(i) {
			if (!this.dataController || !this.dataController.contents) return '';
			return Object.keys(this.dataController.contents)[i];};
		
	
GenericDataSource.prototype.nameForKey = function GenericDataSource_nameForKey(key) {
			if (!this.dataController || !this.dataController.contents) return '';
			return key;};
		
		
GenericDataSource.prototype.addEmptyData = function GenericDataSource_addEmptyData() {
			if (!this.dataController.contents) return false;
			this.dataController.contents.push({});
			return true;};
		
		
GenericDataSource.prototype.deleteDataForRow = function GenericDataSource_deleteDataForRow(rowIndex) {
			alertd("deleteDataForRow", arguments);console.log("deleteDataForRow", arguments);
			console.log(this.dataController);
			this.dataController.contents.splice(rowIndex, 1);
			return true;};
		
		
	
	

	

// role CollectionViewDataSource (Core.UI) 
	
GenericDataSource.prototype.numberOfItemsInSection = function GenericDataSource_numberOfItemsInSection(section) {
			return this.numberOfRowsInSection(section);};
		
		
GenericDataSource.prototype.dataForIndexPath = function GenericDataSource_dataForIndexPath(indexPath) {
			return this.dataForItemInSectionAtIndex(indexPath.section, indexPath.item);};
		
	
	
		

	
	
// role Observer (Core) 

GenericDataSource.prototype.observedObjectValueDidAppearForKey = function GenericDataSource_observedObjectValueDidAppearForKey(obj, key, sender) {
			if (this.listView)
				this.listView.reloadData();};
		
		
GenericDataSource.prototype.observedObjectValueDidDisappearForKey = function GenericDataSource_observedObjectValueDidDisappearForKey(obj, value, key, sender) {
			if (this.listView)
				this.listView.reloadData();};
		

GenericDataSource.prototype.observedObjectValueDidChangeKey = function GenericDataSource_observedObjectValueDidChangeKey(obj, oldKey, newKey, keyPath, sender) {
			if (this.listView)
				this.listView.reloadData();};
		

GenericDataSource.prototype.observedObjectValuesDidReplace = function GenericDataSource_observedObjectValuesDidReplace(obj, sender) {
			if (this.listView)
				this.listView.reloadData();};
		

GenericDataSource.prototype.observedObjectValueDidChangeForKeyPath = function GenericDataSource_observedObjectValueDidChangeForKeyPath(obj, keyPath, sender) {
			if (this.listView)
				this.listView.reloadData();};
		

GenericDataSource.prototype.observedObjectSelectionDidChangeForKey = function GenericDataSource_observedObjectSelectionDidChangeForKey(obj, index, isSelected, sender) {
			if (this.listView)
				this.listView.reloadData();};
		

	

GenericDataSource.prototype.initPropertiesFromData = function GenericDataSource_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("id")) this.id = data.id;
if (data.hasOwnProperty("name")) this.name = data.name;
if (data.hasOwnProperty("contents")) this.contents = data.contents;
if (data.hasOwnProperty("dataController")) this.dataController = data.dataController;
if (data.hasOwnProperty("keyPath")) this.keyPath = data.keyPath;
};

GenericDataSource.prototype.decodeData = function GenericDataSource_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

GenericDataSource.prototype.encode = function GenericDataSource_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

GenericDataSource.prototype.encodeCloned = function GenericDataSource_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

GenericDataSource.prototype.expectedTypeForProperty = function GenericDataSource_expectedTypeForProperty(key) {
	if (key === "id") return "";
	if (key === "name") return "";
	if (key === "contents") return "";
	if (key === "dataController") return "";
	if (key === "keyPath") return "";
	if (key === "listView") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return GenericDataSource; }()));