
registerType('Core.UI', (function () { function ImageView() {} var __super = setSupertypeFromDomain(ImageView, 'View', 'Core.UI');

	var canvasBased = false;

ImageView.prototype.initFromData = function ImageView_initFromData(data, holdBindings) {

		if (!__super.prototype.initFromData.call(this, data, null, true))
			return null;

		if (data === undefined) return;
		
		Object.defineProperty(this, "_backgroundSize", {
		writable: true, 
			value: ''});
		

		[ 'drawWithCanvas',
		  'contentMode',
		  'imageSrc',
		  'name',
		  'changeWithTransition',
		  'delegate',
		  'contentScale',
		].every(function (option) {
			if (data[option] !== undefined)
				this[option] = data[option];
			return true;
		}.bind(this));

		if (!data.contentMode) this.contentMode = 'center';
		
		
		if (!holdBindings)
			this.applyBindings(true);

		return this;
};
	

ImageView.prototype.setImageSrc = function ImageView__setImageSrc(value) {


		var oldImageSrc = this._originalImageSrc;

		Object.defineProperty(this, "_originalImageSrc", {
		writable: true, 
			value: value});
		
	
		if (value)
			value = this.context.pathForOptimizedImage(value);

		if (value === this._imageSrc) return;
		


		Object.defineProperty(this, "_imageSrc", {
		writable: true, 
			value: value});
		
		


		if (!value) {
			this.styleEmpty();
			return;
		}
		
		
		if (this.changeWithTransition === true && !this.transitionView) {
			var data = this.encode();
			delete data.bindings;
			delete data.observations;
			data.imageSrc = oldImageSrc;
			this.transitionView = this.context.decodeObjectTree(data);
			this.addSubview(this.transitionView);
		}

		this.context.whenImageIsReady(value, function (img, _value) {

			
			if (this._imageSrc !== _value || this._isDestroyed === true) {
				return;
			}
			
			if (canvasBased || this.drawWithCanvas) {
			
				this.drawImageOnCanvas(img);
			
			}
			else {

				this.style({
					backgroundImage: 'url("'+img.src+'")',
					backgroundSize: this._backgroundSize,
					backgroundRepeat: 'no-repeat',
					backgroundPosition: '50% 50%'
				});
			
			}


			Object.defineProperty(this, "_image", {
			writable: true, 
				value: img});
			

			this.imageDidLoad();
			
			
			
			
			if (this.transitionView) {
				this.transitionView.style({
					webkitTransition: 'opacity 0.25s ease-in-out',
					opacity: 0
				});
				setTimeout(function () {
					if (!this.transitionView) return;
					this.transitionView.removeFromSuperview();
					delete this.transitionView;
				}.bind(this), 500);
			}
		
		}.bind(this), function (img, _value, event) {
		
			this.styleEmpty();
		
		
		}.bind(this));
		};
	
	
ImageView.prototype.styleEmpty = function ImageView__styleEmpty() {
		this.style({
			backgroundImage: 'none'
		});
		if (canvasBased || this.drawWithCanvas) {
			if (this._canvas) this._canvas.getContext('2d').clearRect(0,0,this._canvas.width, this._canvas.height);
		}};
	
	
ImageView.prototype.applyContentMode = function ImageView__applyContentMode() {
	
		if (canvasBased || this.drawWithCanvas) {
			this.updateCanvas();
			return;
		}
	
		var value = this._contentMode;
		
		if (this._image === undefined || this.imageSrc === undefined) {
		
			
			this._backgroundSize = '0%';
			
		}
		else {
		
			switch (value) {
				case 'center':
					if ((this.imageSrc.indexOf('@2x') !== -1 && this.context.highResolutionEnabled === true) || this.usesHighResolutionByDefault)
						this._backgroundSize = (this._image.width/2)+'px auto';
					else
						this._backgroundSize = '';
					break;
				case 'scaleToFill':
					this._backgroundSize = '100% 100%';
					break;
				case 'scaleAspectFitNoUpscaling':
					var scale = this.contentScale||(this.context.highResolutionEnabled ? 2 : 1);
				
					if (this._image.width/scale < this.size.width &&
						this._image.height/scale < this.size.height) {
							this._backgroundSize = (this._image.width/scale)+'px '+(this._image.height/scale)+'px';
							break;
					}
				case 'scaleAspectFit':
					if (this._imageRatio > this.size.width/this.size.height)
						this._backgroundSize = '100% auto';
					else
						this._backgroundSize = 'auto 100%';
					break;
				case 'scaleAspectFill':
					if (this._imageRatio < this.size.width/this.size.height)
						this._backgroundSize = '100% auto';
					else
						this._backgroundSize = 'auto 100%';
					break;
				default:
					return;
			}
		
		}

		this.style({
			backgroundSize: this._backgroundSize
		});
	};
	
	
	Object.defineProperty(ImageView.prototype, "imageRatio", {
	synthesized: true, get:function () { return this._imageRatio; }, set:function (v) {if (!Object.hasOwnProperty(this, "_imageRatio")) Object.defineProperty(this, "_imageRatio", { writable: true, configurable: true }); this._imageRatio = v; }});
	
	
ImageView.prototype.imageDidLoad = function ImageView__imageDidLoad() {
	
		this.imageRatio = this._image.width/this._image.height;
	
		if (this._contentMode !== undefined) {
			this.applyContentMode(this._contentMode);
		}
		
		this.callDelegate('imageViewDidLoadImage', [this, this._image]);

		
		var e = document.createEvent('CustomEvent');
		e.initCustomEvent("load", false, false, null);
		this.dispatchEvent(e);
		
		};
	
	
ImageView.prototype.drawImageOnCanvas = function ImageView__drawImageOnCanvas(img) {
	
		if (!this._canvas) {

			var _canvas = document.createElement('canvas');
			_canvas.style.position = 'absolute';
			this.DOMNode.appendChild(_canvas);
			
			Object.defineProperty(this, "_canvas", {
				value: _canvas});
			
		}

		Object.defineProperty(this, "_img", {
		writable: true, 
			value: img});
		
		
		if (!this.contentMode) this.updateCanvas();
	};
	
	
ImageView.prototype.updateCanvas = function ImageView__updateCanvas() {
		if (!this._canvas) return;
		this.redrawCanvas();};
	
	
ImageView.prototype.redrawCanvas = function ImageView__redrawCanvas() {

		var scale = this.context.highResolutionEnabled ? 2 : 1;
		this._canvas.width = this.size.width*scale;
		this._canvas.height = this.size.height*scale;
		this._canvas.style.width = this.size.width+'px';
		this._canvas.style.height = this.size.height+'px';
		
		var ctx = this._canvas.getContext('2d'),
			img = this._img,
			width = this.size.width*scale,
			height = this.size.height*scale,
			imgWidth = img.width,
			imgHeight = img.height,
			contentMode = this.contentMode,
			imageRatio = imgWidth/imgHeight;
		
		ctx.clearRect(0, 0, width, height);

		if (contentMode === 'topLeft')
			ctx.drawImage(img, 0, 0);

		else if (contentMode === 'center')
			ctx.drawImage(img, Math.ceil((width-imgWidth)/2), Math.ceil((height-imgHeight)/2));

		else if (contentMode === 'scaleToFill')
			ctx.drawImage(img, 0, 0, width, height);

		else if (contentMode === 'scaleAspectFill') {
			if (imageRatio < width/height) {
				var h = width/imageRatio;
				ctx.drawImage(img, 0, (height-h)/2, width, h);
			}
			else {
				var w = height*imageRatio;
				ctx.drawImage(img, (width-w)/2, 0, w, height);
			}
		}

		else if (contentMode === 'scaleAspectFit' ||
				 contentMode === 'scaleAspectFitNoUpscaling') {

			if (imageRatio > width/height) {
				var h = width/imageRatio;
				this.drawImage_onContext_position_size(img, ctx, 0, (height-h)/2, width, h);
			}
			else {
				var w = height*imageRatio;
				this.drawImage_onContext_position_size(img, ctx, (width-w)/2, 0, w, height);
			}
		}
		else {
			console.warn('ImageView.redrawCanvas(): contentMode +'+contentMode+' is not available in canvas-based drawing.');
		}
};
	
	
ImageView.prototype.drawImage_onContext_position_size = function ImageView__drawImage_onContext_position_size(img, ctx, x, y, w, h) {

		resample_hermite(ctx, img, x, y, w, h);
		
		if (x || y) {
			var imageData = ctx.getImageData(0, 0, w, h);
			ctx.clearRect(0,0,w,h);
			ctx.putImageData(imageData,x,y);
		}
};
	
	
ImageView.prototype.viewDidResize = function ImageView_viewDidResize() {
		__super.prototype.viewDidResize.call(this);
		this.applyContentMode();};
	


	

ImageView.prototype.encode = function ImageView_encode() {
		return this.context.encodeObject(this, this.DOMNode, ['position','left','top','width','height','right','bottom','backgroundImage','backgroundSize','backgroundRepeatX','backgroundRepeatY','backgroundPositionX','backgroundPositionY']);};
	


	

	Object.defineProperty(ImageView.prototype, "image", {
		get: function () { return this._image; }});
	
	
	Object.defineProperty(ImageView.prototype, "outlineIconURL", {
		get: function () { return this.imageSrc; }});
	
	
	Object.defineProperty(ImageView.prototype, "imageSrc", {
	enumerable: true, 
		set: function (value) {
			this.setImageSrc(value);
		}, 
		get: function () {
			return this._imageSrc;
		}});
	

	Object.defineProperty(ImageView.prototype, "contentMode", {
	enumerable: true, 
		set: function (value) {
			Object.defineProperty(this, "_contentMode", {
			writable: true, 
				value: value});
			
			this.applyContentMode(value);
		}, 
		get: function () {
			return this._contentMode;
		}});
	
	
	Object.defineProperty(ImageView.prototype, "highResolutionEnabled", {
		set: function (trueOrFalse) {
		
			this.setImageSrc(this._originalImageSrc);
	
		}});
	
	
	Object.defineProperty(ImageView.prototype, "delegate", {
	outlet: true, get:function () { return this._delegate; }, set:function (v) {if (!Object.hasOwnProperty(this, "_delegate")) Object.defineProperty(this, "_delegate", { writable: true, configurable: true }); this._delegate = v; }});
	

	Object.defineProperty(ImageView.prototype, "bindableProperties", {
		get:function () {
			return Object.getOwnPropertyDescriptor(__super.prototype, "bindableProperties").get.call(this);
		}});
	

	
	function resample_hermite(ctx, img, x, y, w, h) {
		var W = img.width, H = img.height, W2 = w, H2 = h;
		var time1 = Date.now();
		var canvas = document.createElement('canvas');
		canvas.width = W;
		canvas.height = H;
		var canvas_ctx = canvas.getContext("2d");
		if(canvas_ctx !== undefined && img !== undefined) {
			canvas_ctx.drawImage(img, 0, 0);
		}
		var img = canvas.getContext("2d").getImageData(0, 0, W, H);
		var img2 = ctx.getImageData(0, 0, W2, H2);
		var data = img.data;
		var data2 = img2.data;
		var ratio_w = W / W2;
		var ratio_h = H / H2;
		var ratio_w_half = Math.ceil(ratio_w/2);
		var ratio_h_half = Math.ceil(ratio_h/2);
		for (var j = 0; j < H2; j++) {
			for (var i = 0; i < W2; i++) {
				var x2 = (i + j*W2) * 4;
				var weight = 0;
				var weights = 0;
				var gx_r = gx_g = gx_b = gx_a = 0;
				var center_y = (j + 0.5) * ratio_h;
				for(var yy = Math.floor(j * ratio_h); yy < (j + 1) * ratio_h; yy++){
					var dy = Math.abs(center_y - (yy + 0.5)) / ratio_h_half;
					var center_x = (i + 0.5) * ratio_w;
					var w0 = dy*dy 
					for(var xx = Math.floor(i * ratio_w); xx < (i + 1) * ratio_w; xx++){
						var dx = Math.abs(center_x - (xx + 0.5)) / ratio_w_half;
						var w = Math.sqrt(w0 + dx*dx);
						if(w >= -1 && w <= 1){
							
							weight = 2 * w*w*w - 3*w*w + 1;
							if(weight > 0){
								dx = 4*(xx + yy*W);
								gx_r += weight * data[dx];
								gx_g += weight * data[dx + 1];
								gx_b += weight * data[dx + 2];
								gx_a += weight * data[dx + 3];
								weights += weight;
								}
							}
						}       
					}
				data2[x2]     = gx_r / weights;
				data2[x2 + 1] = gx_g / weights;
				data2[x2 + 2] = gx_b / weights;
				data2[x2 + 3] = gx_a / weights;
				}
		}
	
		ctx.putImageData(img2, 0, 0);
	}

ImageView.prototype.initPropertiesFromData = function ImageView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("delegate")) this.delegate = data.delegate;
};

ImageView.prototype.decodeData = function ImageView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

ImageView.prototype.encodeCloned = function ImageView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

ImageView.prototype.expectedTypeForProperty = function ImageView_expectedTypeForProperty(key) {
	if (key === "imageRatio") return "";
	if (key === "image") return "";
	if (key === "outlineIconURL") return "";
	if (key === "imageSrc") return "";
	if (key === "contentMode") return "";
	if (key === "highResolutionEnabled") return "";
	if (key === "delegate") return "";
	if (key === "bindableProperties") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ImageView; }()));