
registerType('Core.UI', (function () { function ItemsView() {} var __super = setSupertypeFromDomain(ItemsView, 'View', 'Core.UI');

ItemsView.prototype.init = function ItemsView_init() {
		__super.prototype.init.call(this);
		
		
		if (this.usesDataSource !== false)
			this.usesDataSource = true;

		
		if (!this.usesDataSource) {
			if (this.staticSections &&
			this.staticSections.length > this.numberOfStaticSections)
			this.staticSections.splice(this.numberOfStaticSections,this.staticSections.length);
			
		}
		if (Array.isArray(this.staticSections)) this.staticSections.every(function (section) {
			section.itemsView = this;return true; }, this);
		
		
		return this;};
	
	
ItemsView.prototype.destroy = function ItemsView_destroy() {
		if (this.dataSource) try { this.dataSource.removeObserver(this); } catch (err) {}
		__super.prototype.destroy.call(this);};
	

ItemsView.prototype.reloadDataLazy = function ItemsView_reloadDataLazy() {
	
		if (!this.DOMNode) return;
		if (this.viewIsLoaded !== true)
			return;
		
		if (!this.cellPrototype)
			this.setDefaultCellPrototype();

		var scrollLeftBefore = this.scrollLeft,
			scrollTopBefore = this.scrollTop;
		
		this.clearData();
		this.insertData();
		
		if (!this.layoutSubviews())
			this.arrangeSubviews();
		
		if (this.setsHeightToFitContent) this.setHeightToFit();
		else this.scrollTo(scrollLeftBefore, scrollTopBefore);
		
		if (this.selectionToRestore) { _context.editor.restoreSelection(this.selectionToRestore); this.selectionToRestore = null; }
		};
	

	Object.defineProperty(ItemsView.prototype, "scrollLeft", {
	outlet: true, 
	enumerable: true, 
		get: function () { if (this._scrollLeft !== undefined) return this._scrollLeft; if (this.DOMNode) return this.DOMNode.scrollLeft; }, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_scrollLeft")) Object.defineProperty(this, "_scrollLeft", { writable: true, configurable: true }); this._scrollLeft = v; this.DOMNode.scrollLeft = v; }});
	

	Object.defineProperty(ItemsView.prototype, "scrollTop", {
	outlet: true, 
	enumerable: true, 
		get: function () { if (this._scrollTop !== undefined) return this._scrollTop; if (this.DOMNode) return this.DOMNode.scrollTop; }, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_scrollTop")) Object.defineProperty(this, "_scrollTop", { writable: true, configurable: true }); this._scrollTop = v; this.DOMNode.scrollTop = v; }});
	
	
	Object.defineProperty(ItemsView.prototype, "selectionToRestore", {
	synthesized: true, get:function () { return this._selectionToRestore; }, set:function (v) {if (!Object.hasOwnProperty(this, "_selectionToRestore")) Object.defineProperty(this, "_selectionToRestore", { writable: true, configurable: true }); this._selectionToRestore = v; }});
	
	
ItemsView.prototype.clearData = function ItemsView__clearData() {
		if (!this.usesDataSource) {
			if (Array.isArray(clone(this.subviews))) clone(this.subviews).every(function (subview) {
				subview.removeFromSuperview(true);return true; }, this);
			
		}
		else {
			
			if (Array.isArray(clone(this.subviews))) clone(this.subviews).every(function (subview) {
				if (subview === this._listHeaderView) return true;
			
				var doNotDestroy = (
					subview === this._listHeaderView ||
					subview === this._listFooterView ||
					subview === this._paginationCell);
	
				subview.removeFromSuperview(doNotDestroy);return true; }, this);
			
		}
		
		this.selectedIndexPaths = [];

		this.clearDynamicBindings();};
	
	
ItemsView.prototype.clearDynamicBindings = function ItemsView__clearDynamicBindings() {
		
		if (this.dynamicBindings)
			this.dynamicBindings.forEach(function (binding) {
				this.context.unregisterBinding(binding);
			}, this);
		this.dynamicBindings = [];
		};
	
	
ItemsView.prototype.addEditorButtonsToCells = function ItemsView__addEditorButtonsToCells(cells) {

		if (Array.isArray(cells)) cells.every(function (subview) {
			if (subview.isSectionView) {
				this.addEditorButtonsToCells(subview.subviews);
				return true;
			}
				
			this.addEditorButtonsToCell(subview);

return true; }, this);
		
	};
	

ItemsView.prototype.addEditorButtonsToCell = function ItemsView__addEditorButtonsToCell(subview) {

		var self = this, editor = _context.editor;
		editor.addEditDetailButtonToCellInView(subview, this);

		subview.DOMNode.ondblclick = function (e) {
			if (self.locked) return;
			if (editor.isActionClick(e)) return;
			self.editCellWithEditor(this, editor);
		}.bind(subview);
};
	

ItemsView.prototype.editCellWithEditor = function ItemsView__editCellWithEditor(cell, editor) {

		if (!cell) {
			console.trace();
			return;
		}

		editor.treeController.beginSelectionChange();
		editor.treeController.unselectAll();

		if (this.usesDataSource && cell.indexPath) {
			this.cellPrototypeView.position = cell.positionCopy;
			this.cellPrototypeView.indexPath = cell.indexPath;
			editor.treeController.selectValue(this.cellPrototypeView);
		}
		else {
			editor.treeController.selectValue(cell.contentView||cell);
		}

		editor.treeController.commitSelectionChange(this);};
	

	

	Object.defineProperty(ItemsView.prototype, "selectable", {
	outlet: true, 
	enumerable: true, get:function () { return this._selectable; }, set:function (v) {if (!Object.hasOwnProperty(this, "_selectable")) Object.defineProperty(this, "_selectable", { writable: true, configurable: true }); this._selectable = v; }});
	

	Object.defineProperty(ItemsView.prototype, "draggable", {
	outlet: true, 
	enumerable: true, get:function () { return this._draggable; }, set:function (v) {if (!Object.hasOwnProperty(this, "_draggable")) Object.defineProperty(this, "_draggable", { writable: true, configurable: true }); this._draggable = v; }});
	

	Object.defineProperty(ItemsView.prototype, "dataSource", {
	outlet: true, 
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_dataSource")) Object.defineProperty(this, "_dataSource", { writable: true, configurable: true });
			this.setDataSource(v);
		}, get:function () { return this._dataSource; }});
	
	
ItemsView.prototype.setDataSource = function ItemsView__setDataSource(v) {

		var didChange, oldID;

		if (this.dataSource) {
			didChange = true; oldID = this.dataSource.$id;
		}

		if (didChange) {
		
			Object.defineProperty(this, "needsUpdateForBindingsOldID", {
			configurable: true, 
			writable: true, 
				value: oldID});
			
			
		}

			if (!v) return;
		
			if (!this.dataSourceConformsToProtocol(v)) {
				console.warn('The datasource does not implement all methods required by the protocol.', this, v);
				return;
			}

			if (this.dataSource) {
				try { this.dataSource.removeObserver(this); } catch (err) {}
			}

			Object.defineProperty(this, '_dataSource', {
				value: v, configurable: true, enumerable: false
			});

			try { v.addObserver(this); } catch (err) { console.warn('Could not add an observer to the data source.', v, err); }

			this.reloadData();};
	
	
	Object.defineProperty(ItemsView.prototype, "dataSourceUTI", {
		get: function () {
			return this.dataSource ? this.dataSource.UTI : '';
		}});
	
	

ItemsView.prototype.dataSourceConformsToProtocol = function ItemsView__dataSourceConformsToProtocol(ds) {

		if (!ds.numberOfItemsInSection) {
			console.warn('numberOfItemsInSection() is required in', ds);
			return false;
		}
		
		return true;};
	

	
	
	
ItemsView.prototype.reloadData = function ItemsView_reloadData() {};
	


	
	
ItemsView.prototype.prepareCellWithDataForIndexPath = function ItemsView__prepareCellWithDataForIndexPath(cell, indexPath, keepOriginalIDs) {
	
		if (!this.dataSource) return;
	
		var data, context = {}, dataSourceChildrenId = this.dataSource.$id;
		
		try {
			data = this.dataSource.dataForIndexPath(indexPath);
			context[dataSourceChildrenId] = data;
			this.applyBindingsInCellContentView(cell, context, keepOriginalIDs);
		}
		catch (err) {
			console.warn(err);
			return;
		}

		
		if (this.draggable) {
			cell.DOMNode.draggable = true;
			cell.DOMNode.addEventListener('dragstart', function (e) {
				var self = this.superview;
				self.cellCreateDragWithEvent(this, e);
			}.bind(cell));
		}

		
		cell.DOMNode.addEventListener('contextmenu', function (e) {
			this.cellContextMenuHandler(e, cell);
		}.bind(this));
		
		cell.indexPath = clone(indexPath);			
		cell.dataset = data;
};
	
	
	
	
	
	Object.defineProperty(ItemsView.prototype, "useNativeDragAndDrop", {
	configurable: true, 
		value: false});
	
	
ItemsView.prototype.cellCreateDragWithEvent = function ItemsView__cellCreateDragWithEvent(cell, e) {

		if (!this.useNativeDragAndDrop)
			e = this.createCustomDragEventForCellAndEvent(cell, e);
			
		var dataset = this.dataSource.dataForIndexPath(cell.indexPath);

		if (dataset && dataset.transferData) {
			if (!e.dataTransfer.setData(dataset.transferData.format, dataset.transferData.data)) {
				console.warn('Failed setting dataTransfer data.', dataset.transferData);
			}
		}
		};
	
	
ItemsView.prototype.cellOnDragStart = function ItemsView__cellOnDragStart(cell, e) {};
	
	
ItemsView.prototype.cellOnDragEnd = function ItemsView__cellOnDragEnd(cell, e) {};
	
	
ItemsView.prototype.createCustomDragEventForCellAndEvent = function ItemsView__createCustomDragEventForCellAndEvent(cell, e) {

		var dragItem = createComponentFromDomain("DragItem", "Core.UI", this.context, {
			sourceView: this.callDelegate('itemsViewDragViewForCellAndEvent', [this, cell, e]) || cell,
			onBegin: function (e) {
				this.cellOnDragStart(cell, e);
			}.bind(this),
			onFinish: function () {
				this.cellOnDragEnd(cell, e);
			}.bind(this)})
		;
		
		return dragItem.dragWithEvent(e);
		};
	


	

ItemsView.prototype.applyBindingsInCellContentView = function ItemsView_applyBindingsInCellContentView(rowContentView, localContext, keepOriginalIDs) {
	
		this.registerDynamicBindings(rowContentView, localContext, true, keepOriginalIDs);
};
	
	
	Object.defineProperty(ItemsView.prototype, "dynamicBindings", {
	synthesized: true, get:function () { return this._dynamicBindings; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dynamicBindings")) Object.defineProperty(this, "_dynamicBindings", { writable: true, configurable: true }); this._dynamicBindings = v; }});
	
	
ItemsView.prototype.registerDynamicBindings = function ItemsView__registerDynamicBindings(view, localContext, isContentView, keepOriginalIDs) {
	
		if (view.encodesSubviews!==false) {
			for (var i = 0, c = view.subviews.length; i < c; i++) {
				this.registerDynamicBindings(view.subviews[i], localContext, false, keepOriginalIDs);
			}
		}

		if (!view.bindings) return;

		if (view._dynamicBindings) {
			this.unregisterDynamicBindings(view);
		}
	
		Object.defineProperty(view, '_dynamicBindings', {
			value: [],
			configurable: true
		});
		
		if (!keepOriginalIDs) {
			view.$id = undefined;
			view.identify();
		}
		
		var sizeBindingInvolved = false;

		if (Array.isArray(view.bindings)) view.bindings.every(function (binding) {
		
			if (binding.enumerableItemAccess !== true) {
				return true;
			}

			var _binding = this.context.convertEnumerableItemBindingToPermanentFromObjectInLocalContext(binding, view, localContext);
			
			if (!_binding) return true;

			view._dynamicBindings.push(_binding);

			if (!this.dynamicBindings) this.dynamicBindings = [];
			this.dynamicBindings.push(_binding);
			
			if (_binding.valueTransformer && typeof _binding.valueTransformer === 'string')
				_binding.valueTransformer = new Function ("a", _binding.valueTransformer);

			this.context.applyBinding(_binding);
			if (!_binding.sourceKeyPath) {
				console.log('--->', _binding.sourceKeyPath, _binding);
			}
			if (_binding.sourceKeyPath.substr(0, 5) === 'size.')
				sizeBindingInvolved = true;
			
			if (keepOriginalIDs && binding.sourceObject) {
				binding.sourceObject = view;
			}
return true; }, this);
		

		if (sizeBindingInvolved) {
			if (isContentView) {
				if (view.superview)
					view.superview.size.height = view.size.height;
			}
		}};
	

ItemsView.prototype.unregisterDynamicBindings = function ItemsView__unregisterDynamicBindings(view) {

		if (view._dynamicBindings) {
			if (Array.isArray(view._dynamicBindings)) view._dynamicBindings.every(function (_binding) {
				this.context.unregisterBinding(_binding);

				var idx = this.dynamicBindings.indexOf(_binding);
				if (idx !== -1) this.dynamicBindings.splice(idx, 1);return true; }, this);
			
			delete view._dynamicBindings;
		}
	};
	

ItemsView.prototype.performSimpleBindingsUpdate = function ItemsView__performSimpleBindingsUpdate() {
	
		if (this.cellPrototypeView.subviews &&
			this.cellPrototypeView.subviews.length === 1) {

			var label = this.cellPrototypeView.subviews[0];

			
			if (label.UTI === 'appdoo.iOS.UILabel') {
				
				var binding = label.bindingForKey('text');
				if (binding) {
					label.removeBinding(binding);
				}

				if (this.dataSource) {

					var destinationKeyPath = this.dataSource.firstItemKey;
					
					if (typeof destinationKeyPath === 'string') {
						binding = {
							sourceKeyPath: 'text',
							destination: this.dataSource.$id,
							destinationKeyPath: destinationKeyPath,
							enumerableItemAccess: true
						};
						label.addBinding(binding);
						
						this.cellPrototype = this.cellPrototypeView.encode();
						
						return true;
					}

				}
			
			}
		}};
	

ItemsView.prototype.updateBindingsInViews = function ItemsView__updateBindingsInViews(viewsToUpdate, oldDataSourceID, newDataSourceID) {

		if (!viewsToUpdate) return;
		
		var oldDestination = oldDataSourceID,
			newDestination = newDataSourceID;
	
		if (Array.isArray(viewsToUpdate)) viewsToUpdate.every(function (view) {
			if (!view) return true;
			this.updateBindingsInViews(view.subviews, oldDataSourceID, newDataSourceID);

			if (view.bindings) {
				if (Array.isArray(view.bindings)) view.bindings.every(function (binding) {
					if (binding.destination === oldDestination)
						binding.destination = newDestination;return true; }, this);
				
			}
			return true; }, this);
		};
	


	Object.defineProperty(ItemsView.prototype, "dataSourceId", {
	synthesized: true, 
	enumerable: true, get:function () { return this._dataSourceId; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dataSourceId")) Object.defineProperty(this, "_dataSourceId", { writable: true, configurable: true }); this._dataSourceId = v; }});
	

	Object.defineProperty(ItemsView.prototype, "editorDidChangeDataSource", {
	synthesized: true, get:function () { return this._editorDidChangeDataSource; }, set:function (v) {if (!Object.hasOwnProperty(this, "_editorDidChangeDataSource")) Object.defineProperty(this, "_editorDidChangeDataSource", { writable: true, configurable: true }); this._editorDidChangeDataSource = v; }});
	

	Object.defineProperty(ItemsView.prototype, "e_dataSourceID", {
		set: function (v) {
			this.dataSourceId = v;
			this.editorDidChangeDataSource = true;
			if (this.viewIsLoaded) this.loadDataSource();
			if (v && !this.e_usesDataSource)
				this.dataController.setValueForKey(true, 'e_usesDataSource', this.dataController);
		}, 
		get: function () {
			return this.dataSource ? this.dataSource.identify() : this.dataSourceId || '';
		}});
	
	
ItemsView.prototype.dataSourceDidLoad = function ItemsView_dataSourceDidLoad(dataSource) {

		if (this.editorDidChangeDataSource)
			this.dataSourceDidChange(this.needsUpdateForBindingsOldID);

		this.reloadData(true);
	};
	
	
ItemsView.prototype.unprepareForEditor = function ItemsView_unprepareForEditor(editor) {};
	

ItemsView.prototype.dataSourceDidChange = function ItemsView__dataSourceDidChange(oldDataSourceID) {

		this.needsUpdateForBindingsOldID = null;
	
		var newDataSourceID = this._dataSourceId;
		var couldDoSimpleUpdate = this.performSimpleBindingsUpdate();

		if (!couldDoSimpleUpdate && oldDataSourceID) {
			this.updateBindingsInViews([this.listHeaderView, this.cellPrototypeView, this.listFooterView], oldDataSourceID, newDataSourceID);
		}
		this.updatePrototypesForEditor(_context.editor);};
	
	
ItemsView.prototype.updatePrototypesForEditor = function ItemsView_updatePrototypesForEditor(editor) {
		if (!this.cellPrototypeView) return;
		
		editor.changeCellPrototypeForItemsView('cellPrototype', this.cellPrototypeView.encode(), this, true);
		};
	

ItemsView.prototype.insertStaticContent = function ItemsView__insertStaticContent() {};
	

ItemsView.prototype.insertStaticCell = function ItemsView__insertStaticCell(cell) {

		if (cell.isSectionView && _context.editor.isInSubviewEditingMode) {
			if (Array.isArray(cell.section.staticCells)) cell.section.staticCells.every(function (subcell) {
				if (_context.editor.editedSubview === (subcell.contentView||subcell)) {
					this.selectionToRestore = _context.editor.getSelectedObjectIDs();
					_context.editor.endEditingSubview();
					cell.section.populateView();
					return false;
				}return true; }, this);
			
		}
		else if (_context.editor.editedSubview === cell)
			_context.editor.endEditingSubview();

		this.addSubview(cell);};
	


	
	
ItemsView.prototype.cellContextMenuHandler = function ItemsView__cellContextMenuHandler(e, cell) {

		var indexPath = cell.indexPath;
		
		if (!this.dataSource || !this.dataSource.menuForItems)
			return;
		
		e.stopPropagation();
		e.preventDefault();
		
		var items, cells;
		
		if (cell._selected) {
			items = [];
			cells = [];
			if (Array.isArray(this.selectedIndexPaths)) this.selectedIndexPaths.every(function (indexPath) {
				var _cell = this.cellForIndexPath(indexPath);
				items.push(_cell.dataset);
				cells.push(_cell);return true; }, this);
			
		}
		else {
			cells = [cell];
			items = [cell.dataset];
		}

		var menu = this.dataSource.menuForItems(items);
		if (!menu) return;
		
		menu.x = e.x;
		menu.y = e.y;
		
		this._currentContextMenuCell = cell;
		
		if (Array.isArray(cells)) cells.every(function (_cell) {
			this.styleCellAsTargetActive(_cell, true);return true; }, this);
		
		
		setTimeout(function () {
			this.context.showContextMenu(menu);
			if (Array.isArray(this.subviews)) this.subviews.every(function (_cell) {
				this.styleCellAsTargetActive(_cell, false);return true; }, this);
			
			
			if (this._onCMFinishTimeout) {
				clearTimeout(this._onCMFinishTimeout);
				delete this._onCMFinishTimeout;
			}
			
			this._onCMFinishTimeout = setTimeout(function () {
				delete this._currentContextMenuCell;
			}.bind(this), 10);
		}.bind(this), 1);

	};
	

ItemsView.prototype.styleCellAsTargetActive = function ItemsView__styleCellAsTargetActive(cell, isActive) {

		if (cell._isTarget === isActive)
			return;

		cell._isTarget = isActive;

		if (isActive) {
			var targetIndicator = createComponentFromDomain("View", "Core.UI", this.context, {
				style: {
					backgroundColor: 'rgba(191,216,255,.5)',
					border: '2px solid rgb(77,114,220)',
					borderRadius: '7px',
					pointerEvents: 'none',
					zIndex: 0
				},
				size: { width: cell.size.width-this.targetIndicatorPadding, height: cell.size.height-this.targetIndicatorPadding },
				position: { left: this.targetIndicatorLeft, top: this.targetIndicatorTop }})
			;
			cell.insertSubviewAtIndex(targetIndicator, 0);
			cell._targetIndicator = targetIndicator;
		}
		else {
			if (cell._targetIndicator) {
				cell._targetIndicator.superview.removeSubview(cell._targetIndicator);
				delete cell._targetIndicator;
			}
		}};
	
	
	Object.defineProperty(ItemsView.prototype, "targetIndicatorPadding", {
	configurable: true, 
		value: 0});
	 
	
	Object.defineProperty(ItemsView.prototype, "targetIndicatorTop", {
	configurable: true, 
		value: -3});
	

	Object.defineProperty(ItemsView.prototype, "targetIndicatorLeft", {
	configurable: true, 
		value: -2});
	

ItemsView.prototype.cellForItem = function ItemsView_cellForItem(item) {
		if (!this.subviews) return;
		var r;
		if (Array.isArray(this.subviews)) this.subviews.every(function (cell) {
			if (cell.dataset === item) { r = cell; return false; }return true; }, this);
		
		return r;};
	
	



	Object.defineProperty(ItemsView.prototype, "e_navigatesToDetailScene", {
		get: function ( ) { return this.usesDataSource && !!this.detailSceneID; }, 
		set: function (v) {
		
			if (v === false) {
				this.detailSceneID = undefined;
				this.updateSegue();
				_context.editor.refreshInspector();
				this.reloadData();
				return;
			}

			var result;
			if (_context.undoManager.isUndoingOrRedoing) result = 1;
			else result = this.context.nativeProxy.sendMessage('confirmWithOptions', JSON.stringify({
					message: LocalizedString('Do you want to create a new screen or use an existing one?'),
					details: '',
					button1: LocalizedString('New Screen'),
					button2: LocalizedString('Use Existing'),
					button3: LocalizedString('Cancel')
				}));
			
			if (result !== 2) {
	
				var id;

				if (result === true) {

					var scene = _context.createNewScene(true, this);

					if (scene) {
						scene.e_showsNavigationBar = true;
						if (this.dataSource && this.dataSource.firstItemKey) {
							scene.navigationBar.items[0].bindings = [
								{
									sourceKeyPath: 'title',
									destination: scene.getOrCreateInputDataSource().identify(),
									destinationKeyPath: 'contents.'+this.dataSource.firstItemKey
								}
							];
						}
						id = scene.identify();
					}
				}
				else {
					id = _context.projectScenesController.lastValue.$id;
					if (id === _context.editor.editedScene.$id)
						id = _context.projectScenesController.firstValue.$id;
				}
				
				this.detailSceneID = id;
				this.updateSegue();
				this.reloadData();
			}
			_context.editor.refreshInspector();
		}});
	

	Object.defineProperty(ItemsView.prototype, "detailSceneID", {
	outlet: true, 
	enumerable: true, get:function () { return this._detailSceneID; }, set:function (v) {if (!Object.hasOwnProperty(this, "_detailSceneID")) Object.defineProperty(this, "_detailSceneID", { writable: true, configurable: true }); this._detailSceneID = v; }});
	

	Object.defineProperty(ItemsView.prototype, "e_detailSceneID", {
		get: function ( ) {
			if (this.e_navigatesToDetailScene)
				return this.detailSceneID;
		}, 
		set: function (v) {

			this.detailSceneID = v;
			this.updateSegue();
			this.reloadData();
		}});
	
	
ItemsView.prototype.updateSegue = function ItemsView__updateSegue() {
		_context.editor.updateSegueForView__type__destination__(this, 'push', this.e_detailSceneID);};
	
	
	Object.defineProperty(ItemsView.prototype, "dataSourceInspectorProperties", {
		get: function () {
		
			return	{
					type: 'group',
					title: LocalizedString('Data Source'),
					id: 'ItemsViewDataSource',
					items: [

						{ name: '', keyPath: 'e_dataSourceID', type: 'object', labelOnTop: true, isFirstInGroup:true, objectType:'dataSource', placeholder:'There are no data sources available in this screen.', numberOfVisibleItems:4 },

						{ type: 'space' },

					]
				  };

		}});
	
	
	Object.defineProperty(ItemsView.prototype, "e_dataSourceDataKeyPath", {
		set: function (v) {
			if (!v) return;

			var ds = createComponentFromDomain("FilteredDataSource", "info.appdoo-mac", this.context, {
				dataSourceID: this.dataSource.identify(),
				doFilterByKeyPath: true,
				filterKeyPath: v})
			;

			_context.editor.registerInsertedItem(ds);
			_context.editor.addUndoStepForInsertOperation(ds);

			this.dataController.setValueForKeyPath(ds.identify(), 'e_dataSourceID', this.dataController);

		}});
	
	
	Object.defineProperty(ItemsView.prototype, "usesAutomaticScrollInsets", {
	outlet: true, 
	enumerable: true, get:function () { return this._usesAutomaticScrollInsets; }, set:function (v) {if (!Object.hasOwnProperty(this, "_usesAutomaticScrollInsets")) Object.defineProperty(this, "_usesAutomaticScrollInsets", { writable: true, configurable: true }); this._usesAutomaticScrollInsets = v; }});
	
	
	Object.defineProperty(ItemsView.prototype, "e_usesAutomaticScrollInsets", {
		get: function ( ) { return this.usesAutomaticScrollInsets; }, 
		set: function (v) { this.usesAutomaticScrollInsets = v; }});
	

	Object.defineProperty(ItemsView.prototype, "scrollViewInsetsInspectorProperties", {
		get: function ( ) {
			return 				{
					type: 'group',
					title: LocalizedString('Scroll Insets'),
					id: 'UIScrollViewInsets',
					items: [

						{ name: LocalizedString('Above'), keyPath: 'e_insetTop', type: 'number', undefinedValue: '0', forceLeftLabel:false },
						{ type: 'button', caption:LocalizedString('Estimate'),buttonWidth:64,buttonStyle:'flat',marginTop:-8, actionKeyPath:'setInsetTopByEstimation' },

						{ name: LocalizedString('Beneath'), keyPath: 'e_insetBottom', type: 'number', undefinedValue: '0', forceLeftLabel:false },
						{ type: 'button', caption:LocalizedString('Estimate'),buttonWidth:64,buttonStyle:'flat',marginTop:-8, actionKeyPath:'setInsetBottomByEstimation' },

					]
				};
		}});
	

	
ItemsView.prototype.setInsetTopByEstimation = function ItemsView_setInsetTopByEstimation() {
		function estimate() {
			var estimation = 0;
			var nb = _context.editor.contentFrameController.navigationBar;
			if (!nb || !nb.translucent) return estimation;
			return Math.max(0, nb.size.height+_context.editor.getRelativeYRespectingOriginalSuperview(this, 0, _context.editor.editedView));
		}
		this.e_insetTop = estimate.call(this);
		_context.editor.refreshInspector();};
	

ItemsView.prototype.setInsetBottomByEstimation = function ItemsView_setInsetBottomByEstimation() {
		function estimate() {
			var estimation = 0;
			var tb = _context.editor.contentFrameController.tabBar;
			if (!tb || !tb.translucent) return estimation;
			var window = _context.editor.contentFrameController.simulatedWindow;
			var tbTop = -tb.getRelativeY(0, window);
			var selfBottom = -_context.editor.getRelativeYRespectingOriginalSuperview(this, 0, window)+this.size.height;
			return Math.max(0, selfBottom-tbTop);
		}
		this.e_insetBottom = estimate.call(this);
		_context.editor.refreshInspector();};
	

	

	Object.defineProperty(ItemsView.prototype, "insetTop", {
	outlet: true, 
	enumerable: true, get:function () { return this._insetTop; }, set:function (v) {if (!Object.hasOwnProperty(this, "_insetTop")) Object.defineProperty(this, "_insetTop", { writable: true, configurable: true }); this._insetTop = v; }});
	

	Object.defineProperty(ItemsView.prototype, "insetBottom", {
	outlet: true, 
	enumerable: true, get:function () { return this._insetBottom; }, set:function (v) {if (!Object.hasOwnProperty(this, "_insetBottom")) Object.defineProperty(this, "_insetBottom", { writable: true, configurable: true }); this._insetBottom = v; }});
	
	
	Object.defineProperty(ItemsView.prototype, "e_insetTop", {
		set: function (v) {
		
			this._insetTop = v;
			if (this.drawBackground) this.drawBackground();
			this.arrangeSubviews();
			this.contentSizeDidChange();
			return;
		
			var delta = ((v||0) - (this._insetTop||0));
			this._insetTop = v;
			if (delta && this.viewIsLoaded) {

				if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {
					subview.position.top += delta;return true; }, this);
				
				this.drawBackground();
			}
			this.contentSizeDidChange();
		}, 
		get: function () {
			return this.insetTop;
		}});
	

	Object.defineProperty(ItemsView.prototype, "e_insetBottom", {
		set: function (v) {
			this._insetBottom = v;
			if (this.drawBackground) this.drawBackground();
			this.arrangeSubviews();
			this.contentSizeDidChange();
		}, 
		get: function () {
			return this.insetBottom;
		}});
	

ItemsView.prototype.contentSizeDidChange = function ItemsView__contentSizeDidChange() {
		if (this.setsHeightToFitContent)
			this.setHeightToFit();};
	

	Object.defineProperty(ItemsView.prototype, "usesDataSource", {
	outlet: true, 
	enumerable: true, get:function () { return this._usesDataSource; }, set:function (v) {if (!Object.hasOwnProperty(this, "_usesDataSource")) Object.defineProperty(this, "_usesDataSource", { writable: true, configurable: true }); this._usesDataSource = v; }});
	
	
	Object.defineProperty(ItemsView.prototype, "e_usesDataSource", {
		set: function (v) {
			if (this.usesDataSource === v) return;
			this.clearData();
			this.usesDataSource = v;
			_context.editor.refreshInspector();
			if (v) {
				if (!this.e_dataSourceID||!this.dataSource||this.dataSource._isDestroyed) {
					var anyDataSource = this.context.anyDataSource;
					if (anyDataSource)
						this.e_dataSourceID = anyDataSource.identify();
					_context.editor.refreshInspector();
				}
				else this.loadDataSource();
			}
			else this.reloadData();
			this.updateNodes();
		}, 
		get: function ( ) { return this.usesDataSource; }});
	


	
ItemsView.prototype.updateNodes = function ItemsView__updateNodes() {

		var editor = _context.editor;
		var node = this.node;
		if (!node) return;
		node.isLeaf = false;
		node.removeAllChildNodes(this);

		
		if (this.listHeaderView) {
			if (!this.listHeaderView.node)
				editor.registerItem(this.listHeaderView, node.addChildNodeWithRepresentedObject(this.listHeaderView, editor));
			else this.node.addChildNode(this.listHeaderView.node, _context.editor);
		}

		if (this.usesDataSource) {
			this.addNodeForCellPrototype();
		} else {
			this.addNodesForStaticContent();
		}
		
		
		if (this.listFooterView) {
			if (!this.listFooterView.node)
				editor.registerItem(this.listFooterView, node.addChildNodeWithRepresentedObject(this.listFooterView, editor));
			else this.node.addChildNode(this.listFooterView.node, _context.editor);
		}
};
	
	
ItemsView.prototype.addNodeForCellPrototype = function ItemsView__addNodeForCellPrototype() {
		if (!this.node) return;
		this.node.addChildNode(this.cellPrototypeView.node, _context.editor);};
	
	
ItemsView.prototype.addNodesForStaticContent = function ItemsView__addNodesForStaticContent() {
		var editor = _context.editor,
			node = this.node;

		var i = 0, c = this.numberOfStaticSections;
		
		if (c <= 0) return;
		
		if (!this.hasSectionNodes) {
			var firstSection = this.staticSections[0];
			var i = 0, c = Math.max(0, firstSection.numberOfStaticCells);
			if (Array.isArray(firstSection.staticCells)) firstSection.staticCells.every(function (cell) {
				if (i++ >= c) return false;
				editor.registerItem(cell, node.addChildNodeWithRepresentedObject(cell, editor));return true; }, this);
			
			return;
		}

		if (Array.isArray(this.staticSections)) this.staticSections.every(function (section) {
			if (i++ >= c) return false;
			editor.registerItem(section, node.addChildNodeWithRepresentedObject(section, editor));return true; }, this);
		
	};
	

	Object.defineProperty(ItemsView.prototype, "hasSectionNodes", {
		get: function () {
			return !(this.numberOfStaticSections === 1 && !this.listHeaderEnabled && !this.listFooterEnabled);
		}});
	
	
	
	

	Object.defineProperty(ItemsView.prototype, "pullToRefresh", {
	outlet: true, 
	enumerable: true, get:function () { return this._pullToRefresh; }, set:function (v) {if (!Object.hasOwnProperty(this, "_pullToRefresh")) Object.defineProperty(this, "_pullToRefresh", { writable: true, configurable: true }); this._pullToRefresh = v; }});
	

	Object.defineProperty(ItemsView.prototype, "e_pullToRefresh", {
		set: function (v) { this.pullToRefresh = v; _context.editor.refreshInspector(); }, 
		get: function () { return this.pullToRefresh; }});
	
	
	
	

	Object.defineProperty(ItemsView.prototype, "setsHeightToFitContent", {
	outlet: true, 
	enumerable: true, get:function () { return this._setsHeightToFitContent; }, set:function (v) {if (!Object.hasOwnProperty(this, "_setsHeightToFitContent")) Object.defineProperty(this, "_setsHeightToFitContent", { writable: true, configurable: true }); this._setsHeightToFitContent = v; }});
	

	Object.defineProperty(ItemsView.prototype, "e_setsHeightToFitContent", {
		set: function (v) { this.setsHeightToFitContent = v;
			if (v) {
				this.dataController.setValueForKeyPath(this.heightForContent(), 'size.height', this.dataController);

			}
			
			this.dataController.context.broadcastValueChangeForKeyPathInObject('heightIsEditable', this.dataController, this);
		}, 
		get: function () { return this.setsHeightToFitContent; }});
	
	
	Object.defineProperty(ItemsView.prototype, "heightIsEditable", {
		get: function () {
			return !this.setsHeightToFitContent;
		}});
	
	
ItemsView.prototype.heightForContent = function ItemsView__heightForContent() {
		if (!this.subviews) return 0;
		var lastSubview = this.subviews[this.subviews.length-1];
		
		return (lastSubview ? lastSubview.position.bottom : (this.e_insetTop||0))+(this.e_insetBottom||0);
	};
	
	
ItemsView.prototype.setHeightToFit = function ItemsView__setHeightToFit() {
		
		var h = this.heightForContent();
		if (this.size.height === h) return;

		if (this.dataController) {
			_context.undoManager.disableRegistration();
			this.dataController.setValueForKeyPath(h, 'size.height');
			_context.undoManager.enableRegistration();
		}
		else {
			this.size.height = h;
		}
};
	
	
ItemsView.prototype.setDefaultCellPrototype = function ItemsView__setDefaultCellPrototype() {

		this.cellPrototype = clone(this.defaultCellPrototype);
};
	

ItemsView.prototype.arrangeSubviews = function ItemsView__arrangeSubviews() {};
	

ItemsView.prototype.prepareForEditor = function ItemsView_prepareForEditor(editor) {
		
		var node = this.node;
		node.isLeaf = false;

		this.cellPrototypeView = this.context.decodeObjectTree(this.cellPrototype);

		var cellNode = node.addChildNodeWithRepresentedObject(this.cellPrototypeView, this);
		editor.registerItem(this.cellPrototypeView, cellNode);

		this.reloadData();
		editor.addDropHandlerToItemsView(this);
		
		this.updateNodes();
		
		this.DOMNode.onscroll = function (e) {
			if (!this.DOMNode) return;
			if (editor && editor.manipulator && editor.manipulator.updateSizeModifierButtons)
				editor.manipulator.updateSizeModifierButtons();
			this._scrollLeft = this.DOMNode.scrollLeft;
			this._scrollTop = this.DOMNode.scrollTop;
		}.bind(this);
};
	

	Object.defineProperty(ItemsView.prototype, "numberOfStaticSections", {
	outlet: true, 
	enumerable: true, get:function () { return this._numberOfStaticSections; }, set:function (v) {if (!Object.hasOwnProperty(this, "_numberOfStaticSections")) Object.defineProperty(this, "_numberOfStaticSections", { writable: true, configurable: true }); this._numberOfStaticSections = v; }});
	

	Object.defineProperty(ItemsView.prototype, "e_numberOfStaticSections", {
		set: function (v) {
			this.numberOfStaticSections = v;
			var createdSections = [];
			if (this.staticSections.length < v) {
				var numberOfSectionsToAdd = v - this.staticSections.length;
				while (numberOfSectionsToAdd--) {
					var section = this.createStaticSection();
					this.staticSections.push(section);
					createdSections.push(section);
				}
			}
			
			if (Array.isArray(createdSections)) createdSections.every(function (section) {
				section.e_numberOfStaticCells = 1;return true; }, this);
			

			this.updateNodes();
		}, 
		get: function () { return this.numberOfStaticSections; }});
	

	Object.defineProperty(ItemsView.prototype, "staticSections", {
	outlet: true, 
	enumerable: true, 
		get: function () {
			if (!this._staticSections) this.staticSections = [];
			return this._staticSections;
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_staticSections")) Object.defineProperty(this, "_staticSections", { writable: true, configurable: true }); this._staticSections = v; }});
	

ItemsView.prototype.addCell = function ItemsView__addCell(cell, index) {
		if (this.usesDataSource || this.staticSections.length !== 1) return;
		this.staticSections[0].addCell(cell, index);
		this.addEditorButtonsToCell(cell);};
	
	
	Object.defineProperty(ItemsView.prototype, "name", {
	outlet: true, 
	enumerable: true, get:function () { return this._name; }, set:function (v) {if (!Object.hasOwnProperty(this, "_name")) Object.defineProperty(this, "_name", { writable: true, configurable: true }); this._name = v; }});
	

	Object.defineProperty(ItemsView.prototype, "e_name", {
		set: function (v) {
			this.name = v;
			this.readableValueDidChange(v);
		}, 
		get: function ( ) { return this.name; }});
	
	
ItemsView.prototype.deleteForEditor = function ItemsView_deleteForEditor(editor) {
		this.e_navigatesToDetailScene = false;};
	
	
ItemsView.prototype.convertLayoutRelationsInDynamicCell = function ItemsView__convertLayoutRelationsInDynamicCell(view) {

		
		
		

		if (!view) return;
		
		if (view.layoutRelations) {
			var newLayoutRelations = [];
			if (Array.isArray(view.layoutRelations)) view.layoutRelations.every(function (lr) {
				var newLR = clone(lr);
				newLR.isConverted = true;
				var originalDestination = this.context.globals[newLR.destination];
				if (!originalDestination) return true;
				if (!originalDestination.superview) return true;
				var indexOfTheView = originalDestination.superview.subviews.indexOf(originalDestination);
				var newDestination = view.superview.subviews[indexOfTheView];
				if (!newDestination) return true;
				
				newLR.destination = newDestination.$id;
				newLR.source = view.$id;
				newLayoutRelations.push(newLR);return true; }, this);
			
			view.layoutRelations = newLayoutRelations;
		}
		if (Array.isArray(view.subviews)) view.subviews.every(function (subview) {
			this.convertLayoutRelationsInDynamicCell(subview);return true; }, this);
		};
	

ItemsView.prototype.bindingIsValid = function ItemsView_bindingIsValid(binding) {
		return true;};
	
	
	var newDataSourcePanel;
ItemsView.prototype.showNewDataSourcePanel = function ItemsView_showNewDataSourcePanel(sender, button) {

		var dataSourceUTIs = ['info.appdoo-mac.TextualListDataSource','info.appdoo-mac.AtomDataSource','info.appdoo-mac.CSVDataSource','info.appdoo-mac.JSONDataSource','info.appdoo-mac.RSS2DataSource','info.appdoo-mac.FilteredDataSource'];
		var self = this;
	
		function close(index) {
			alertd(index);
			var ds = _context.editor.insertFromBlueprint(dataSourceUTIs[index]);
			self.e_dataSourceID = ds.identify();
		}
		
		var superview = _context.editor.view;
		if (!newDataSourcePanel) {
			var padding = 5;
			var size = { width: (dataSourceUTIs.length*(48+padding)-padding)+20, height: 80 };
			var panel = createComponentFromDomain("View", "Core.UI", this.context, {
				size: size,
				style: { backgroundColor: 'rgba(240,240,240,.95)',zIndex:1001, border: '1px solid rgba(0,0,0,.1)', borderRadius: '16px',boxShadow:'0 9px 22px rgba(0,0,0,.3)',opacity:0,transition:'opacity .25s ease-out' },
				position: { left: superview.size.width/2-size.width/2, top: superview.size.height/2-size.height/2 }})
			;
			newDataSourcePanel = panel;
			
			var arrowhead = createComponentFromDomain("ImageView", "Core.UI", this.context, {
				size: { width: 18, height: 34 },
				position: { left: size.width, top: size.height/2-28/2 },
				imageSrc: 'Resources/PanelArrowhead.png'})
			;
			panel.addSubview(arrowhead);
			
			var x = (size.width-(48*dataSourceUTIs.length+padding*(dataSourceUTIs.length-1)))/2;
			var y = size.height/2-48/2;
			var i = 0;
			
			if (Array.isArray(dataSourceUTIs)) dataSourceUTIs.every(function (uti) {
				var proto = getPrototype(uti);
			
				var imageView = createComponentFromDomain("ImageView", "Core.UI", this.context, {
					size: { width: 48, height: 48 },
					position: { left: x, top: y },
					imageSrc: proto.iconURL,
					style: { borderRadius:'8px' },
					tag: i++,
					toolTip: proto.readableDescription})
				;
				panel.addSubview(imageView);
				
				imageView.DOMNode.onmouseover = function (e) {
					imageView.DOMNode.style.backgroundColor = '#ddd';
				};
				imageView.DOMNode.onmouseout = function (e) {
					imageView.DOMNode.style.backgroundColor = '';
				};
				imageView.DOMNode.onclick = function (e) {
					close(imageView.tag);
				};
				
				x += 48 + padding;return true; }, this);
			
		}
		

		newDataSourcePanel.position.left = -button.getRelativeX(0)-newDataSourcePanel.size.width-16-2;
		newDataSourcePanel.position.top = Math.floor(-button.getRelativeY(0)-newDataSourcePanel.size.height/2+button.size.height/2)-1;
		superview.addSubview(newDataSourcePanel);
		newDataSourcePanel.DOMNode.style.opacity = 1;
		newDataSourcePanel.DOMNode.style.pointerEvents = '';
		newDataSourcePanel.DOMNode.style.display = '';
		
		window.onmouseup = function (e) {
			setTimeout(function () {
				newDataSourcePanel.DOMNode.style.opacity = 0;
				newDataSourcePanel.DOMNode.style.pointerEvents = 'none';
				setTimeout(function () {
					newDataSourcePanel.DOMNode.style.display = 'none';
				}, 250);
			}, 1);
		};};
	
	
	
	Object.defineProperty(ItemsView.prototype, "modalTransitionStyleProperty", {
		get: function () {
			return {
				name: LocalizedString('Modal Presentation'),
				keyPath: 'modalTransitionStyle',
				type: 'select',
				options: [
					['-1',LocalizedString('none')],
					
					['UIModalTransitionStyleCoverVertical',LocalizedString('Push from Bottom')],
					['UIModalTransitionStyleFlipHorizontal',LocalizedString('Flip')],
					['UIModalTransitionStyleCrossDissolve',LocalizedString('Crossfade')]
				],
				numberOfVisibleItems: 4,
				labelOnTop: true,
				showsIcons: false,
				hidden: !this.e_usesDataSource||!this.e_navigatesToDetailScene
			};
		}});
	

ItemsView.prototype.initPropertiesFromData = function ItemsView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("scrollLeft")) this.scrollLeft = data.scrollLeft;
if (data.hasOwnProperty("scrollTop")) this.scrollTop = data.scrollTop;
if (data.hasOwnProperty("selectable")) this.selectable = data.selectable;
if (data.hasOwnProperty("draggable")) this.draggable = data.draggable;
if (data.hasOwnProperty("dataSource")) this.dataSource = data.dataSource;
if (data.hasOwnProperty("detailSceneID")) this.detailSceneID = data.detailSceneID;
if (data.hasOwnProperty("usesAutomaticScrollInsets")) this.usesAutomaticScrollInsets = data.usesAutomaticScrollInsets;
if (data.hasOwnProperty("insetTop")) this.insetTop = data.insetTop;
if (data.hasOwnProperty("insetBottom")) this.insetBottom = data.insetBottom;
if (data.hasOwnProperty("usesDataSource")) this.usesDataSource = data.usesDataSource;
if (data.hasOwnProperty("pullToRefresh")) this.pullToRefresh = data.pullToRefresh;
if (data.hasOwnProperty("setsHeightToFitContent")) this.setsHeightToFitContent = data.setsHeightToFitContent;
if (data.hasOwnProperty("numberOfStaticSections")) this.numberOfStaticSections = data.numberOfStaticSections;
if (data.hasOwnProperty("staticSections")) this.staticSections = data.staticSections;
if (data.hasOwnProperty("name")) this.name = data.name;
};

ItemsView.prototype.decodeData = function ItemsView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("staticSections")) decoded.staticSections = []; if (Array.isArray(data.staticSections)) { data.staticSections.forEach(function (o) { decoded.staticSections.push(this.context.decodeObjectTree(o)); }.bind(this)); }
return decoded; };

ItemsView.prototype.encode = function ItemsView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._staticSections && this._staticSections.encode) {encoded.staticSections = []; this._staticSections.forEach(function (o) { encoded.staticSections.push(o.encode()); });
}return encoded; };

ItemsView.prototype.encodeCloned = function ItemsView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._staticSections && this._staticSections.encode) {encoded.staticSections = []; this._staticSections.forEach(function (o) { encoded.staticSections.push(o.encodeCloned()); });
}return encoded; };

ItemsView.prototype.expectedTypeForProperty = function ItemsView_expectedTypeForProperty(key) {
	if (key === "scrollLeft") return "";
	if (key === "scrollTop") return "";
	if (key === "selectionToRestore") return "";
	if (key === "selectable") return "";
	if (key === "draggable") return "";
	if (key === "dataSource") return "";
	if (key === "needsUpdateForBindingsOldID") return "";
	if (key === "dataSourceUTI") return "";
	if (key === "useNativeDragAndDrop") return "";
	if (key === "dynamicBindings") return "";
	if (key === "dataSourceId") return "";
	if (key === "editorDidChangeDataSource") return "";
	if (key === "e_dataSourceID") return "";
	if (key === "targetIndicatorPadding") return "";
	if (key === "targetIndicatorTop") return "";
	if (key === "targetIndicatorLeft") return "";
	if (key === "e_navigatesToDetailScene") return "";
	if (key === "detailSceneID") return "String";
	if (key === "e_detailSceneID") return "String";
	if (key === "dataSourceInspectorProperties") return "";
	if (key === "e_dataSourceDataKeyPath") return "";
	if (key === "usesAutomaticScrollInsets") return "Boolean";
	if (key === "e_usesAutomaticScrollInsets") return "Boolean";
	if (key === "scrollViewInsetsInspectorProperties") return "";
	if (key === "insetTop") return "Number";
	if (key === "insetBottom") return "Number";
	if (key === "e_insetTop") return "Number";
	if (key === "e_insetBottom") return "Number";
	if (key === "usesDataSource") return "Boolean";
	if (key === "e_usesDataSource") return "Boolean";
	if (key === "hasSectionNodes") return "";
	if (key === "pullToRefresh") return "Boolean";
	if (key === "e_pullToRefresh") return "Boolean";
	if (key === "setsHeightToFitContent") return "Boolean";
	if (key === "e_setsHeightToFitContent") return "Number";
	if (key === "heightIsEditable") return "";
	if (key === "numberOfStaticSections") return "Number";
	if (key === "e_numberOfStaticSections") return "Number";
	if (key === "staticSections") return "UITableViewSection[]";
	if (key === "name") return "";
	if (key === "e_name") return "String";
	if (key === "modalTransitionStyleProperty") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ItemsView; }()));
registerType('appdoo.iOS', (function () { function UIItemsViewSection() {} var __super = setSupertypeFromDomain(UIItemsViewSection, 'BasicObject', 'Core');

UIItemsViewSection.prototype.init = function UIItemsViewSection_init() {
		__super.prototype.init.call(this);
		if(this.numberOfStaticCells < 0) {
			this.numberOfStaticCells = 0;
		}
		if (this.numberOfStaticCells < this.staticCells.length) {
			for (var i = this.numberOfStaticCells, c = this.staticCells.length; i < c; i++) {
				this.staticCells[i].deleteForEditor(_context.editor);
			}
			this.staticCells.splice(this.numberOfStaticCells, this.staticCells.length);
		}
		return this;};
	

	Object.defineProperty(UIItemsViewSection.prototype, "readableType", {
		get: function () { return LocalizedString('Section'); }});
	

	Object.defineProperty(UIItemsViewSection.prototype, "itemsView", {
	outlet: true, get:function () { return this._itemsView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_itemsView")) Object.defineProperty(this, "_itemsView", { writable: true, configurable: true }); this._itemsView = v; }});
	

	Object.defineProperty(UIItemsViewSection.prototype, "outlineIconURL", {
	readonly: true, 
		get: function () {
			return this.context.pathForResource('ViewGroup.png');
		}});
	

	Object.defineProperty(UIItemsViewSection.prototype, "staticCells", {
	outlet: true, 
	enumerable: true, 
		get: function () {
			if (!this._staticCells) this.staticCells = [];
			return this._staticCells;
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_staticCells")) Object.defineProperty(this, "_staticCells", { writable: true, configurable: true }); this._staticCells = v; }});
	

	Object.defineProperty(UIItemsViewSection.prototype, "cells", {
		get: function () { return this.staticCells; }, 
		set: function (v) { this.staticCells = v; }});
	

	Object.defineProperty(UIItemsViewSection.prototype, "numberOfStaticCells", {
	outlet: true, 
	enumerable: true, get:function () { return this._numberOfStaticCells; }, set:function (v) {if (!Object.hasOwnProperty(this, "_numberOfStaticCells")) Object.defineProperty(this, "_numberOfStaticCells", { writable: true, configurable: true }); this._numberOfStaticCells = v; }});
	
	
	Object.defineProperty(UIItemsViewSection.prototype, "view", {
	synthesized: true, 
		get: function () {
			if (!this._view) {
				this.view = createComponentFromDomain("UIItemsViewSectionView", "appdoo.iOS", this.context, {
					size: { width: 320, height: 44 },
					section: this})
				;
				Object.defineProperty(this.view, 'allCells', {
					get: function () { return this.staticCells; }.bind(this)
				});
				this.populateView();
			}
			return this._view;
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_view")) Object.defineProperty(this, "_view", { writable: true, configurable: true }); this._view = v; }});
	
	
	Object.defineProperty(UIItemsViewSection.prototype, "isStaticSection", {
		get: function () {
			if (!this.itemsView) return;
			return !this.itemsView.usesDataSource;
		}});
	
	
	Object.defineProperty(UIItemsViewSection.prototype, "isSection", {
		value: true});
	

UIItemsViewSection.prototype.createStaticCell = function UIItemsViewSection__createStaticCell() {
		var cell = this.context.decodeObjectTree(this.itemsView.staticCellPrototype);
		return cell;};
	
	
	var demoDict = ['Alpha','Beta','Gamma','Delta','Epsilon','Zeta','Eta','Theta','Iota','Kappa','Lambda','My','Ny','Xi','Omikron','Pi','Rho','Sigma','Tau','Ypsilon','Phi','Chi','Psi','Omega'];

	Object.defineProperty(UIItemsViewSection.prototype, "e_numberOfStaticCells", {
		set: function (v) {
			this.numberOfStaticCells = Math.max(0, v);
			if (this.staticCells.length < v) {
				var numberOfCellsToAdd = v - this.staticCells.length;
				var lastCell = this.staticCells[this.staticCells.length-1];
				while (numberOfCellsToAdd--) {
					var cell = lastCell ? lastCell.clone() : this.createStaticCell();
					this.staticCells.push(cell);
				}
			}

			this.populateView();
			this.itemsView.reloadDataLazy();
			this.itemsView.updateNodes();
		}, 
		get: function ( ) { if (!this.usesDataSource) return this.numberOfStaticCells; }});
	

UIItemsViewSection.prototype.prepareForEditor = function UIItemsViewSection_prepareForEditor(editor) {
		this.node.isLeaf = false;
		this.updateNodes();};
	
	
UIItemsViewSection.prototype.updateNodes = function UIItemsViewSection__updateNodes() {
		if (!this.node) return;
		this.node.removeAllChildNodes(this);
		this.addNodesForStaticContent();};
	

UIItemsViewSection.prototype.addNodesForStaticContent = function UIItemsViewSection__addNodesForStaticContent() {
		var editor = _context.editor,
			node = this.node;
		var i = 0, c = this.numberOfStaticCells;
		if (Array.isArray(this.staticCells)) this.staticCells.every(function (cell) {
			if (i++ >= c) return false;
			editor.registerItem(cell, node.addChildNodeWithRepresentedObject(cell, editor));return true; }, this);
		
	};
	
	
	Object.defineProperty(UIItemsViewSection.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType,
					id: 'UIItemsViewSection',
					items: [
						{ name: LocalizedString('Rows'), keyPath: 'e_numberOfStaticCells', type: 'number',
							},
					]
				}
			];
		}});
	
	
UIItemsViewSection.prototype.populateView = function UIItemsViewSection__populateView() {};
	
	
UIItemsViewSection.prototype.reorderCell = function UIItemsViewSection__reorderCell(cell, oldIndex, newIndex) {

		var i = this.staticCells.indexOf(cell);
		if (i === -1) return;
		
		this.staticCells.splice(i, 1);
		this.staticCells.splice(newIndex, 0, cell);
		
		if (this.itemsView) {
			this.populateView();
			this.itemsView.reloadData();
		}
	};
	
	
UIItemsViewSection.prototype.removeCell = function UIItemsViewSection__removeCell(cell) {

		var i = this.staticCells.indexOf(cell);
		if (i === -1) return;
		
		this.staticCells.splice(i, 1);
		if(this.numberOfStaticCells > 0) {
			this.numberOfStaticCells--;
		}
		if (this.itemsView) {
			this.populateView();
			this.itemsView.reloadData();
		}};
	

UIItemsViewSection.prototype.addCell = function UIItemsViewSection__addCell(cell, index) {

		this.staticCells.splice(index, 0, cell);
		this.numberOfStaticCells++;

		if (this.itemsView) {
			this.populateView();
			this.itemsView.reloadData();
		}};
	

	Object.defineProperty(UIItemsViewSection.prototype, "canManageStaticCells", {
		get: function () {
			return !this.itemsView.usesDataSource;
		}});
	
	
UIItemsViewSection.prototype.contentSizeDidChange = function UIItemsViewSection_contentSizeDidChange() {
		this.itemsView.contentSizeDidChange();};
	

UIItemsViewSection.prototype.initPropertiesFromData = function UIItemsViewSection_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("itemsView")) this.itemsView = data.itemsView;
if (data.hasOwnProperty("staticCells")) this.staticCells = data.staticCells;
if (data.hasOwnProperty("numberOfStaticCells")) this.numberOfStaticCells = data.numberOfStaticCells;
};

UIItemsViewSection.prototype.decodeData = function UIItemsViewSection_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("itemsView")) decoded.itemsView = this.context.decodeObjectTree(data.itemsView);
if (data.hasOwnProperty("staticCells")) decoded.staticCells = []; if (Array.isArray(data.staticCells)) { data.staticCells.forEach(function (o) { decoded.staticCells.push(this.context.decodeObjectTree(o)); }.bind(this)); }
return decoded; };

UIItemsViewSection.prototype.encode = function UIItemsViewSection_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._staticCells && this._staticCells.encode) {encoded.staticCells = []; this._staticCells.forEach(function (o) { encoded.staticCells.push(o.encode()); });
}return encoded; };

UIItemsViewSection.prototype.encodeCloned = function UIItemsViewSection_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._staticCells && this._staticCells.encode) {encoded.staticCells = []; this._staticCells.forEach(function (o) { encoded.staticCells.push(o.encodeCloned()); });
}return encoded; };

UIItemsViewSection.prototype.expectedTypeForProperty = function UIItemsViewSection_expectedTypeForProperty(key) {
	if (key === "readableType") return "String";
	if (key === "itemsView") return "ItemsView";
	if (key === "outlineIconURL") return "";
	if (key === "staticCells") return "UIView[]";
	if (key === "cells") return "";
	if (key === "numberOfStaticCells") return "Number";
	if (key === "view") return "";
	if (key === "isStaticSection") return "";
	if (key === "isSection") return "";
	if (key === "e_numberOfStaticCells") return "Number";
	if (key === "inspectorProperties") return "Array";
	if (key === "canManageStaticCells") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UIItemsViewSection; }()));
registerType('appdoo.iOS', (function () { function UIItemsViewSectionView() {} var __super = setSupertypeFromDomain(UIItemsViewSectionView, 'View', 'Core.UI');

	Object.defineProperty(UIItemsViewSectionView.prototype, "section", {
	outlet: true, 
	enumerable: true, get:function () { return this._section; }, set:function (v) {if (!Object.hasOwnProperty(this, "_section")) Object.defineProperty(this, "_section", { writable: true, configurable: true }); this._section = v; }});
	

	Object.defineProperty(UIItemsViewSectionView.prototype, "isSectionView", {
		value: true});
	

	Object.defineProperty(UIItemsViewSectionView.prototype, "allCells", {
		get: function () {
			return this.section.staticCells;
		}});
	

UIItemsViewSectionView.prototype.editorDidEditSubview = function UIItemsViewSectionView_editorDidEditSubview(editor, subview) {
		
		this.section.arrangeSubviews();};
	

UIItemsViewSectionView.prototype.initPropertiesFromData = function UIItemsViewSectionView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("section")) this.section = data.section;
};

UIItemsViewSectionView.prototype.decodeData = function UIItemsViewSectionView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("section")) decoded.section = this.context.decodeObjectTree(data.section);
return decoded; };

UIItemsViewSectionView.prototype.encode = function UIItemsViewSectionView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._section && this._section.encode) {encoded.section = this.section.encode();
}return encoded; };

UIItemsViewSectionView.prototype.encodeCloned = function UIItemsViewSectionView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._section && this._section.encode) {encoded.section = this.section.encodeCloned();
}return encoded; };

UIItemsViewSectionView.prototype.expectedTypeForProperty = function UIItemsViewSectionView_expectedTypeForProperty(key) {
	if (key === "section") return "UIItemsViewSection";
	if (key === "isSectionView") return "Boolean";
	if (key === "allCells") return "View[]";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UIItemsViewSectionView; }()));