
registerType('Core.UI', (function () { function Label() {} var __super = setSupertypeFromDomain(Label, 'View', 'Core.UI');


	

Label.prototype.initFromData = function Label_initFromData(data) {

		if (!__super.prototype.initFromData.call(this, data))
			return;

		if (data.text !== undefined) {
			if (data.localizeText === true) {
				this.text = LocalizedString(data.text);
				this.localizeText = true;
			}
			else
				this.text = data.text;
		}
		if (data.html) this.html = data.html;
		
		if (data.numberOfLines !== undefined) 
			this.numberOfLines = data.numberOfLines;

		return this;};
	

Label.prototype.initPropertiesFromData = function Label__initPropertiesFromData(data) {
		__super.prototype.initPropertiesFromData.call(this, data);};
	


	

	Object.defineProperty(Label.prototype, "text", {
	enumerable: true, 
	synthesized: true, 
		set: function (value) {if (!Object.hasOwnProperty(this, "_text")) Object.defineProperty(this, "_text", { writable: true, configurable: true });
			if (!this.DOMNode) {
				return;
			}
			this._text = value;

			
			if (!value) value = ' ';
			
			else if (value[0] === ' ') value[0] = ' ';
			
			this.DOMNode.textContent = value;
		}, get:function () { return this._text; }});
	

	Object.defineProperty(Label.prototype, "html", {
	enumerable: true, 
	synthesized: true, 
		set: function (value) {if (!Object.hasOwnProperty(this, "_html")) Object.defineProperty(this, "_html", { writable: true, configurable: true });
			if (!this.DOMNode) {
				return;
			}
			this._html = value;
			this.DOMNode.innerHTML = value;
		}, get:function () { return this._html; }});
	

	Object.defineProperty(Label.prototype, "fontSize", {
	enumerable: true, 
		get: function () {
			return this._fontSize;
		}, 
		set: function (value) {
			Object.defineProperty(Label.prototype, '_fontSize', {
				value: value, writable: true });
			this.DOMNode.style.fontSize = value+'px';
		}});
	
	
	Object.defineProperty(Label.prototype, "isBold", {
		get: function () {
			if (this.DOMNode)
				return this.DOMNode.style.fontWeight === 'bold';
		}, 
		set: function (v) {
			if (this.DOMNode)
				this.DOMNode.style.fontWeight = v ? 'bold' : '';
		}});
	

	Object.defineProperty(Label.prototype, "isItalic", {
		get: function () {
			if (this.DOMNode)
				return this.DOMNode.style.fontStyle === 'italic';
		}, 
		set: function (v) {
			if (this.DOMNode)
				this.DOMNode.style.fontStyle = v ? 'italic' : '';
		}});
	
	
	Object.defineProperty(Label.prototype, "numberOfLines", {
	synthesized: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_numberOfLines")) Object.defineProperty(this, "_numberOfLines", { writable: true, configurable: true });
			this._numberOfLines = v;
			
			var isOneLine = (v === 1);
			
			this.style({
				overflow: isOneLine ? 'hidden' : '',
				textOverflow: isOneLine ? 'ellipsis' : '',
				whiteSpace: isOneLine ? 'nowrap' : ''
			});
			
		}, get:function () { return this._numberOfLines; }});
	
	
	Object.defineProperty(Label.prototype, "readableValue", {
		get: function () {
			return this.text
		}});
	

Label.prototype.expectedTypeForProperty = function Label_expectedTypeForProperty(key) {
	if (key === "text") return "";
	if (key === "html") return "";
	if (key === "fontSize") return "";
	if (key === "isBold") return "";
	if (key === "isItalic") return "";
	if (key === "numberOfLines") return "";
	if (key === "readableValue") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return Label; }()));
registerType('Core.UI', (function () { function SelectableLabel() {} var __super = setSupertypeFromDomain(SelectableLabel, 'Label', 'Core.UI');

SelectableLabel.prototype.init = function SelectableLabel_init() {
		__super.prototype.init.call(this);
		this.style({
                      	webkitUserSelect: 'auto',
                      	cursor: 'text',
                      	outline: 'none'
                      	
		});
		this.acceptsFocus = true;
		this.DOMNode.on
		return this;};
	
	
SelectableLabel.prototype.canSelectAll = function SelectableLabel_canSelectAll() {
		return true;};
	

SelectableLabel.prototype.selectAll = function SelectableLabel_selectAll(sender) {
		document.execCommand('selectall');};
	
	
SelectableLabel.prototype.copy = function SelectableLabel_copy() {
		document.execCommand('copy');};
	

SelectableLabel.prototype.paste = function SelectableLabel_paste() {
		return false;};
	

SelectableLabel.prototype.onFocus = function SelectableLabel__onFocus() {
		this.style({ textOverflow: '' });};
	

SelectableLabel.prototype.onBlur = function SelectableLabel__onBlur() {
		this.style({ textOverflow: 'ellipsis' });};
	
	
	window.widthForTextWithAttributes = function widthForTextWithAttributes(text, styles) {
		var node = document.createElement('div');
		for (var key in styles) {
			node.style[key] = styles[key];
		}
		node.textContent = text;
		document.body.appendChild(node);

		
		var w = node.offsetWidth; 
		
		document.body.removeChild(node);
		return w;
	}
	
SelectableLabel.prototype.expectedTypeForProperty = function SelectableLabel_expectedTypeForProperty(key) {
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SelectableLabel; }()));