
registerType('Core.UI', (function () { function ListView() {} var __super = setSupertypeFromDomain(ListView, 'ItemsView', 'Core.UI');


ListView.prototype.initFromData = function ListView_initFromData(data) {
	
		if (!__super.prototype.initFromData.call(this, data))
			return;
		
		this.style({
			'overflow-y': 'auto', 'overflow-x': 'hidden' });

		this.initBackgroundCanvas(data);
		this.initDataSource(data);
	
		
		[ 'cellPrototype',
		  'rowHeight',
		  'separatorColor',
		  'separatorStyle',
		  'delegate',
		  'draggable',
		  'acceptsDrop',
		  'selectable',
		  'listHeaderView',
		  'listFooterView',
		  'sectionHeaderTemplate',
		  'sectionFooterTemplate',
		  'drawsBackground',
		  'usesAlternatingRowBackgroundColors',
		  'shouldReloadImmediately',
		  'backgroundColor',
		  'oddCellBackgroundColor',
		  'scrollTop',
		  'scrollLeft'
		].every(function (option) {
			if (data[option] !== undefined)
				this[option] = data[option];
			return true;
		}.bind(this));
		
		this.selectedIndexPaths = [];
		
		Object.defineProperty(this, "oddBackgroundColor", {
		writable: true, 
			value: (window.tint === 6 ? oddBackgroundColorGraphite : oddBackgroundColorAqua)});
		

		Object.defineProperty(this, "_didChangeMainCbk", {
			value: function (e) {
				this.windowFocusDidChange();
			}.bind(this)});
		

		Object.defineProperty(this, "_mouseMoveCallback", {
			value: function (e) {
				if (this._dragEvent)
					this.mouseMovedWhileDragging(e);
			}.bind(this)});
		

		Object.defineProperty(this, "_mouseOutCallback", {
			value: function (e) {
				this.mouseOut(e);
			}.bind(this)});
		

		Object.defineProperty(this, "_mouseUpCallback", {
			value: function (e) {
				this.mouseUp(e);
			}.bind(this)});
		

		window.addEventListener("didBecomeMain", this._didChangeMainCbk);
		window.addEventListener("didResignMain", this._didChangeMainCbk);
		this.DOMNode.addEventListener('mousemove', this._mouseMoveCallback);
		this.DOMNode.addEventListener('mouseout', this._mouseOutCallback);
		this.DOMNode.addEventListener('mouseup', this._mouseUpCallback);
		
		this.layoutSubviews();

		return this;
};
	
	
	Object.defineProperty(ListView.prototype, "backgroundColor", {
	synthesized: true, 
	enumerable: true, get:function () { return this._backgroundColor; }, set:function (v) {if (!Object.hasOwnProperty(this, "_backgroundColor")) Object.defineProperty(this, "_backgroundColor", { writable: true, configurable: true }); this._backgroundColor = v; }});
	

	Object.defineProperty(ListView.prototype, "oddCellBackgroundColor", {
	synthesized: true, 
	enumerable: true, get:function () { return this._oddCellBackgroundColor; }, set:function (v) {if (!Object.hasOwnProperty(this, "_oddCellBackgroundColor")) Object.defineProperty(this, "_oddCellBackgroundColor", { writable: true, configurable: true }); this._oddCellBackgroundColor = v; }});
	
	
ListView.prototype.destroy = function ListView_destroy() {
		
		if (this._listHeaderView !== undefined) {
			this._listHeaderView = null;
		}
		
		if (this._listFooterView !== undefined) {
			this._listFooterView = null;
		}
		
		if (this.ownsDataSource === true) {
			if (this._dataSource.destroy)
				this._dataSource.destroy();
			this.dataSource = null;
		}
		
		window.removeEventListener("didBecomeMain", this._didChangeMainCbk);
		window.removeEventListener("didResignMain", this._didChangeMainCbk);
		this.DOMNode.removeEventListener('mousemove', this._mouseMoveCallback);
		this.DOMNode.removeEventListener('mouseout', this._mouseOutCallback);
		this.DOMNode.removeEventListener('mouseup', this._mouseUpCallback);
		__super.prototype.destroy.call(this);
};
	

ListView.prototype.mouseMovedWhileDragging = function ListView_mouseMovedWhileDragging(e) {
		var y = this.getRelativeY(e.y)-this.DOMNode.scrollTop;
		if (y < 15 && this.DOMNode.scrollTop) {
			this.startScrolling(-1);
		}
		else if (y > this.size.height-15) {
			this.startScrolling(+1);
		}
		else {
			this.stopScrolling();
		}};
	
	
ListView.prototype.mouseUp = function ListView_mouseUp(e) {
		this.stopScrolling();};
	

ListView.prototype.mouseOut = function ListView_mouseOut(e) {
		this.stopScrolling();};
	

	Object.defineProperty(ListView.prototype, "scrollInterval", {
	synthesized: true, 
	configurable: true, get:function () { return this._scrollInterval; }, set:function (v) {if (!Object.hasOwnProperty(this, "_scrollInterval")) Object.defineProperty(this, "_scrollInterval", { writable: true, configurable: true }); this._scrollInterval = v; }});
	
	
ListView.prototype.startScrolling = function ListView_startScrolling(direction) {
		if (this._scrollInterval) return;
		var speed = 2;
		this.scrollInterval = setInterval(function () {
				this.DOMNode.scrollTop += direction*speed;
				if (this.DOMNode.scrollTop <= 0)
					this.stopScrolling();
				if (speed < 50)
					speed += speed/50;
			}.bind(this), 25);;};
	

ListView.prototype.stopScrolling = function ListView_stopScrolling() {
		if (this._scrollInterval) {
			clearInterval(this._scrollInterval);
			this.scrollInterval = null;
		}};
	

	

// role EncodableObject (Core) 

ListView.prototype.decodeData = function ListView_decodeData(data) {
			
			var unfrozen = __super.prototype.decodeData.call(this, data);
	
			if (data.dataSource) { unfrozen.dataSource = this.context.createFromDataWithoutInitializing(data.dataSource); }

			return unfrozen;};
		

ListView.prototype.initFromArchive = function ListView_initFromArchive(data) {
			if (data.dataSource) { this.context.initObjectFromArchive(data.dataSource); }
			__super.prototype.initFromArchive.call(this, data);};
		
		
		var CSSPropertiesToSkip = ['position','left','top','width','height','right','bottom','overflowX','overflowY'];

ListView.prototype.encode = function ListView_encode() {
		
			var frozen = this.context.encodeObject(this, this.encodesStyles ? this.DOMNode : null, CSSPropertiesToSkip);
			
			if (this.ownsDataSource) {
				frozen.dataSource = this.dataSource.encode();
			}
			
			if (this._cellPrototype) {
				frozen.cellPrototype = this._cellPrototype;
			}

			if (this._listHeaderView) {
				frozen.listHeaderView = this._listHeaderView.encode();
			}

			if (this._listFooterView) {
				frozen.listFooterView = this._listFooterView.encode();
			}
			
			return frozen;};
		

ListView.prototype.encodeCloned = function ListView_encodeCloned() {
			var frozen = this.context.encodeObject(this, this.DOMNode, CSSPropertiesToSkip);

			if (this._cellPrototype) {
				var cellPrototypeInstance = this.context.decodeObjectTree(this._cellPrototype);
				frozen.cellPrototype = cellPrototypeInstance.encodeCloned();
			}

			if (this._listHeaderView) {
				frozen.listHeaderView = this._listHeaderView.encodeCloned();
			}

			if (this._listFooterView) {
				frozen.listFooterView = this._listFooterView.encodeCloned();
			}
			
			return frozen;};
		
	
	
	

	
	
// role View (Core.UI) 

ListView.prototype.viewDidLoad = function ListView_viewDidLoad() {
	
			this.viewIsLoaded = true;
			this.reloadData();
			};
		

		
	
ListView.prototype.layoutSubviews = function ListView_layoutSubviews() {
			if (!this.DOMNode) return;
		
			
			if (this._backgroundCanvas) this._backgroundCanvas.height = 0;
				
			__super.prototype.layoutSubviews.call(this);

			var width = this.DOMNode.clientWidth || this.size.width;
		
			if (this._listHeaderView)
				this._listHeaderView.size.width = width;
			if (this._listFooterView)
				this._listFooterView.size.width = width;
			
			if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {
				subview.size.width = width;return true; }, this);
			

			this.drawBackground();};
		
	
	


	Object.defineProperty(ListView.prototype, "timer", {
	synthesized: true, get:function () { return this._timer; }, set:function (v) {if (!Object.hasOwnProperty(this, "_timer")) Object.defineProperty(this, "_timer", { writable: true, configurable: true }); this._timer = v; }});
	
	
	
	
// role ListView 

		

ListView.prototype.reloadData = function ListView_reloadData(immediately) {
		
			if (this.shouldReloadImmediately||immediately) {
				if (this.timer) { clearTimeout(this.timer); this.timer = null; }
				this.reloadDataLazy();
				return;
			}
			
			if (this.timer) return;
			this.timer = setTimeout(function () {
				this.reloadDataLazy();
				this.timer = null;
			}.bind(this), 1);
	};
		
	
ListView.prototype.reloadDataLazy = function ListView_reloadDataLazy() {
		
			if (this.viewIsLoaded !== true)
				return;

			if (!this.cellPrototype)
				this.setDefaultCellPrototype();
				
			var scrollLeftBefore = this.scrollLeft,
				scrollTopBefore = this.scrollTop;

			this.clearData();
					
			this.insertData();
			
			this.layoutSubviews();

			if (this.setsHeightToFitContent) this.setHeightToFit();
			else this.scrollTo(scrollLeftBefore, scrollTopBefore);
	
			if (this.selectionToRestore) { _context.editor.restoreSelection(this.selectionToRestore); this.selectionToRestore = null; }
			};
		
	
		

		Object.defineProperty(ListView.prototype, "selectedIndexPaths", {
		synthesized: true, 
			set: function (v) {if (!Object.hasOwnProperty(this, "_selectedIndexPaths")) Object.defineProperty(this, "_selectedIndexPaths", { writable: true, configurable: true });
				this._selectedIndexPaths = v;
			}, get:function () { return this._selectedIndexPaths; }});
		
	
ListView.prototype.selectRowAtIndexPath = function ListView_selectRowAtIndexPath(indexPath, sender) {
		
			var rowView = this.rowForIndexPath(indexPath);
			if (!rowView || rowView._selected === true) return;

			if (sender === this && this._dataSource.setItemIsSelected) {
				this._dataSource.setItemIsSelected(rowView.dataset, true);
			}
			
			rowView._selected = true;
			
			this.selectedIndexPaths.push(indexPath);
			
			if (this.selectedIndexPaths.length === 1)
				this.scrollToShowView(rowView);
	
			this.styleSelectedRows();};
		
	
ListView.prototype.unselectAll = function ListView_unselectAll(sender) {
			this.selectedIndexPaths.every(function (indexPath) {
				this.unselectRowAtIndexPath(indexPath, sender);
				return true;
			}.bind(this));};
		
	
ListView.prototype.unselectRowAtIndexPath = function ListView_unselectRowAtIndexPath(indexPath, sender) {
		
			var rowView = this.rowForIndexPath(indexPath);
			if (!rowView || !rowView.contentView) return;

			if (sender === this && this._dataSource.setItemIsSelected) {
				this._dataSource.setItemIsSelected(rowView.dataset, false);
			}
			
			this.styleRowUnselected(rowView);
	};
		
		
ListView.prototype.styleRowUnselected = function ListView__styleRowUnselected(rowView) {

			rowView._selected = false;
			var node = rowView.DOMNode;
			
			
			if (this.cellPrototype.selectedStyle) {
				for (key in this.cellPrototype.selectedStyle) {
					var normalStyle = this.cellPrototype.style[key] || null;
					node.style[key] = normalStyle;
				}
			}
			
			var subviews = rowView.contentView.subviews, j = 0;
			if (Array.isArray(subviews)) subviews.every(function (subview) {
				if (subview.selectedStyle !== undefined) {
					for (key in subview.selectedStyle) {
						
						var styleObj = {};
						styleObj[key] = subview.defaultStyle[key];
						subview.style(styleObj);
					}
				}
				j++;return true; }, this);
			
			
			this.styleSelectedRows();
};
		

		
	
ListView.prototype.rowForIndexPath = function ListView_rowForIndexPath(indexPath) {
			return this.cellForIndexPath(indexPath);};
		
		
ListView.prototype.cellForIndexPath = function ListView_cellForIndexPath(indexPath) {

			if (!this._subviews) {
				if (window.isDebugging) {
					console.error('No subviews available!');
					console.trace();
				}
			}
		
			if (!indexPath || !this.subviews) return;

			if (!this.usesDataSource && this.staticSections) {
				if (!this.staticSections[indexPath.section]) return;
				return this.staticSections[indexPath.section].staticCells[indexPath.item];
			}
		
			var subviewIndex = 0;
			if (this.subviews[0] === this._listHeaderView)
				subviewIndex = 1;
			

			for (var i = 0, c = indexPath.section; i < c; i++) {
				subviewIndex += this._dataSource.numberOfItemsInSection(i);
				if (this._dataSource &&
					this._dataSource.titleForHeaderInSection &&
					this._dataSource.titleForHeaderInSection(i) !== undefined)
				subviewIndex += 1;
			}
	
			if (this._dataSource &&
				this._dataSource.titleForHeaderInSection &&
				this._dataSource.titleForHeaderInSection(
					indexPath.section) !== undefined)
				subviewIndex += 1;
			
			subviewIndex += indexPath.item;
			
			return this.subviews[subviewIndex];
		};
		
		
ListView.prototype.rowForItem = function ListView_rowForItem(item) {
			return this.cellForItem(item);};
		
		
		

ListView.prototype.rowBeforeRow = function ListView__rowBeforeRow(row) {
			var rowIndex = this.subviews.indexOf(row);
			return this.subviews[rowIndex-1];};
		

ListView.prototype.rowAfterRow = function ListView__rowAfterRow(row) {
			var rowIndex = this.subviews.indexOf(row);
			return this.subviews[rowIndex+1];};
		

		

		Object.defineProperty(ListView.prototype, "cellPrototype", {
		synthesized: true, 
	
			set: function (v) {if (!Object.hasOwnProperty(this, "_cellPrototype")) Object.defineProperty(this, "_cellPrototype", { writable: true, configurable: true });

				this._cellPrototype = v;
				if (!v) {
					return;
				}

				['size','style','selectedStyle','selectedStyleGraphite','selectedStyleWithoutFocus'].every(function (property) {
					if (v[property] === undefined)
						v[property] = this.defaultCellPrototype[property];
					return true;
				}.bind(this));
				
			}
	, get:function () { return this._cellPrototype; }});
		
		
		Object.defineProperty(ListView.prototype, "rowHeight", {
		synthesized: true, 
		enumerable: true, 
			get: function () {
				if (this._rowHeight) return this._rowHeight;

				if (!this.cellPrototype)
					return 0;

				if (this.cellPrototype.size)
					return this.cellPrototype.size.height;

				if (this.cellPrototype.frame)
					return this.cellPrototype.frame.size.height;
			}, set:function (v) {if (!Object.hasOwnProperty(this, "_rowHeight")) Object.defineProperty(this, "_rowHeight", { writable: true, configurable: true }); this._rowHeight = v; }});
		
		
		Object.defineProperty(ListView.prototype, "sectionHeaderTemplate", {
		enumerable: true, 
			set: function (v) {

				Object.defineProperty(this, '_sectionHeaderTemplate', {
					value: v, writable: true });
				
				Object.defineProperty(this, '_sectionHeaderTemplateGetterProperty', {
					value: v, writable: true });

			}, 
			get: function () {
				return this._sectionHeaderTemplateGetterProperty;
			}});
		

		Object.defineProperty(ListView.prototype, "sectionFooterTemplate", {
		enumerable: true, 
			set: function (v) {

				Object.defineProperty(this, '_sectionFooterTemplate', {
					value: v, writable: true });
				
				Object.defineProperty(this, '_sectionFooterTemplateGetterProperty', {
					value: v, writable: true });

			}, 
			get: function () {
				return this._sectionFooterTemplateGetterProperty;
			}});
		

		Object.defineProperty(ListView.prototype, "listHeaderView", {
		synthesized: true, 
			set: function (value) {if (!Object.hasOwnProperty(this, "_listHeaderView")) Object.defineProperty(this, "_listHeaderView", { writable: true, configurable: true });
			
				var listHeaderView = this.context.decodeObjectTree(clone(value));
				listHeaderView.cellType = "Header";
				listHeaderView.position = { top: 0 };
				listHeaderView.style({overflow: 'hidden'});
				
				this._listHeaderView = listHeaderView;
	
			}, get:function () { return this._listHeaderView; }});
		
	
		Object.defineProperty(ListView.prototype, "listFooterView", {
		synthesized: true, 
			set: function (value) {if (!Object.hasOwnProperty(this, "_listFooterView")) Object.defineProperty(this, "_listFooterView", { writable: true, configurable: true });
			
				var listFooterView = this.context.decodeObjectTree(clone(value));
				listFooterView.cellType = "Footer";
				listFooterView.style({overflow: 'hidden'});
				this._listFooterView = listFooterView;
	
			}, get:function () { return this._listFooterView; }});
		
	

		

		Object.defineProperty(ListView.prototype, "separatorColor", {
		enumerable: true, 
			set: function (value) {
				Object.defineProperty(this, '_separatorColor', {
					value: value, writable: true
				});
				this.drawBackground();
			}, 
			get: function () {
				return this._separatorColor;
			}});
		
		

	
	
ListView.prototype.dataSourceConformsToProtocol = function ListView__dataSourceConformsToProtocol(ds) {
		
		var result = true;

		['dataForItemInSectionAtIndex', 'numberOfItemsInSection', 'numberOfSections'].forEach(function (key) {
			if (!ds[key]) {
				console.warn(key+'() is missing in', ds);
				result = false;
			}
		});
		
		return result;};
	


	
	
// role ListViewDataSourceDelegate (Core) 
	
ListView.prototype.dataSourceIndexDidChangeInSection = function ListView_dataSourceIndexDidChangeInSection(oldIndex, newIndex, section) {
		
			
			
			this.reloadData();};
		
	
	


	

ListView.prototype.insertData = function ListView__insertData() {

		var ds = this._dataSource,
		
			
			context = {
				dataSourceChildrenId: ds?ds.identify():0
			},
			
			rowOffsetY = 0;
		
		
		if (this.insetTop) rowOffsetY += this.insetTop;

		if (this.listHeaderEnabled) {
			if (!this._listHeaderView.superview)
				this.addSubview(this._listHeaderView);
			this._listHeaderView.position.top = rowOffsetY;
			rowOffsetY += this._listHeaderView.size.height;
		}
		


		if (ds)
		for (var sectionIndex = 0,
			 sectionNumber = ds.numberOfSections();
			 sectionIndex != sectionNumber;
			 sectionIndex++) {


			if (ds.titleForHeaderInSection !== undefined) {
			
				var sectionHeaderTitle = ds.titleForHeaderInSection(sectionIndex);
				
				if (sectionHeaderTitle !== undefined) {
				
					if (this._sectionHeaderTemplate === undefined)
						this.setDefaultSectionHeaderTemplate();
				
					var sectionView = this.context.decodeObjectTree(clone(this._sectionHeaderTemplate));
					
					sectionView.cellType = "SectionHeaderCell";
					sectionView.position.top = rowOffsetY;
					
					this.decorateSectionHeaderAtIndexWithTitle(sectionView, sectionIndex, sectionHeaderTitle);

					if (sectionView._size.width !== this._size.width) {
						sectionView.size.width = this._size.width;
					}
					
					this.addSubview(sectionView);
					
					rowOffsetY += sectionView.size.height;

				}
			}


			var numberOfItems = ds.numberOfItemsInSection(sectionIndex);

			for (var childIndex = 0; childIndex !== numberOfItems; childIndex++) {
			
				var indexPath = { item: childIndex, section: sectionIndex };
			
				
				
				try {
					context[context.dataSourceChildrenId] =
					  ds.dataForItemInSectionAtIndex(sectionIndex, childIndex);
				} catch (err) {
					console.error(err.message+' in '+err.sourceURL+', line '+err.line, err);
					continue;
				}
				
				var rowContentView = null;
				if (ds && ds.listViewCellForRowAtIndexPath) rowContentView = ds.listViewCellForRowAtIndexPath(this, indexPath);
				if (!rowContentView) rowContentView = this.createRowContentView();

				var row = createComponentFromDomain(this.rowType.$type, this.rowType.$domain, this.context, {
						size: {
							width: this.size.width,
							height: rowContentView.size.height
						},
						position: { top: rowOffsetY },
						style: this.cellPrototype.style
					});

				row.addSubview(rowContentView);
				row.contentView = rowContentView;
				row.cellType = "Cell";
				row.indexPath = indexPath;
				row.backgroundColor = rowContentView.backgroundColor;

				this.addSubview(row);
				this.prepareRow(row, context);
				
				rowOffsetY += rowContentView.size.height||0;
			}


			if (this._sectionFooterTemplate !== undefined) {
				var sectionFooter = this.context.decodeObjectTree(clone(this._sectionFooterTemplate));
				sectionFooter.position.top = rowOffsetY;
				this.addSubview(sectionFooter);
				rowOffsetY += sectionFooter._size.height;
			}
		}

		if (this.listFooterEnabled) {
			this._listFooterView.position.top = rowOffsetY;
			this.addSubview(this._listFooterView);
			rowOffsetY += this._listFooterView.size.height;
		}

};
	
	
ListView.prototype.decorateSectionHeaderAtIndexWithTitle = function ListView__decorateSectionHeaderAtIndexWithTitle(sectionHeaderView, sectionIndex, title) {

		sectionHeaderView.subviews[0].text = title;
	};
	

ListView.prototype.extendSelectionToIndexPath = function ListView__extendSelectionToIndexPath(indexPath) {};
	

ListView.prototype.styleSelectedRows = function ListView__styleSelectedRows() {
	
		if (Array.isArray(this.selectedIndexPaths)) this.selectedIndexPaths.every(function (p) {
			this.styleSelectedRow(this.rowForIndexPath(p));return true; }, this);
		};
	
	
ListView.prototype.styleSelectedRow = function ListView__styleSelectedRow(rowView) {
	
		if (!rowView) return;
	
		var node = rowView.DOMNode,
			selectedStyle;

		if (!this.hasFocus) {
			selectedStyle = this.cellPrototype.selectedStyleWithoutFocus;
		}
		else if (window.tint === 6) {
			selectedStyle = this.cellPrototype.selectedStyleGraphite;
		}
		
		if (!selectedStyle)
			selectedStyle = this.cellPrototype.selectedStyle;
	
		if (selectedStyle) {
			for (key in selectedStyle) {
				node.style[key] = selectedStyle[key];
			}
		}

		if (!rowView.contentView) return;
		this.styleSelectedRowSubviews(rowView.contentView.subviews);
		};
	
	
ListView.prototype.styleSelectedRowSubviews = function ListView__styleSelectedRowSubviews(subviews, styleProperty) {
	
		
		if (!styleProperty) {
		
			if (!this.hasFocus)
				styleProperty = 'selectedStyleWithoutFocus';
			else
				styleProperty = 'selectedStyle';
			
		}

		var j = 0;
		if (Array.isArray(subviews)) subviews.every(function (subview) {
			if (subview[styleProperty]) {
				for (key in subview[styleProperty]) {
					var styleObj = {};
					styleObj[key] = subview[styleProperty][key];
					subview.style(styleObj);
				}
			}
			j++;
			
			if (subview.subviews && subview.subviews.length)
				this.styleSelectedRowSubviews(subview.subviews, styleProperty);return true; }, this);
		
	};
	
	
	Object.defineProperty(ListView.prototype, "hasFocus", {
		get: function () { return window.hasFocus && document.activeElement === this.DOMNode; }});
	
	
	
	
	
ListView.prototype.scrollToBottom = function ListView_scrollToBottom() {
		this.DOMNode.scrollTop = 100000;};
	
	
ListView.prototype.scrollToTop = function ListView_scrollToTop() {
		this.DOMNode.scrollTop = 0;};
	


	

ListView.prototype.initBackgroundCanvas = function ListView__initBackgroundCanvas(data) {
		
		if (this.drawsBackground === false && !data.drawsBackground) return;
	
		
		var backgroundCanvas = document.createElement('canvas');
		backgroundCanvas.style.position = 'absolute';
		backgroundCanvas.style.pointerEvents = 'none';
		backgroundCanvas.width = data.size.width;
		backgroundCanvas.height = data.size.height;
		
		this.DOMNode.appendChild(backgroundCanvas);
		
		Object.defineProperty(this, '_backgroundCanvas', {
			value: backgroundCanvas
		});
		};
	
	
	Object.defineProperty(ListView.prototype, "rowOffsetY", {
		value: 0});
	
	
	Object.defineProperty(ListView.prototype, "cellWidthIsEditable", {
		value: false});
	

	
	
	var oddBackgroundColorAqua = 'rgb(243,246,250)',
		oddBackgroundColorGraphite = 'hsl(0,0%,96%)';
		
	Object.defineProperty(ListView.prototype, "totalHeight", {
	writable: true});
	

ListView.prototype.sizeBackgroundCanvas = function ListView__sizeBackgroundCanvas() {

		var scale = this.context.highResolutionEnabled ? 2 : 1;
	
		this.totalHeight = 0;

		if (this.subviews.length) {
			var lastSubview = this.subviews[this.subviews.length-1];
			this.totalHeight = lastSubview.position.top + lastSubview.size.height-1;
		}

		if (this.e_insetBottom) this.totalHeight += this.e_insetBottom;

		if (this.totalHeight < this.size.height)
			this.totalHeight = this.size.height;

		this._backgroundCanvas.style.display = 'none';
		this._backgroundCanvas.height = this.totalHeight*scale;
		this._backgroundCanvas.width = this.size.width*scale;
		this._backgroundCanvas.style.height = (this.totalHeight)+'px';
		this._backgroundCanvas.style.width = this.size.width+'px';
		this._backgroundCanvas.style.display = 'block';

	};
	

ListView.prototype.drawBackground = function ListView__drawBackground() {

		if (this.viewIsLoaded !== true) return;
	
		if (this.drawsBackground === false) return;
		
		var offsetX = 0;
		var scale = this.context.highResolutionEnabled ? 2 : 1;
		

		var defaultRowHeight = this.rowHeight || 44,
			oddBackgroundColor = this.oddCellBackgroundColor || this.cellPrototype.oddBackgroundColor || this.oddBackgroundColor,
			width = this.size.width,
			
			ctx = this._backgroundCanvas.getContext('2d'),
			usesAlternatingRowBackgroundColors = this.usesAlternatingRowBackgroundColors === true;

			
		this.sizeBackgroundCanvas();

		ctx.scale(scale, scale);
		ctx.clearRect(0, 0, width, this.size.height);
		ctx.strokeStyle = this.separatorColor ? this.separatorColor : this.defaultSeparatorColor;
		ctx.fillStyle = oddBackgroundColor;
		
		var offsetY = -0.5,
			childIndex = 0;

		if (this.insetTop) {
			offsetY += this.insetTop;
		}
		

		for (var rowIndex = 0, rowCount = this.subviews.length;
			 rowIndex < rowCount;
			 rowIndex++) {

			var subview = this.subviews[rowIndex],
				rowHeight = subview.size.height;

			offsetY += (rowHeight+this.rowOffsetY);

			
			if (subview === this._listFooterView)
				return; 

			if (subview !== this._listHeaderView) {
				ctx.beginPath();
				ctx.moveTo(offsetX, offsetY);
				ctx.lineTo(width, offsetY);
				ctx.stroke();
			}
			
			if (usesAlternatingRowBackgroundColors && oddBackgroundColor && (childIndex % 2) !== 0) {
				ctx.fillRect(0, offsetY-rowHeight, width, rowHeight);
			}
		
			childIndex++;
			
			if (subview.cellType === 'SectionHeaderCell')
				childIndex = 0;
			
		}
		
		var i = childIndex;
		
		while (offsetY < this.totalHeight) {

			offsetY += defaultRowHeight;
			
			ctx.beginPath();
			ctx.moveTo(offsetX, offsetY);
			ctx.lineTo(width, offsetY);
			ctx.stroke();

		
			if (usesAlternatingRowBackgroundColors && oddBackgroundColor && (i % 2) !== 0) {
				ctx.fillRect(0, offsetY-defaultRowHeight, width, defaultRowHeight);
			}

			i++;
		}
		};
	
	
	Object.defineProperty(ListView.prototype, "defaultSeparatorColor", {
		value: 'rgb(224,224,244)'});
	


	

ListView.prototype.initDataSource = function ListView__initDataSource(data) {
	
		Object.defineProperty(this, '_dataSource', { configurable: true });

		if (data.dataSource) {
			this.dataSource = data.dataSource;
			Object.defineProperty(this, 'ownsDataSource', { value: true });
			return;
		}
		
		if (data.dataSourceId !== undefined) {
			this.dataSource =
				this.context.getOrCreateInstance(data.dataSourceId);
			this.dataSourceId = data.dataSourceId;
		}};
	


	


ListView.prototype.setDefaultSectionHeaderTemplate = function ListView__setDefaultSectionHeaderTemplate() {
	
		this._sectionHeaderTemplate = this.defaultSectionHeaderTemplate;
};
	

ListView.prototype.prepareRow = function ListView__prepareRow(row, context) {

		var rowNode = row.DOMNode,
			rowContentView = row.contentView;

		row.dataset = context[context.dataSourceChildrenId];
		rowNode.style.overflow = 'hidden';
		
		this.applyBindingsInCellContentView(rowContentView, context);

		
		if (this.draggable) {
			rowNode.draggable = true;
			rowNode.addEventListener('dragstart',
				this.rowDragStartHandler.bind({ row: row, self: this, context: this.context }));
		}

		if (this.selectable !== false) {

			
			var selectEvent = this.draggable ? 'click' : 'mousedown';
			rowNode.addEventListener(selectEvent, this.rowSelectHandler.bind(
				row));

		}
		
		rowNode.addEventListener('contextmenu', function (e) {
			this.rowContextMenuHandler(e, row);
		}.bind(this));
};
	
	

ListView.prototype.createRowContentView = function ListView__createRowContentView() {
		
		var data = clone(this.cellPrototype);
		data.size = { width: this.cellPrototype.size.width, height: this.cellPrototype.size.height };

		delete data.subviews;
		data.position = {};
		if (data.frame)
			data.frame.origin = { x: 0, y: 0 };
		
		var rowContentView = createComponentFromDomain(this.cellPrototype.$type, this.cellPrototype.$domain, this.context, data);
		
		
		if (this.cellPrototype.subviews &&
			this.cellPrototype.subviews.length !== 0) {
			for (var i = 0, c = this.cellPrototype.subviews.length;
				i < c; i++) {
				
				var subviewData = this.cellPrototype.subviews[i],
					subview = this.context.decodeObjectTree(subviewData);
				
				Object.defineProperty(subview, 'listView', {
					value: this
				});

				rowContentView.addSubview(subview);

				subview.destroy = function () {
					this.listView.unregisterDynamicBindings(this);
					this.__proto__.destroy.call(this);
				};

			}
		}
		
		if (rowContentView._size.width !== this._size.width) {
			rowContentView.size.width = this._size.width;
		}
		
		return rowContentView;
		};
	

	Object.defineProperty(ListView.prototype, "defaultCellPrototype", {
	
		
		
		value: {
			$type: "View",
			$domain: "Core.UI",
			size: { height: 23 },
			style: {},
			selectedStyle: {
				backgroundColor: 'rgb(56,117,215)',
			},
			subviews: [
				{
					$type: "Label",
					$domain: "Core.UI",
					position: { left: 10, top: 3 },
					size: { width: 200 },
					text: "Row",
					style: { fontSize: '13px', color: '' },
					selectedStyle: { color: 'white' },
				},
			],
			oddBackgroundColor:'rgba(255,255,255,.12)',
		}});
	

	Object.defineProperty(ListView.prototype, "defaultSectionHeaderTemplate", {

		
		
		value: {
			$type: "View",
			$domain: "Core.UI",
			style: {
				backgroundColor: '#eee'
			},
			size: {
				width: 320,
				height: 23
			},
			subviews: [{
				$type: "Label",
				$domain: "Core.UI",
				style: {
					fontSize: '14px',
					fontWeight: 'bold'
				},
				position: { left: 5, top: 3 }
			}]
		}});
	

	Object.defineProperty(ListView.prototype, "listHeaderTemplate", {
		get: function () {
			return {
				$type: 'TableViewHeaderView',
				$domain: 'appdoo.iOS',
				size: { width: this.size.width||320, height: 100 },
				subviews: []
			};
		}});
	

	Object.defineProperty(ListView.prototype, "listFooterTemplate", {
		get: function () {
			return {
				$type: 'TableViewFooterView',
				$domain: 'appdoo.iOS',
				size: { width: this.size.width||320, height: 100 },
				subviews: []
			};
		}});
	

ListView.prototype.setDefaultListHeader = function ListView__setDefaultListHeader() {
		this.listHeaderView = this.listHeaderTemplate;};
	
	
ListView.prototype.setDefaultListFooter = function ListView__setDefaultListFooter() {
		this.listFooterView = this.listFooterTemplate;};
	


	

ListView.prototype.rowSelectHandler = function ListView__rowSelectHandler(e) {
	
		var row = this,
			listView = row.superview,
			indexPath = row.indexPath;
		
		
		if (listView._currentContextMenuCell) return; 
		

		listView.dataSource.beginChangingSelection();

		if (e.metaKey !== true && e.shiftKey !== true)
			listView.unselectAll(listView);

		if (e.shiftKey === true)
			listView.extendSelectionToIndexPath(indexPath);

		else {
			if (e.metaKey === true &&
				listView.rowForIndexPath(indexPath)._selected === true)
				listView.unselectRowAtIndexPath(indexPath, listView);
			
			else {
				listView.selectRowAtIndexPath(indexPath, listView);
				listView.callDelegate('listViewDidSelectRowAtIndexPath', [listView, indexPath]);
			}
		}

		listView.dataSource.endChangingSelection(this);
};
	
	
ListView.prototype.rowContextMenuHandler = function ListView__rowContextMenuHandler(e, row) {
		__super.prototype.cellContextMenuHandler.call(this, e, row);};
	


	

	Object.defineProperty(ListView.prototype, "readableValue", {
		get: function () {
			if (this.dataSource !== undefined)
				return this.dataSource.name;
		}});
	

	
	

	Object.defineProperty(ListView.prototype, "rowType", {
		value: { $type: 'ListViewRowView', $domain: "Core.UI" }});
	

	
	

ListView.prototype.systemTintDidChange = function ListView_systemTintDidChange(tint) {

		this.oddBackgroundColor = (tint === 6 ? oddBackgroundColorGraphite : oddBackgroundColorAqua);

		this.drawBackground();
		
		this.styleSelectedRows();
		};
	

ListView.prototype.windowFocusDidChange = function ListView__windowFocusDidChange() {

		this.drawBackground();
		
		if (Array.isArray(this.selectedIndexPaths)) this.selectedIndexPaths.every(function (p) {
			this.styleSelectedRow(this.rowForIndexPath(p));return true; }, this);
		
};
	
	
	
	
	
ListView.prototype.highlightRowAtIndexPath = function ListView_highlightRowAtIndexPath(indexPath, highlightColor) {

		var rowView = this.rowForIndexPath(indexPath);
		if (!rowView) return false;
		
		var interval = 120;
		
		if (!highlightColor)
			highlightColor = 'hsl(0,0%,90%)';

		this.scrollToShowView(rowView);
		
		var backgroundColorBefore = rowView.DOMNode.style.backgroundColor || '';

		rowView.style({
			backgroundColor: highlightColor,
			webkitTransition: 'background-color 0.2s'
		});
		
		setTimeout(function () {
			rowView.style({
				backgroundColor: backgroundColorBefore
			});

		setTimeout(function () {
			rowView.style({
				backgroundColor: highlightColor
			});

		setTimeout(function () {
			rowView.style({
				backgroundColor: backgroundColorBefore
			});
		}, interval);

		}, interval);


		}, interval);

		
		return true;
};
	
	
	
	
ListView.prototype.rowDragStartHandler = function ListView__rowDragStartHandler(e) {
	
		var row = this.row,
			self = this.self;

		if (self.callDelegate('listViewWillBeginDraggingRowWithEvent', [self, row, e]) === false) return;
		
		var dataTransferData = {}, draggedView;
		
		if (!row.dataset) return;
		
		if (row.dataset.transferData) {
			var transferData = row.dataset.transferData;
			dataTransferData[transferData.format] = transferData.data;
			draggedView = row;
		}
		else {
			var promisedObjects,
				promisedObjectIDs;

			draggedView = createComponentFromDomain("View", "Core.UI", this.context, {
				size: self.size})
			;
			setTimeout(function () { draggedView.destroy(); }, 1);

			if (row._selected) {
				promisedObjectIDs = [];
				promisedObjects = [];
				if (Array.isArray(self.selectedIndexPaths)) self.selectedIndexPaths.every(function (indexPath) {
					var _row = self.rowForIndexPath(indexPath),
						rowClone = _row.clone();
					promisedObjectIDs.push(_row.dataset.$id);
					promisedObjects.push(_row.dataset);
					draggedView.addSubview(rowClone);return true; }, this);
				
			}
			else {
				promisedObjectIDs = [row.dataset.$id];
				promisedObjects = [row.dataset];
				draggedView.addSubview(row.clone());
			}
			
			if (Array.isArray(draggedView.subviews)) draggedView.subviews.every(function (subview) {
				if (self.styleRowForDragging(subview));return true; }, this);
			
			
			dataTransferData['promised-objects'] = promisedObjectIDs.join("\n");
			
			self.callDelegate('listViewWillUseDataTransferForDraggingItems', [self, dataTransferData, promisedObjects]);
		}
		
		if (self.dataSource.validateDragWithItems &&
			self.dataSource.validateDragWithItems(promisedObjects) !== true) {
			e.preventDefault();
			return;
		}
		
		
		var dragItem = createComponentFromDomain("DragItem", "Core.UI", this.context, {
			sourceView: draggedView,
			dataTransferData: dataTransferData,
			position: { left: -self.getRelativeX(0), top: -self.getRelativeY(-1) }})
		;
		
		dragItem.dragWithEvent(e);
};
	
	
ListView.prototype.styleRowForDragging = function ListView__styleRowForDragging(row) {
		this.styleRowUnselected(row);};
	
	

	

	Object.defineProperty(ListView.prototype, "acceptsDrop", {
	synthesized: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_acceptsDrop")) Object.defineProperty(this, "_acceptsDrop", { writable: true, configurable: true });
			if (this._acceptsDrop === v) return;
			this._acceptsDrop = v;
			this.dropHandler = v ? this : null;
		}, get:function () { return this._acceptsDrop; }});
	
	
ListView.prototype.enableClearingTimer = function ListView__enableClearingTimer() {
		this.isActiveDropTarget = false;
		if (this.didLeaveTimer) clearTimeout(this.didLeaveTimer);
		this.didLeaveTimer = setTimeout(function () {
			this.didLeaveTimer = null;
			if (!this.isActiveDropTarget)
				this.clearDropTargetStyle();
		}.bind(this), 100);};
	

ListView.prototype.disableClearingTimer = function ListView__disableClearingTimer() {
		this.isActiveDropTarget = true;
		if (this.didLeaveTimer) {
			clearTimeout(this.didLeaveTimer);
			this.didLeaveTimer = null;
		}};
	
	
ListView.prototype.didEnterWithEvent = function ListView__didEnterWithEvent(e) {
		this.disableClearingTimer();};
	

ListView.prototype.didLeaveWithEvent = function ListView__didLeaveWithEvent(e) {
		this.enableClearingTimer();
		this._dragEvent = null;};
	
	Object.defineProperty(ListView.prototype, "dragEvent", {
	synthesized: true, get:function () { return this._dragEvent; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dragEvent")) Object.defineProperty(this, "_dragEvent", { writable: true, configurable: true }); this._dragEvent = v; }});
	


	var lastMouseOverRow;
	
ListView.prototype.dropEffectForEvent = function ListView__dropEffectForEvent(e) {
		this._dragEvent = e;

		this.disableClearingTimer();

		var y = this.getRelativeY(e.y),
			mouseOverRow;
		
		if (Array.isArray(this.subviews)) this.subviews.every(function (row) {
			if (row.position.top < y && row.position.bottom+1 > y &&
				row !== this.insertIndicator) {
				mouseOverRow = row;
				return false;
			}return true; }, this);
		
		
		this.clearDropTargetStyle();

		var dropIsValid = false;

		lastMouseOverRow = mouseOverRow;

		if (!mouseOverRow) {
			dropIsValid = this.dropIsValid(e, null, -1);
			if (dropIsValid) {
				var lastRow = this.subviews[this.subviews.length-1];
				if (lastRow) {
					var x = lastRow.position.left,
						y = lastRow.position.bottom,
						w = lastRow.size.width;
					this.showInsertIndicatorWithParams(x, y, w);
				}
				if (dropIsValid === 2) return 'copy';
				return e.altKey ? 'copy' : 'move';
			}
			dropIsValid = this.unspecificDropIsValid(e);
			if (dropIsValid === 2) return 'copy';
			if (dropIsValid === 3) return (e.altKey ? 'copy' : 'move');
			return 'none';
		}
		
		if (y - mouseOverRow.position.top < mouseOverRow.size.height/4) {
			var validAndRow = this.dropIsValidAboveRow(e, mouseOverRow);
			if (validAndRow) {
				this.showInsertIndicatorAboveRow(mouseOverRow, validAndRow[1]);
				dropIsValid = validAndRow[0];
			}
		} else if (y - mouseOverRow.position.top >= (mouseOverRow.size.height/4)*3) {
			var validAndRow = this.dropIsValidBelowRow(e, mouseOverRow);
			if (validAndRow) {
				this.showInsertIndicatorBelowRow(mouseOverRow, validAndRow[1]);
				dropIsValid = validAndRow[0];
			}
		} else {
			var valid = this.dropIsValidAtRow(e, mouseOverRow);
			if (valid) {
				this.styleCellAsTargetActive(mouseOverRow, true);
				dropIsValid = valid;
			}
		}
		
		if (!dropIsValid) {
			dropIsValid = this.unspecificDropIsValid(e);
		}

		if (dropIsValid === 2) return 'copy';
		
		return dropIsValid ? (e.altKey ? 'copy' : 'move') : 'none';};
	

	
ListView.prototype.clearDropTargetStyle = function ListView__clearDropTargetStyle() {
		if (lastMouseOverRow) {
			this.styleCellAsTargetActive(lastMouseOverRow, false);
		}
		this.hideInsertIndicator();};
	
	
	Object.defineProperty(ListView.prototype, "targetIndicatorPadding", {
	configurable: true, 
		value: 6});
	 
	
	Object.defineProperty(ListView.prototype, "targetIndicatorLeft", {
	configurable: true, 
		value: 1});
	

	Object.defineProperty(ListView.prototype, "targetIndicatorTop", {
	configurable: true, 
		value: 2});
	

ListView.prototype.showInsertIndicatorAboveRow = function ListView__showInsertIndicatorAboveRow(row, validRow) {
		if (!validRow) validRow = row;
		this.showInsertIndicatorWithParams(validRow.contentView.position.left, row.position.top, validRow.size.width);};
	

ListView.prototype.showInsertIndicatorBelowRow = function ListView__showInsertIndicatorBelowRow(row, validRow) {
		if (!validRow) validRow = row;
		this.showInsertIndicatorWithParams(validRow.contentView.position.left, row.position.bottom, validRow.size.width);};
	
	
ListView.prototype.showInsertIndicatorWithParams = function ListView__showInsertIndicatorWithParams(x, y, rowWidth) {
	
		if (!this.insertIndicator) {
			this.insertIndicator = createComponentFromDomain("ListViewInsertIndicator", "Core.UI", this.context, {
				size: { width: 200, height: 10 }})
			;
		}
		
		this.insertIndicator.position.left = x+20;
		this.insertIndicator.position.top = y > 0 ? y-8 : -6;
		this.insertIndicator.size.width = rowWidth-x-30;
		this.insertIndicator.redraw();
		this.addSubview(this.insertIndicator);
};
	
	
ListView.prototype.hideInsertIndicator = function ListView__hideInsertIndicator() {
		if (this.insertIndicator && this.insertIndicator.superview)
			this.insertIndicator.removeFromSuperview(true);};
	

ListView.prototype.dropIsValidBelowRow = function ListView__dropIsValidBelowRow(e, row) {};
	

ListView.prototype.dropIsValidAboveRow = function ListView__dropIsValidAboveRow(e, row) {};
	

ListView.prototype.dropIsValidAtRow = function ListView__dropIsValidAtRow(e, row) {};
	
	
ListView.prototype.unspecificDropIsValid = function ListView__unspecificDropIsValid(e) {};
	

ListView.prototype.didDropWithEvent = function ListView__didDropWithEvent(e, dropEffect) {
		this.clearDropTargetStyle();};
	


	
	
	Object.defineProperty(ListView.prototype, "listHeaderEnabled", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_listHeaderEnabled")) Object.defineProperty(this, "_listHeaderEnabled", { writable: true, configurable: true }); this.changeListHeaderOrFooterEnabled('Header', v); }, 
		get: function ( ) { return !!this._listHeaderView && this._listHeaderEnabled !== false; }});
	
	
	Object.defineProperty(ListView.prototype, "listFooterEnabled", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_listFooterEnabled")) Object.defineProperty(this, "_listFooterEnabled", { writable: true, configurable: true }); this.changeListHeaderOrFooterEnabled('Footer', v); }, 
		get: function ( ) { return !!this._listFooterView && this._listFooterEnabled !== false; }});
	

ListView.prototype.changeListHeaderOrFooterEnabled = function ListView__changeListHeaderOrFooterEnabled(keyUcFirst, v) {
		
		if (['Header','Footer'].indexOf(keyUcFirst) === -1) return;
	
		var enabledKey = '_list'+keyUcFirst+'Enabled';
		var viewKey = '_list'+keyUcFirst+'View';
		var methodKey = 'setDefaultList'+keyUcFirst;

		if (this[enabledKey] === v) return;
		this[enabledKey] = v;

		
		if (v) { if (!this[viewKey]) this[methodKey](); this.registerSpecialCell(keyUcFirst); }
		else {
			var um = _context.undoManager;
			
			if (this[viewKey]) {
				um.registerChange(this, {
					type: 'deleteList'+keyUcFirst,
					value: this[viewKey].encode()
				});
				if (this[viewKey].node) this[viewKey].node.remove();
				this[viewKey].deleteForEditor(_context.editor);
			}
			this[viewKey] = null;
		}
		
		this.updateNodes();
		this.reloadData();
};
	
	
ListView.prototype.registerSpecialCell = function ListView__registerSpecialCell(keyUcFirst) {
		var editor = _context.editor;
		var viewKey = '_list'+keyUcFirst+'View';
		var index = keyUcFirst === 'Header' ? 0 : this.node.childNodes.length;
		var node = this.node.insertChildNodeWithRepresentedObjectAtIndex(this[viewKey], index, editor);
		editor.registerItem(this[viewKey], node);};
	

// role UndoCapableObject (Core) 

ListView.prototype.undoChange = function ListView_undoChange(change, undoManager) {
			
			if (change.type === 'deleteListHeader') {
				this._listHeaderView = this.context.decodeObjectTree(change.value);
				return true;
			}
			if (change.type === 'deleteListFooter') {
				this._listFooterView = this.context.decodeObjectTree(change.value);
				return true;
			}
			};
		

ListView.prototype.readableUndoName = function ListView_readableUndoName(change) {

			var undoNameForType = {
				'deleteListHeader': LocalizedString('Remove Header'),
				'deleteListFooter': LocalizedString('Remove Footer')
			};
			
			return undoNameForType[change.type];
};
		

ListView.prototype.readableUndoDetails = function ListView_readableUndoDetails(change) {
			return change.type + ' – ' + change.controllerId;};
		

ListView.prototype.undoNameForKeyPaths = function ListView_undoNameForKeyPaths(keyPaths) {

			if (keyPaths.indexOf('listHeaderEnabled') !== -1)
				return LocalizedString('Change Header');
			if (keyPaths.indexOf('listFooterEnabled') !== -1)
				return LocalizedString('Change Footer');

			return __super.prototype.undoNameForKeyPaths.call(this, keyPaths);};
		

	
	
	Object.defineProperty(ListView.prototype, "persistantID", {
		get: function () {
			return this.$id;
		}});
	
	
	Object.defineProperty(ListView.prototype, "nameForNormalCell", {
		get: function () { return LocalizedString('Row'); }});
	
	
ListView.prototype.setHeightToFit = function ListView__setHeightToFit() {

		if (this._backgroundCanvas) {
			var displayBefore = this._backgroundCanvas.style.display;
			this._backgroundCanvas.style.display = 'none';
			__super.prototype.setHeightToFit.call(this);
			this._backgroundCanvas.style.display = displayBefore;
		}
		else {
			__super.prototype.setHeightToFit.call(this);
		}
		};
	

ListView.prototype.expectedTypeForProperty = function ListView_expectedTypeForProperty(key) {
	if (key === "oddBackgroundColor") return "";
	if (key === "backgroundColor") return "";
	if (key === "oddCellBackgroundColor") return "";
	if (key === "scrollInterval") return "";
	if (key === "timer") return "";
	if (key === "selectedIndexPaths") return "";
	if (key === "cellPrototype") return "";
	if (key === "rowHeight") return "";
	if (key === "sectionHeaderTemplate") return "";
	if (key === "sectionFooterTemplate") return "";
	if (key === "listHeaderView") return "";
	if (key === "listFooterView") return "";
	if (key === "separatorColor") return "";
	if (key === "hasFocus") return "";
	if (key === "rowOffsetY") return "";
	if (key === "cellWidthIsEditable") return "";
	if (key === "totalHeight") return "Number";
	if (key === "defaultSeparatorColor") return "";
	if (key === "defaultCellPrototype") return "";
	if (key === "defaultSectionHeaderTemplate") return "";
	if (key === "listHeaderTemplate") return "";
	if (key === "listFooterTemplate") return "";
	if (key === "readableValue") return "";
	if (key === "rowType") return "";
	if (key === "acceptsDrop") return "";
	if (key === "dragEvent") return "";
	if (key === "targetIndicatorPadding") return "";
	if (key === "targetIndicatorLeft") return "";
	if (key === "targetIndicatorTop") return "";
	if (key === "listHeaderEnabled") return "";
	if (key === "listFooterEnabled") return "";
	if (key === "persistantID") return "";
	if (key === "nameForNormalCell") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ListView; }()));
registerType('Core.UI', (function () { function ListViewInsertIndicator() {} var __super = setSupertypeFromDomain(ListViewInsertIndicator, 'View', 'Core.UI');

ListViewInsertIndicator.prototype.init = function ListViewInsertIndicator_init() {
		var self = __super.prototype.init.call(this);
		if (self) {
			self.canvas = document.createElement('canvas');
			self.DOMNode.appendChild(self.canvas);
			self.DOMNode.style.pointerEvents = 'none';
		}
		return self;};
	

ListViewInsertIndicator.prototype.redraw = function ListViewInsertIndicator_redraw() {
		var ctx,
			width = this.size.width,
			height = this.size.height;
		var scaleFactor = this.context.highResolutionEnabled ? 2 : 1;
		
		this.canvas.style.width = width + 'px';
		this.canvas.style.height = height + 'px';
		
		this.canvas.width = width*scaleFactor;
		this.canvas.height = height*scaleFactor;
		
		ctx = this.canvas.getContext('2d');

		ctx.clearRect(0, 0, width*scaleFactor, height*scaleFactor);
		ctx.moveTo(6*scaleFactor, 5*scaleFactor);
		ctx.lineTo(width*scaleFactor, 5*scaleFactor);

		ctx.lineWidth = 2*scaleFactor;
		ctx.strokeStyle = "rgb(77,114,220)";
		ctx.stroke();
		
		ctx.beginPath();
		ctx.arc(4*scaleFactor, 5*scaleFactor, 3*scaleFactor, 0, Math.PI*2, false);
		ctx.stroke();};
	

ListViewInsertIndicator.prototype.expectedTypeForProperty = function ListViewInsertIndicator_expectedTypeForProperty(key) {
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ListViewInsertIndicator; }()));
registerType('Core.UI', (function () { function ListViewRowView() {} var __super = setSupertypeFromDomain(ListViewRowView, 'View', 'Core.UI');

	Object.defineProperty(ListViewRowView.prototype, "contentView", {
	outlet: true, 
	synthesized: true, 
	enumerable: true, get:function () { return this._contentView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_contentView")) Object.defineProperty(this, "_contentView", { writable: true, configurable: true }); this._contentView = v; }});
	

	Object.defineProperty(ListViewRowView.prototype, "indexPath", {
	outlet: true, 
	synthesized: true, 
	enumerable: true, get:function () { return this._indexPath; }, set:function (v) {if (!Object.hasOwnProperty(this, "_indexPath")) Object.defineProperty(this, "_indexPath", { writable: true, configurable: true }); this._indexPath = v; }});
	

	Object.defineProperty(ListViewRowView.prototype, "selected", {
	outlet: true, 
	synthesized: true, 
	enumerable: true, get:function () { return this._selected; }, set:function (v) {if (!Object.hasOwnProperty(this, "_selected")) Object.defineProperty(this, "_selected", { writable: true, configurable: true }); this._selected = v; }});
	

	Object.defineProperty(ListViewRowView.prototype, "isTarget", {
	outlet: true, 
	synthesized: true, 
	enumerable: true, get:function () { return this._isTarget; }, set:function (v) {if (!Object.hasOwnProperty(this, "_isTarget")) Object.defineProperty(this, "_isTarget", { writable: true, configurable: true }); this._isTarget = v; }});
	

	Object.defineProperty(ListViewRowView.prototype, "level", {
	outlet: true, 
	synthesized: true, 
	enumerable: true, get:function () { return this._level; }, set:function (v) {if (!Object.hasOwnProperty(this, "_level")) Object.defineProperty(this, "_level", { writable: true, configurable: true }); this._level = v; }});
	

	Object.defineProperty(ListViewRowView.prototype, "parentRow", {
	outlet: true, 
	synthesized: true, get:function () { return this._parentRow; }, set:function (v) {if (!Object.hasOwnProperty(this, "_parentRow")) Object.defineProperty(this, "_parentRow", { writable: true, configurable: true }); this._parentRow = v; }});
	

	Object.defineProperty(ListViewRowView.prototype, "dataset", {
	outlet: true, 
	synthesized: true, get:function () { return this._dataset; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dataset")) Object.defineProperty(this, "_dataset", { writable: true, configurable: true }); this._dataset = v; }});
	
	
ListViewRowView.prototype.decodeData = function ListViewRowView_decodeData(data) {
		var unfrozen = __super.prototype.decodeData.call(this, data);
		if (data.contentView) {
			unfrozen.contentView = this.context.createFromDataWithoutInitializing(data.contentView);
		}
		return unfrozen;};
	
	
ListViewRowView.prototype.initFromArchive = function ListViewRowView_initFromArchive(data) {
		__super.prototype.initFromArchive.call(this, data);
		if (data.contentView) {
			this.context.initObjectFromArchive(data.contentView);
		}};
	

ListViewRowView.prototype.initPropertiesFromData = function ListViewRowView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("contentView")) this.contentView = data.contentView;
if (data.hasOwnProperty("indexPath")) this.indexPath = data.indexPath;
if (data.hasOwnProperty("selected")) this.selected = data.selected;
if (data.hasOwnProperty("isTarget")) this.isTarget = data.isTarget;
if (data.hasOwnProperty("level")) this.level = data.level;
if (data.hasOwnProperty("parentRow")) this.parentRow = data.parentRow;
if (data.hasOwnProperty("dataset")) this.dataset = data.dataset;
};

ListViewRowView.prototype.encode = function ListViewRowView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

ListViewRowView.prototype.encodeCloned = function ListViewRowView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

ListViewRowView.prototype.expectedTypeForProperty = function ListViewRowView_expectedTypeForProperty(key) {
	if (key === "contentView") return "";
	if (key === "indexPath") return "";
	if (key === "selected") return "";
	if (key === "isTarget") return "";
	if (key === "level") return "";
	if (key === "parentRow") return "";
	if (key === "dataset") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ListViewRowView; }()));