
registerType('Core.UI', (function () { function OutlineView() {} var __super = setSupertypeFromDomain(OutlineView, 'ListView', 'Core.UI');


OutlineView.prototype.initFromData = function OutlineView_initFromData(data) {

		__super.prototype.initFromData.call(this, data);

		Object.defineProperty(this, "expandedRows", {
		writable: true});
		
		
		Object.defineProperty(this, "rowViewForItemId", {
		writable: true});
		
		
		this.selectedIndices = [];
		this.levelDeltaX = 24;
		
		return this;
		};
	
	
	Object.defineProperty(OutlineView.prototype, "selectedIndices", {
	synthesized: true, get:function () { return this._selectedIndices; }, set:function (v) {if (!Object.hasOwnProperty(this, "_selectedIndices")) Object.defineProperty(this, "_selectedIndices", { writable: true, configurable: true }); this._selectedIndices = v; }});
	

	Object.defineProperty(OutlineView.prototype, "hasSourceStyle", {
	outlet: true, get:function () { return this._hasSourceStyle; }, set:function (v) {if (!Object.hasOwnProperty(this, "_hasSourceStyle")) Object.defineProperty(this, "_hasSourceStyle", { writable: true, configurable: true }); this._hasSourceStyle = v; }});
	

	Object.defineProperty(OutlineView.prototype, "drawsFancySelectionGradient", {
	outlet: true, get:function () { return this._drawsFancySelectionGradient; }, set:function (v) {if (!Object.hasOwnProperty(this, "_drawsFancySelectionGradient")) Object.defineProperty(this, "_drawsFancySelectionGradient", { writable: true, configurable: true }); this._drawsFancySelectionGradient = v; }});
	
	
	Object.defineProperty(OutlineView.prototype, "disclosureTriangleColorStyle", {
	readonly: true, 
		get: function () {
			return this.hasSourceStyle ? 3 : 1;
		}});
	


	
	
OutlineView.prototype.viewDidLoad = function OutlineView_viewDidLoad() {
		if (this.viewIsLoaded) return;
		this.viewIsLoaded = true;
		this.reloadItem(null, undefined, true);
		};
	

OutlineView.prototype.reloadItem = function OutlineView_reloadItem(item, reloadChildren, immediately) {
	
		if (immediately) {
			clearTimeout(this.timer);
			this.timer = null;
			this.reloadItemLazy(item, reloadChildren);
			return;
		}
	
		if (this.timer) return;

		this.timer = setTimeout(function () {
			this.reloadItemLazy(item, reloadChildren);
			this.timer = null;
		}.bind(this), 0);
};
	
	
OutlineView.prototype.reloadItemLazy = function OutlineView_reloadItemLazy(item, reloadChildren) {

		if (!this.viewIsLoaded)
			return;
		
		if (!this._dataSource)
			return;
		
		if (!this.DOMNode)
			return;

		
		if (!this.cellPrototype)
			this.setDefaultCellPrototype();
			
		var ds = this._dataSource,

			
			context = {
				dataSourceChildrenId: this.context.identify(ds)
			};

		var c = this._dataSource.numberOfChildrenOfItem(item);
		var scrollTop = this.DOMNode.scrollTop;
		
		
		this._itemAtRow = [];
		this.clearData();
		this.selectedIndices = [];
		this.expandedRows = [];
		this.rowViewForItemId = {};
		
		var row, y = 0;
		for (var i = 0; i != c; i++) {
		
			var child = this.itemAtRow(i);
			if (child == undefined) {

				
				
				try {
					child = ds.childWithIndexOfItem(i, item);
				} catch (err) {
					console.error(err.message, 'Line ' + err.line);
					continue;
				}
			}

			if (ds.itemShouldDrawAsSeparator &&
				ds.itemShouldDrawAsSeparator(child)) {
				var padding = 4;
				row = createComponentFromDomain(this.rowType.$type, this.rowType.$domain, this.context, {
						size: { width: this.size.width, height: 0 },
						autoresizingMask: 2
					});

				row.isSeparator = true;
				this.styleSeparatorRow(row);
			}
			else if (ds.itemShouldDrawAsCaption &&
					ds.itemShouldDrawAsCaption(child)) {
				var height = y > 0 ? 26 : 22;
			
				row = createComponentFromDomain(this.rowType.$type, this.rowType.$domain, this.context, {
						size: { width: this.size.width, height: height },
						autoresizingMask: 2
					});
				var margin = 10;
				row.addSubview(createComponentFromDomain('Label','Core.UI',this.context,{
						size: { width: this.size.width-margin*2, height: 15 },
						position: {left:margin, top: height-16 },
						autoresizingMask: 2,
						text: ds.captionForItem(child),
						style: {
							fontSize: '11px',
							textTransform: 'uppercase',
							fontWeight: 'bold',
							textShadow: '0 1px 0 rgba(255,255,255,.5)'
						}
				}));
				row.isCaption = true;
				this.styleCaptionRow(row);
			}
			
			else {
			
				
				context[context.dataSourceChildrenId] = child;
	
				var rowContentView = this.createRowContentView();
				
				row = createComponentFromDomain(this.rowType.$type, this.rowType.$domain, this.context, {
						size: rowContentView.size,
						autoresizingMask: 2
					});
				row.style(this.cellPrototype.style);
					
				row.addSubview(rowContentView);
				row.contentView = rowContentView;
	
				var childId = this.identifyItem(child);
				this.rowViewForItemId[childId] = row;
	
				if (item === null) {
					row._level = 0;
					this._itemAtRow[i] = child;
				}
	
			
			}

			this.prepareOutlineViewRow(row, i, context, item, child, rowContentView);
			
			row.position.top = y;
			y += row.size.height;
	
			row.tag = i;
			this.addSubview(row);
		}
		if (row) row._isLastItemRow = true;

		
		if (c > 0)
			this.restoreRowState([0, c]);

		this.drawBackground();
		
		this.callDelegate('outlineViewDidChange',[this]);
		
		this.layoutSubviews();
			
		this.DOMNode.scrollTop = scrollTop;
		};
	
	
OutlineView.prototype.identifyItem = function OutlineView__identifyItem(item) {
		if (item && item.context)
		return item.context.identify(item);};
	

OutlineView.prototype.restoreRowState = function OutlineView__restoreRowState(range) {
	
		var i = range[0], c = i + range[1];
		

		
		var items = [];
		for (; i < c; i++) {
			items.push(this.itemAtRow(i));
		}


		if (this.dataSource.isItemExpanded !== undefined) {

			
			if (Array.isArray(items)) items.every(function (item) {
				if (this.dataSource.isItemExpanded(item) === true) {
					this.expandItem(item);
				}return true; }, this);
			
		}

		if (this.dataSource.isItemSelected !== undefined) {

			
			if (Array.isArray(items)) items.every(function (item) {
				if (this.dataSource.isItemSelected(item) === true) {
					var indexPath = this.indexPathForItem(item);
					this.selectRowAtIndex(indexPath.item);
				}return true; }, this);
			
		}
};
	
	
	var backgroundColor = 'rgb(221,228,235)',
		backgroundColorWithoutFocus = 'hsl(0,0%,93%)';
		
OutlineView.prototype.drawBackground = function OutlineView__drawBackground() {
	
		if (this.drawsBackground === false) return;
		
		this._backgroundCanvas.height = 0;
	
		var ctx = this._backgroundCanvas.getContext('2d'),
			width = this.size.width,
			height = this.DOMNode.scrollHeight || this.DOMNode.offsetHeight || this.size.height;
		
		
		this._backgroundCanvas.height = height;
		this._backgroundCanvas.width = this.size.width;
		
		if (this.hasSourceStyle) {

			var gradient = ctx.createLinearGradient(0,0,0,height);
			gradient.addColorStop(0, 'rgb(224,228,234)');
			gradient.addColorStop(1, 'rgb(209,216,224)');
			backgroundColor = gradient;
			
			ctx.fillStyle = window.hasFocus ? backgroundColor : backgroundColorWithoutFocus;
	
			ctx.fillRect(0,0,width,height);
		}
		else {

			ctx.fillStyle = this.backgroundColor||'#fff';
			ctx.fillRect(0,0,width,height);
			
			if (this.usesAlternatingRowBackgroundColors) {
	
				var rowCount = this.subviews.length,
					offsetY = 0,
					childIndex = 0;
				var defaultRowHeight = this.rowHeight||21;
					
				ctx.fillStyle = this.oddCellBackgroundColor || 'rgb(243,246,250)';
	
				for (var rowIndex = 0; rowIndex < rowCount; rowIndex++) {

					var subview = this.subviews[rowIndex],
						rowHeight = subview.size.height;
					offsetY += rowHeight;
					
					if (subview.isSeparator) continue;
						
					if ((childIndex % 2) !== 0) {
						ctx.fillRect(0, offsetY-rowHeight, width, rowHeight);
					}
					childIndex++;
				}

				var totalHeight = 0;
				if (this.subviews.length) {
					var lastSubview = this.subviews[this.subviews.length-1];
					totalHeight = lastSubview.position.top + lastSubview.size.height-1;
				}
				if (totalHeight < height)
					totalHeight = height;
					
				var i = childIndex;
				while (offsetY < totalHeight && defaultRowHeight) {
					offsetY += defaultRowHeight;

					if (this.usesAlternatingRowBackgroundColors && (i % 2) !== 0) {
						ctx.fillRect(0, offsetY-defaultRowHeight, width, defaultRowHeight);
					}
					
					i++;
				}

			}
			

		}
};
	


	
	
OutlineView.prototype.rowIsExpanded = function OutlineView__rowIsExpanded(row) {
		if (!this.expandedRows) return false;
		return this.expandedRows.indexOf(row) !== -1;};
	

OutlineView.prototype.expandItem = function OutlineView_expandItem(item, sender) {

		var rowView = this.rowForItem(item);
		
		if (this.rowIsExpanded(rowView)) return;
		
		var indexPath = this.indexPathForItem(item);
		if (!indexPath) return;

		var rowIndex = indexPath.item,
			numberOfChildren = this._dataSource.numberOfChildrenOfItem(item),
			addY = numberOfChildren * (this.cellPrototype.size.height),
			isExpandable = this._dataSource.isItemExpandable(item);
			

		if (numberOfChildren === 0 || isExpandable === false) return;
		if (rowView._disclosureTriangle)
			rowView._disclosureTriangle.selected = true;


		
		for (var i = rowIndex + 1, c = this.subviews.length; i < c; i++) {
			var nextRow = this.subviews[i];
			nextRow.position.top += addY;
			nextRow.indexPath.item += numberOfChildren;
		}
		
		Object.defineProperty(rowView, 'childRowViews', {
			value: [],
			writable: true
		});

		var ds = this._dataSource,
			context = {
				dataSourceChildrenId: this.context.identify(ds)
			},
			childRow,
			y = rowView.position.top + rowView.size.height;

		for (var i = 0, c = numberOfChildren; i < c; i++) {
			var child = this._dataSource.childWithIndexOfItem(i,item),
				childRowContentView = this.createRowContentView();
			
			childRow = createComponentFromDomain(this.rowType.$type, this.rowType.$domain, this.context, {
					size: childRowContentView.size,
					autoresizingMask: 2,
					tag: i
				});
			
			context[context.dataSourceChildrenId] = child;
			
			rowView.childRowViews.push(childRow);

			childRow.style(this.cellPrototype.style);
			childRow.contentView = childRowContentView;
			childRow.addSubview(childRowContentView);

			this.rowViewForItemId[this.identifyItem(child)] = childRow;
			childRow._level = rowView._level + 1;
			childRow._parentRow = rowView;

			this.prepareOutlineViewRow(childRow, rowIndex+1+i, context, item, child, childRowContentView);
			childRow.position.top = y;
			y += childRow.size.height;
			
			this.insertSubviewAtIndex(childRow, rowIndex+1+i);
			this._itemAtRow.splice(rowIndex+1+i, 0, child);
		}
		
		if (childRow) childRow._isLastItemRow = true;


		this.restoreRowState([rowIndex + 1, numberOfChildren]);
		
		this.callDelegate('outlineViewDidExpandItem', [this, item]);
		
		if (this._dataSource.setItemIsExpanded !== undefined)
			this._dataSource.setItemIsExpanded(item, true, sender);

		this.expandedRows.push(rowView);

		this.updateSelectedRowIndices();
		
		this.layoutSubviews();
};
	

OutlineView.prototype.collapseItem = function OutlineView_collapseItem(item, sender) {
	
		var rowView = this.rowForItem(item);

		if (!this.rowIsExpanded(rowView)) return;
		

		var rowIndex = rowView.indexPath.item,
			numberOfChildren = rowView.childRowViews.length,
			addY = numberOfChildren * (this.cellPrototype.size.height);

		rowView._disclosureTriangle.selected = false;


		
		if (Array.isArray(rowView.childRowViews)) rowView.childRowViews.every(function (childRowView) {
			var child = childRowView.dataset;
			this.collapseItem(child, this);
			this.removeSubview(childRowView);return true; }, this);
		

		
		var newY = rowView.position.top + (this.cellPrototype.size.height);
		for (var i = rowIndex + 1, c = this.subviews.length; i < c; i++) {
			var nextRow = this.subviews[i];
			nextRow.position.top = newY;
			nextRow.indexPath.item = i;
			
			newY += (nextRow.size.height);
		}

		
		this._itemAtRow.splice(rowIndex+1, numberOfChildren);

		this.callDelegate('outlineViewDidCollapseItem', [this, item]);

		if (this._dataSource.setItemIsExpanded !== undefined)
			this._dataSource.setItemIsExpanded(item, false, sender);

		this.expandedRows.splice(this.expandedRows.indexOf(rowView), 1);

		this.updateSelectedRowIndices();

		this.layoutSubviews();
};
	
	
OutlineView.prototype.expandToShowItem = function OutlineView_expandToShowItem(item, sender) {
		
		var parentItem = item;
		do {
			var rowView = this.rowForItem(item);
			if (rowView) return true;
			
			parentItem = this.dataSource.parentItemForItem(parentItem);
			this.expandItem(parentItem, sender);
		} while (parentItem);
		
		return false;};
	


OutlineView.prototype.expandOrCollapseItem = function OutlineView__expandOrCollapseItem(item, sender) {
		var rowView = this.rowForItem(item);
		if (this.rowIsExpanded(rowView))
			this.collapseItem(item, sender);
		else this.expandItem(item, sender);};
	
	
OutlineView.prototype.updateSelectedRowIndices = function OutlineView__updateSelectedRowIndices() {

		var newSelectedIndices = [], i = 0;
		if (Array.isArray(this.subviews)) this.subviews.every(function (rowView) {
			if (rowView._selected === true)
				newSelectedIndices.push(i);
			i++;return true; }, this);
		
		this.selectedIndices = newSelectedIndices;
		this._lastSelectedIndex = newSelectedIndices[0];};
	


	

OutlineView.prototype.selectItem = function OutlineView_selectItem(item, sender) {
		var row = this.rowForItem(item);
		this.selectRow(row, sender);};
	

OutlineView.prototype.selectRowAtIndex = function OutlineView_selectRowAtIndex(index, sender) {
		var row = this.subviews[index];
		if (!row) {
			console.warn('Out of bounds in OutlineView.selectRowAtIndex('+index+')');
			console.trace();
			return;
		}
		this.selectRow(row, sender);};
	
	
OutlineView.prototype.selectRow = function OutlineView__selectRow(row, sender) {
	
		if (!row || row._selected) {
			return;
		}

		var index = this.subviews.indexOf(row);


		row._selected = true;

		this.selectedIndices.push(index);
		this._lastSelectedIndex = index;

		this.styleSelectedRows();

		if (row._disclosureTriangle) {
			row._disclosureTriangle.colorStyle = 2;
			row._disclosureTriangle.updateStyle();
		}

		if (this.selectedIndexPaths.length === 1)
			this.scrollToShowView(row);

		if (sender === this && this._dataSource.setItemIsSelected) {
			this._dataSource.setItemIsSelected(row.dataset, true);
		}};
	


OutlineView.prototype.unselectItem = function OutlineView_unselectItem(item, sender) {
		var row = this.rowForItem(item);
		this.unselectRow(row, sender);};
	

OutlineView.prototype.unselectRowAtIndex = function OutlineView_unselectRowAtIndex(index, sender) {
		var row = this.subviews[index];
		if (!row) {
			console.warn('Out of bounds in OutlineView.unselectRowAtIndex('+index+')');
			console.trace();
			return;
		}
		this.unselectRow(row, sender);};
	
	
OutlineView.prototype.unselectRow = function OutlineView__unselectRow(row, sender) {
		if (!row) return;
	
		var index = this.subviews.indexOf(row);

		row._selected = false;

		this.selectedIndices.splice(this.selectedIndices.indexOf(index), 1);

		__super.prototype.unselectRowAtIndexPath.call(this, { section: 0, item: index }, sender);
		if (row._disclosureTriangle) row._disclosureTriangle.colorStyle = this.disclosureTriangleColorStyle;
	};
	

OutlineView.prototype.unselectAll = function OutlineView_unselectAll(sender) {

		var indices = this.selectedIndices.splice(0, this.selectedIndices.length);

		indices.every(function (index) {
			this.unselectRowAtIndex(index, sender);
			return true;
		}.bind(this));
};
	
	
	
	
OutlineView.prototype.styleSelectedRow = function OutlineView__styleSelectedRow(row) {
	
		if (!row) return;
	
		__super.prototype.styleSelectedRow.call(this, row);

        if (window.systemVersion.minor === 10) {
            row.style({backgroundColor:!window.hasFocus?'rgb(212,211,212)':'rgb(26,96,246)'});
            return;
        }

		if (!this.drawsFancySelectionGradient) return;
		
		
		var colors = window.hasFocus ? [
			[0,105,217], 
			[0,105,217], 
			[0,105,217], 
			[0,105,217], 
			[0,105,217], 
			[0,105,217]  
		] : [
			[200,200,200], 
			[200,200,200], 
			[200,200,200], 
			[200,200,200], 
			[200,200,200], 
			[200,200,200]  
		];
		
















		
		function rgbString(a) {
			return 'rgb('+a[0]+','+a[1]+','+a[2]+')';
		}
		
		function colorBetween(a, b, percent) {
			return [
				a[0] + (b[0] - a[0])*percent | 0,
				a[1] + (b[1] - a[1])*percent | 0,
				a[2] + (b[2] - a[2])*percent | 0,
			];
		}
		
		var rowIndex = row.indexPath.item;
		var nextRow = this.rowAfterRow(row);
		var previousRow = this.rowBeforeRow(row);
		var isFirstSelectedRow = !(previousRow && previousRow._selected);
		var isLastSelectedRow = !(nextRow && nextRow._selected);

		var numbersOfPrecedingRowsInSelectionGroup = 0;
		var numbersOfFollowingRowsInSelectionGroup = 0;

		var _row = row;
		while ((_row = this.rowBeforeRow(_row)) && _row._selected) {
			numbersOfPrecedingRowsInSelectionGroup++;
		}

		var _row = row;
		while ((_row = this.rowAfterRow(_row)) && _row._selected) {
			numbersOfFollowingRowsInSelectionGroup++;
		}
		
		var numberOfRowsInSelectionGroup = (numbersOfPrecedingRowsInSelectionGroup+1+numbersOfFollowingRowsInSelectionGroup);
		
		var isFirstSelectedRow = numbersOfPrecedingRowsInSelectionGroup===0;
		var isLastSelectedRow = numbersOfFollowingRowsInSelectionGroup===0;
		var red = [255,0,0];
		
		var partialColors = [
			colors[2],
			colors[2],
			colors[3],
			colors[3]
		];
		
		if (numbersOfFollowingRowsInSelectionGroup) {
			var percentage = (numbersOfPrecedingRowsInSelectionGroup+1)/numberOfRowsInSelectionGroup;
			partialColors[2] = colorBetween(colors[2], colors[3], percentage);
			partialColors[3] = partialColors[2];
		}
		if (numbersOfPrecedingRowsInSelectionGroup) {
			var percentage = numbersOfPrecedingRowsInSelectionGroup/numberOfRowsInSelectionGroup;
			partialColors[0] = colorBetween(colors[2], colors[3], percentage);
			partialColors[1] = partialColors[0];
		}
		
		var borderColors = [
			partialColors[0],
			partialColors[3]
		];

		if (isFirstSelectedRow) {
			borderColors[0] = colors[0];
			partialColors[0] = colors[1];
		}
		if (isLastSelectedRow) {
			partialColors[3] = colors[4];
			borderColors[1] = colors[5];
		}

		var backgroundImageString = "-webkit-linear-gradient("+rgbString(partialColors[0])+" 0%, "+rgbString(partialColors[1])+" 5%, "+rgbString(partialColors[2])+" 95%, "+rgbString(partialColors[3])+" 100%)";

		
		row.style({
			"backgroundImage" : backgroundImageString,
			"borderTopColor": rgbString(borderColors[0]),
			"borderBottomColor": rgbString(borderColors[1])
		});

		};
	

OutlineView.prototype.styleRowUnselected = function OutlineView__styleRowUnselected(row) {
		__super.prototype.styleRowUnselected.call(this, row);
		row.style({ backgroundImage: 'none', borderColor: 'transparent' });};
	


	

OutlineView.prototype.rowForItem = function OutlineView_rowForItem(item) {
		if (!this.rowViewForItemId) {
			return;
		}
		if (!item) {
			return;
		}

		return this.rowViewForItemId[item.$id];};
	
	
OutlineView.prototype.indexPathForItem = function OutlineView_indexPathForItem(item) {
		var rowView = this.rowForItem(item);
		if (!rowView) return;
		return rowView.indexPath;};
	

OutlineView.prototype.itemAtRow = function OutlineView_itemAtRow(row) {
		return this._itemAtRow[row];};
	


	

OutlineView.prototype.levelForItem = function OutlineView_levelForItem(item) {
		if (item === null) return 0;
		var rowView = this.rowForItem(item);
		if (!rowView) {
			console.warn(item);
			console.trace();
		}
		return rowView._level;};
	


	

OutlineView.prototype.selectRowAtIndexPath = function OutlineView_selectRowAtIndexPath(indexPath, sender) {
		this.selectRowAtIndex(indexPath.item, sender);};
	

OutlineView.prototype.unselectRowAtIndexPath = function OutlineView_unselectRowAtIndexPath(indexPath, sender) {
		this.unselectRowAtIndex(indexPath.item, sender);};
	

OutlineView.prototype.extendSelectionToIndexPath = function OutlineView__extendSelectionToIndexPath(indexPath) {
		var index = indexPath.item;
		if (index < this._lastSelectedIndex) {
			for (var i = index, c = this._lastSelectedIndex;
			i < c; i++) {
				this.selectRowAtIndex(i, this);
			}
		}
		else {
			for (var i = index, c = this._lastSelectedIndex;
			i > c; i--) {
				this.selectRowAtIndex(i, this);
			}
		}};
	

OutlineView.prototype.selectionDidChange = function OutlineView__selectionDidChange() {
		this.callDelegate('outlineViewSelectionDidChange', [this]);};
	
	

	
	
	Object.defineProperty(OutlineView.prototype, "defaultCellPrototype", {

		
		
		get: function () {
		
			var cellPrototype = {
				"$type": "View",
				"$domain": "Core.UI",
				"size": { "height": 23 },
				style: {
					height: '21px',
					display: 'block',
					borderTopColor: 'transparent',
					borderTopWidth: '1px',
					borderTopStyle: 'solid',
					borderBottomColor: 'transparent',
					borderBottomWidth: '1px',
					borderBottomStyle: 'solid',
					backgroundImage: 'none',
					backgroundColor: 'transparent'
				},
				subviews: [
					{
						"$type": "Label",
						"$domain": "Core.UI",
						"position": { "left": 23, "top": 2 },
						"size": { "width": 160, "height": 18 },
						"text": "Row",
						"style": { "fontSize": "13px", "color": "", "overflow": "hidden" },
						"selectedStyle": { "color": "white" },
						"selectedStyleWithoutFocus": { "color": "white" }
					}
				],
				oddBackgroundColor:'rgba(255,255,255,.12)',
			};
			
			if (this.hasSourceStyle) {
				
				cellPrototype.selectedStyle = { 
						"borderTopColor" : "rgb(0,105,217)",
						"borderBottomColor" : "rgb(0,105,217)",
						"backgroundImage" : "-webkit-linear-gradient(rgb(0,105,217), rgb(0,105,217))",
						"fontWeight" : "bold",
						"textShadow" : "0 1px 2px rgba(0,0,0,.4)",
						"color": "#fff"
				};
				cellPrototype.selectedStyleGraphite = {
						"borderTopColor" : "rgb(153,153,158)",
						"borderBottomColor" : "rgb(153,153,158)",
						"backgroundImage" : "-webkit-linear-gradient(rgb(153,153,158), rgb(153,153,158))",
						"fontWeight" : "bold",
						"textShadow" : "0 1px 2px rgba(0,0,0,.4)"
	
				};
				

















				
				
				
				cellPrototype.selectedStyleWithoutFocus = {
						"borderTopColor" : "rgb(190,194,202)",
						"borderBottomColor" : "rgb(154,159,167)",
						"backgroundImage" : "-webkit-linear-gradient(rgb(199,203,210), rgb(175,180,189))",
						"fontWeight" : "bold",
						"textShadow" : "0 1px 2px rgba(0,0,0,.4)"
				};
			}
			else {
				cellPrototype.selectedStyle = {
					"backgroundColor": "rgb(56,117,215)"
				};
				cellPrototype.selectedStyleGraphite = {
					"backgroundColor": "rgb(175,180,189)"
				};
				cellPrototype.selectedStyleWithoutFocus = {
					"backgroundColor": "#ccc"
				};
				cellPrototype.subviews[0].selectedStyleWithoutFocus = {
					"color": "#000"
				};
			}
			
			return cellPrototype;
			
		}});
	

OutlineView.prototype.prepareOutlineViewRow = function OutlineView__prepareOutlineViewRow(rowView, index, context, parent, item, rowContentView) {
	
		rowView.indexPath = { section: 0, item: index };
		
		if (rowView.isCaption || rowView.isSeparator) return;
	
		this.prepareRow(rowView, context);

		var level = rowView._level,
			isExpandable = this._dataSource.isItemExpandable(item),
			isCollapsable = !this._dataSource.isItemCollapsable || this._dataSource.isItemCollapsable(item);
		

		if (isExpandable &&
			isCollapsable &&
			this._dataSource.numberOfChildrenOfItem(item) > 0) {
			this.addDisclosureTriangle(item, rowView);
		}
		
		var leftMargin = level * this.levelDeltaX;
		rowContentView.position.left = leftMargin;
		rowContentView.size.width -= leftMargin;

		this.style({ 'overflow-y': 'auto' });
		};
	

OutlineView.prototype.addDisclosureTriangle = function OutlineView__addDisclosureTriangle(item, rowView) {

		var level = rowView._level;

		var triangle = createComponentFromDomain("DisclosureTriangle", "Core.UI", this.context, {
			position: { left: level*this.levelDeltaX + 5, top: parseInt(rowView.size.height/2)-9 },
			delegate: {
				disclosureTriangleDidChange: function (dt) {
					this.outlineView.expandOrCollapseItem(this.item);
				},
				item: item,
				outlineView: this
			},
			colorStyle: this.disclosureTriangleColorStyle})
		;
		
		rowView.addSubview(triangle);
		rowView._disclosureTriangle = triangle;
};
	


	
	
	Object.defineProperty(OutlineView.prototype, "dataSource", {
		get: function () { return this._dataSource; }, 
		set: function (v) {
			if (!v
				|| !v.numberOfChildrenOfItem
				|| !v.isItemExpandable
				|| !v.childWithIndexOfItem
				) {
				console.warn('The OutlineView\'s data source does not implement all methods required by the protocol.');
				return;
			}
			this._dataSource = v;
			this.reloadItem(null);
		}});
	

	Object.defineProperty(OutlineView.prototype, "selectedIndices", {});
	

	Object.defineProperty(OutlineView.prototype, "selectedIndexPaths", {
		get: function() {
			var r = [];
			if (Array.isArray(this.selectedIndices)) this.selectedIndices.every(function (index) {
				r.push({
					item: index,
					section: 0
				});return true; }, this);
			
			return r;
		}, 
		set: function (v) {
			this.selectedIndices = [];
			if (Array.isArray(v)) v.every(function (indexPath) {
				this.selectedIndices.push(v.item);return true; }, this);
			
		}});
	

	Object.defineProperty(OutlineView.prototype, "rowOffsetY", {
		value: 1});
	
	
	
	

OutlineView.prototype.showInsertIndicatorBelowRow = function OutlineView__showInsertIndicatorBelowRow(row, validRow) {
		var x = validRow.contentView.position.left,
			y = row.position.bottom,
			width = validRow.size.width;

		if (this.rowIsExpanded(row)) {
			x += this.levelDeltaX;
		}
			
		this.showInsertIndicatorWithParams(x, y, width);};
	

OutlineView.prototype.dropIsValidAboveRow = function OutlineView__dropIsValidAboveRow(e, row) {
		var parentRow = this.parentRowForRow(row),
			item = parentRow ? parentRow.dataset : null,
			index = row ? row.tag : 0;

		var valid = this.dropIsValid(e, item, index);
		return valid ? [valid,row] : null;};
	

OutlineView.prototype.dropIsValidBelowRow = function OutlineView__dropIsValidBelowRow(e, row, cascading) {

		var item, index, valid;
	
		if (!cascading && this.rowIsExpanded(row)) {
			item = row.dataset;
			index = 0;
			valid = this.dropIsValid(e, item, index);
			return valid ? [valid,row] : null;
		}
		
		var parentRow = this.parentRowForRow(row);
		item = parentRow ? parentRow.dataset : null;
		index = row ? row.tag+1 : 0;
		valid = this.dropIsValid(e, item, index);
		if (!valid) {
			var isLastRow = (row && row.dataset && row.dataset.nextSibling === undefined);
			
			if (isLastRow)
				return this.dropIsValidBelowRow(e, parentRow, true);
			return false;
		}
		return [valid,row];
		};
	
	
OutlineView.prototype.dropIsValid = function OutlineView__dropIsValid(e, item, index) {
		valid = this.dataSource.validateDropInItemWithIndex(e, item, index);
		
		if (valid) {
			this._currentDropItem = item;
			this._currentDropIndex = index;
		}
		else this._currentDropIndex = -2;
		
		return valid;};
	

OutlineView.prototype.dropIsValidAtRow = function OutlineView__dropIsValidAtRow(e, row) {
		var valid = this.dataSource.validateDropInItemWithIndex(e, row.dataset, -1);
		if (valid) {
			this._currentDropItem = row.dataset;
			this._currentDropIndex = -1;
		}
		else this._currentDropIndex = -2;
		return valid;};
	

OutlineView.prototype.unspecificDropIsValid = function OutlineView__unspecificDropIsValid(e) {
		return this.dataSource.validateUnspecificDrop(e);};
	
	
OutlineView.prototype.didDropWithEvent = function OutlineView__didDropWithEvent(e, dropEffect) {
		__super.prototype.didDropWithEvent.call(this, e);
		if (!this.dataSource.handleDropInItemWithIndex) return false;
		var r = this.dataSource.handleDropInItemWithIndex(e, this._currentDropItem, this._currentDropIndex, dropEffect);
		this._currentDropItem = null;
		this._currentDropIndex = -1;
		return r;};
	
	
OutlineView.prototype.parentRowForRow = function OutlineView__parentRowForRow(row) {
		if (!row) return null;
		return row._parentRow;};
	


	

	Object.defineProperty(OutlineView.prototype, "rowType", {
		value: { $type: 'OutlineViewRowView', $domain: "Core.UI" }});
	
	
	
	

OutlineView.prototype.styleRowForDragging = function OutlineView__styleRowForDragging(row) {
		__super.prototype.styleRowForDragging.call(this, row);
		if (row.disclosureTriangle)
			row.disclosureTriangle.hidden = true;};
	
	
OutlineView.prototype.styleSeparatorRow = function OutlineView__styleSeparatorRow(row) {
		return;
		var color;
		
		if (this.hasSourceStyle) {
			color = window.hasFocus ? 'rgb(169,183,201)' : 'rgba(0,0,0,.2)';
		} else color = window.hasFocus?'rgba(0,0,0,.1)':'rgba(0,0,0,.1)';
		
		if (this.separatorColor) color = this.separatorColor;
		
		row.subviews[0].style({ backgroundColor: color });};
	
	
OutlineView.prototype.styleCaptionRow = function OutlineView__styleCaptionRow(row) {
		var color = window.hasFocus ? 'rgb(112,126,149)' : 'rgb(134,139,150)'
		row.subviews[0].style({
			color: color
		});};
	

OutlineView.prototype.windowFocusDidChange = function OutlineView__windowFocusDidChange() {
		__super.prototype.windowFocusDidChange.call(this);
		if (Array.isArray(this.subviews)) this.subviews.every(function (rowView) {
			if (rowView.isSeparator)
				this.styleSeparatorRow(rowView);
			if (rowView.isCaption)
				this.styleCaptionRow(rowView);return true; }, this);
		};
	
	
	
	

	Object.defineProperty(OutlineView.prototype, "targetIndicatorTop", {
	configurable: true, 
		value: 0});
	

OutlineView.prototype.clearData = function OutlineView__clearData() {
	
		if (!this.subviews) return;
	
		
		var subviews = clone(this.subviews);
		for (var i = 0, c = this.subviews.length; i !== c; i++) {
			if (subviews[i] === this._listHeaderView) continue;
		
			var doNotDestroy = (
				subviews[i] === this._listHeaderView ||
				subviews[i] === this._listFooterView);

			subviews[i].removeFromSuperview(doNotDestroy);
		}
		
		this.selectedIndexPaths = [];
		
		this.clearDynamicBindings();};
	

OutlineView.prototype.initPropertiesFromData = function OutlineView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("hasSourceStyle")) this.hasSourceStyle = data.hasSourceStyle;
if (data.hasOwnProperty("drawsFancySelectionGradient")) this.drawsFancySelectionGradient = data.drawsFancySelectionGradient;
};

OutlineView.prototype.decodeData = function OutlineView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

OutlineView.prototype.encode = function OutlineView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

OutlineView.prototype.encodeCloned = function OutlineView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

OutlineView.prototype.expectedTypeForProperty = function OutlineView_expectedTypeForProperty(key) {
	if (key === "expandedRows") return "";
	if (key === "rowViewForItemId") return "";
	if (key === "selectedIndices") return "";
	if (key === "hasSourceStyle") return "";
	if (key === "drawsFancySelectionGradient") return "";
	if (key === "disclosureTriangleColorStyle") return "";
	if (key === "defaultCellPrototype") return "";
	if (key === "dataSource") return "";
	if (key === "selectedIndices") return "";
	if (key === "selectedIndexPaths") return "";
	if (key === "rowOffsetY") return "";
	if (key === "rowType") return "";
	if (key === "targetIndicatorTop") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return OutlineView; }()));
registerType('Core.UI', (function () { function OutlineViewRowView() {} var __super = setSupertypeFromDomain(OutlineViewRowView, 'ListViewRowView', 'Core.UI');

	Object.defineProperty(OutlineViewRowView.prototype, "level", {
	outlet: true, 
	synthesized: true, 
	enumerable: true, get:function () { return this._level; }, set:function (v) {if (!Object.hasOwnProperty(this, "_level")) Object.defineProperty(this, "_level", { writable: true, configurable: true }); this._level = v; }});
	

	Object.defineProperty(OutlineViewRowView.prototype, "parentRow", {
	outlet: true, 
	synthesized: true, get:function () { return this._parentRow; }, set:function (v) {if (!Object.hasOwnProperty(this, "_parentRow")) Object.defineProperty(this, "_parentRow", { writable: true, configurable: true }); this._parentRow = v; }});
	
	
	Object.defineProperty(OutlineViewRowView.prototype, "disclosureTriangle", {
		get: function () {
			return this.subviews[1];
		}});
	

OutlineViewRowView.prototype.initPropertiesFromData = function OutlineViewRowView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("level")) this.level = data.level;
if (data.hasOwnProperty("parentRow")) this.parentRow = data.parentRow;
};

OutlineViewRowView.prototype.decodeData = function OutlineViewRowView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

OutlineViewRowView.prototype.encode = function OutlineViewRowView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

OutlineViewRowView.prototype.encodeCloned = function OutlineViewRowView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

OutlineViewRowView.prototype.expectedTypeForProperty = function OutlineViewRowView_expectedTypeForProperty(key) {
	if (key === "level") return "";
	if (key === "parentRow") return "";
	if (key === "disclosureTriangle") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return OutlineViewRowView; }()));