
registerType('Core.UI', (function () { function PopUpButton() {} var __super = setSupertypeFromDomain(PopUpButton, 'View', 'Core.UI');

PopUpButton.prototype.initFromData = function PopUpButton_initFromData(data, holdBindings) {
	
		if (!__super.prototype.initFromData.call(this, data, 'select', true))
			return;
		
		['localizeItems', 'items', 'target', 'method','value'].every(function (option) {
			if (data[option] !== undefined)
				this[option] = data[option];return true; }, this);
		

		this.DOMNode.addEventListener('change', this.onChange.bind(this));
		
		
        
		this.DOMNode.onmouseup = function (e) {
			if (document.activeElement !== this) {
				if (this.size > 1) return;
				this.style.outline = 'none';
				var activeElement = document.activeElement;
				setTimeout(function () {
                    if (activeElement !== document.body) {
                        activeElement.focus();
                    } else {
                        this.blur();
                    }
					this.style.outline = '';
				}.bind(this));
			}
		};
		
		if (holdBindings !== true) this.applyBindings(true);
		
		return this;
};
	


	

PopUpButton.prototype.onChange = function PopUpButton__onChange(e) {
	
		var value;
		for (var i = 0, c = this.DOMNode.childNodes.length; i < c; i++) {
			var option = this.DOMNode.childNodes[i];
			if (option.value === this.DOMNode.value) {
				value = this.items[option.tag];
				if (Array.isArray(value)) value = value[0];
				break;
			}
		}
		
		this._value = value;
		this.context.broadcastValueChangeForKeyPathInObject('value', this, this);
		if (this.target) {
			this.target[this.method](this);
		}};
	


	

PopUpButton.prototype.valueShouldChangeForKeyPath = function PopUpButton_valueShouldChangeForKeyPath(value, keyPath) {
		
		if (keyPath === 'value' || keyPath === 'items') {
			this[keyPath] = value;
			return true;
		}
		
		return false;
	};
	


	

	var loc = function (dict) {
		return dict[window.language] || dict['en'];
	};

	Object.defineProperty(PopUpButton.prototype, "items", {
	enumerable: true, 
		set: function (v) {

			Object.defineProperty(this, '_items', {
				value: v, writable: true
			});
			
			if (!this.DOMNode) return;
			
			if (this.DOMNode.childNodes.length !== 0)
				this.DOMNode.innerHTML = '';


			
			
			
			var i = 0;
			if (Array.isArray(v)) v.every(function (item) {
			
				if(item === '-') {
					var seperator = document.createElement('hr');
					this.DOMNode.appendChild(seperator);
					seperator.tag = i;
					i++;
					return true;
				}

				var option = document.createElement('option');
				if (Array.isArray(item)) {
					option.value = item[0]||'';
					if (this.localizeItems === true) {
						option.textContent = LocalizedString(item[1]);
					}
					else {
						if (typeof item[1] === 'string')
							option.textContent = item[1];
						if (typeof item[1] === 'object' && item[1] !== null)
							option.textContent = loc(item[1]);
					}
				}
				else {
					option.value = item;
					if (this.localizeItems === true)
						option.textContent = LocalizedString(item);
					else
						option.textContent = item;
				}
				option.tag = i;
				this.DOMNode.appendChild(option);
				i++;
return true; }, this);
			
			
			if (this._value !== undefined)
				this.value = this._value;
		}, 
		get: function () { return this._items; }});
	

    Object.defineProperty(PopUpButton.prototype, "value", {
    synthesized: true, 
    enumerable: true, 
        set: function (value) {if (!Object.hasOwnProperty(this, "_value")) Object.defineProperty(this, "_value", { writable: true, configurable: true });
        	this._value = value;
        	
        	if (value === undefined) value = '';
        	if (this.DOMNode) this.DOMNode.value = value;
        }, get:function () { return this._value; }});
    

	Object.defineProperty(PopUpButton.prototype, "disabled", {
	enumerable: true, 
		set: function (v) {
			this.DOMNode.disabled = v;
		}, 
		get: function () {
			return this.DOMNode.disabled;
		}});
	
	

PopUpButton.prototype.expectedTypeForProperty = function PopUpButton_expectedTypeForProperty(key) {
	if (key === "items") return "";
	if (key === "value") return "";
	if (key === "disabled") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return PopUpButton; }()));