
registerType('Core.UI', (function () { function SegmentedViewController() {} var __super = setSupertypeFromDomain(SegmentedViewController, 'ViewController', 'Core.UI');


SegmentedViewController.prototype.initFromData = function SegmentedViewController_initFromData(data) {

		if (!__super.prototype.initFromData.call(this, data))
			return;

		if (this.view === undefined) this.createView();
		this.view.size = data.size;
		this.view.position = data.position;
		this.view.autoresizingMask = (1 << 1) | (1 << 4);
		this.segments = data.segments;
		

		var offset;
		
		if (data.segmentedControl) {
			this.segmentedControl = data.segmentedControl;
			this.segmentedControl.delegate = this;
			offset = 0;
		}
		else {
			this.segmentedControl = this.context.decodeObjectTree(
				this.createSegmentedControlData()
			);
			this.view.addSubview(this.segmentedControl);
			offset = 32;
		}

		if (data.contentView) {
			this.contentView = data.contentView;
		}
		else {
			this.contentView = this.context.decodeObjectTree({
				$type: 'View',
				$domain: 'Core.UI',
				size: {
					width: this.view.size.width,
					height: this.view.size.height - offset
				},
				position: { top: offset },
				autoresizingMask: (1 << 1) | (1 << 4),
				adjustsSubviewToFitWidth: true
			}, this.context);
	
			this.view.addSubview(this.contentView);
		}
		
		if (typeof data.selectedIndex === 'number')
			this.selectedIndex = data.selectedIndex;

		return this;};
	
	
SegmentedViewController.prototype.createSegmentedControlData = function SegmentedViewController__createSegmentedControlData() {
	
		return {
			$type: 'SegmentedControl',
			$domain: 'Core.UI',
			segments: this.segments,
			size: { width: this.view.size.width },
			position: {},
			delegate: this,
			autoresizingMask: (1 << 1),
		};

};
	


	
	
SegmentedViewController.prototype.viewDidLoad = function SegmentedViewController_viewDidLoad(view) {
		__super.prototype.viewDidLoad.call(this, view);
		if (view === this.view) {
			this.segmentedControlDidChangeValue(this.segmentedControl);
		}};
	

SegmentedViewController.prototype.viewDidAppear = function SegmentedViewController_viewDidAppear(view) {};
	

SegmentedViewController.prototype.loadSegmentAtIndex = function SegmentedViewController__loadSegmentAtIndex(index) {

		var segmentData = this.segments[index],
			currentView = this.contentView.subviews[0],
			segmentController,
			segmentView;
		
		if (!segmentData) return;

		if (currentView !== undefined) {
			currentView.removeFromSuperview(true);
		}
		
		if (!this.segmentControllers) this.segmentControllers = [];
		segmentController = this.segmentControllers[index];
		
		if (segmentController === undefined) {
			segmentController = this.context.decodeObjectTree(clone(segmentData), this.context);
			this.segmentControllers[index] = segmentController;
			segmentController.loadView();
			segmentController.viewDidLoad();
		}
		
		this.currentSegmentController = segmentController;
		
		segmentView = segmentController.view;
		this.contentView.addSubview(segmentView);
		
		var size = this.contentView.sizeCopy;
		size.height -= 3;
		
		segmentView.size = size;
		segmentView.autoresizingMask = 18;
};
	
	

	
	
// role SegmentedControlDelegate (Core.UI) 
SegmentedViewController.prototype.segmentedControlDidChangeValue = function SegmentedViewController_segmentedControlDidChangeValue(sc) {
			if (!sc) console.trace();
			this.loadSegmentAtIndex(sc.selectedIndex);
			this.callDelegate('segmentedViewControllerDidLoadViewAtIndex', [this, sc.selectedIndex]);};
		
	


	

	Object.defineProperty(SegmentedViewController.prototype, "selectedIndex", {
		set: function (value) {
			this.segmentedControl.selectedIndex = value;
		}, 
		get: function () {
			return this.segmentedControl.selectedIndex;
		}});
	

SegmentedViewController.prototype.expectedTypeForProperty = function SegmentedViewController_expectedTypeForProperty(key) {
	if (key === "selectedIndex") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SegmentedViewController; }()));