
registerType('Core.UI', (function () { function SmartScalingImage() {} var __super = setSupertypeFromDomain(SmartScalingImage, 'View', 'Core.UI');

	Object.defineProperty(SmartScalingImage.prototype, "_canvas", {
	synthesized: true, get:function () { return this.__canvas; }, set:function (v) {if (!Object.hasOwnProperty(this, "__canvas")) Object.defineProperty(this, "__canvas", { writable: true, configurable: true }); this.__canvas = v; }});
	

	Object.defineProperty(SmartScalingImage.prototype, "_image", {
	synthesized: true, get:function () { return this.__image; }, set:function (v) {if (!Object.hasOwnProperty(this, "__image")) Object.defineProperty(this, "__image", { writable: true, configurable: true }); this.__image = v; }});
	

	Object.defineProperty(SmartScalingImage.prototype, "contentMode", {
	synthesized: true, get:function () { return this._contentMode; }, set:function (v) {if (!Object.hasOwnProperty(this, "_contentMode")) Object.defineProperty(this, "_contentMode", { writable: true, configurable: true }); this._contentMode = v; }});
	
	
	Object.defineProperty(SmartScalingImage.prototype, "encodesSubviews", {
		value: false});
	


	

SmartScalingImage.prototype.initFromData = function SmartScalingImage_initFromData(data) {

		if (!__super.prototype.initFromData.call(this, data))
			return;
			
		this.contentMode = data.contentMode;
		
		var canvas = document.createElement('canvas');
		this._canvas = canvas;
		
		
		if (this.context.highResolutionEnabled === true) {
			canvas.width = this._size.width*2;
			canvas.height = this._size.height*2;
			canvas.style.width = this._size.width+'px';
			canvas.style.height = this._size.height+'px';
			this.contentInset = [];
			if (Array.isArray(data.contentInset)) data.contentInset.every(function (v) {
				this.contentInset.push(v*2);return true; }, this);
			
		}
		else {
			canvas.width = this._size.width;
			canvas.height = this._size.height;
			this.contentInset = data.contentInset;
		}
		this.DOMNode.appendChild(canvas);
		this.redraw();

		this.imageSrc = data.imageSrc;

		return this;};
	
	
	
	
	

SmartScalingImage.prototype.drawSlice = function SmartScalingImage__drawSlice(ctx, img, sx,sy,swidth,sheight,x,y,width,height) {

			if (this.contentMode === 'repeat') {
				var _x = x, endX = x+width;
				while (_x < endX) {
					var _y = y, endY = y+height;
					while (_y < endY) {
						var w = Math.min(swidth, endX-_x), h = Math.min(sheight, endY-_y);
						ctx.drawImage(img,
							sx, sy, 
							w, h, 
							_x, _y, 
							w, h); 
						_y += sheight;
					}
					_x += swidth;
				}
			}
			else {
				ctx.drawImage(img,
					sx, sy, 
					swidth, sheight, 
					x, y, 
					width, height); 
			}
	};
	

SmartScalingImage.prototype.redraw = function SmartScalingImage_redraw() {
		
		
		if (this._image === undefined)
			return;

		var canvas = this._canvas,
			ctx = canvas.getContext('2d'),
			inset = this.contentInset,
			imgWidth = this._image.width,
			imgHeight = this._image.height;

		
		ctx.clearRect(0, 0, canvas.width, canvas.height);
		
		if (inset.length === 4) { 

			var column1Width = inset[0],
				column2Width = inset[1],
				column3Width = (imgWidth-column1Width-column2Width),
				row1Height = inset[2],
				row2Height = inset[3],
				row3Height = (imgHeight-row1Height-row2Height);
				

			
			ctx.drawImage(this._image,
				0, 0, 
				column1Width, row1Height, 
				0, 0, 
				column1Width, row1Height); 
	
			
			this.drawSlice(ctx, this._image,
				column1Width, 0, 
				column2Width, row1Height, 
				column1Width, 0, 
				canvas.width - column1Width - column3Width, row1Height); 
			
			
			ctx.drawImage(this._image,
				column1Width + column2Width, 0, 
				column3Width, row1Height, 
				canvas.width - column3Width, 0, 
				column3Width, row1Height 
			);

			
			this.drawSlice(ctx, this._image,
				0, row1Height, 
				column1Width, row2Height, 
				0, row1Height, 
				column1Width, canvas.height - row1Height - row3Height); 

			
			this.drawSlice(ctx, this._image,
				column1Width, row1Height, 
				column2Width, row2Height, 
				column1Width, row1Height, 
				canvas.width - column1Width - column3Width,
				canvas.height - row1Height - row3Height); 

			
			this.drawSlice(ctx, this._image,
				imgWidth - column3Width, row1Height, 
				column3Width, row2Height, 
				canvas.width-column3Width, row1Height, 
				column1Width, canvas.height - row1Height - row3Height); 

			
			ctx.drawImage(this._image,
				0, row1Height + row2Height, 
				column1Width, row3Height, 
				0, canvas.height - row3Height, 
				column1Width, row3Height 
			);

			
			this.drawSlice(ctx, this._image,
				column1Width, row1Height + row2Height, 
				column2Width, row3Height, 
				column1Width, canvas.height - row3Height, 
				canvas.width - column1Width - column3Width, row3Height); 

			
			ctx.drawImage(this._image,
				column1Width + column2Width, row1Height + row2Height, 
				column3Width, row3Height, 
				canvas.width - column3Width, canvas.height - row3Height, 
				column3Width, row3Height 
			);

		}};
	


	

SmartScalingImage.prototype.viewDidResize = function SmartScalingImage_viewDidResize() {
		if (!this._canvas) return;

		if (this.context.highResolutionEnabled === true) {
			this._canvas.width = this._size.width*2;
			this._canvas.height = this._size.height*2;
			this._canvas.style.width = this._size.width+'px';
			this._canvas.style.height = this._size.height+'px';
		}
		else {
			this._canvas.width = this.size.width;
			this._canvas.height = this.size.height;
		}
		this.redraw();};
	


	
	
	Object.defineProperty(SmartScalingImage.prototype, "imageSrc", {
	enumerable: true, 
		get: function () { return this._imageSrc; }, 
		set: function (v) {

			v = this.context.pathForOptimizedImage(v);

			Object.defineProperty(this, '_imageSrc', { value: v, writable: true });
			
			this.context.whenImageIsReady(v, function (img) {
				this._image = img;
				this.redraw();
			}.bind(this));
		
		}});
	

SmartScalingImage.prototype.expectedTypeForProperty = function SmartScalingImage_expectedTypeForProperty(key) {
	if (key === "contentMode") return "";
	if (key === "encodesSubviews") return "";
	if (key === "imageSrc") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SmartScalingImage; }()));