
registerType('Core.UI', (function () { function SplitView() {} var __super = setSupertypeFromDomain(SplitView, 'View', 'Core.UI');

SplitView.prototype.initFromData = function SplitView_initFromData(data) {
	
		if (!__super.prototype.initFromData.call(this, data))
			return;

		this.isVertical = data.isVertical;
		this.autoresizingDisabledOnViews = data.autoresizingDisabledOnViews || [];
		this.minimumSizesForViews = data.minimumSizesForViews || [];
		this.maximumSizesForViews = data.maximumSizesForViews || [];
		this.dividerStyle = data.dividerStyle;
		this.collapsedViews = data.collapsedViews || [];
		this.viewsToLayout = [];

		Object.defineProperty(this, "_dividers", {
			value: []});
		
};
	
	
	var thickDividerSize = 10;
	var thinDividerSize = 0;
	
	var dividerThickness = thickDividerSize+1,
		dividerThickness_2 = Math.ceil(dividerThickness/2);
	
SplitView.prototype.prepare = function SplitView__prepare() {
	
		if (this.isPrepared === true) return;
		this.isPrepared = true;

		var flexibleBit;


		function viewIsFlexible(view) {
			return (view.autoresizingMask & flexibleBit) !== 0;
		}
		
		var flexibleViewFollowsAfter = function flexibleViewFollowsAfter(view) {
			var subviews = this.viewsToLayout,
				subviewIndex = subviews.indexOf(view);
			
			for (var i = subviewIndex + 1, c = subviews.length; i < c; i++) {
				if (viewIsFlexible(subviews[i])) {
					return true;
				}
			}
			return false;
		}.bind(this);


		this.fixedViews = [];
		this.flexibleViews = [];
		this.autoresizingViews = [];
		this.autoresizingViewSizeRatios = [];
		this.viewsToLayout = clone(this.subviews);
		this.dividers = [];

		
		
		
		if (this.isVertical === true) {
			this.fillSizeProperty = 'height';
			this.modeSizeProperty = 'width';
			this.modePositionProperty = 'left';
			flexibleBit = 2;
		} else {
			this.fillSizeProperty = 'width';
			this.modeSizeProperty = 'height';
			this.modePositionProperty = 'top';
			flexibleBit = 16;
		}

		

		if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {
		
			
			
			if (viewIsFlexible(subview)) {
				this.flexibleViews.push(subview);		
				if (this.autoresizingDisabledOnViews.indexOf(this.subviews.indexOf(subview)) === -1)
					this.autoresizingViews.push(subview);
			} else {
				this.fixedViews.push(subview);
			}

			
			
			if (!subview.DOMNode.style.overflowX)
				subview.DOMNode.style.overflowX = 'hidden';
			if (!subview.DOMNode.style.overflowY)
				subview.DOMNode.style.overflowY = 'hidden';
return true; }, this);
		
		
		
		
		if (this.autoresizingViews.length === 0) {
			this.autoresizingViews = this.fixedViews;
			this.fixedViews = [];
		}
		
		
		
		this.calculateSizeRatios();
		
		
		
		for (var i = 0, c = this.viewsToLayout.length - 1; i < c; i++) {

			var view = this.viewsToLayout[i];


			var dividerSize = {},
				dividerImageSrc;
			
			dividerSize[this.modeSizeProperty] = dividerThickness;
			dividerSize[this.fillSizeProperty] = this.size[this.fillSizeProperty];
			
			var divider = createComponentFromDomain("ImageView", "Core.UI", this.context, {
				size: dividerSize,
				tag: i,
				imageSrc: '',
				contentMode: 'scaleToFill'})
			;
			
			if (this.dividerStyle == 'thick') {

				var dividerButton = createComponentFromDomain("ImageView", "Core.UI", this.context, {
						size: { width: 7, height: 6 },
						position: { left: this.size[this.fillSizeProperty]/2-4, top: 2 },
						autoresizingMask: (1 << 0) + (1 << 2),
						imageSrc: this.context.pathForResource('DividerThickButton.png'),
						contentMode: 'center'
					});
				divider.addSubview(dividerButton);
			
			}

			this.dividers.push(divider);
			this.addSubview(divider);
			
			if (viewIsFlexible(view) && flexibleViewFollowsAfter(view)) {
				
				divider.DOMNode.onmousedown = this.dividerOnMouseDown.bind({
					splitView: this,
					divider: divider
				});

				divider.DOMNode.onmouseover = this.dividerOnMouseOver.bind({
					splitView: this,
					divider: divider,
					view: view
				});

				divider.DOMNode.onmouseout = this.dividerOnMouseOut.bind({
					splitView: this,
					divider: divider
				});

			}
			else {
				divider.style({ pointerEvents: 'none' });
			}
			
			this.updateStyle();
			
		}
};
	
	
SplitView.prototype.calculateSizeRatios = function SplitView__calculateSizeRatios() {
		var autoresizingViewSizeSum = 0;
		this.autoresizingViewSizeRatios = [];

		if (Array.isArray(this.autoresizingViews)) this.autoresizingViews.every(function (subview) {
			if (this.viewIsCollapsed(subview)) return true;
			autoresizingViewSizeSum += subview.size[this.modeSizeProperty];return true; }, this);
		

		if (Array.isArray(this.autoresizingViews)) this.autoresizingViews.every(function (subview) {
			this.autoresizingViewSizeRatios.push(subview.size[this.modeSizeProperty] / autoresizingViewSizeSum);return true; }, this);
		};
	
	
SplitView.prototype.updateStyle = function SplitView__updateStyle() {
		if(!this.dividers) {
			return
		}
		
		for (var i = 0, c = this.dividers.length; i < c; i++) {
			if (this.dividerStyle == 'thick') {
				if(this.context.themeName == 'dark') {
					this.dividers[i].imageSrc = this.isVertical ? this.context.pathForResource("DividerThick.png") : this.context.pathForResource("DividerThickHor.png");
				} else {
					this.dividers[i].imageSrc = this.isVertical ? this.context.pathForResource("DividerThick.png") : this.context.pathForResource("DividerThickHor.png");
				}
			} else {
				if(this.context.themeName == 'dark') {
					this.dividers[i].imageSrc = this.isVertical ? this.context.pathForResource("DividerThinDark.png") : this.context.pathForResource("DividerThinHorDark.png");
				} else {
					this.dividers[i].imageSrc = this.isVertical ? this.context.pathForResource("DividerThin.png") : this.context.pathForResource("DividerThinHor.png");
				}
			}
		}};
	
	
	

SplitView.prototype.layoutSubviews = function SplitView_layoutSubviews() {
		
		if (this.isPrepared !== true) this.prepare();

		var originalSizeValue = this._lastStableContentSize[this.modeSizeProperty],
			sizeValueNow = this.size[this.modeSizeProperty],
			sizeValueDelta = sizeValueNow - originalSizeValue,
			fillSize = this.size[this.fillSizeProperty],
			offset = 0,
			dividerSize = (this.dividerStyle === 'thick' ? thickDividerSize : thinDividerSize),
			lastSubview = this.viewsToLayout[this.viewsToLayout.length-1];

		if (Array.isArray(this.viewsToLayout)) this.viewsToLayout.every(function (subview) {
		
			if (this.viewIsCollapsed(subview))
				return true;
		
			var flexibleViewIndex = this.autoresizingViews.indexOf(subview);
			if (flexibleViewIndex !== -1) {
				subview.size[this.modeSizeProperty] += sizeValueDelta * this.autoresizingViewSizeRatios[flexibleViewIndex];
			}

			subview.position[this.modePositionProperty] = offset;
			subview.size[this.fillSizeProperty] = fillSize;

			offset += subview.size[this.modeSizeProperty];
			offset += dividerSize;
return true; }, this);
		

		this.adjustDividers();
	};
	
	
SplitView.prototype.setSizeForView = function SplitView_setSizeForView(size, view, dontValidate) {
	
		if (dontValidate !== true) {
			var validated = this.validateSizeForView(size, view);
			if (validated < 0)
				return false;
			size = validated;
		}

		view.size[this.modeSizeProperty] = size;

		this.adjustSubviews();
		this.adjustDividers();
		
		return true;
	};
	
	
SplitView.prototype.collapseViewAtIndexAnimated = function SplitView_collapseViewAtIndexAnimated(index, animated) {
		var subview = this.viewsToLayout[index];
		if (!subview) return false;
		return this.collapseViewAnimated(subview, animated);};
	
	
SplitView.prototype.collapseView = function SplitView_collapseView(view) {
		this.collapseViewAnimated(view, false);};
	

SplitView.prototype.collapseViewAnimated = function SplitView_collapseViewAnimated(view, animated) {

		this.prepare();

		var viewIndex = this.viewsToLayout.indexOf(view);
		if (viewIndex === -1) return;
		if (this.viewIsCollapsedAtIndex(viewIndex)) return;
		if (this.isTransitioning) {
			this.scheduleAction('collapse', view, animated);
			return;
		}
		
		this.collapsedViews.push(viewIndex);

		var finish = function () {

			
			
			
			this.calculateSizeRatios();
			
			var viewSize = view.size[this.modeSizeProperty] + this.dividerSizeForView(view),
				i = 0;
	
			if (Array.isArray(this.autoresizingViews)) this.autoresizingViews.every(function (_view) {
				if (_view === view)
					return true;
	
				_view.size[this.modeSizeProperty] += viewSize * this.autoresizingViewSizeRatios[i];

				i++;return true; }, this);
			

			this.layoutSubviews();
		
		}.bind(this);

		if (animated !== true) {
			view.hidden = true;
			finish();
			return;
		}

		
		finish();
		this.isTransitioning = true;

		var divider = this.dividers[viewIndex-1],
			dividerSize = (this.dividerStyle === 'thick' ? thickDividerSize : thinDividerSize),
			position = this._size[this.modeSizeProperty] - view.size[this.modeSizeProperty],
			targetPosition = this._size[this.modeSizeProperty],
			transformProperty = this.isVertical ? 'translateX' : 'translateY',
			animationStyle = {
				webkitTransition: '-webkit-transform .45s ease-in-out',
				webkitTransform: transformProperty+'('+targetPosition+'px)'
			},
			self = this;

		
		view.position[this.modePositionProperty] = position;
		if (divider)
			divider.position[this.modePositionProperty] = position - dividerSize;

		view.size[this.modeSizeProperty] -= 1;
		if (divider)
			divider.size[this.fillSizeProperty] += 1;
		
		
		
		view.style(animationStyle);
		if (divider)
			divider.style(animationStyle);

		
		setTimeout(function () {

			self.isTransitioning = false;

			view.hidden = true;
			if (divider)
				divider.hidden = true;
			
			var animationResetStyle = {
				webkitTransition: '',
				webkitTransform: ''
			};
			
			view.style(animationResetStyle);
			if (divider)
				divider.style(animationResetStyle);
			
			
			
			
			view.size[this.modeSizeProperty] += 1;
			if (divider)
				divider.size[this.fillSizeProperty] -= 1;
			

		}, 600);
		};
	

SplitView.prototype.expandViewAtIndexAnimated = function SplitView_expandViewAtIndexAnimated(index, animated) {
		var subview = this.viewsToLayout[index];
		if (!subview) return false;
		return this.expandViewAnimated(subview, animated);};
	

SplitView.prototype.expandView = function SplitView_expandView(view) {
		this.expandViewAnimated(view, false);};
	
	
SplitView.prototype.expandViewAnimated = function SplitView_expandViewAnimated(view, animated) {
	
		this.prepare();
		this.adjustDividers();

		var viewIndex = this.viewsToLayout.indexOf(view),
			dividerSize = (this.dividerStyle === 'thick' ? thickDividerSize : thinDividerSize);

		if (viewIndex === -1) return;
		if (this.collapsedViews.indexOf(viewIndex) === -1) return;
		if (this.isTransitioning) {
			this.scheduleAction('expand', view, animated);
			return;
		}
		
		this.collapsedViews.splice(this.collapsedViews.indexOf(viewIndex), 1);
		
		var finish = function () {

			
			
			
			var viewSize = view.size[this.modeSizeProperty] + this.dividerSizeForView(view),
				i = 0;
			
			if (Array.isArray(this.autoresizingViews)) this.autoresizingViews.every(function (_view) {
				if (_view === view)
					return true;
				
				_view.size[this.modeSizeProperty] -= viewSize * this.autoresizingViewSizeRatios[i];

				i++;return true; }, this);
			
			this.calculateSizeRatios();
			this.layoutSubviews();


		}.bind(this);
		

		view.hidden = false;


		
		if (animated !== true) {
			finish();
			return;
		}

		
		this.isTransitioning = true;
		view.size[this.fillSizeProperty] += 1;
		
		
		var targetSize = view._size[this.modeSizeProperty],
			transformProperty = this.isVertical ? 'translateX' : 'translateY',
			isFirstSubview = (viewIndex === 0),
			transformOffset = isFirstSubview ? targetSize : -targetSize,
			animationStyle = {
				webkitTransition: '-webkit-transform 0.3s ease-in-out',
				webkitTransform: transformProperty+'('+(transformOffset)+'px)',
				zIndex: 100
			},
			self = this,
			divider = this.dividers[viewIndex-1];
		
		if (isFirstSubview) {
			view.position[this.modePositionProperty] = -view.size[this.modeSizeProperty];
		}
		else {
			
			view.position[this.modePositionProperty] = this._size[this.modeSizeProperty] + viewIndex;
		}
		
		if (divider) {
			divider.size[this.fillSizeProperty] += 1;
			divider.hidden = false;
			divider.position[this.modePositionProperty] = this._size[this.modeSizeProperty] - dividerSize + 1;
		}

		setTimeout(function () {
			view.style(animationStyle);
			if (divider)
				divider.style(animationStyle);
		}, 1);
		
		setTimeout(function () {
			
			self.isTransitioning = false;

			var animationResetStyle = {
				webkitTransition: '',
				webkitTransform: '',
				zIndex: ''
			};
			
			view.style(animationResetStyle);
			if (divider)
				divider.style(animationResetStyle);
			
			
			
			view.size[this.fillSizeProperty] -= 1;
			if (divider)
				divider.size[this.fillSizeProperty] -= 1;


			finish();

		}, 500-50);
};
	

SplitView.prototype.scheduleAction = function SplitView__scheduleAction(actionType, view, animated) {
		setTimeout(function () {
			if (actionType === 'expand')
				this.expandViewAnimated(view, animated);
			else if (actionType === 'collapse')
				this.collapseViewAnimated(view, animated);
		}.bind(this), 600);};
	
	
SplitView.prototype.viewIsCollapsedAtIndex = function SplitView_viewIsCollapsedAtIndex(index) {
		return this.collapsedViews.indexOf(index) !== -1;};
	
	
SplitView.prototype.viewIsCollapsed = function SplitView_viewIsCollapsed(view) {
		return this.viewIsCollapsedAtIndex(this.viewsToLayout.indexOf(view));};
	
	
SplitView.prototype.validateSizeForView = function SplitView__validateSizeForView(size, view, ignoreSiblings) {

		

		var viewIndex = this.viewsToLayout.indexOf(view),
			minimumSize = this.minimumSizesForViews[viewIndex],
			maximumSize = this.maximumSizesForViews[viewIndex];
		
		
		if (minimumSize && size < minimumSize) {
			size = minimumSize;
		}
		else if (maximumSize && size > maximumSize)
			size = maximumSize;


		if (ignoreSiblings === true)
			return size;
		
	
		var totalSize = 0,
			viewSizes = this.viewsToLayout.map(function (view) {
				var s = view._size[this.modeSizeProperty];
				totalSize += s;
				return s;
			}.bind(this)),
			delta;
		

		
		

		delta = size - viewSizes[viewIndex];
		if (delta === 0)
			return size;

		viewSizes[viewIndex] = size;


		
		
		for (var i = viewIndex + 1, c = this.viewsToLayout.length; i < c; i++) {
			var _view = this.viewsToLayout[i];
			if (this.flexibleViews.indexOf(_view) !== -1) {
				var _size = viewSizes[i] - delta,
					validated = this.validateSizeForView(_size, _view, true);
				
				if (validated < 0)
					return -1;
				
				viewSizes[i] = validated;
			}
		}
		
		
		var newTotalSize = 0;
		viewSizes.map(function (num) {
			newTotalSize += num;
		});


		if (newTotalSize > totalSize) {
			return this.validateSizeForView(size-1, view);
		}
		
	
		return size;
	};
	
	

SplitView.prototype.adjustSubviews = function SplitView__adjustSubviews() {
	
		var offset = 0,
			dividerSize = (this.dividerStyle === 'thick' ? thickDividerSize : thinDividerSize);
		
		if (Array.isArray(this.viewsToLayout)) this.viewsToLayout.every(function (subview) {
			var difference = offset - subview._position[this.modePositionProperty];
			if (difference !== 0) {
				if (this.flexibleViews.indexOf(subview) !== -1) {
					subview.position[this.modePositionProperty] += difference;
					subview.size[this.modeSizeProperty] -= difference;
				}
			}
			offset += subview.size[this.modeSizeProperty];
			offset += dividerSize;return true; }, this);
		
	
	};
	
	
SplitView.prototype.adjustDividers = function SplitView__adjustDividers() {
		
		var fillSize = this.size[this.fillSizeProperty],
			dividerOffset = (this.dividerStyle === 'thick' ? 0 : dividerThickness_2-1);

		if (Array.isArray(this.dividers)) this.dividers.every(function (divider) {

			var dividerView = this.subviews[divider.tag];
		
			if (this.viewIsCollapsed(dividerView)) {
				divider.hidden = true;
				return true;
			}
			
			divider.hidden = false;
		
			divider.position[this.modePositionProperty] = dividerView.position[this.modePositionProperty] + dividerView.size[this.modeSizeProperty] - dividerOffset;
			divider.size[this.fillSizeProperty] = fillSize;
			

			var followingView = this.subviews[divider.tag+1];
			if (followingView)
				divider.hidden = followingView.hidden;
return true; }, this);
		
	};
	
	
	var cocoaCursorIdentifiers = {
		'default': '',
		'col-resize': 'resizeLeftRightCursor',
		'row-resize': 'resizeUpDownCursor',
		'n-resize': 'resizeUpCursor',
		's-resize': 'resizeDownCursor',
		'e-resize': 'resizeRightCursor',
		'w-resize': 'resizeLeftCursor',
	};
	
SplitView.prototype.updateCursorForView = function SplitView__updateCursorForView(view) {
	
		var cursorIdentifier = view ? this.cursorForView(view) : 'default',
			cocoaCursorIdentifier = cocoaCursorIdentifiers[cursorIdentifier];
		
		this.context.nativeProxy.sendMessage('forceCursorUpdate', cocoaCursorIdentifier);
		document.body.style.cursor = cursorIdentifier;
};
	

SplitView.prototype.cursorForView = function SplitView__cursorForView(view) {
	
		var viewSize = view.size[this.modeSizeProperty],
			canShrink = this.validateSizeForView(viewSize-1, view) === viewSize - 1,
			canExpand = this.validateSizeForView(viewSize+1, view) === viewSize + 1;
		
		if (canExpand && !canShrink) return this.isVertical ? 'e-resize' : 's-resize';
		if (canShrink && !canExpand) return this.isVertical ? 'w-resize' : 'n-resize';
		
		return this.isVertical ? 'col-resize' : 'row-resize';
		};
	
	
SplitView.prototype.dividerSizeForView = function SplitView__dividerSizeForView(view) {
		var viewIndex = this.viewsToLayout.indexOf(view),
			divider = this.dividers[viewIndex > 0 ? viewIndex-1 : 0];
		
		if (!divider) return 0;
		
		return (this.dividerStyle === 'thick' ? 9 : 1);};
	


	

SplitView.prototype.dividerOnMouseDown = function SplitView__dividerOnMouseDown(e) {
		
		var self = this.splitView,
			divider = this.divider,
			dividerView = self.subviews[divider.tag],
			availableModes,
			x0 = e.x, y0 = e.y,
			width0 = dividerView.size.width,
			height0 = dividerView.size.height,
			deltaX, deltaY;


		e.preventDefault();
		
		if (self.isVertical === true) {
			window.onmousemove = function (e) {
				deltaX = e.x - x0;
				this.setSizeForView(width0 + deltaX, dividerView);
				this.updateCursorForView(dividerView);
			}.bind(self);
		}
		else {
			window.onmousemove = function (e) {
				deltaY = e.y - y0;
				this.setSizeForView(height0 + deltaY, dividerView);
				this.updateCursorForView(dividerView);
			}.bind(self);
		}

		window.onmouseup = function (e) {
			window.onmousemove = null;
			window.onmouseup = null;
			self.mouseIsDown = false;
			self.calculateSizeRatios();	
			if (self.mouseIsOver !== true) {
				self.updateCursorForView(null);
			}
		};	
		
		self.mouseIsDown = true;};
	
	
SplitView.prototype.dividerOnMouseOver = function SplitView__dividerOnMouseOver(e) {
	
		
		if (document.body.style.cursor &&
			document.body.style.cursor !== 'default')
			return;
		
		this.splitView.mouseIsOver = true;
		if (this.splitView.mouseIsDown) return;

		this.splitView.updateCursorForView(this.view);
		};
	

SplitView.prototype.dividerOnMouseOut = function SplitView__dividerOnMouseOut(e) {
		if (!this.splitView.mouseIsOver) return;
		this.splitView.mouseIsOver = false;
		if (this.splitView.mouseIsDown) return;
		this.splitView.updateCursorForView(null);};
	


SplitView.prototype.expectedTypeForProperty = function SplitView_expectedTypeForProperty(key) {
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SplitView; }()));