
registerType('Core.UI', (function () { function SpriteButton() {} var __super = setSupertypeFromDomain(SpriteButton, 'Button', 'Core.UI');


SpriteButton.prototype.initFromData = function SpriteButton_initFromData(data) {

		if (!__super.prototype.initFromData.call(this, data))
			return;

		['highlightOnMouseOver','sprite','keepHighlightedOnMouseOut'].every(function (prop) {
			if (data[prop] !== undefined)
				this[prop] = data[prop];return true; }, this);
		
		
		return this;};
	


	

SpriteButton.prototype.encode = function SpriteButton_encode() {
		return this.context.encodeObject(this, this.DOMNode, ['position','left','top','width','height','right','bottom','backgroundImage','backgroundRepeatX','backgroundRepeatY','backgroundPositionX','backgroundPositionY','backgroundAttachment','backgroundOrigin','backgroundClip','backgroundColor']);};
	;


	

	Object.defineProperty(SpriteButton.prototype, "sprite", {
	enumerable: true, 
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_sprite")) Object.defineProperty(this, "_sprite", { writable: true, configurable: true });
			if (this._sprite === v) return;

			if (this.context.highResolutionEnabled) {
				var highResSrc = v.replace(/.png/, "@2x.png");
				this.style({
					background: 'url('+highResSrc+') 0 0 no-repeat',
					width: this._size.width*2+'px',
					height: this._size.height*2+'px',
					webkitTransform: 'scale(0.5)',
					webkitTransformOrigin: '0 0'
				});
			}
			else {
				this.style({
					background: 'url('+v+') 0 0 no-repeat',
					width: this._size.width+'px',
					height: this._size.height+'px',
					webkitTransform: ''
				});
			}
		
			this._sprite = v;
			
			if (this.DOMNode) {
				
				this.DOMNode.addEventListener('mousedown', function (e) {
				
					this.highlighted = true;
					
					var self = this;
					window.addEventListener('mouseup', function onMouseUp(e) {
						setTimeout(function () {
							self.highlighted = false;
						}, 20);
						window.removeEventListener('mouseup', onMouseUp);
						if (!self.DOMNode) return;
						self.DOMNode.onmouseout = null;
						self.DOMNode.onmouseover = null;
					});
				}.bind(this));
		
				if (this.highlightOnMouseOver) {
					this.DOMNode.addEventListener('mouseover', function (e) {
						this.mouseOver = true;
					}.bind(this));
					this.DOMNode.addEventListener('mouseout', function (e) {
						if (!this.DOMNode) return;
						this.mouseOver = false;
					}.bind(this));
				}
		
				this.DOMNode.onclick = function (e) {
		
					if (this.selectable === true) {
						this.selected = !this.selected;
					}
		
				}.bind(this);
			}
			
			v = null;
		}, get:function () { return this._sprite; }});
	

	Object.defineProperty(SpriteButton.prototype, "selected", {
	enumerable: true, 
		
		set: function (v) {
			if (this._selected === v) return;
			this._selected = v;
	
			if (this._animationInProcess) return;
			
			
			if (v) {
				this.style({
					backgroundPositionY: (-this.contentHeight*2)+'px',
				});
			}
			else {
				this.style({
					backgroundPositionY: 0,
				});
			}
		}, 
		
		get: function () {
			return this._selected;
		}});
	
	
	Object.defineProperty(SpriteButton.prototype, "contentHeight", {
		get: function () {
			var h = this._size.height;
			return this.context.highResolutionEnabled === true ? h*2 : h;
		}});
	

	Object.defineProperty(SpriteButton.prototype, "contentWidth", {
		get: function () {
			var w = this._size.width;
			return this.context.highResolutionEnabled === true ? w*2 : w;
		}});
	
	
	Object.defineProperty(SpriteButton.prototype, "highlighted", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_highlighted")) Object.defineProperty(this, "_highlighted", { writable: true, configurable: true }); this._highlighted = v; this.updateImage(); }, get:function () { return this._highlighted; }});
	
	
	Object.defineProperty(SpriteButton.prototype, "mouseOver", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_mouseOver")) Object.defineProperty(this, "_mouseOver", { writable: true, configurable: true }); this._mouseOver = v; this.updateImage(); }, get:function () { return this._mouseOver; }});
	
	
SpriteButton.prototype.updateImage = function SpriteButton__updateImage() {
		if (!this.DOMNode) return;

		var backgroundPositionY;

		if (this.highlighted === true) {
			if (this.highlightOnMouseOver === true)
				backgroundPositionY =
					(this._selected === true) ? -this.DOMNode.offsetHeight*4
											  :	-this.DOMNode.offsetHeight*2;
			else
				backgroundPositionY =
					(this._selected === true) ? -this.DOMNode.offsetHeight*3
											  :	-this.DOMNode.offsetHeight*1;
		}

		else {
			if (this._animationInProcess === true)
				return;

			if (this.mouseOver === true || (this.keepHighlightedOnMouseOut && this.highlighted)) {
				backgroundPositionY = -this.DOMNode.offsetHeight*1;
			}
			else {

				backgroundPositionY =
					(this._selected === true) ? -this.DOMNode.offsetHeight*2
										  :	0;
										  
			}
		}

		this.style({ backgroundPositionY: backgroundPositionY + 'px' });


	};
	

SpriteButton.prototype.expectedTypeForProperty = function SpriteButton_expectedTypeForProperty(key) {
	if (key === "sprite") return "";
	if (key === "selected") return "";
	if (key === "contentHeight") return "";
	if (key === "contentWidth") return "";
	if (key === "highlighted") return "";
	if (key === "mouseOver") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SpriteButton; }()));