
registerType('Core.UI', (function () { function StackedView() {} var __super = setSupertypeFromDomain(StackedView, 'View', 'Core.UI');

	Object.defineProperty(StackedView.prototype, "areGroupsCollapsable", {
	outlet: true, get:function () { return this._areGroupsCollapsable; }, set:function (v) {if (!Object.hasOwnProperty(this, "_areGroupsCollapsable")) Object.defineProperty(this, "_areGroupsCollapsable", { writable: true, configurable: true }); this._areGroupsCollapsable = v; }});
	

StackedView.prototype.addViewWithTitle = function StackedView_addViewWithTitle(view, title) {
	
		var subview = createComponentFromDomain("View", "Core.UI", this.context, {
				size: view.size,
				autoresizingMask: 2,})
			,
			index = this.subviews.length,
			disclosureLabel = createComponentFromDomain("DisclosureLabel", "Core.UI", this.context, {
				position: { left: 10, top: 8 },
				size: { width: this.size.width - 20, height: 15 },
				autoresizingMask: 2,
				selected: this.callDelegate('viewIsExpandedAtIndex', [index]),
				tag: index,
				delegate: this,
				text: title,
				style: {
					color: '#505050',
					fontSize: '12px',
					fontWeight: 'bold',
					textShadow: '0 1px 0 rgba(255,255,255,.4)'
				}})
			;

		subview.size.height += headerHeight;

		if (title) {
			view.position.top = headerHeight;
			subview.addSubview(disclosureLabel);
		}
		
		subview.addSubview(view);
		
		this.addSubview(subview);


		var isFirstGroup = this.subviews.length === 1;
		if (isFirstGroup) {
			disclosureLabel.disclosureTriangle.hidden = true;
			disclosureLabel.label.position.left = 5;
		}
		
		return subview;
	};
	

StackedView.prototype.arrangeSubviews = function StackedView_arrangeSubviews() {

		var y = 3;
		this.subviews.every(function (subview) {
			subview.position.top = y;
			y += subview.size.height;
			return true;
		});
};
	
	
StackedView.prototype.collapseViewAtIndex = function StackedView_collapseViewAtIndex(index) {
		var subview = this.subviews[index];
		subview.normalHeight = subview.size.height;
		subview.size.height = headerHeight;
		subview.subviews[1].hidden = true;
		this.arrangeSubviews();};
	

StackedView.prototype.expandViewAtIndex = function StackedView_expandViewAtIndex(index) {
		var subview = this.subviews[index];
		subview.size.height = subview.normalHeight;
		subview.subviews[1].hidden = false;
		this.arrangeSubviews();};
	


// role DisclosureTriangleDelegate (Core.UI) 
	
StackedView.prototype.disclosureTriangleDidChange = function StackedView_disclosureTriangleDidChange(disclosureTriangle) {
		
			var index = disclosureTriangle.tag;
	
			if (disclosureTriangle.selected === false) {
				this.collapseViewAtIndex(index);
				this.callDelegate('viewDidCollapseAtIndex', [index]);
			}
			else {
				this.expandViewAtIndex(index);
				this.callDelegate('viewDidExpandAtIndex', [index]);
			}			
};
		
	
	


	var headerHeight = 30;

StackedView.prototype.initPropertiesFromData = function StackedView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("areGroupsCollapsable")) this.areGroupsCollapsable = data.areGroupsCollapsable;
};

StackedView.prototype.decodeData = function StackedView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

StackedView.prototype.encode = function StackedView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

StackedView.prototype.encodeCloned = function StackedView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

StackedView.prototype.expectedTypeForProperty = function StackedView_expectedTypeForProperty(key) {
	if (key === "areGroupsCollapsable") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return StackedView; }()));