
registerType('Core.UI', (function () { function TableView() {} var __super = setSupertypeFromDomain(TableView, 'ListView', 'Core.UI');

	var headerHeight = 16,
		defaultRowHeight = 18,
		selectionActiveColor= '#557bba',
		selectionInactiveColor = 'rgb(212,212,212)';

	function isNumber(x) {
		return typeof x === 'number';
	}
	
	Object.defineProperty(TableView.prototype, "rowHeight", {
	synthesized: true, get:function () { return this._rowHeight; }, set:function (v) {if (!Object.hasOwnProperty(this, "_rowHeight")) Object.defineProperty(this, "_rowHeight", { writable: true, configurable: true }); this._rowHeight = v; }});
	

TableView.prototype.initFromData = function TableView_initFromData(data) {

		if (!__super.prototype.initFromData.call(this, data))
			return;

		this.rowHeight = data.rowHeight || defaultRowHeight;

		if (data.acceptsFocus !== false) this.DOMNode.contentEditable = true;
		this.DOMNode.onfocus = this.viewDidFocus.bind(this);
		this.DOMNode.onblur = this.viewDidBlur.bind(this);
		this.DOMNode.onkeydown = this.keyDownHandler.bind(this);
		
		['columns', 'rowHeight'].every(function (option) {
			if (data[option] !== undefined)
				this[option] = data[option];return true; }, this);
		
		
		this.wrappingView = createComponentFromDomain("View", "Core.UI", this.context, {
			size: {
				width: this._size.width-2,
				height: this._size.height-2
			},
			style: {
				backgroundColor: '#fff',
				borderWidth: '1px',
				webkitBorderImage: 'url('+this.context.pathForResource('TextFieldBorder@2x.png')+') 2 2 2 2 repeat stretch'
			}})
		;
		this.addSubview(this.wrappingView);
		
		this.headerIsHidden = data.headerIsHidden;

		this.initColumnsHeaderView();
		this.initContentView();
		this.layoutSubviews();

		return this;
};
	

TableView.prototype.destroy = function TableView_destroy() {
		window.removeEventListener("didBecomeMain", this._didChangeMainCbk);
		window.removeEventListener("didResignMain", this._didChangeMainCbk);
		__super.prototype.destroy.call(this);};
	

TableView.prototype.windowFocusDidChange = function TableView__windowFocusDidChange() {

		this.drawBackground();
		
		if (Array.isArray(this._selectedRows)) this._selectedRows.every(function (r) {
			this.styleRowView(r);return true; }, this);
		
};
	
	
TableView.prototype.initColumnsHeaderView = function TableView__initColumnsHeaderView() {
	
		var columnsHeaderView = createComponentFromDomain("View", "Core.UI", this.context, {
				size: { height: headerHeight-1, width: this.size.width-2 },
				style: {
						"backgroundImage": "-webkit-linear-gradient(hsl(0,0%,100%) 0%, hsl(0,0%,97%) 48%, hsl(0,0%,93%) 53%, hsl(0,0%,93%) 90%, hsl(0,0%,96%) 100%)",
						"borderBottom": "1px solid hsl(0,0%,75%)",
				},})
			;
			
			columns = this.columns;
			
		
		for (var j = 0, c = columns.length, x = 0; j !== c; j++) {
		
			var text = columns[j].title;
			if (columns[j].localizeTitle) text = LocalizedString(text);

			var columnHeader = this.context.decodeObjectTree({
				$type: "View",
				$domain: "Core.UI",
				size: { height: headerHeight, width: 100 },
				position: { left: x },
				style: {
					borderRight: '1px solid hsla(0,0%,0%,.12)',
				},
				subviews: [
					{
						$type: "Label",
						$domain: "Core.UI",
						text: text,
						position: { left: 10, top: 0 },
						size: { height: headerHeight, width: 86 },
						autoresizingMask: 2,
						numberOfLines: 1,
						style: {
							fontSize: '12px',
							textAlign: columns[j].textAlign || 'left'
						},
						fontSize: 12
					}
				]
			});
			
			columnsHeaderView.addSubview(columnHeader);
			
		}
		
		this.wrappingView.addSubview(columnsHeaderView);
		
	
		Object.defineProperty(this, "_columnsHeaderView", {
			value: columnsHeaderView });
		
};
	

TableView.prototype.initContentView = function TableView__initContentView() {
	
		var contentView = createComponentFromDomain("View", "Core.UI", this.context, {
				type: "View",
				size: {
					height: this.size.height - headerHeight - 2,
					width: this.size.width-2 },
				position: { top: headerHeight },
				style: {
					overflowY: 'auto',
					overflowX: 'hidden',
				}})
			;
		
		this.wrappingView.addSubview(contentView);
		
		contentView.DOMNode.onmousedown = function (e) {
			if (!this.selectable) return;
			if (e.target === contentView.DOMNode &&
				!contentView.mouseEventTargetsScrollbars(e))
				this.unselectAllRows(this);
		}.bind(this);
	
		Object.defineProperty(this, "_contentView", {
			value: contentView});
		
		
		this._backgroundCanvas.style.zIndex = '0';
		
		contentView.DOMNode.insertBefore(this._backgroundCanvas, contentView.DOMNode.firstChild);
		
		this.contentView = contentView;
		};
	

TableView.prototype.layoutSubviews = function TableView__layoutSubviews() {
	
		if (!this.subviews) return;

		var h = this._size.height-2,
			w = this._size.width-2,
			wrappingView = this.subviews[0],
			contentView = this.contentView;
			
		if (!wrappingView) return;

		wrappingView.size.heigth = h;
		wrappingView.size.width = w;
		
		contentView.size.height = h - headerHeight;
		contentView.size.width = w;
		
		this._columnsHeaderView.size.width = w;

		if (this.headerIsHidden) {
			this._columnsHeaderView.hidden = true;
			this.contentView.position.top = 0;
			this.contentView.size.height += headerHeight;
		}
		
		this.recalculateColumnWidths();

		this.drawBackground();

		this.layoutHeader();
		this.layoutRows();
};
	
	
TableView.prototype.layoutHeader = function TableView__layoutHeader() {
	
		var columnWidths = this._columnWidths,
			x = 0, i = 0;

		if (Array.isArray(this._columnsHeaderView.subviews)) this._columnsHeaderView.subviews.every(function (columnHeader) {
			columnHeader.position.left = x;
			columnHeader.size.width = columnWidths[i];
			
			x += columnWidths[i];
			i++;return true; }, this);
		};
	

TableView.prototype.layoutRows = function TableView__layoutRows() {
	
		var contentView = this._contentView,
			columnWidths = this._columnWidths;
		
		if (Array.isArray(contentView.subviews)) contentView.subviews.every(function (rowView) {
			var x = 0, i = 0;
			rowView.size.width = this.size.width-2;
			if (Array.isArray(rowView.subviews)) rowView.subviews.every(function (cellView) {
				cellView.position.left = x;
				cellView.size.width = columnWidths[i];
				x += columnWidths[i];
				i++;return true; }, this);
			return true; }, this);
		
		};
	

	Object.defineProperty(TableView.prototype, "isEditing", {
		get: function () {
			return !!this._editingTextField;
		}});
	


	

TableView.prototype.insertData = function TableView__insertData() {

		var numberOfRows = this.dataSource.numberOfRows();
		
		for (var i = 0; i !== numberOfRows; i++) {
			this.insertRowWithIndex(i);
		}
		};
	

TableView.prototype.insertRowWithIndex = function TableView__insertRowWithIndex(i) {
	
		var columns = this.columns,
			numberOfColumns = columns.length,
			columnWidths = this._columnWidths,
			rowWidth = this.size.width - 2,
			contentView = this._contentView,
			rowHeight = this.rowHeight || defaultRowHeight;
		
		
		var rowView = createComponentFromDomain("View", "Core.UI", this.context, {
			size: { height: rowHeight, width: rowWidth },
			style: {
				zIndex: 1
			}})
		;
		
		var rowData = this._dataSource.dataForRowAtIndex(i);
		this.context.registerGlobal(this.dataSource.$id+'[]', rowData);

		
		for (var j = 0, x = 0; j !== numberOfColumns; j++) {
		
			var dataKeyPath = this._dataSource.bindableDataKeyPathForColumnNameAtRow(columns[j].name, i);
		
		
			var cellView;
			if (columns[j].view) {
				cellView = this.context.decodeObjectTree(clone(columns[j].view, 100));
				cellView.size = {
					width: columnWidths[j],
					height: rowHeight
				};
				cellView.position.left = x;

				this.prepareCellWithDataForIndexPath(cellView,{section:0,item:i});
			} else {
				cellView = this.context.decodeObjectTree({
					$type: "View",
					$domain: "Core.UI",
					size: { width: columnWidths[j], height: rowHeight },
					position: { left: x },
					subviews: []
				});
			}
			
			
			if (!columns[j].view) {
	
				if (columns[j].editable === true) {
			
					var textField = createComponentFromDomain("TextField", "Core.UI", this.context, {
							value: this._dataSource.dataForColumnNameAtRow(
								columns[j].name, i),
							size: { width: columnWidths[j]-10, height: rowHeight-2 },
							autoresizingMask: 2,
							position: { left: 10, top: 1 },
							style: { fontSize: (columns[j].fontSize || 12)+"px", padding: 0, border: 0, backgroundColor: 'transparent', cursor: 'default', pointerEvents: 'none' },
							normalStyle: { color: 'inherit' },
							delegate: this})
						,
						textFieldNode = textField.inputNode;
					
					cellView.addSubview(textField);
	
					textFieldNode.contentEditable = true;
					
					textFieldNode.oninput = function (e) {
						
						if (this.dataSource.valueShouldChangeForColumnNameAtRow !== undefined)
						this.dataSource.valueShouldChangeForColumnNameAtRow(this.columnName, this.rowView.tag, this.node.value, this.dataSource);
						
										
					}.bind({ node: textFieldNode, columnName: columns[j].name, dataSource: this._dataSource, tableView: this, cell: cellView, textField: cellView.subviews[0], rowView: rowView });
					
					textFieldNode.onkeydown = function (e) {
						if (e.keyCode === 13) {
							setTimeout(function () {
								this.focus();
							}.bind(this), 1);
						}
					}.bind(this);
					
				
				}
				else {
					var labelWrapper = createComponentFromDomain("View", "Core.UI", this.context, {
						size: { width: columnWidths[j]-20, height: rowHeight-2 },
						position: { left: 10, top: 1 },
						autoresizingMask: 2,
						style: {
							position: 'relative',
							verticalAlign: 'middle',
							textAlign: columns[j].textAlign || 'left',
							backgroundColor: 'yellow',
							overflow: 'hidden',
						}})
					;
				
					var label = createComponentFromDomain("Label", "Core.UI", this.context, {
						text: this._dataSource.dataForColumnNameAtRow(
								columns[j].name, i),
						style: {
							fontSize: (columns[j].fontSize || 12)+"px",
							position: 'inline',
							overflow: 'hidden',
							textOverflow: 'ellipsis',
							whiteSpace:'nowrap'
						},
						normalStyle: {
							color: 'inherit'
						},
						selectedStyle: {
							color: '#fff'
						},
						selectedStyleWithoutFocus: {
							color: 'inherit'
						}})
					;
					labelWrapper.addSubview(label);
					cellView.addSubview(labelWrapper);
				}
			}

			
			rowView.addSubview(cellView);
			
			x += columnWidths[j];
			
		}
		
		this.context.unregisterGlobal(this.dataSource.$id+'[]');
		
		
		rowView.position.top = i * rowHeight;
		rowView.tag = i;
		contentView.insertSubviewAtIndex(rowView, i);
		
		rowView.DOMNode.onmousedown = function (e) {
			if (!this.selectable) return;
		
			if (this._selectedRows.indexOf(rowView) !== -1) {
				if (e.metaKey === true)
					this.unselectRow(rowView.tag, this);
				return;
			}
			
			this.unselectAllRows(this);
			this.selectRow(rowView.tag, this);
		}.bind(this);
		
		
		if (this.dataSource.isRowSelectedAtIndex &&
			this.dataSource.isRowSelectedAtIndex(i))
			this.selectRow(i, this.dataSource);
		
		return rowView;
		};
	

TableView.prototype.clearData = function TableView__clearData() {
	
		this._contentView.removeAllSubviews();
		this._selectedRows = [];
		this.clearDynamicBindings();
	};
	


	
	
TableView.prototype.rowAtIndex = function TableView_rowAtIndex(rowIndex) {
		return this._contentView.subviews[rowIndex];};
	

TableView.prototype.editCellWithColumnNameAtRow = function TableView__editCellWithColumnNameAtRow(columnName, rowIndex) {

		var rowView = this.rowAtIndex(rowIndex);
		if (!rowView) return;
		
		var	columnIndex = this.indexOfColumnWithName(
				columnName),
			cellView = rowView.subviews[columnIndex],
			textField = cellView.subviews[0];

		if (this.columns[columnIndex].editable !== true) {
			console.warn("editCellWithColumnNameAtRow"+': Column is not editable! ', columnName, this.columns);
			return false;
		}
		
		textField.selectAll();
		
		return true;};
	


	

TableView.prototype.indexOfColumnWithName = function TableView_indexOfColumnWithName(columnName) {

		for (var i = 0, c = this.columns.length; i < c; i++) {
			if (this.columns[i].name === columnName) {
				return i;
			}
		}
		return -1;};
	
	
	
	
	
TableView.prototype.selectRow = function TableView_selectRow(rowIndex, sender) {
		if (!this.subviews) return;
		
		var rowView = this._contentView.subviews[rowIndex];
		if (this._selectedRows.indexOf(rowView) !== -1) return;
		if (!rowView) return;

		this._selectedRows.push(rowView);
		this.styleRowView(rowView,
			null,
			{
				color: 'white',
				pointerEvents: 'all'
			}
		);
		

		this.styleSelectedRowSubviews(rowView.subviews);
		
		rowView.superview.scrollToShowView(rowView);

		if (sender === this && this._dataSource && this._dataSource.setRowIsSelected)
			this._dataSource.setRowIsSelected(rowIndex, true);};
	

TableView.prototype.unselectRow = function TableView_unselectRow(rowIndex, sender) {
	
		var rowView = this._contentView.subviews[rowIndex];
		if (this._selectedRows.indexOf(rowView) === -1) return;

		this._selectedRows.splice(this._selectedRows.indexOf(rowView), 1);
		this.styleRowView(rowView,
			null,
			{
				color: '',
				pointerEvents: 'none'
			}
		);
		

		this.styleSelectedRowSubviews(rowView.subviews, 'normalStyle');

		if (sender === this && this._dataSource && this._dataSource.setRowIsSelected)
			this._dataSource.setRowIsSelected(rowIndex, false);};
	
	
	Object.defineProperty(TableView.prototype, "selectedIndices", {
		get: function () {
			var indices = [];
			if (Array.isArray(this._selectedRows)) this._selectedRows.every(function (rowView) {
				indices.push(this._contentView.subviews.indexOf(rowView));return true; }, this);
			
			return indices;
		}});
	
	
TableView.prototype.unselectAllRows = function TableView_unselectAllRows(sender) {
		if (Array.isArray(clone(this._selectedRows))) clone(this._selectedRows).every(function (rowView) {
			this.unselectRow(this._contentView.subviews.indexOf(rowView), this);return true; }, this);
		};
	
	
TableView.prototype.styleRowView = function TableView__styleRowView(rowView, rowViewStyle, textFieldStyle) {
		if (!rowView) return;
		
		if (!rowViewStyle) {
			rowViewStyle = {
					backgroundColor: 'inherit',
					color: 'inherit'
				};
			var rowIsSelected = this._selectedRows.indexOf(rowView) !== -1;
			if (rowIsSelected) {
				rowViewStyle.backgroundColor = window.hasFocus ? selectionActiveColor : selectionInactiveColor;
				rowViewStyle.color = window.hasFocus ? '#fff' : 'inherit';
			}
		}
		
		rowView.style(rowViewStyle);

		if (textFieldStyle)
		if (Array.isArray(rowView.subviews)) rowView.subviews.every(function (cell) {
			var textField = cell.subviews[0];
			if (textField && textField.styleInput) textField.styleInput(textFieldStyle);return true; }, this);
		
};
	
	
	
	
	
TableView.prototype.addEmptyRow = function TableView_addEmptyRow(sender) {

		if (!this._dataSource ||
			!this._dataSource.addEmptyData ||
			!this._dataSource.addEmptyData()) {
			this.context.beep();
			return false;
		}
		
		this.reloadDataLazy();
		this.layoutSubviews();
		
		var rowToSelect = this._contentView.subviews.length-1;
		this.selectRow(rowToSelect, this);
		this.editCellWithColumnNameAtRow(this.columns[0].name, rowToSelect);
		
		return true;
		};
	
	
TableView.prototype.removeSelectedRows = function TableView_removeSelectedRows(sender) {
	
		if (!this._selectedRows.length ||
			!this._dataSource.deleteDataForRow) return false;
		
		var rowToSelect = this._selectedRows[0].tag;

		var result;
		if (Array.isArray(clone(this._selectedRows))) clone(this._selectedRows).every(function (rowView) {
			this.unselectRow(rowView.tag, this);
			result = this._dataSource.deleteDataForRow(rowView.superview.subviews.indexOf(rowView));
			if (!result) {
				this.context.beep();
				return false;
			}return true; }, this);
		
		if (!result) return;

		this.reloadDataLazy();
		
		if (this._contentView.subviews.length) {
		
			if (rowToSelect > this._contentView.subviews.length-1)
				rowToSelect = this._contentView.subviews.length-1;
			
			this.selectRow(rowToSelect, this);

		}
		
		return true;
		};
	
	
	
	
	
TableView.prototype.viewDidFocus = function TableView_viewDidFocus(e) {
		this.context.registerFocus(this);
		
		if (Array.isArray(this._contentView.subviews)) this._contentView.subviews.every(function (rowView) {
			if (Array.isArray(rowView.subviews)) rowView.subviews.every(function (cell) {
				if (cell.editable === true) {
					var textField = cell.subviews[0];
				}return true; }, this);
			return true; }, this);
		

		setTimeout(function () {

		if (this._editingTextField) return;

		if (Array.isArray(this._selectedRows)) this._selectedRows.every(function (rowView) {
			this.styleRowView(rowView,
				{
					backgroundColor: selectionActiveColor,
				},
				{
					color: 'white !important',
					pointerEvents: 'all'
				}
			);
			
			this.styleSelectedRowSubviews(rowView.subviews);return true; }, this);
		
				
		}.bind(this), 1);

		if (this.drawsFocusRing !== false)
			this.style({ outline: 'auto 2px -webkit-focus-ring-color' });
		else
			this.style({ outline: 'none' });};
	

TableView.prototype.viewDidBlur = function TableView_viewDidBlur(e) {

		this.context.unregisterFocus(this);

		setTimeout(function () {

		if (this._editingTextField) return;
		if (this.context.focusedElement === this) return;

		if (Array.isArray(this._contentView.subviews)) this._contentView.subviews.every(function (rowView) {
			if (Array.isArray(rowView.subviews)) rowView.subviews.every(function (cell) {
				var textField = cell.subviews[0];return true; }, this);
			return true; }, this);
		


		setTimeout(function () {
		if (Array.isArray(this._selectedRows)) this._selectedRows.every(function (rowView) {
			this.styleRowView(rowView,
				{
					backgroundColor: selectionInactiveColor,
				},
				{
					color: 'rgba(1,1,1,1) !important',
					pointerEvents: 'none'
				}
			);
			
			this.styleSelectedRowSubviews(rowView.subviews);return true; }, this);
		
		}.bind(this), 1);
		
		}.bind(this), 1);

		this.style({ outline: 'none' });};
	
	
	
	

TableView.prototype.drawBackground = function TableView__drawBackground() {
	
		if (this.drawsBackground === false) return;

		var rowCount = this.subviews.length,
			offsetY = 0,
			width = this.size.width,
			ctx = this._backgroundCanvas.getContext('2d'),
			rowIndex = 0,
			lastRow = this._contentView.subviews[this._contentView.subviews.length-1],
			totalHeight = this._contentView._size.height,
			rowHeight = this.rowHeight || 17,
			oddBackgroundColor = this.oddBackgroundColor;
		
		if (lastRow)
			totalHeight = Math.max(totalHeight, lastRow._position.top + lastRow._size.height);
		
		
		this._backgroundCanvas.height = totalHeight;
		this._backgroundCanvas.width = this.size.width-2;
		ctx.clearRect(0, 0, width, this.size.height);
		ctx.fillStyle = oddBackgroundColor;

		if (Array.isArray(this._contentView.subviews)) this._contentView.subviews.every(function (subview) {
		
			var rowHeight = subview.size.height;
			offsetY += rowHeight + this.rowOffsetY;

			if ((rowIndex % 2) !== 0) {
				ctx.fillRect(0, offsetY - rowHeight, width, rowHeight);
			}
			
			rowIndex++;
		return true; }, this);
		
	
		
		var i = rowIndex;

		while (offsetY < totalHeight+rowHeight) {

			offsetY += rowHeight;
			
			if ((i % 2) !== 0) {
				ctx.fillRect(0, offsetY-rowHeight, width, rowHeight);
			}

			i++;
		}
};
	
	
	
	

TableView.prototype.keyDownHandler = function TableView__keyDownHandler(e) {
	
		if (this._editingTextField) return;

		switch (e.keyCode) {

			case 8: 
				if (this.removeSelectedRows(this)) {
					e.preventDefault();
				}
				break;

			case 13: 
				if (this.selectedIndices.length === 1) {
					if (Array.isArray(this.columns)) this.columns.every(function (column) {
						if (this.editCellWithColumnNameAtRow(column.name, this.selectedIndices[0])) {
							e.preventDefault();
							return false;
						}return true; }, this);
					
				}
				break;

			case 38: 
				e.preventDefault();
				var index = this.selectedIndices[0]-1;
				if (!isNumber(index)) index = this._contentView.subviews.length - 1;
				if (index >= 0) {
					if (!e.shiftKey) this.unselectAllRows(this);
					this.selectRow(index, this);
				}
				break;

			case 40: 
				e.preventDefault();
				var index = this.selectedIndices[this.selectedIndices.length-1]+1;
				if (!isNumber(index)) index = 0;
				if (index < this._contentView.subviews.length) {
					if (!e.shiftKey) this.unselectAllRows(this);
					this.selectRow(index, this);
				}
				break;

		}
};
	


	
	
// role Observer (Core) 

TableView.prototype.valueDidAppearInKeyPath = function TableView_valueDidAppearInKeyPath(insertion, keyPath, sender) {

			
			var columns = this.columns,
				numberOfColumns = columns.length,
				index = insertion.keyPath;
			
			if (!isNumber(index)) return false;
				
			for (var i = index, c = this._contentView.subviews.length;
				i < c; i++) {
				
				var rowView = this._contentView.subviews[i];
				rowView.position.top += 30;
				
				for (var j = 0, x = 0; j !== numberOfColumns; j++) {
			
					var dataKeyPath = this._dataSource.bindableDataKeyPathForColumnNameAtRow(columns[j].name, i+1);

					rowView.subviews[j].subviews[0].bindings = [["value", dataKeyPath]];
					rowView.tag = i+1;

				}
			}
			
			this.insertRowWithIndex(index);};
		

	

// role TextFieldDelegate (Core.UI) 
	
TableView.prototype.textFieldDidChangeValue = function TableView_textFieldDidChangeValue(textField) {

			var cell = textField.superview,
				row = cell.superview,
				cellIndex = row.subviews.indexOf(cell),
				rowIndex = row.superview.subviews.indexOf(row),
				columnName = this.columns[cellIndex].name;
				
			if (textField.value === this._editingTextFieldValueBefore)
				return;
			
			if (this._dataSource.setValueForColumnNameInRow !== undefined)
				if (this._dataSource.setValueForColumnNameInRow(textField.value, columnName, rowIndex) === false) {
					textField.value = this._editingTextFieldValueBefore;
					this.context.beep();
					console.log(this._dataSource);
					setTimeout(function () {
						textField.DOMNode.focus();
						textField.selectAll();
					},1);
					return false;
				}
};
		
		
TableView.prototype.textFieldDidBeginEditing = function TableView_textFieldDidBeginEditing(textField) {
		
			this._editingTextField = textField;
			this._editingTextFieldValueBefore = textField.value;

			textField.styleInput({
				color: '',
				backgroundColor: 'white',
				cursor: ''
			});
			
			textField.selectAll();
			};
		

TableView.prototype.textFieldDidEndEditing = function TableView_textFieldDidEndEditing(textField) {

			delete this._editingTextField;

			var rowIsSelected = (this._selectedRows.indexOf(textField.superview.superview) !== -1);

			textField.styleInput({
				color: rowIsSelected ? 'white' : '',
				backgroundColor: 'transparent',
				cursor: 'default'
			});
			
			this.viewDidBlur();};
		
	
	
	

	
	
	Object.defineProperty(TableView.prototype, "dataSource", {
		get: function () { return this._dataSource; }, 
		set: function (v) {
			if (!v) return;

			if (!v
				|| v.dataForColumnNameAtRow === undefined
				|| v.dataForRowAtIndex === undefined
				|| v.numberOfRows === undefined
				|| v.bindableDataKeyPath === undefined
				|| v.bindableDataKeyPathForColumnNameAtRow == undefined) {

				console.warn('The TableViews\'s datasource does not implement all methods required by the protocol.', v);

				return;
			}
			this._dataSource = v;

			try { v.addObserver(this); } catch (err) { console.warn('Could not add an observer to the data source.', v); }

			this.reloadData();
			
		}});
	
	
	Object.defineProperty(TableView.prototype, "columns", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_columns")) Object.defineProperty(this, "_columns", { writable: true, configurable: true });
			this._columns = v;
			this.recalculateColumnWidths();
		}, get:function () { return this._columns; }});
	
	
TableView.prototype.recalculateColumnWidths = function TableView__recalculateColumnWidths() {
			
			var v = this._columns,
				columnWidths = [], rowWidth = this.size.width - 2;
			
			for (var j = 0, c = v.length; j !== c; j++) {
				columnWidths[j] = rowWidth * v[j].width;
			}
			
			Object.defineProperty(this, "_columnWidths", {
				value: columnWidths, writable: true });};
	

TableView.prototype.deleteSelection = function TableView_deleteSelection() {
			this.removeSelectedRows();};
		
TableView.prototype.canDelete = function TableView_canDelete() {
			return this._selectedRows.length !== 0;};
		
	
TableView.prototype.expectedTypeForProperty = function TableView_expectedTypeForProperty(key) {
	if (key === "rowHeight") return "";
	if (key === "isEditing") return "";
	if (key === "selectedIndices") return "";
	if (key === "dataSource") return "";
	if (key === "columns") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return TableView; }()));