
registerType('Core.UI', (function () { function TextField() {} var __super = setSupertypeFromDomain(TextField, 'View', 'Core.UI');
	
TextField.prototype.initFromData = function TextField_initFromData(data, holdBindings) {
	
		var textFieldStyle = data.style;
		delete data.style;
	
		if (!__super.prototype.initFromData.call(this, data, null, holdBindings))
			return;
		
		this.inputNode = document.createElement(data.multiLine == true ? 'textarea' : 'input');

		if (this.valueWhenUninitialized) {
			this.inputNode.value = this.valueWhenUninitialized;
		}
		
		this.DOMNode.appendChild(this.inputNode);

		Object.defineProperty(this, "inputType", {
		enumerable: true, 
			value: data.inputType});
		
		
		if (data.localizePlaceholder)
			data.placeholder = LocalizedString(data.placeholder);
		
		var value;
		['value', 'placeholder', 'delegate', 'multiLine', 'acceptsOnReturn', 'shouldUseModalUndoManager', 'unfocusWithEscapeKey', 'allowTabs'].every(function (option) {
			value = data[option];
			if (value !== undefined) this[option] = value;return true; }, this);
		
		
		if (data.acceptsOnReturn === undefined)
			this.acceptsOnReturn = this.multiLine !== true;
		
		
		if (data.inputType === 'search') {
			this.inputNode.type = data.inputType;
		}

		if (data.inputType === 'number') {
			this.step = data.step||1;
			this.prepareAsNumberInput();
		}
		
		this.inputNode.onchange = this.onChange.bind(this);

		if (data.multiLine) {
			this.inputNode.onkeydown = function (e) {
				if (e.keyCode === 9 && this.allowTabs && !e.altKey) {
					e.preventDefault();
					e.stopPropagation();
					document.execCommand('inserthtml',false,'	');
				}
			}.bind(this);
		}


		this.inputNode.onkeypress = function (e) {

			if (e.keyCode === 13) {
				if (this.context.nativeProxy.sendMessage('numberKeypadEnterIsPressed')) {
					this.inputNode.onchange(e);
					e.preventDefault();
					return;
				}
				if (this.acceptsOnReturn !== false && !e.altKey) {
					this.selectAll(this);
					e.preventDefault();
					if (this.acceptsOnReturn) this.inputNode.onchange(e);
				}
			}
			
			if (e.keyCode === 27 && this.unfocusWithEscapeKey) {
				this.blur();
				e.preventDefault();
			}

		}.bind(this);

		this.inputNode.onfocus = function (e) {
			this.context.registerFocus(this);
			if (this.shouldUseModalUndoManager)
				this.context.enableModalUndoManager();
			this.callDelegate('textFieldDidBeginEditing', [this]);
			if (this.autoupdateWithTimer) {
				var valueBefore = this.value;
				this.autoupdateTimer = setInterval(function () {
					if (this.value === valueBefore) return;
					valueBefore = this.value;
					this.onChange();
				}.bind(this), 1000);
			}
		}.bind(this);


		this.inputNode.onblur = function (e) {
			this.context.unregisterFocus(this);
			if (this.shouldUseModalUndoManager)
				this.context.disableModalUndoManager();
			this.callDelegate('textFieldDidEndEditing', [this]);
			
			if (this.autoupdateTimer) {
				clearInterval(this.autoupdateTimer);
				this.autoupdateTimer = null;
			}
		}.bind(this);


		this.inputNode.oninput = function (e) {
			this.callDelegate('textFieldDidGetInput', [this]);
		}.bind(this);
		
		var inputWidth = data.size.width;
		if (data.inputType === 'number') inputWidth -= 20;
		var inputHeight = data.size.height;

		if (!textFieldStyle || !(textFieldStyle.background || textFieldStyle.backgroundImage || textFieldStyle.backgroundColor)) {

			this.styleInput({
				height: inputHeight+'px',
				width: inputWidth+'px',
				borderWidth: '1px',
				webkitBorderImage: 'url('+this.context.pathForResource('TextFieldBorder@2x.png')+') 2 2 2 2 repeat stretch',
				boxShadow: 'inset 0px 1px 2px #e4e4e4',
				padding: '2px 2px'
			});
		}
		if (textFieldStyle)
			this.styleInput(textFieldStyle);
		
		if (data.isFirstResponder)
			this.inputNode.autofocus = true;
		
		if (data.disabled) this.disabled = true;
		this.autoupdateWithTimer = data.autoupdateWithTimer;
		
		data = null;
		
		this.layoutSubviews()
		
		return this;};
	


	Object.defineProperty(TextField.prototype, "allowTabs", {
	synthesized: true, 
	enumerable: true, get:function () { return this._allowTabs; }, set:function (v) {if (!Object.hasOwnProperty(this, "_allowTabs")) Object.defineProperty(this, "_allowTabs", { writable: true, configurable: true }); this._allowTabs = v; }});
	

	
TextField.prototype.destroy = function TextField_destroy() {
		if (this.autoupdateTimer) clearInterval(this.autoupdateTimer);
		__super.prototype.destroy.call(this);};
	
	
TextField.prototype.prepareAsNumberInput = function TextField__prepareAsNumberInput() {

		this.steppers = createComponentFromDomain("NumberInputSteppers", "Core.UI", this.context, {
			position: { left: this.size.width-12-2, top: -2 },
			autoresizingMask: 1,
			input: this,
			step: this.step})
		;
		this.addSubview(this.steppers);
		
		this.inputNode.onkeydown = function (e) {

			if (e.altKey) return;
			
			if (e.keyCode === 38 || e.keyCode === 40) {
				e.preventDefault();
				var delta = this.step*(e.keyCode === 38 ? 1 : -1);
				
				if (e.shiftKey) delta *= 10;
				this.value += delta;
				this.onChange(e);
				this.selectAll();
			}
			
			if (e.keyCode === 13 && this.multiLine !== true) {
				e.preventDefault();
				this.onChange(e);
				this.selectAll();
			}

		}.bind(this);};
	
	
	

TextField.prototype.onChange = function TextField__onChange(e) {

		if (this.callDelegate('textFieldDidChangeValue', [this]) === false)
			return;

		this.context.broadcastValueChangeForKeyPathInObject('value', this, this);
		
		this.dispatchEvent({ type: 'change' });};
	
	
	
TextField.prototype.layoutSubviews = function TextField_layoutSubviews() {
		var inputWidth = this.size.width-6;
		if (this.inputType === 'number') inputWidth -= 16;
		this.inputNode.style.width = inputWidth+'px';
		this.inputNode.style.height = this.size.height+'px';

		__super.prototype.layoutSubviews.call(this);};
	
	

	

// role EditActionResponder 

TextField.prototype.canSelectAll = function TextField_canSelectAll() {
			return true;};
		

TextField.prototype.canDelete = function TextField_canDelete() {
			return true;};
		
	
TextField.prototype.selectAll = function TextField_selectAll() {
			this.inputNode.focus();
			this.inputNode.select();};
		
	
TextField.prototype.copy = function TextField_copy() {
			};
		
	
TextField.prototype.paste = function TextField_paste() {
			};
		
	
TextField.prototype.cut = function TextField_cut() {
			};
		
	
TextField.prototype.deleteSelection = function TextField_deleteSelection() {
			document.execCommand('delete');};
		
	
	
	
TextField.prototype.blur = function TextField_blur() {
		this.inputNode.blur();};
	


	
	
// role BindingsCapableObject 

TextField.prototype.valueShouldChangeForKeyPath = function TextField_valueShouldChangeForKeyPath(value, keyPath, sender) {
		
			if (['value', 'placeholder', 'disabled'].indexOf(keyPath) !== -1) {
				this[keyPath] = value;
				return true;
			}
			
			return false;
	};
		
		
TextField.prototype.get = function TextField_get(keyPath) {
		
			if (keyPath === 'value') return this.value;
		};
		

		


	
	
	Object.defineProperty(TextField.prototype, "value", {
	enumerable: true, 
		set: function (v) {
			if (v === undefined) v = '';
			if (this.inputNode) {
				if (this.inputType === 'number' && !isNaN(v)) {
					v = ((Math.round(v*1000)|0)/1000 || 0); 
					v = renderFloatLocal(v);
				}
				this.inputNode.value = v;
			}
			else {
				Object.defineProperty(this, "valueWhenUninitialized", {
				configurable: true, 
					value: v});
				
			}
		}, 
		get: function () {

			
			

			if (!this.inputNode) return this.valueWhenUninitialized;
			
			return (this.inputType === 'number') ?
				(parseFloatLocal(this.inputNode.value)||0)
				: this.inputNode.value;
		}});
	
	
	Object.defineProperty(TextField.prototype, "placeholder", {
	enumerable: true, 
		set: function (v) {
			this.inputNode.placeholder = v;
		}, 
		get: function () {
			return this.inputNode.placeholder;
		}});
	

	Object.defineProperty(TextField.prototype, "disabled", {
	enumerable: true, 
		set: function (v) {
			if (this.inputNode) {
				this.style({ opacity: v ? 0.5 : 1 });
				this.inputNode.disabled = v;
			}
		}, 
		get: function () {
			return this.inputNode.disabled;
		}});
	

TextField.prototype.styleInput = function TextField_styleInput(styleData) {
		this.style.call({ DOMNode: this.inputNode }, styleData);};
	
	
	
TextField.prototype.setSelectionRange = function TextField_setSelectionRange(start, end) {
		this.inputNode.setSelectionRange(start, end);};
	


	function renderFloatLocal(f) {
		if (window.language === 'de') return (f+'').replace('.',',');
		return f+'';
	}
TextField.prototype.expectedTypeForProperty = function TextField_expectedTypeForProperty(key) {
	if (key === "inputType") return "";
	if (key === "allowTabs") return "Boolean";
	if (key === "value") return "";
	if (key === "valueWhenUninitialized") return "";
	if (key === "placeholder") return "";
	if (key === "disabled") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return TextField; }()));
registerType('Core.UI', (function () { function NumberInputSteppers() {} var __super = setSupertypeFromDomain(NumberInputSteppers, 'ImageView', 'Core.UI');

	var mouseIsDownInSegment = null,
		mouseDownTimer,
		mouseDownInterval;
		
	Object.defineProperty(NumberInputSteppers.prototype, "input", {
	synthesized: true, get:function () { return this._input; }, set:function (v) {if (!Object.hasOwnProperty(this, "_input")) Object.defineProperty(this, "_input", { writable: true, configurable: true }); this._input = v; }});
	

NumberInputSteppers.prototype.initFromData = function NumberInputSteppers_initFromData(data) {

		data.imageSrc = this.context.pathForResource('SteppersMini.png');
		data.size = { width: 17, height: 27 };
		data.contentMode = 'scaleAspectFit';
		data.drawWithCanvas = true;
		var self = __super.prototype.initFromData.call(this, data);
		self.input = data.input;
		self.DOMNode.onmousedown = function (e) {
		
			if (self.input.disabled) return;
			
			e.preventDefault();
			mouseIsDownInSegment = e.offsetY/15 | 0;
			this.redrawCanvas();
			
			var delta = this.step*(e.shiftKey ? 10 : 1);
			
			window.onmouseup = function () {
				window.onmouseup = null;
				mouseIsDownInSegment = null;
				this.redrawCanvas();
				clearTimeout(mouseDownTimer);
				if (mouseDownInterval) clearInterval(mouseDownInterval);
				mouseDownTimer = null;
				mouseDownInterval = null;
			}.bind(this);
			
			mouseDownTimer = setTimeout(function () {
				mouseDownInterval = setInterval(function () {
					this.trigger(mouseIsDownInSegment, delta);
				}.bind(this), 50);
			}.bind(this), 400);
			
			this.trigger(mouseIsDownInSegment, delta);
			
		}.bind(this);
		
		this.step = data.step;
		
		data = null;
		return self;};
	

NumberInputSteppers.prototype.redrawCanvas = function NumberInputSteppers__redrawCanvas() {
		__super.prototype.redrawCanvas.call(this);
		if (mouseIsDownInSegment === null) return;
		var ctx = this._canvas.getContext('2d');
		ctx.fillStyle = 'rgba(0,0,0,.15)';
		
		var scale = this.context.highResolutionEnabled ? 2 : 1;
		ctx.scale(scale, scale);

		ctx.beginPath();
		ctx.save();
		if (mouseIsDownInSegment === 1) {
			ctx.translate(17,26);
			ctx.rotate(180*Math.PI/180);
		}
		ctx.moveTo(3,13);
		ctx.lineTo(3,9);
		ctx.arcTo(3,3,9,3,5);
		ctx.arcTo(14,3,14,13,5);
		ctx.lineTo(14,13);
		ctx.lineTo(3,13);
		ctx.restore();
		ctx.fill();};
	
	
NumberInputSteppers.prototype.trigger = function NumberInputSteppers_trigger(segment, delta) {
		if (!delta) delta = this.step||1;
		if (segment === 0) {
			this.input.value += delta;
		}
		else if (segment === 1) {
			this.input.value -= delta;
		}
		this.input.onChange();};
	
	

NumberInputSteppers.prototype.expectedTypeForProperty = function NumberInputSteppers_expectedTypeForProperty(key) {
	if (key === "input") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return NumberInputSteppers; }()));
registerType('Core.UI', (function () { function Checkbox() {} var __super = setSupertypeFromDomain(Checkbox, 'View', 'Core.UI');

	Object.defineProperty(Checkbox.prototype, "disabled", {
	outlet: true, 
	enumerable: true, get:function () { return this._disabled; }, set:function (v) {if (!Object.hasOwnProperty(this, "_disabled")) Object.defineProperty(this, "_disabled", { writable: true, configurable: true }); this._disabled = v; }});
	

	Object.defineProperty(Checkbox.prototype, "value", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_value")) Object.defineProperty(this, "_value", { writable: true, configurable: true });
			this._value = v;
			if (this.checkboxNode) this.checkboxNode.checked = v;
		}, get:function () { return this._value; }});
	

	Object.defineProperty(Checkbox.prototype, "title", {
	outlet: true, 
	enumerable: true, get:function () { return this._title; }, set:function (v) {if (!Object.hasOwnProperty(this, "_title")) Object.defineProperty(this, "_title", { writable: true, configurable: true }); this._title = v; }});
	
	
	Object.defineProperty(Checkbox.prototype, "checkboxNode", {
	synthesized: true, get:function () { return this._checkboxNode; }, set:function (v) {if (!Object.hasOwnProperty(this, "_checkboxNode")) Object.defineProperty(this, "_checkboxNode", { writable: true, configurable: true }); this._checkboxNode = v; }});
	

	Object.defineProperty(Checkbox.prototype, "labelNode", {
	synthesized: true, get:function () { return this._labelNode; }, set:function (v) {if (!Object.hasOwnProperty(this, "_labelNode")) Object.defineProperty(this, "_labelNode", { writable: true, configurable: true }); this._labelNode = v; }});
	

Checkbox.prototype.init = function Checkbox_init() {
		__super.prototype.init.call(this);

		this.checkboxNode = document.createElement('input');
		this.checkboxNode.type = 'checkbox';
		this.checkboxNode.style.fontSize = '16px';
		this.checkboxNode.style.position = 'relative';
		this.checkboxNode.style.left = '-4px';
		this.checkboxNode.id = this.context.createUID('CheckboxNode');
		this.checkboxNode.disabled = this.disabled ? 'disabled' : false;
		this.checkboxNode.checked = this.value;
		this.checkboxNode.onmousedown = function (e) {
			e.stopPropagation();
		};
		this.checkboxNode.addEventListener('change', function (e) {
			var value = this.checkboxNode.checked;
			this.value = value;
			this.context.broadcastValueChangeForKeyPathInObject('value', this, this);
		}.bind(this));
		
		var labelNode = document.createElement('label');
		labelNode.style.position = 'absolute';
		labelNode.style.width = (this.size.width || 150+5)+'px';
		labelNode.style.height = 16;
		labelNode.style.left = 19+'px';
		labelNode.style.top = 2+'px';
		labelNode.style.overflow = 'hidden';
		labelNode.style.textOverflow = 'ellipsis';
		labelNode.appendChild(document.createTextNode(' '+this.title));
		labelNode.setAttribute('for', this.checkboxNode.id);
		if (this.disabled) labelNode.style.color = '#888';

		this.DOMNode.appendChild(this.checkboxNode);
		if (this.title) this.DOMNode.appendChild(labelNode);

		return this;};
	

Checkbox.prototype.initPropertiesFromData = function Checkbox_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("disabled")) this.disabled = data.disabled;
if (data.hasOwnProperty("value")) this.value = data.value;
if (data.hasOwnProperty("title")) this.title = data.title;
};

Checkbox.prototype.decodeData = function Checkbox_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

Checkbox.prototype.encode = function Checkbox_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

Checkbox.prototype.encodeCloned = function Checkbox_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

Checkbox.prototype.expectedTypeForProperty = function Checkbox_expectedTypeForProperty(key) {
	if (key === "disabled") return "Boolean";
	if (key === "value") return "Boolean";
	if (key === "title") return "String";
	if (key === "checkboxNode") return "";
	if (key === "labelNode") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return Checkbox; }()));