
registerType('Core.UI', (function () { function View() {} var __super = setSupertypeFromDomain(View, 'BasicObject', 'Core');


// role BasicObject (Core) 
	
View.prototype.initFromData = function View_initFromData(data, nodeTag, holdBindings) {

			this.subviews = [];
			this.viewIsLoaded = false;
			
			Object.defineProperty(this, "_lastStableContentSize", {
			writable: true});
			
		
			Object.defineProperty(this, "_position", {
			writable: true});
			

			this._position = { left: 0, top: 0 };
		
			Object.defineProperty(this, "_size", {
			writable: true});
			



			Object.defineProperty(this, "DOMNode", {
			configurable: true, 
				value: document.createElement(nodeTag || "div")});
			

			if (!data.style || !data.style.position) {
				this.DOMNode.style.position = "absolute";
			}


			if (data.size === undefined) {
				data.size = {  };
			}

			if (data.localizeToolTip === true) {
				data.toolTip = LocalizedString(data.toolTip);
			}
			
			
			

			var properties = ['position',
			 'size',
			 'position',
			 'dropHandler',
			 'eventHandler',
			 'autoresizesSubviews',
			 'autoresizingMask',
			 'adjustsSubviewToFitWidth',
			 'hidden',
			 'tag',
			 'normalStyle',
			 'selectedStyle',
			 'selectedStyleWithoutFocus',
			 'disabled',
			 'ignoreStyleForDisabled',
			 'acceptsFocus',
			 'toolTip',
			 "delegate",
			 "drawsFocusRing",
			 'contextMenu',
			 'className',
			 'id',
			 'localizeToolTip',
			 'layoutRelations',
			 ];

			if (Array.isArray(properties)) properties.every(function (key) {
				if (data.hasOwnProperty(key)) {
					this[key] = data[key];
				}return true; }, this);
			

			if (data.style !== undefined) {
				this.style(data.style);
				Object.defineProperty(this, "defaultStyle", {
				writable: true, 
					value: data.style});
				
			}

			if (!__super.prototype.initFromData.call(this, data, true))
				return;
	

			if (holdBindings !== true) {
				this.applyBindings(true);
			}

			
			return this;
	};
		
		
View.prototype.destroy = function View_destroy() {
			if (this.keepInMemory) {
				if (this.superview) this.removeFromSuperview(true);
				return;
			}
		
			if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {
				subview.destroy();return true; }, this);
			

			delete this._subviews;
			delete this._superview;
			
			if (this._dropHandler !== undefined)
				delete this.DOMNode._dropHandler;

			delete this.DOMNode;
	
			__super.prototype.destroy.call(this);};
		
	
	

	Object.defineProperty(View.prototype, "superview", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_superview")) Object.defineProperty(this, "_superview", { writable: true, configurable: true });
			this._superview = v;
		}, get:function () { return this._superview; }});
	


	Object.defineProperty(View.prototype, "subviews", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_subviews")) Object.defineProperty(this, "_subviews", { writable: true, configurable: true });
			this._subviews = v;
		}, get:function () { return this._subviews; }});
	
	
	Object.defineProperty(View.prototype, "viewIsLoaded", {
	synthesized: true, get:function () { return this._viewIsLoaded; }, set:function (v) {if (!Object.hasOwnProperty(this, "_viewIsLoaded")) Object.defineProperty(this, "_viewIsLoaded", { writable: true, configurable: true }); this._viewIsLoaded = v; }});
	
	
	Object.defineProperty(View.prototype, "normalStyle", {
	writable: true});
	


	

	Object.defineProperty(View.prototype, "$id", {
	enumerable: true, 
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_$id")) Object.defineProperty(this, "_$id", { writable: true, configurable: true });
			this._$id = v;
			if (this.DOMNode !== undefined)
				this.DOMNode.id = v;
		}, get:function () { return this._$id; }});
	


	

	Object.defineProperty(View.prototype, "size", {
	enumerable: true, 
		get: function () {
			return Object.create(Object, {
				'width': {
					enumerable: true,
					set: function (width) { this._size.width = width;
											this.style({ width: width + 'px' });
											this.viewDidResize(true, true);
											}.bind(this),
					get: function () {
						if (!this._size) console.log(this);
						return this._size.width; }.bind(this)
				},
				'height': {
					enumerable: true,
					set: function (height) { this._size.height = height;
											 this.style({ height: height + 'px' });
											 this.viewDidResize(true, true);
											 }.bind(this),
					get: function () {
						return this._size.height; }.bind(this)
				},
			});
		}, 
		set: function (size) {
		
			if (size === undefined) {
				return;
			}
			
			var w = parseInt(size.width),
				h = parseInt(size.height),
				isUpdating = (this._size !== undefined);
			
			if (isUpdating === false) {
				this._size = {
					width: w,
					height: h
				};

				this._lastStableContentSize = clone(this._size);
			}
			else {
				this._size.width = w;
				this._size.height = h;
			}

			if (this.DOMNode !== undefined)
				this.style({
					width: w + 'px',
					height: h + 'px'
				});
			
			if (isUpdating === true)
				this.viewDidResize(true, true);
		}});
	
	
	Object.defineProperty(View.prototype, "sizeCopy", {
		get: function () {
			return {
				width: this.size.width,
				height: this.size.height 
			};
		}});
	

	function isNumber(x) {
		return typeof x === 'number';
	}

	Object.defineProperty(View.prototype, "position", {
	enumerable: true, 
		get: function () {
			return Object.create(Object, {
				'left': {
					enumerable: true,
					set: function (left) {
						this._position.left = left;
						this.style({ left: left + 'px' });
					}.bind(this),
					get: function () { return this._position.left; }.bind(this)
				},
				'top': {
					enumerable: true,
					set: function (top) {
						this._position.top = top;
						this.style({ top: top + 'px' });
					}.bind(this),
					get: function () { return this._position.top; }.bind(this)
				},
				'right': {
					enumerable: false,
					get: function () { return this._position.left + this._size.width; }.bind(this)
				},
				'bottom': {
					enumerable: false,
					get: function () { return this._position.top + this._size.height; }.bind(this)
				},
			});
		}, 
		set: function (position) {
		
			if (this._position === undefined) this._position = {};

			if (position === undefined) {
				this._position.left = 0;
				this._position.top = 0;
				return;
			}
			else {
				this._position.left = position.left;
				this._position.top = position.top;
			}
			
			if (this.DOMNode !== undefined) {

				if (isNumber(position.left))
					this.DOMNode.style.left = position.left + 'px';
				if (isNumber(position.right)) {
					this.DOMNode.style.right = position.right + 'px';
					this.DOMNode.style.left = '';
				}
				if (isNumber(position.top))
					this.DOMNode.style.top	= position.top + 'px';
				if (isNumber(position.bottom))
					this.DOMNode.style.bottom	= position.bottom + 'px';
				
			}
		}});
	
	
	Object.defineProperty(View.prototype, "positionCopy", {
		get: function () {
			return {
				left: this.position.left,
				top: this.position.top
			};
		}});
	
	
	
	
	
	Object.defineProperty(View.prototype, "dragEnterEventListener", {
	synthesized: true, get:function () { return this._dragEnterEventListener; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dragEnterEventListener")) Object.defineProperty(this, "_dragEnterEventListener", { writable: true, configurable: true }); this._dragEnterEventListener = v; }});
	

	Object.defineProperty(View.prototype, "dragOverEventListener", {
	synthesized: true, get:function () { return this._dragOverEventListener; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dragOverEventListener")) Object.defineProperty(this, "_dragOverEventListener", { writable: true, configurable: true }); this._dragOverEventListener = v; }});
	

	Object.defineProperty(View.prototype, "dropEventListener", {
	synthesized: true, get:function () { return this._dropEventListener; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dropEventListener")) Object.defineProperty(this, "_dropEventListener", { writable: true, configurable: true }); this._dropEventListener = v; }});
	

	Object.defineProperty(View.prototype, "dragLeaveEventListener", {
	synthesized: true, get:function () { return this._dragLeaveEventListener; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dragLeaveEventListener")) Object.defineProperty(this, "_dragLeaveEventListener", { writable: true, configurable: true }); this._dragLeaveEventListener = v; }});
	

	Object.defineProperty(View.prototype, "dropHandler", {
	synthesized: true, 
		set: function (handler) {if (!Object.hasOwnProperty(this, "_dropHandler")) Object.defineProperty(this, "_dropHandler", { writable: true, configurable: true });
			
			this._dropHandler = handler;
			
			if (this.DOMNode === undefined) {
				
				return;
			}
				
			if (!handler) {
				delete this.DOMNode._dropHandler;
				this.DOMNode.removeEventListener('dragenter',	this.dragEnterEventListener);
				this.DOMNode.removeEventListener('dragover',	this.dragOverEventListener);
				this.DOMNode.removeEventListener('drop',		this.dropEventListener);
				this.DOMNode.removeEventListener('dragleave',	this.dragLeaveEventListener);
				this.dragEnterEventListener = null;
				this.dragOverEventListener = null;
				this.dropEventListener = null;
				this.dragLeaveEventListener = null;
				return;
			}

			this.DOMNode._dropHandler = handler;

			if (handler.didEnterWithEvent !== undefined) {
				this.dragEnterEventListener = function (e) {
					this._dropHandler.didEnterWithEvent.call(this, e);
				}.bind(this);
				this.DOMNode.addEventListener('dragenter', this.dragEnterEventListener);
			}
			
			this.dragOverEventListener = function (e) {
				e.preventDefault();
				e.stopPropagation();
				e.dataTransfer.dropEffect =
					this._dropHandler.dropEffectForEvent.call(this, e);
			}.bind(this);
			this.DOMNode.addEventListener('dragover', this.dragOverEventListener);

			this.dropEventListener = function (e) {
				var r = this._dropHandler.didDropWithEvent.call(this, e);
				if (r) e.preventDefault();
				e.stopPropagation();
			}.bind(this);
			this.DOMNode.addEventListener('drop', this.dropEventListener);
			
			if (handler.didLeaveWithEvent !== undefined) {
				this.dragLeaveEventListener = function (e) {
					this._dropHandler.didLeaveWithEvent.call(this, e);
				}.bind(this);
				this.DOMNode.addEventListener('dragleave', this.dragLeaveEventListener);
			}
			
			handler = undefined;
		}, get:function () { return this._dropHandler; }});
	
	
	
	

View.prototype.removeFromSuperview = function View_removeFromSuperview(doNotDestroy) {
		if (!this.superview) {
			 console.warn('removeFromSuperview(): This view has no superview.');
			 console.trace();
			return;
		}
		this.superview.removeSubview(this, doNotDestroy);
		this.superview = undefined;};
	
	
View.prototype.addSubview = function View_addSubview(view) {

		if (this.DOMNode === undefined) {
			 console.warn("addSubview(): Trying to add a subview to a view that has been destroyed.");
			 console.trace();
			return;
		}

		if (view === undefined) {
			 console.warn("The view to be added is "+view+".");
			 console.trace();
			return;
		}

		if (view.DOMNode === undefined) {
			var additionalInfo = view.constructor ? ", the element is a "+view.constructor.name : "";
			 console.warn("addSubview(): Can't add a view without a DOMNode"+additionalInfo+".", view);
			 console.trace();
			return;
		}
		
		if (view.superview) view.removeFromSuperview(true);
		this.DOMNode.appendChild(view.DOMNode);

		try {
			if (this.viewIsLoaded === true && view.viewIsLoaded !== true) {
				view.viewDidLoad();
				this.callDelegate('viewDidLoad', [view]);
			}
		} catch (err) {
			 console.error('addSubview(): Error calling view.viewDidLoad() or view.delegate.viewDidLoad(view).', this, this.delegate);
			 console.trace();
			throw err;
		}
		
		this.subviews.push(view);
		view.superview = this;
};
	

View.prototype.removeSubview = function View_removeSubview(view, doNotDestroy) {

		if (!this.subviews) {
			 console.warn('removeSubview(): No subviews! Destroyed: '+this._isDestroyed, this);
			 console.trace();
			return;
		}


		var indexOfTheView = this.subviews.indexOf(view);
		if (indexOfTheView == -1) {
			 console.warn('This view has no such subview.');
			 console.trace();
			return;
		}
		
		this.subviews.splice(indexOfTheView, 1);
		
		this.DOMNode.removeChild(view.DOMNode);

		delete view.superview;

		if (doNotDestroy !== true)
			view.destroy();
};
	
	
View.prototype.removeAllSubviews = function View_removeAllSubviews(doNotDestroy) {
		if (!this.subviews) return;

		for (var i = 0, c = this.subviews.length; i !== c; i++) {
			var subview = this.subviews[0];
			this.removeSubview(subview, doNotDestroy);
		}
};
	
	
View.prototype.insertSubviewAtIndex = function View_insertSubviewAtIndex(view, index) {
	
		if (view.superview) view.removeFromSuperview(true);
		
		try {
			var nodeBefore = this.subviews[index] ? this.subviews[index].DOMNode : null;
			this.DOMNode.insertBefore(view.DOMNode, nodeBefore);
			this.subviews.splice(index, 0, view);
			view.superview = this;
			
			if (this.viewIsLoaded === true && view.viewIsLoaded !== true) {
				view.viewDidLoad();
				this.callDelegate('viewDidLoad', [view]);
			}
		} catch (err) {
			 console.error(err);
			 console.trace();
		};
		};
	


	

View.prototype.style = function View_style(obj) {

		if (this.DOMNode === undefined) {
			var typeName = this.__proto__.constructor.name;
			 
			 
			return;
		}
		
		if (_isAnimating) {
			for (var key in obj) {
				_propertiesToAnimate[key] = this.DOMNode.style[key];
				this.DOMNode.style[key] = obj[key];
			}
		}
		else {
			for (var key in obj) {
				this.DOMNode.style[key] = obj[key];
			}
		}

};
	
	
	Object.defineProperty(View.prototype, "backgroundColor", {});
	


View.prototype.readableNameForProperty = function View_readableNameForProperty(theProperty) {
		switch (theProperty) {
			case 'hidden': return LocalizedString('Hidden');
		}
		return __super.prototype.readableNameForProperty.call(this, theProperty);};
	

	Object.defineProperty(View.prototype, "bindableProperties", {
		get:function () {
			return [
				['hidden', this.readableNameForProperty('hidden')]
			];
		}});
	


	

	Object.defineProperty(View.prototype, "hidden", {
	enumerable: true, 
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_hidden")) Object.defineProperty(this, "_hidden", { writable: true, configurable: true });

			if (this._hidden === v) return;
			
			this._hidden = v;
			
			if (this.DOMNode) this.style({ visibility: v ? 'hidden' : '' });

			if (v !== true)	{
				this.callDelegate('viewDidAppear', [this]);
			}
			else {
				this.callDelegate('viewDidDisappear', [this]);
			}

		}, 
		get: function () {
			if (this.DOMNode) return this.DOMNode.style.visibility === 'hidden';
			return this._hidden;
		}});
	

	Object.defineProperty(View.prototype, "visible", {
		set: function (v) { this.hidden = !v; }, 
		get: function () { return !this.hidden; }});
	


	
	
// role EncodableObject (Core) 

View.prototype.decodeData = function View_decodeData(data) {

			var decoded = clone(data);

			if (data.subviews) {
				var subviews = [];
				if (Array.isArray(data.subviews)) data.subviews.every(function (subviewData) {

					if (!subviewData.$domain)
						subviewData.$domain = data.$domain;
					
					var subview = this.context.createFromDataWithoutInitializing(subviewData);
					
					subviews.push(subview);
return true; }, this);
				
				decoded.subviews = subviews;
			}

			if (data.contextMenu) {
				decoded.contextMenu = this.context.createFromDataWithoutInitializing(data.contextMenu);
			}

			return decoded;};
		
		
View.prototype.initFromArchive = function View_initFromArchive(data) {
		
			this.initFromData(data);
			
			if (data.subviews) {
				if (!this.subviews) this.subviews = [];
				if (Array.isArray(data.subviews)) data.subviews.every(function (subview) {
					this.context.initObjectFromArchive(subview);
					this.addSubview(subview);return true; }, this);
				
			}
			if (data.contextMenu) {
				this.context.initObjectFromArchive(data.contextMenu);
			}};
		
		
		var CSSPropertiesToNotEncode = ['position','left','top','width','height','right','bottom','overflowX','overflowY','backgroundImage','backgroundSize','backgroundPosition'];
		
		Object.defineProperty(View.prototype, "encodesStyles", {
			value: true});
		

View.prototype.encode = function View_encode() {
		
			if (this._isDestroyed === true) {
				 console.error('Trying to encode() a view that has been destroyed:', this);
				 console.trace();
				return;
			}
		
			var data = this.context.encodeObject(this, this.encodesStyles ? this.DOMNode : null, CSSPropertiesToNotEncode);
			
			if (this.subviews.length && this.encodesSubviews !== false) {
				data.subviews = [];
				if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {
					var encodedSubview = subview.encode();
					data.subviews.push(encodedSubview);return true; }, this);
				
			}

			return data;
	};
		

View.prototype.encodeCloned = function View_encodeCloned() {
		
			var data = this.context.encodeObject(this, this.encodesStyles ? this.DOMNode : null, CSSPropertiesToNotEncode);
			delete data.$id;
			
			if (this.subviews.length && this.encodesSubviews !== false) {
				data.subviews = [];
				if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {
					data.subviews.push(subview.encodeCloned());return true; }, this);
				
			}
			
			return data;
	};
		

	
	

	
	
// role ViewEventResponder 

View.prototype.viewDidLoad = function View_viewDidLoad() {
			this.viewIsLoaded = true;
			if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {
				subview.viewDidLoad();return true; }, this);
			};
		
	
View.prototype.viewDidResize = function View_viewDidResize(resizeSubviews, considerPausing) {
		
			if (this._lastStableContentSize === undefined) {
				 console.warn('Missing _lastStableContentSize property. The view was initialized without a size.', this);
				 console.trace();
			}
	
			var newContentWidth = this._size.width,
				newContentHeight = this._size.height;
	
			if (newContentWidth === this._lastStableContentSize.width &&
				newContentHeight === this._lastStableContentSize.height)
					return;
	
	
			if (this.autoresizesSubviews !== false && resizeSubviews !== false) {
				this.layoutSubviews();
			}
			
			Object.defineProperty(this, "_lastStableContentSize", {
				value: {
					width: newContentWidth,
					height: newContentHeight
				}});
			;
			};
		
		
View.prototype.viewWillResize = function View_viewWillResize() {};
		
	
	

	Object.defineProperty(View.prototype, "eventHandler", {
	enumerable: true, 
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_eventHandler")) Object.defineProperty(this, "_eventHandler", { writable: true, configurable: true });

			if (this._eventHandler !== undefined) {
				 console.warn('Trying to replace the event handlers of a view, which is impossible to do.');
				return;
			}

			this._eventHandler = v;

			
			
			for (var eventType in v) {
				var paths = v[eventType];
				if (Array.isArray(paths)) paths.every(function (path) {
					var symbol = path.substr(0, path.indexOf('.')),
						func = path.substr(symbol.length+1),
						obj = this[symbol] || this.context.globals[symbol];
					
					if (obj === undefined) {
						return true;
					}
					this.DOMNode.addEventListener(eventType, function (e) {
						this.target[this.method].call(this.target, e, this.sender);
					}.bind({ target: obj, sender: this, method: func }));
return true; }, this);
				
			}
			
			v = undefined;
		}, get:function () { return this._eventHandler; }});
	


	

View.prototype.getRelativeX = function View_getRelativeX(x, outerView) {
		var innerOffsetX = x;
		var _view = this;
		if (!_view.DOMNode) {
			 console.warn('getRelativeX(): The view has not DOMNode.');
			 console.trace();
			return 0;
		}
		do {
			if (_view.DOMNode.offsetLeft)
				innerOffsetX -= _view.DOMNode.offsetLeft;
			else if (_view.position.left)
				innerOffsetX -= _view.position.left;
			
			if (_view.DOMNode.scrollLeft)
				innerOffsetX += _view.DOMNode.scrollLeft;
			_view = _view.superview;
		} while(_view !== outerView && _view !== undefined);
		
		return innerOffsetX;};
	

View.prototype.getRelativeY = function View_getRelativeY(y, outerView) {
		var innerOffsetY = y;
		var _view = this;
		do {
			if (_view.DOMNode.offsetTop)
				innerOffsetY -= _view.DOMNode.offsetTop;
			else if (_view.position.top)
				innerOffsetY -= _view.position.top;

			if (_view.DOMNode.scrollTop)
				innerOffsetY += _view.DOMNode.scrollTop;
			_view = _view.superview;
		} while(_view !== outerView && _view !== undefined && _view.DOMNode);

		
		return innerOffsetY;};
	


	

View.prototype.layoutSubviews = function View_layoutSubviews() {

		var deltaWidth  = this.size.width - this._lastStableContentSize.width,
			deltaHeight = this.size.height - this._lastStableContentSize.height;

		this.layoutSubviewsWithSizeDelta(deltaWidth, deltaHeight);

		if (this.adjustsSubviewToFitWidth && this.subviews.length) {
			var deltaWidth = this.subviews[0].size.width - this.DOMNode.clientWidth;

			if (deltaWidth)
				this.layoutSubviewsWithSizeDelta(-deltaWidth, 0);
		}
};
	


View.prototype.layoutSubviewsWithSizeDelta = function View__layoutSubviewsWithSizeDelta(deltaWidth, deltaHeight) {
		
		if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {

			var autoresizingMask = subview.autoresizingMask;

			if (autoresizingMask === undefined ||
				autoresizingMask === 0)
				return true;


			
			if ((autoresizingMask & (1 << 0)) !== 0 &&
				(autoresizingMask & (1 << 2)) !== 0) {
				
				subview.position.left = 
					(subview.position.left || 0) + deltaWidth/2;

			}
			
			else if ((autoresizingMask & (1 << 0)) === (1 << 0)) {
				subview.position.left = 
					(subview.position.left || 0) + deltaWidth;
			}
			
			else if ((autoresizingMask & (1 << 2)) === (1 << 2)) {
				
			}
			
			
			if ((autoresizingMask & (1 << 3)) === (1 << 3) &&
				(autoresizingMask & (1 << 5)) === (1 << 5)) {

				subview.position.top = 
					(subview.position.top || 0) + deltaHeight/2;
			}
			
			else if ((autoresizingMask & (1 << 3)) === (1 << 3)) {
				subview.position.top = 
					(subview.position.top || 0) + deltaHeight;
			}
			
			else if ((autoresizingMask & (1 << 5)) === (1 << 5)) {
				
			}

			
			if ((autoresizingMask & (1 << 1)) === (1 << 1)) {
				subview.size.width = 
					(subview.size.width || 0) + deltaWidth;
			}

			
			if ((autoresizingMask & (1 << 4)) === (1 << 4)) {
				subview.size.height = 
					(subview.size.height || 0) + deltaHeight;
			}
			
			subview.viewDidResize();
return true; }, this);
		
};
	

	Object.defineProperty(View.prototype, "autoresizingMask", {
	writable: true, 
	enumerable: true, 
		value: undefined});
	
	


	

    Object.defineProperty(View.prototype, "disabled", {
    synthesized: true, 
    	set: function (v) {if (!Object.hasOwnProperty(this, "_disabled")) Object.defineProperty(this, "_disabled", { writable: true, configurable: true });
    		this._disabled = v;
    		this.styleForDisabled(v);
    	}, get:function () { return this._disabled; }});
    

View.prototype.styleForDisabled = function View__styleForDisabled(v) {
		if (v === true) {
			if(this.ignoreStyleForDisabled === true) {
				this.style({ opacity: 1, pointerEvents: 'none' });
			} else {
				this.style({ opacity: .5, pointerEvents: 'none' });
			}
		} else {
			this.style({ opacity: 1, pointerEvents: 'all' });
		}};
	
    
    Object.defineProperty(View.prototype, "ignoreStyleForDisabled", {
    synthesized: true, 
    	set: function (v) {if (!Object.hasOwnProperty(this, "_ignoreStyleForDisabled")) Object.defineProperty(this, "_ignoreStyleForDisabled", { writable: true, configurable: true });
    		this._ignoreStyleForDisabled = v;
    		this.styleForDisabled(this.disabled);
    	}, get:function () { return this._ignoreStyleForDisabled; }});
    
	
	
	
	Object.defineProperty(View.prototype, "acceptsFocus", {
	enumerable: true, 
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_acceptsFocus")) Object.defineProperty(this, "_acceptsFocus", { writable: true, configurable: true });
		
			if (v === undefined) return;
			
			this._acceptsFocus = v;
			this.DOMNode.contentEditable = v;
			
			if (!v) {
				this.DOMNode.onfocus = null;
				this.DOMNode.onblur = null;
			}
			else {
				this.DOMNode.onfocus = function (e) {
					if (this.disabled === true) {
						e.preventDefault();
						return;
					}
					this.onFocus();
					this.context.registerFocus(this);
				}.bind(this);

				this.DOMNode.onblur = function () {
					this.onBlur();
					this.context.unregisterFocus(this);
				}.bind(this);
			}
		}, get:function () { return this._acceptsFocus; }});
	
	
View.prototype.onFocus = function View__onFocus() {};
	

View.prototype.onBlur = function View__onBlur() {};
	


	
	
View.prototype.scrollTo = function View_scrollTo(x, y) {
		if (!this.DOMNode) return;
		this.DOMNode.scrollLeft = x;
		this.DOMNode.scrollTop = y;};
	

View.prototype.scrollToShowView = function View_scrollToShowView(viewInside, margin) {
		if (!viewInside || !viewInside.DOMNode) return;
	
		if (!isNumber(margin)) margin = 0;

		
		

		var viewRect = {
			x: -viewInside.getRelativeX(0, this)-margin,
			y: -viewInside.getRelativeY(0, this)-margin,
			width: viewInside._size.width+margin+margin*2,
			height: viewInside._size.height+margin*2
		};
		
		var visibleRect = {
			x: this.DOMNode.scrollLeft,
			y: this.DOMNode.scrollTop,
			width: this.DOMNode.offsetWidth,
			height: this.DOMNode.offsetHeight
		};
		
		
		function update(xOrY, widthOrHeight) {
			if (viewRect[xOrY] + viewRect[widthOrHeight] > visibleRect[xOrY] + visibleRect[widthOrHeight]) {
				visibleRect[xOrY] = viewRect[xOrY] + viewRect[widthOrHeight] - visibleRect[widthOrHeight];
			}
			if (viewRect[xOrY] < visibleRect[xOrY])
				visibleRect[xOrY] = viewRect[xOrY];
		}
		
		update('x', 'width');
		update('y', 'height');

		if (this.DOMNode.scrollLeft !== visibleRect.x)
			this.DOMNode.scrollLeft = visibleRect.x;
		if (this.DOMNode.scrollTop !== visibleRect.y)
			this.DOMNode.scrollTop = visibleRect.y;
};
	

	var scrollbarSize = 16;
	
	Object.defineProperty(View.prototype, "isHorizontalScrollbarVisible", {
		get: function () {
			return this.DOMNode.scrollWidth > this.DOMNode.clientWidth &&
			this.DOMNode.style.overflowX !== 'hidden';
		}});
	

	Object.defineProperty(View.prototype, "isVerticalScrollbarVisible", {
		get: function () {
			return this.DOMNode.scrollHeight > this.DOMNode.clientHeight &&
			this.DOMNode.style.overflowY !== 'hidden';
		}});
	
	
	Object.defineProperty(View.prototype, "currentScrollbarWidth", {
		get: function () {
			return this.isVerticalScrollbarVisible ? scrollbarSize : 0;
		}});
	

	Object.defineProperty(View.prototype, "currentScrollbarHeight", {
		get: function () {
			return this.isHorizontalScrollbarVisible ? scrollbarSize : 0;
		}});
	
	
View.prototype.mouseEventTargetsScrollbars = function View_mouseEventTargetsScrollbars(e) {
		return (this.isHorizontalScrollbarVisible && e.offsetY > this._size.height-scrollbarSize) || (this.isVerticalScrollbarVisible && e.offsetX > this._size.width-scrollbarSize);};
	
	

	

	Object.defineProperty(View.prototype, "highResolutionEnabled", {
		set: function setHighResolutionEnabled(trueOrFalse) {
	
			if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {
				subview.highResolutionEnabled = trueOrFalse;return true; }, this);
			
			
		}});
	
	
	
	
View.prototype.systemTintDidChange = function View_systemTintDidChange(tint, depth) {

		if (depth === undefined)
			depth = 0;

		if (depth > 100) {
			 console.warn('This view has a cyclic relationship with its subviews.', this.superview);
			return;
		}

		if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {
			subview.systemTintDidChange(tint, depth+1);return true; }, this);
		};
	
	
	
	
	
	Object.defineProperty(View.prototype, "toolTip", {
	enumerable: true, 
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_toolTip")) Object.defineProperty(this, "_toolTip", { writable: true, configurable: true });
			if (v === undefined) return;
			this._toolTip = v;
			if (this.DOMNode) this.DOMNode.title = v;
		}, get:function () { return this._toolTip; }});
	
	
	
	
	
	Object.defineProperty(View.prototype, "contextMenu", {
	synthesized: true, 
		set: function (menu) {if (!Object.hasOwnProperty(this, "_contextMenu")) Object.defineProperty(this, "_contextMenu", { writable: true, configurable: true });
		
			this._contextMenu = menu;
		
			if (!menu) {
				if (this.DOMNode)
					this.DOMNode.oncontextmenu = null;
				return;
			}
			
			this.DOMNode.oncontextmenu = function (e) {
			
				if (menu.delegate) menu.delegate.menuNeedsUpdate(menu);
			
				menu.x = e.x;
				menu.y = e.y;
				this.context.showContextMenu(menu, e);
				e.stopPropagation();
				e.preventDefault();
	
			}.bind(this);


		}, get:function () { return this._contextMenu; }});
	
	
		
	

// role EditableItem (Compose.Editor) 
	
View.prototype.prepareForEditor = function View_prepareForEditor(editor) {

			if (this.layoutRelations)
			if (Array.isArray(this.layoutRelations)) this.layoutRelations.every(function (lr) {

				var t = lr.type;
	
				if (t === 'x')
					this.xIsEditable = false;
	
				if (t === 'y' || t === 'below')
					this.yIsEditable = false;return true; }, this);
			
};
		
			
		Object.defineProperty(View.prototype, "sizeIsEditable", {
			value: true});
		
	
		Object.defineProperty(View.prototype, "positionIsEditable", {
			value: true});
		
	
		Object.defineProperty(View.prototype, "xIsEditable", {
		synthesized: true, 
			get: function () {
				if (this._xIsEditable === undefined) return this.positionIsEditable;
				else return this._xIsEditable;
			}, set:function (v) {if (!Object.hasOwnProperty(this, "_xIsEditable")) Object.defineProperty(this, "_xIsEditable", { writable: true, configurable: true }); this._xIsEditable = v; }});
		
	
		Object.defineProperty(View.prototype, "yIsEditable", {
		synthesized: true, 
			get: function () {
				if (this._yIsEditable === undefined) return this.positionIsEditable;
				else return this._yIsEditable;
			}, set:function (v) {if (!Object.hasOwnProperty(this, "_yIsEditable")) Object.defineProperty(this, "_yIsEditable", { writable: true, configurable: true }); this._yIsEditable = v; }});
		
	
		Object.defineProperty(View.prototype, "widthIsEditable", {
		synthesized: true, 
			get: function () {
				if (this._widthIsEditable === undefined) return this.sizeIsEditable;
				else return this._widthIsEditable;
			}, set:function (v) {if (!Object.hasOwnProperty(this, "_widthIsEditable")) Object.defineProperty(this, "_widthIsEditable", { writable: true, configurable: true }); this._widthIsEditable = v; }});
		
	
		Object.defineProperty(View.prototype, "heightIsEditable", {
		synthesized: true, 
			get: function () {
				if (this._heightIsEditable === undefined) return this.sizeIsEditable;
				else return this._heightIsEditable;
			}, set:function (v) {if (!Object.hasOwnProperty(this, "_heightIsEditable")) Object.defineProperty(this, "_heightIsEditable", { writable: true, configurable: true }); this._heightIsEditable = v; }});
		

		Object.defineProperty(View.prototype, "autoresizingMaskIsEditable", {
			value: true});
		
	
View.prototype.undoNameForKeyPaths = function View_undoNameForKeyPaths(keyPaths) {
			
			var name = __super.prototype.undoNameForKeyPaths.call(this, keyPaths);
			if (name) return name;
		
			if (keyPaths.indexOf('size.width') !== -1 ||
				keyPaths.indexOf('size.height') !== -1) {
				return LocalizedString('Resize');
			}
			if (keyPaths.indexOf('position.left') !== -1 ||
				keyPaths.indexOf('position.top') !== -1) {
				return LocalizedString('Move');
			}

			var propertyNames = {
				'DOMNode.style.backgroundColor': 'Background Color'
			};

			for (var keyPath in propertyNames) {
				if (keyPaths.indexOf(keyPath) !== -1)
					return LocalizedString1('Change %1', LocalizedString(propertyNames[keyPath]));
			}};
		

	

// role EditActionResponder 

View.prototype.canCopy = function View_canCopy() {
			return false;};
		

View.prototype.canPaste = function View_canPaste() {
			return false;};
		

View.prototype.canSelectAll = function View_canSelectAll() {
			return false;};
		

View.prototype.canDuplicate = function View_canDuplicate() {
			return false;};
		

View.prototype.canDelete = function View_canDelete() {
			return false;};
		
	
	

View.prototype.focus = function View_focus() {
		this.DOMNode.focus();};
	


	

	Object.defineProperty(View.prototype, "pixelDensity", {
		get: function () {
			return this.context.highResolutionEnabled === true ? 2 : 1;
		}});
	
	
	
	
	
	var _isAnimating, _propertiesToAnimate, _timingFunction, _animationDuration, _animationHardwareAccelerationEnabled;

View.prototype.beginAnimations = function View_beginAnimations() {
		_isAnimating = true;
		_propertiesToAnimate = {};
		_timingFunction = 'ease-in-out';
		_animationDuration = 0.2;
		_animationHardwareAccelerationEnabled = true;
		this.animationId = Math.random()*10000000000 | 0;};
	
	
	Object.defineProperty(View.prototype, "animationTimingFunction", {
		set: function (v) {
			_timingFunction = v;
		}});
	

	Object.defineProperty(View.prototype, "animationDuration", {
		set: function (v) {
			_animationDuration = v;
		}});
	

	Object.defineProperty(View.prototype, "animationHardwareAccelerationEnabled", {
		set: function (v) {
			_animationHardwareAccelerationEnabled = v;
		}});
	

	Object.defineProperty(View.prototype, "animationId", {
	synthesized: true, get:function () { return this._animationId; }, set:function (v) {if (!Object.hasOwnProperty(this, "_animationId")) Object.defineProperty(this, "_animationId", { writable: true, configurable: true }); this._animationId = v; }});
	

View.prototype.commitAnimations = function View_commitAnimations() {

		_isAnimating = false;

		if (this.hidden || !this.DOMNode) return;
		
		
		var currentAnimationId = this.animationId;
		
		
		
		var needsTransform = false,
			transformValues = { translateX: 0, translateY: 0, scaleX: 1, scaleY: 1 },
			transformPropertyForName = { left: 'translateX', top: 'translateY' };
		
		if (this.scaleX) transformValues.scaleX = this.scaleX;
		if (this.scaleY) transformValues.scaleY = this.scaleY;
		
		if (_animationHardwareAccelerationEnabled)
		['left','top'].every(function (propertyName) {
			if (_propertiesToAnimate.hasOwnProperty(propertyName)) {
				var valueBefore = parseInt(_propertiesToAnimate[propertyName]),
					valueNow = parseInt(this.DOMNode.style[propertyName]),
					difference = valueNow-valueBefore;
				
				
				this.DOMNode.style[propertyName] = valueBefore+'px';
				
				delete _propertiesToAnimate[propertyName];
				
				transformValues[transformPropertyForName[propertyName]] = difference;
				needsTransform = true;
			}return true; }, this);
		

		
		if (needsTransform) {
			_propertiesToAnimate['-webkit-transform'] = '';
			this.DOMNode.style.webkitTransform = 'translateX('+transformValues['translateX']+'px) translateY('+transformValues['translateY']+'px) scaleX('+transformValues['scaleX']+') scaleY('+transformValues['scaleY']+')';
		}
		
		
		this.DOMNode.style.webkitTransitionProperty = Object.keys(_propertiesToAnimate).join(',');
		this.DOMNode.style.webkitTransitionDuration = _animationDuration+'s';
		this.DOMNode.style.webkitTransitionTimingFunction = _timingFunction;

		setTimeout(function () {
			if (!this.DOMNode) return; 
			if (this.animationId !== currentAnimationId) return; 
			
			this.DOMNode.style.webkitTransition = '';
			if (needsTransform) {
				
				
				this.DOMNode.style.webkitTransform = '';
				if (transformValues['translateX'])
					this.DOMNode.style.left = (parseInt(this.DOMNode.style.left)+transformValues['translateX'])+'px';
				if (transformValues['translateY'])
					this.DOMNode.style.top = (parseInt(this.DOMNode.style.top)+transformValues['translateY'])+'px';
			}
		}.bind(this), _animationDuration*1000+99);};
	
	
View.prototype.containsView = function View_containsView(aView) {
		var result = false;
		
		if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {
			if (subview === aView) {
				result = true; return false;
			}return true; }, this);
		
		if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {
			if (subview.containsView(aView)) {
				result = true; return false;
			}return true; }, this);
		
		return result;};
	

View.prototype.expectedTypeForProperty = function View_expectedTypeForProperty(key) {
	if (key === "DOMNode") return "";
	if (key === "defaultStyle") return "";
	if (key === "superview") return "";
	if (key === "subviews") return "";
	if (key === "viewIsLoaded") return "";
	if (key === "normalStyle") return "";
	if (key === "$id") return "";
	if (key === "size") return "";
	if (key === "sizeCopy") return "";
	if (key === "position") return "";
	if (key === "positionCopy") return "";
	if (key === "dragEnterEventListener") return "";
	if (key === "dragOverEventListener") return "";
	if (key === "dropEventListener") return "";
	if (key === "dragLeaveEventListener") return "";
	if (key === "dropHandler") return "";
	if (key === "backgroundColor") return "";
	if (key === "bindableProperties") return "";
	if (key === "hidden") return "Boolean";
	if (key === "visible") return "";
	if (key === "encodesStyles") return "";
	if (key === "eventHandler") return "";
	if (key === "autoresizingMask") return "";
	if (key === "disabled") return "";
	if (key === "ignoreStyleForDisabled") return "";
	if (key === "acceptsFocus") return "";
	if (key === "isHorizontalScrollbarVisible") return "";
	if (key === "isVerticalScrollbarVisible") return "";
	if (key === "currentScrollbarWidth") return "";
	if (key === "currentScrollbarHeight") return "";
	if (key === "highResolutionEnabled") return "";
	if (key === "toolTip") return "";
	if (key === "contextMenu") return "";
	if (key === "sizeIsEditable") return "";
	if (key === "positionIsEditable") return "";
	if (key === "xIsEditable") return "";
	if (key === "yIsEditable") return "";
	if (key === "widthIsEditable") return "";
	if (key === "heightIsEditable") return "";
	if (key === "autoresizingMaskIsEditable") return "";
	if (key === "pixelDensity") return "";
	if (key === "animationTimingFunction") return "";
	if (key === "animationDuration") return "";
	if (key === "animationHardwareAccelerationEnabled") return "";
	if (key === "animationId") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return View; }()));
registerType('Core.UI', (function () { function CanvasView() {} var __super = setSupertypeFromDomain(CanvasView, 'View', 'Core.UI');
	
CanvasView.prototype.initFromData = function CanvasView_initFromData(data, holdBindings) {
	
		if (!__super.prototype.initFromData.call(this, data, 'canvas', true))
			return;
			
		this.contentScale = this.context.highResolutionEnabled ? 2 : 1;

		this.layoutSubviews();

		return this;};
	

CanvasView.prototype.draw = function CanvasView_draw(width, height) {
		};
	
	
	Object.defineProperty(CanvasView.prototype, "contentScale", {
	synthesized: true, get:function () { return this._contentScale; }, set:function (v) {if (!Object.hasOwnProperty(this, "_contentScale")) Object.defineProperty(this, "_contentScale", { writable: true, configurable: true }); this._contentScale = v; }});
	

CanvasView.prototype.layoutSubviews = function CanvasView__layoutSubviews() {
		var width = this.size.width,
			height = this.size.height;
			
		this.DOMNode.width = width*this.contentScale;
		this.DOMNode.height = height*this.contentScale;
		this.DOMNode.style.width = width+'px';
		this.DOMNode.style.height = height+'px';

		this.draw(width, height);};
	
CanvasView.prototype.expectedTypeForProperty = function CanvasView_expectedTypeForProperty(key) {
	if (key === "contentScale") return "Number";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return CanvasView; }()));