
registerType('Core.UI', (function () { function ViewController() {} var __super = setSupertypeFromDomain(ViewController, 'BasicObject', 'Core');

ViewController.prototype.initFromData = function ViewController_initFromData(data, holdBindings) {

		if (!__super.prototype.initFromData.call(this, data, holdBindings))
			return;
		
		Object.defineProperty(this, "view", {
		configurable: true, 
		writable: true});
		

		if (data.view !== undefined) {
			this.view = data.view;
		}
		
		['id', 'delegate', 'size', 'position', 'title', 'viewData'].every(function (option) {
			if (data[option] !== undefined)
				this[option] = data[option];return true; }, this);
		

		if (!holdBindings)
			this.applyBindings(true);
	
		return this;};
	

ViewController.prototype.destroy = function ViewController_destroy() {
		if (this.view.superview)
			this.view.removeFromSuperview();
		delete this.view;
		__super.prototype.destroy.call(this);};
	
	


	
	
// role EncodableObject (Core) 

ViewController.prototype.decodeData = function ViewController_decodeData(data) {

			var decoded = clone(data);

			if (data.view) {
				decoded.view = this.context.createFromDataWithoutInitializing(data.view);
			}

			return decoded;};
		

ViewController.prototype.initFromArchive = function ViewController_initFromArchive(data) {
			if (data.view) {
				this.context.initObjectFromArchive(data.view);
			}
			this.initFromData(data);};
		

	


	

ViewController.prototype.loadView = function ViewController_loadView() {
	
		if (this.view) {
			this.viewDidLoadCallOnce();
			return;
		}
		
		if (this.viewId) {
			this.view = this.context.getOrCreateInstance(this.viewId);
		}
		else if (this.viewData) {
			this.view = this.context.decodeObjectTree(this.viewData);
		}
		else {
			console.warn("Unable to load view: viewId and viewData not set.", this);
			return;
		}
		
		
		Object.defineProperty(this.view, "controller", { value: this });
		Object.defineProperty(this.view, "delegate", { value: this });

		if (this.childControllers !== undefined) {

			var vcType = getType('Core.UI.ViewController');
			
			if (Array.isArray(this.childControllers)) this.childControllers.every(function (controller) {

				if (controller instanceof vcType === false)
					return true;

				if (controller.view !== undefined) {
					controller.viewDidLoadCallOnce();
				}
				else controller.loadView();
			return true; }, this);
			
			
		}
		

		this.viewDidLoadCallOnce();
		this.view.viewDidLoad();
		if (this.view.hidden !== true)
			this.viewDidAppear(this.view);
		
		return true;
};
	
	
ViewController.prototype.unloadView = function ViewController_unloadView() {
		if (!this.view) return;
		if (this.view.superview) {
			this.view.removeFromSuperview();
		}
		this.view = null;};
	
	
ViewController.prototype.createView = function ViewController__createView() {

		
		var view = createComponentFromDomain("View", "Core.UI",
			this.context, {
				size: this._size,
				position: this._position
			});
		view.delegate = this;
		
		Object.defineProperty(this, 'view', {
			value: view,
		});
		};
	


	

// role ViewDelegate (Core.UI) 

ViewController.prototype.viewDidLoad = function ViewController_viewDidLoad(view) {

			if (!this.view.viewIsLoaded) {
				this.view.viewIsLoaded = true;
				this.view.viewDidLoad();
			}
};
		
		
ViewController.prototype.viewDidDisappear = function ViewController_viewDidDisappear(view) {
			};
		
		
ViewController.prototype.viewDidAppear = function ViewController_viewDidAppear(view) {
			};
		
	
	
	
ViewController.prototype.viewDidLoadCallOnce = function ViewController__viewDidLoadCallOnce() {

		if (this.__didCallViewDidLoad === true) return;

		Object.defineProperty(this, "__didCallViewDidLoad", {
			value: true});
		
		
		this.viewDidLoad(this.view);};
	

ViewController.prototype.expectedTypeForProperty = function ViewController_expectedTypeForProperty(key) {
	if (key === "view") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ViewController; }()));